/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive;

import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.tools.interactive.DocumentationGenerator;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlStr;
import com.neeve.util.UtlTableFormatter;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.Operation;
import jline.console.UserInterruptException;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiString;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class InteractiveTool
implements Command.Console {
    private static final String NIL = "$NIL";
    private String name;
    private String prompt;
    private ProductInfo productInfo;
    private ConsoleReader reader;
    private Ansi.Color promptColor = Ansi.Color.MAGENTA;
    private Thread readerThread;
    private InterruptHandler interruptHandler;
    private volatile boolean closeRequested = false;
    private Thread shutdownHook;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private FileHistory history;
    private boolean interactive;
    SortedMap<String, ConfigPropertyHandler> configPropertyHandlers = new TreeMap<String, ConfigPropertyHandler>();
    private File configFile;
    private Properties configProperties = new Properties();
    private boolean configDirty = false;
    private boolean environmentSubstitutionEnabled = true;
    final LinkedHashMap<String, Command> commands;
    private final LinkedHashSet<Runnable> closeHooks = new LinkedHashSet();
    private final LinkedHashSet<Runnable> preCommandLoopTasks = new LinkedHashSet();
    @ConfigProperty(name="stacktraces", defaultValue="off", parser=BooleanPropertyParser.class, validOptions={"on", "off", "true", "false"}, description="Whether or not command exception stacktraces should be dumped")
    private boolean showExceptions = false;
    @ConfigProperty(name="longCommandDisplayThreshold", defaultValue="5 seconds", unit=UtlUnit.Unit.Time, defaultTimeUnit=TimeUnit.SECONDS, targetTimeUnit=TimeUnit.SECONDS, description="Commands that take longer than the given time will result in the tool outputting their execution time.")
    private int longCommandDisplayThreshold = 5;
    private boolean echo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractiveTool(String name, String prompt, ProductInfo productInfo) throws Exception {
        this.name = name == null ? "Interactive Tool" : name;
        this.prompt = prompt;
        this.commands = new LinkedHashMap();
        this.productInfo = productInfo == null ? ManifestProductInfo.loadProductInfo("nvx-rumi-core") : productInfo;
        this.configFile = new File(System.getProperty("user.home") + File.separator + ".nvx" + File.separator + "tools" + File.separator + this.name.replace(' ', '_').toLowerCase() + File.separator + "config.props");
        if (this.configFile.exists()) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.configFile));){
                this.configProperties.load(bis);
            }
        }
        this.registerAnnotatedCommands(this);
    }

    public InteractiveTool() throws Exception {
        this(null, null, null);
    }

    public static final String subst(String str, UtlStr.ISubstResolver resolver) throws Exception {
        return UtlTailoring.substitute(str, resolver);
    }

    public static final String substEnv(String str) throws Exception {
        return UtlTailoring.substituteFromEnv(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void run(final ConsoleReader reader, boolean interactive, boolean echo) throws Exception {
        if (this.reader != null) {
            throw new IllegalStateException("Tool is already running");
        }
        boolean originalAnsi = Ansi.isEnabled();
        boolean originalEcho = this.echo;
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.name + " Main");
        try {
            this.interactive = interactive;
            this.reader = reader;
            this.echo = echo;
            this.closeRequested = false;
            this.readerThread = Thread.currentThread();
            this.out = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    reader.print((CharSequence)new Character((char)b).toString());
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    reader.flush();
                }
            }, true);
            this.err = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    reader.print((CharSequence)new Character((char)b).toString());
                }

                @Override
                public void flush() throws IOException {
                    super.flush();
                    reader.flush();
                }
            }, true);
            if (interactive) {
                this.shutdownHook = new Thread(){

                    @Override
                    public final void run() {
                        InteractiveTool.this.close();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            try {
                reader.setExpandEvents(false);
                if (interactive) {
                    reader.print((CharSequence)Ansi.ansi().fg(this.promptColor).a(this.productInfo.getBanner()).reset().toString());
                    String toolName = this.name;
                    String line1 = String.format("%s%" + (this.productInfo.getBannerWidth() - toolName.length()) + "s", toolName, this.productInfo.getComponentVersionString());
                    reader.println((CharSequence)Ansi.ansi().fg(this.promptColor).a(line1).reset().toString());
                    String line2 = String.format("%" + this.productInfo.getBannerWidth() + "s", "Copyright(c) " + Calendar.getInstance().get(1) + " " + this.productInfo.getVendorName());
                    reader.println((CharSequence)Ansi.ansi().fg(this.promptColor).a(line2).reset().toString());
                    String line3 = String.format("%" + this.productInfo.getBannerWidth() + "s", "All Rights Reserved");
                    reader.println((CharSequence)Ansi.ansi().fg(this.promptColor).a(line3).reset().toString());
                    reader.flush();
                    reader.setHistoryEnabled(true);
                    File file = new File(System.getProperty("user.home") + File.separator + ".nvx" + File.separator + "tools" + File.separator + this.name.replace(' ', '_').toLowerCase() + File.separator + ".history");
                    this.history = new FileHistory(file);
                    reader.setHistory((jline.console.history.History)this.history);
                    if (reader.getTerminal().isSupported()) {
                        reader.setPaginationEnabled(true);
                        reader.getKeys().bind((CharSequence)"\u001b", (Object)Operation.INTERRUPT);
                        reader.setHandleUserInterrupt(true);
                    }
                    HashSet<String> completionCommands = new HashSet<String>();
                    for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
                        AnnotatedCommand.Command ac = entry.getValue().getClass().getAnnotation(AnnotatedCommand.Command.class);
                        if (ac != null && ac.hidden()) continue;
                        completionCommands.add(entry.getKey().toLowerCase());
                    }
                    reader.addCompleter((Completer)new StringsCompleter(completionCommands));
                    reader.addCompleter(new Completer(){

                        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
                            String commandName;
                            Command command;
                            int commandDelim = buffer.trim().indexOf(32);
                            if (commandDelim > 0 && (command = InteractiveTool.this.commands.get(commandName = buffer.substring(0, commandDelim))) != null && command instanceof Completer) {
                                return ((Completer)command).complete(buffer, cursor, candidates);
                            }
                            return -1;
                        }
                    });
                } else {
                    reader.setHistoryEnabled(false);
                    Ansi.setEnabled((boolean)false);
                }
                for (Runnable task : this.preCommandLoopTasks) {
                    task.run();
                }
                if (interactive) {
                    reader.println((CharSequence)"Type 'help' for the list of commands");
                }
                while (!this.closeRequested) {
                    if (this.echo) {
                        reader.setPrompt(Ansi.ansi().fg(this.promptColor).a(this.prompt != null ? this.prompt + ">" : ">").reset() + " ");
                    }
                    String line = null;
                    try {
                        line = reader.readLine();
                    }
                    catch (UserInterruptException ue) {
                        if (!interactive) return;
                        try {
                            String response = reader.readLine(Ansi.ansi().fg(this.promptColor).a("Exit? [[y]/n)>").reset() + " ");
                            if (response.trim().length() == 0) return;
                            if (!response.toLowerCase().startsWith("y")) continue;
                            return;
                        }
                        catch (UserInterruptException ue2) {
                            continue;
                        }
                    }
                    if (line == null) {
                        return;
                    }
                    if (interactive) {
                        line = new AnsiString((CharSequence)line).getPlain().toString();
                    }
                    try {
                        this.executeCommand(line);
                    }
                    catch (Exception e) {
                        if (interactive) continue;
                        throw e;
                        return;
                    }
                }
            }
            finally {
                Ansi.setEnabled((boolean)originalAnsi);
                this.echo = originalEcho;
                this.close();
            }
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void close() {
        if (this.reader == null) {
            return;
        }
        this.closeRequested = true;
        for (Runnable closer : this.closeHooks) {
            try {
                closer.run();
            }
            catch (Throwable thrown) {
                this.error("Shutdown error: " + thrown.getMessage(), thrown);
            }
        }
        this.closeHooks.clear();
        if (this.history != null) {
            try {
                this.history.flush();
                this.history = null;
            }
            catch (IOException e) {
                this.error("Error flushing command history", e);
            }
        }
        if (this.configDirty && this.configProperties != null) {
            if (!this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                try {
                    this.configFile.createNewFile();
                }
                catch (IOException ioe) {
                    this.error("Error saving config properties file " + this.configFile, ioe);
                }
            }
            for (ConfigPropertyHandler handler : this.configPropertyHandlers.values()) {
                try {
                    handler.save(this.configProperties);
                }
                catch (Exception e) {
                    this.error("Error saving config property " + handler.annotation.name(), e);
                }
            }
            FilterOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.configFile, false));
                this.configProperties.store(bos, null);
                ((BufferedOutputStream)bos).flush();
            }
            catch (IOException ioe) {
                this.error("Error saving config properties file " + this.configFile, ioe);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            if (this.interactive) {
                this.reader.print((CharSequence)Ansi.ansi().reset().toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.reader.shutdown();
        this.reader = null;
        this.out = System.out;
        this.err = System.err;
        this.readerThread = null;
        if (this.shutdownHook != null && Thread.currentThread() != this.shutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.start();
        }
    }

    public synchronized void executeCommand(String line) {
        this.executeCommand(line, false);
    }

    public void setEnvironmentSubstitutionEnabled(boolean enabled) {
        this.environmentSubstitutionEnabled = enabled;
    }

    public boolean isEnvironmentSubstitutionEnabled() {
        return this.environmentSubstitutionEnabled;
    }

    public synchronized void executeCommand(String line, boolean echoCommand) {
        if (line == null) {
            return;
        }
        if (this.environmentSubstitutionEnabled) {
            try {
                line = UtlTailoring.substituteFromEnv(line);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if ((line = line.trim()).length() > 0 && !line.startsWith("//")) {
            String[] args;
            if (echoCommand && this.echo) {
                if (this.reader == null) {
                    System.out.println(">" + line);
                } else {
                    try {
                        this.reader.println((CharSequence)(">" + line));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not write to console", e);
                    }
                }
            }
            String[] commandTokens = UtlText.parseAsArgs(line, false, false);
            String command = commandTokens[0];
            if (commandTokens.length > 1) {
                args = new String[commandTokens.length - 1];
                System.arraycopy(commandTokens, 1, args, 0, args.length);
            } else {
                args = new String[]{};
            }
            long start = System.currentTimeMillis();
            if (!this.executeCommand(command, line, args)) {
                this.error("Unknown command [" + command + "]. Use 'help' to get a list of commands.");
            }
            long executionTime = System.currentTimeMillis() - start;
            if (this.interactive && this.longCommandDisplayThreshold > 0 && executionTime / 1000L >= (long)this.longCommandDisplayThreshold) {
                this.info(command + " completed in " + executionTime / 1000L + " seconds");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean executeCommand(String cmd, String originalCommandLine, String[] args) {
        Command command = this.commands.get(cmd);
        if (command != null) {
            AnnotatedCommand ac;
            if (command instanceof AnnotatedCommand && (ac = (AnnotatedCommand)command).preserveArgumentQuotes()) {
                String[] commandTokens = UtlText.parseAsArgs(originalCommandLine, true, true);
                if (commandTokens.length > 1) {
                    args = new String[commandTokens.length - 1];
                    System.arraycopy(commandTokens, 1, args, 0, args.length);
                } else {
                    args = new String[]{};
                }
            }
            if (Thread.currentThread() != this.readerThread || !this.interactive || this.interruptHandler != null) {
                command.run(args);
            } else {
                this.interruptHandler = new InterruptHandler(command);
                try {
                    command.run(args);
                }
                finally {
                    this.interruptHandler.close();
                }
            }
            return true;
        }
        String setCommand = cmd;
        for (String arg : args) {
            setCommand = setCommand + " " + arg;
        }
        int index = setCommand.indexOf("=");
        if (setCommand.indexOf("=") > 1) {
            String propName = setCommand.substring(0, index).trim();
            String propValue = null;
            if (setCommand.length() > index + 1) {
                propValue = setCommand.substring(index + 1).trim();
                if (propValue.length() == 0) {
                    propValue = null;
                    return this.executeCommand("set", originalCommandLine, new String[]{propName});
                }
                return this.executeCommand("set", originalCommandLine, new String[]{propName, propValue});
            }
            return this.executeCommand("set", originalCommandLine, new String[]{propName});
        }
        return false;
    }

    public final void registerCommand(Command command) {
        String[] keywords = command.keywords();
        for (int i = 0; i < keywords.length; ++i) {
            command.setConsole(this);
            this.commands.put(keywords[i], command);
        }
    }

    public final void registerAnnotatedCommands(Object container) {
        ConfigPropertyHandler handler;
        ConfigProperty property;
        for (Class<?> clazz : container.getClass().getDeclaredClasses()) {
            if (!clazz.isAnnotationPresent(AnnotatedCommand.Command.class) || clazz.getAnnotation(AnnotatedCommand.Command.class).disabled()) continue;
            try {
                Constructor<?> ctor = clazz.getDeclaredConstructor(container.getClass());
                ctor.setAccessible(true);
                this.registerCommand((AnnotatedCommand)ctor.newInstance(container));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (AnnotatedElement annotatedElement : container.getClass().getFields()) {
            if (!((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigProperty.class)) continue;
            ((Field)annotatedElement).setAccessible(true);
            property = ((Field)annotatedElement).getAnnotation(ConfigProperty.class);
            try {
                handler = new ConfigPropertyHandler(container, (Field)annotatedElement, property);
            }
            catch (Exception e) {
                this.error("Error creating config property handler for " + annotatedElement, e);
                continue;
            }
            this.configPropertyHandlers.put(property.name(), handler);
            if (this.configProperties == null) continue;
            try {
                handler.load(this.configProperties);
            }
            catch (Exception e) {
                this.error("Error loading configuration property value for " + handler.annotation.name() + ": " + e.getMessage(), e);
            }
        }
        for (AnnotatedElement annotatedElement : container.getClass().getDeclaredFields()) {
            if (!((AccessibleObject)annotatedElement).isAnnotationPresent(ConfigProperty.class)) continue;
            ((Field)annotatedElement).setAccessible(true);
            property = ((Field)annotatedElement).getAnnotation(ConfigProperty.class);
            try {
                handler = new ConfigPropertyHandler(container, (Field)annotatedElement, property);
            }
            catch (Exception e) {
                this.error("Error creating config property handler for " + annotatedElement, e);
                continue;
            }
            this.configPropertyHandlers.put(property.name(), handler);
            if (this.configProperties == null) continue;
            try {
                handler.load(this.configProperties);
            }
            catch (Exception e) {
                this.error("Error loading configuration property value for " + handler.annotation.name() + ": " + e.getMessage(), e);
            }
        }
    }

    public final void run(InputStream in) throws Exception {
        this.run(in, false);
    }

    public final void run(InputStream in, boolean echo) throws Exception {
        TerminalFactory.reset();
        TerminalFactory.configure((String)"off");
        ConsoleReader consoleReader = new ConsoleReader(in, (OutputStream)new EchoControlOutputStream(System.out));
        TerminalFactory.configure((String)"auto");
        this.run(consoleReader, false, echo);
    }

    public final void run(File file) throws Exception {
        System.out.println("\n****** Running script '" + file + "' ******");
        this.run(new BufferedInputStream(new FileInputStream(file)), true);
        System.out.println("****** Done ******");
    }

    public final void run() throws Exception {
        TerminalFactory.reset();
        if (Boolean.getBoolean("nv.console.jline.disable")) {
            TerminalFactory.configure((String)"off");
        } else {
            TerminalFactory.configure((String)"auto");
        }
        ConsoleReader reader = new ConsoleReader(System.in, (OutputStream)new EchoControlOutputStream(System.out));
        TerminalFactory.configure((String)"auto");
        TerminalFactory.reset();
        this.run(reader, true, true);
    }

    public void setToolName(String name) {
        this.name = name;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public int getConsoleWidth() {
        if (this.reader != null) {
            return this.reader.getTerminal().getWidth();
        }
        return -1;
    }

    public int getConsoleHeight() {
        if (this.reader != null) {
            return this.reader.getTerminal().getHeight();
        }
        return -1;
    }

    public final void warn(String warning) {
        this.info(Ansi.ansi().fgBright(Ansi.Color.RED).a(warning).reset().toString());
    }

    @Override
    public final void error(String error) {
        this.error(error, null);
    }

    @Override
    public void error(String error, Throwable cause) {
        if (this.echo) {
            System.err.println(error);
            if (cause != null && this.showExceptions) {
                System.err.println(UtlThrowable.prepareStackTrace((Throwable)cause));
            }
        } else {
            this.info(Ansi.ansi().fg(Ansi.Color.RED).a(error).reset().toString());
            if (cause != null && this.showExceptions) {
                this.info(Ansi.ansi().fg(Ansi.Color.RED).a(UtlThrowable.prepareStackTrace((Throwable)cause)).reset().toString());
            }
        }
    }

    @Override
    public void info(String message) {
        if (this.reader != null) {
            try {
                this.reader.println((CharSequence)message);
                this.reader.flush();
            }
            catch (IOException e) {
                System.out.println(message);
            }
        } else {
            System.out.println(message);
        }
    }

    public void addConfigPropertyChangeHandler(String property, PropertyChangeHandler changeHandler) {
        ConfigPropertyHandler handler = (ConfigPropertyHandler)this.configPropertyHandlers.get(property);
        if (handler == null) {
            throw new IllegalArgumentException("Unknown config property: " + property);
        }
        handler.addChangeHandler(changeHandler);
    }

    public void removeConfigPropertyChangeHandler(String property, PropertyChangeHandler changeHandler) {
        ConfigPropertyHandler handler = (ConfigPropertyHandler)this.configPropertyHandlers.get(property);
        if (handler == null) {
            throw new IllegalArgumentException("Unknown config property: " + property);
        }
        handler.removeChangeHandler(changeHandler);
    }

    public void addCloseHook(Runnable closeHook) {
        this.closeHooks.add(closeHook);
    }

    public void addPreCommandLoopTask(Runnable runnable) {
        this.preCommandLoopTasks.add(runnable);
    }

    public void removeCloseHook(Runnable closeHook) {
        this.closeHooks.remove(closeHook);
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    private static final String asString(Object value) {
        return value != null ? String.valueOf(value) : null;
    }

    @Override
    public final PrintStream out() {
        return this.out == null ? System.out : this.out;
    }

    @Override
    public final PrintStream err() {
        return this.err == null ? System.err : this.err;
    }

    public String getName() {
        return this.name;
    }

    public void listCommands(String filter) {
        if (filter != null) {
            filter = filter.toLowerCase();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        try {
            for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
                AnnotatedCommand.Command ac = entry.getValue().getClass().getAnnotation(AnnotatedCommand.Command.class);
                if (ac != null && ac.hidden()) continue;
                String command = entry.getKey().toLowerCase();
                if (filter != null && command.indexOf(filter) <= 0) continue;
                candidates.add(entry.getKey().toLowerCase());
            }
            if (this.reader != null && this.interactive) {
                CandidateListCompletionHandler.printCandidates((ConsoleReader)this.reader, candidates);
            } else {
                Collections.sort(candidates, new Comparator<CharSequence>(){

                    @Override
                    public int compare(CharSequence o1, CharSequence o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                for (CharSequence charSequence : candidates) {
                    this.info(charSequence.toString());
                }
            }
        }
        catch (IOException e) {
            this.error("Error listing commands", e);
        }
    }

    private final class InterruptHandler
    implements SignalHandler {
        private final Signal signal = new Signal("INT");
        private final SignalHandler oldHandler;
        private final Command command;

        InterruptHandler(Command command) {
            this.command = command;
            this.oldHandler = Signal.handle(this.signal, this);
        }

        final synchronized void close() {
            Signal.handle(this.signal, this.oldHandler);
            Thread.interrupted();
        }

        @Override
        public final synchronized void handle(Signal sig) {
            try {
                if (InteractiveTool.this.interactive) {
                    this.handleInterrupt();
                } else {
                    this.oldHandler.handle(sig);
                }
            }
            catch (UserInterruptException e) {
                return;
            }
        }

        private final void handleInterrupt() {
            try {
                if (this.command.interruptable()) {
                    String response = InteractiveTool.this.reader.readLine(Ansi.ansi().fg(InteractiveTool.this.promptColor).a("Interrupt " + this.command.keywords()[0] + "? [(y)es|(n)o|(e)xit)][y]?>").reset() + " ");
                    if (response.trim().length() == 0 || response.toLowerCase().startsWith("y")) {
                        this.command.interrupt(InteractiveTool.this.readerThread);
                    } else if (response.trim().toLowerCase().startsWith("e")) {
                        InteractiveTool.this.closeRequested = true;
                        this.command.interrupt(InteractiveTool.this.readerThread);
                        System.exit(-1);
                    }
                } else {
                    String response = InteractiveTool.this.reader.readLine(Ansi.ansi().fg(InteractiveTool.this.promptColor).a("Can't interrupt " + this.command.keywords()[0] + ". Exit tool? [(y)es|(n)o][n]?>").reset() + " ");
                    if (response.trim().toLowerCase().startsWith("y")) {
                        InteractiveTool.this.closeRequested = true;
                        System.exit(-1);
                    }
                }
            }
            catch (UserInterruptException e) {
                return;
            }
            catch (IOException ioe) {
                InteractiveTool.this.readerThread.interrupt();
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"get"}, description="Gets a configuration or environment property")
    private class Get
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=97, longForm="all", defaultValue="false", description="flag indicating that all properties should be listed")
        boolean all;
        @AnnotatedCommand.Argument(position=1, name="propName", required=false, description="The name of property to get, or with -a, a filter on properties to list")
        String propName;

        private Get() {
        }

        @Override
        public void execute() throws Exception {
            if (this.all) {
                UtlTableFormatter.Table table = UtlTableFormatter.createTable("Property", "Value", "Description");
                for (ConfigPropertyHandler configPropertyHandler : InteractiveTool.this.configPropertyHandlers.values()) {
                    if (this.propName != null && configPropertyHandler.annotation.name().indexOf(this.propName) < 0) continue;
                    configPropertyHandler.appendUsage(table);
                }
                TreeSet<Object> keys = new TreeSet<Object>(UtlEnv.getEnvPropsNoWarn().keySet());
                for (Object object : keys) {
                    if (this.propName != null && object.toString().indexOf(this.propName) < 0) continue;
                    table.addRow(object, UtlEnv.getValue(object.toString()), "Runtime Property");
                }
                StringBuffer stringBuffer = new StringBuffer();
                table.write(stringBuffer, UtlTableFormatter.Format.TABULAR, true, InteractiveTool.this.getConsoleWidth());
                InteractiveTool.this.info(stringBuffer.toString());
                return;
            }
            ConfigPropertyHandler handler = (ConfigPropertyHandler)InteractiveTool.this.configPropertyHandlers.get(this.propName);
            if (handler == null) {
                String value = XRuntime.getValue(this.propName, null);
                UtlTableFormatter.Table table = UtlTableFormatter.createTable("Property", "Value", "Description");
                table.addRow(this.propName, value, "Runtime Property");
                StringBuffer stringBuffer = new StringBuffer();
                table.write(stringBuffer, UtlTableFormatter.Format.TABULAR, true, InteractiveTool.this.getConsoleWidth());
                InteractiveTool.this.info(stringBuffer.toString());
            } else {
                UtlTableFormatter.Table table = UtlTableFormatter.createTable("Property", "Value", "Description");
                handler.appendUsage(table);
                StringBuffer stringBuffer = new StringBuffer();
                table.write(stringBuffer, UtlTableFormatter.Format.TABULAR, true, InteractiveTool.this.getConsoleWidth());
                InteractiveTool.this.info(stringBuffer.toString());
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"reset"}, description="Reset a configuration or environment property to its default value")
    private class Reset
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="propName", required=true, description="The name of property to reset. '*' resets all properties to their default value.")
        String propName;

        private Reset() {
        }

        @Override
        public void execute() throws Exception {
            if (this.propName.equals("*")) {
                for (ConfigPropertyHandler handler : InteractiveTool.this.configPropertyHandlers.values()) {
                    handler.setValue(null);
                }
            } else {
                ConfigPropertyHandler handler = (ConfigPropertyHandler)InteractiveTool.this.configPropertyHandlers.get(this.propName);
                if (handler == null) {
                    this.error("Config property '" + this.propName + "' doesn't exist");
                } else {
                    handler.setValue(null);
                }
                if (InteractiveTool.this.interactive) {
                    InteractiveTool.this.configDirty = true;
                }
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"set"}, description="Sets a configuration or environment property")
    private class Set
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="propName", required=false, description="The name of property to set, if no name is set config properties are listed")
        String propName;
        @AnnotatedCommand.Argument(position=2, name="propValue", required=false, description="The value of the property to set. If omitted clears the property")
        String propValue;

        private Set() {
        }

        @Override
        public void execute() throws Exception {
            if (this.propName == null) {
                UtlTableFormatter.Table table = UtlTableFormatter.createTable("Property", "Value", "Description");
                for (ConfigPropertyHandler handler : InteractiveTool.this.configPropertyHandlers.values()) {
                    handler.appendUsage(table);
                }
                StringBuffer buf = new StringBuffer();
                table.write(buf, UtlTableFormatter.Format.TABULAR, true, InteractiveTool.this.getConsoleWidth());
                InteractiveTool.this.info(buf.toString());
                return;
            }
            ConfigPropertyHandler handler = (ConfigPropertyHandler)InteractiveTool.this.configPropertyHandlers.get(this.propName);
            if (handler == null) {
                if (this.propValue == null) {
                    XRuntime.getProps().remove(this.propName);
                } else {
                    XRuntime.getProps().setProperty(this.propName, this.propValue);
                }
                return;
            }
            handler.setValue(this.propValue);
            String value = handler.getValue();
            if (value == null) {
                InteractiveTool.this.configProperties.remove(handler.annotation.name());
            } else {
                InteractiveTool.this.configProperties.setProperty(handler.annotation.name(), this.propValue == null ? handler.defaultValue : this.propValue);
            }
            if (InteractiveTool.this.interactive) {
                InteractiveTool.this.configDirty = true;
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"sleep"}, description="Sleeps for the specified amount of time", hidden=true)
    private class Sleep
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="seconds", defaultValue="0", description="The amount of time to sleep in seconds")
        float seconds;

        private Sleep() {
        }

        @Override
        public void execute() throws Exception {
            long millis = (long)(this.seconds * 1000.0f);
            this.console().info("Sleeping for " + this.seconds + " seconds...");
            Thread.sleep(millis);
        }
    }

    @AnnotatedCommand.Command(keywords={"stacktraces"}, description="Sets whether or not command exception stacktraces should be shown")
    private class Verbose
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="enabled", validOptions={"true", "false", "on", "off"}, description="Indicates whether or not command exceptions should be displayed")
        String enabled;

        private Verbose() {
        }

        @Override
        public void execute() throws Exception {
            if (this.enabled.equals("on") || this.enabled.equals("off")) {
                InteractiveTool.this.showExceptions = true;
            } else {
                InteractiveTool.this.showExceptions = false;
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"history"}, description="Displays command history")
    public final class History
    extends AnnotatedCommand {
        @AnnotatedCommand.Option(shortForm=99, longForm="clear", description="Clears command history")
        boolean clear = false;
        @AnnotatedCommand.Argument(position=1, name="n", required=false, defaultValue="1000", description="lists only the last 'n' lines")
        int numEntries = 1000;
        private static final String historyFormat = " %5d %s";

        @Override
        public void execute() throws Exception {
            if (this.clear) {
                if (InteractiveTool.this.history != null) {
                    InteractiveTool.this.history.purge();
                }
                return;
            }
            if (InteractiveTool.this.history == null || InteractiveTool.this.history.isEmpty()) {
                InteractiveTool.this.info("No command history available");
            } else if (this.numEntries == -1 || InteractiveTool.this.history.size() <= this.numEntries) {
                ListIterator iterator = InteractiveTool.this.history.entries();
                int i = 0;
                while (iterator.hasNext()) {
                    History.Entry entry = (History.Entry)iterator.next();
                    InteractiveTool.this.info(String.format(historyFormat, i++, entry.value().toString()));
                }
            } else {
                for (int i = InteractiveTool.this.history.size() - this.numEntries; i < InteractiveTool.this.history.size(); ++i) {
                    InteractiveTool.this.info(String.format(historyFormat, i, InteractiveTool.this.history.get(i).toString()));
                }
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"help"}, description="Displays help message")
    public final class Help
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="command", required=false, description="When specifies displays help for that command only")
        private String commandFilter;

        @Override
        public void execute() throws Exception {
            Iterator<Command> iterator = InteractiveTool.this.commands.values().iterator();
            HashSet<Command> commands = new HashSet<Command>();
            while (iterator.hasNext()) {
                Command command = iterator.next();
                if (!commands.contains(command)) {
                    boolean show;
                    boolean bl = show = this.commandFilter == null;
                    if (this.commandFilter != null) {
                        for (String commandName : command.keywords()) {
                            if (!commandName.equalsIgnoreCase(this.commandFilter)) continue;
                            show = true;
                        }
                    }
                    if (show) {
                        command.help();
                        if (!(command instanceof AnnotatedCommand)) {
                            InteractiveTool.this.info("");
                        }
                    }
                }
                commands.add(command);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"ansi"}, description="Enables or disables ansi output")
    public final class AnsiEnable
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="value", required=false, validOptions={"on", "off"}, description="Turns ansi on or off. With no argument display the current ansi setting")
        private String value;

        @Override
        public final void execute() throws IOException {
            if (this.value == null || this.value.trim().length() == 0) {
                InteractiveTool.this.info("ansi is " + (InteractiveTool.this.reader.getTerminal().isAnsiSupported() && Ansi.isDetected() && Ansi.isEnabled() ? "on" : "off"));
                return;
            }
            this.value = this.value.trim();
            if (this.value.equalsIgnoreCase("on") && Ansi.isDetected() && InteractiveTool.this.reader.getTerminal().isAnsiSupported()) {
                Ansi.setEnabled((boolean)true);
            } else {
                Ansi.setEnabled((boolean)false);
            }
        }
    }

    private final class EchoControlOutputStream
    extends FilterOutputStream {
        public EchoControlOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (InteractiveTool.this.echo) {
                this.out.write(b);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"echo"}, description="Displays a message or turns echo on or off")
    public final class Echo
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="value", required=false, description="Displays a message or turns echo on or off. With no argument list the current echo setting")
        private String value;
        @AnnotatedCommand.RemainingArgs(name="message", required=false, defaultValue="", description="A message to display")
        private String message;

        @Override
        public final void execute() throws IOException {
            if (this.value == null || this.value.trim().length() == 0) {
                InteractiveTool.this.info("echo is " + (InteractiveTool.this.echo ? "on" : "off"));
                return;
            }
            this.value = this.value.trim();
            if (this.value.equalsIgnoreCase("on")) {
                InteractiveTool.this.echo = true;
            } else if (this.value.equalsIgnoreCase("off")) {
                InteractiveTool.this.echo = false;
            } else {
                InteractiveTool.this.info(this.value + (this.message != null ? " " + this.message : ""));
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"script"}, description="Runs a command script")
    public final class Script
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="script", required=false, description="The script file to execute")
        private File commandFile;

        @Override
        public final void execute() throws IOException {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.commandFile));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    InteractiveTool.this.executeCommand(line);
                }
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"doc"}, hidden=true, description="Generated documentation.")
    public final class Doc
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(position=1, name="outputDir", required=true, defaultValue=".", description="The output directory to which to write the doc")
        File outputDir;

        @Override
        public final void execute() throws IOException {
            DocumentationGenerator docGen = new DocumentationGenerator(InteractiveTool.this);
            docGen.generate(InteractiveTool.this.name, DocumentationGenerator.Format.Html, this.outputDir);
        }
    }

    @AnnotatedCommand.Command(keywords={"bye", "exit", "quit"}, description="Exit the tool.")
    public final class Bye
    extends AnnotatedCommand {
        @Override
        public final void execute() {
            InteractiveTool.this.info("Exiting...");
            InteractiveTool.this.close();
            InteractiveTool.this.info("Ta!");
            System.exit(0);
        }
    }

    static class ConfigPropertyHandler {
        final ConfigProperty annotation;
        final Object container;
        final Field field;
        final String defaultValue;
        final UtlUnit.Unit unit;
        private final HashSet<String> validOptions = new HashSet();
        final HashSet<PropertyChangeHandler> changeHandlers = new HashSet();
        final PropertyParser parser;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConfigPropertyHandler(Object container, Field field, ConfigProperty annotation) throws InstantiationException, IllegalAccessException {
            this.container = container;
            this.annotation = annotation;
            this.field = field;
            this.defaultValue = annotation.defaultValue().equals(InteractiveTool.NIL) ? null : annotation.defaultValue();
            this.unit = annotation.unit();
            if (annotation.parser() != PassThroughPropertyParser.class) {
                if (this.unit != UtlUnit.Unit.None) {
                    throw new IllegalArgumentException("ConfigProperty annotation on " + field.toString() + " cannot specify both parser and unit properties");
                }
                Class<? extends PropertyParser> parserClass = annotation.parser();
                parserClass = annotation.parser();
                PropertyParser parser = null;
                try {
                    Constructor<? extends PropertyParser> constructor = parserClass.getConstructor(new Class[0]);
                    if (constructor != null) {
                        constructor.setAccessible(true);
                        parser = constructor.newInstance(new Object[0]);
                    }
                    parser = parserClass.newInstance();
                }
                catch (Exception e) {
                    try {
                        Method factoryMethod = parserClass.getMethod("create", new Class[0]);
                        factoryMethod.setAccessible(true);
                        parser = (PropertyParser)factoryMethod.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException("Couldn't instantiate property parser for '" + annotation.name() + "' and no static create factory method found: " + e.getMessage(), e);
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("Couldn't instantiate property parser for '" + annotation.name() + "' via create method (" + e.getMessage() + ") and no accessible zero arg constructor.", e2);
                    }
                }
                finally {
                    this.parser = parser;
                }
            } else {
                switch (this.unit) {
                    case Bytes: {
                        this.parser = new BytesPropertyParser(annotation.defaultByteUnit(), annotation.targetByteUnit());
                        break;
                    }
                    case None: {
                        this.parser = null;
                        break;
                    }
                    case Time: {
                        this.parser = new TimePropertyParser(annotation.defaultTimeUnit(), annotation.targetTimeUnit());
                        break;
                    }
                    default: {
                        this.parser = null;
                    }
                }
            }
            if (annotation.validOptions().length > 0) {
                for (String option : annotation.validOptions()) {
                    if (field.getType() != String.class) {
                        option = option.toLowerCase();
                    }
                    this.validOptions.add(option);
                }
            }
        }

        public void setValue(Object value) throws IllegalArgumentException, IllegalAccessException {
            if (this.parser != null) {
                value = this.parser.parse(InteractiveTool.asString(value), this.defaultValue);
            }
            if (value == null && this.defaultValue != null) {
                value = this.defaultValue;
            }
            if (value != null) {
                String strValue = InteractiveTool.asString(value);
                if (this.field.getType() != String.class) {
                    strValue = strValue.toLowerCase();
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(strValue)) {
                    throw new IllegalArgumentException(value + " is not a valid option for " + this.annotation.name() + ". Expected one of " + this.validOptions);
                }
            }
            try {
                this.field.set(this.container, UtlDataTypes.convert(this.field.getType(), value));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Error setting '" + this.annotation.name() + " value to '" + value + "': " + t.getMessage(), t);
            }
            for (PropertyChangeHandler handler : this.changeHandlers) {
                handler.onPropertyChange(this.annotation.name(), value);
            }
        }

        public String getValue() throws IllegalArgumentException, IllegalAccessException {
            Object value = this.field.get(this.container);
            if (value == null) {
                return null;
            }
            String valueStr = String.valueOf(this.field.get(this.container));
            block0 : switch (this.unit) {
                case Bytes: {
                    if (value instanceof String) break;
                    valueStr = valueStr + this.annotation.targetByteUnit().toString();
                    break;
                }
                case Time: {
                    if (value instanceof String) break;
                    switch (this.annotation.targetTimeUnit()) {
                        case DAYS: {
                            valueStr = valueStr + "d";
                            break block0;
                        }
                        case HOURS: {
                            valueStr = valueStr + "h";
                            break block0;
                        }
                        case MICROSECONDS: {
                            valueStr = valueStr + "us";
                            break block0;
                        }
                        case MILLISECONDS: {
                            valueStr = valueStr + "ms";
                            break block0;
                        }
                        case MINUTES: {
                            valueStr = valueStr + "m";
                            break block0;
                        }
                        case NANOSECONDS: {
                            valueStr = valueStr + "ns";
                            break block0;
                        }
                        case SECONDS: {
                            valueStr = valueStr + "s";
                            break block0;
                        }
                    }
                    break;
                }
            }
            return valueStr;
        }

        public String getReadableValue() throws IllegalArgumentException, IllegalAccessException {
            Object value = this.field.get(this.container);
            if (value == null) {
                return null;
            }
            String valueStr = String.valueOf(this.field.get(this.container));
            switch (this.unit) {
                case Bytes: {
                    if (value instanceof String) break;
                    valueStr = UtlUnit.readableBytesSize((long)UtlUnit.parseBytes(valueStr, this.annotation.targetByteUnit(), UtlUnit.ByteUnit.Bytes));
                    break;
                }
                case Time: {
                    if (value instanceof String) break;
                    valueStr = UtlUnit.formatDuration((long)UtlUnit.parseDuration(valueStr, this.annotation.targetTimeUnit(), TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    break;
                }
            }
            return valueStr;
        }

        public void load(Properties configProperties) throws IllegalArgumentException, IllegalAccessException {
            String value = configProperties.getProperty(this.annotation.name(), this.defaultValue);
            try {
                this.setValue(value);
            }
            catch (RuntimeException re) {
                if (this.defaultValue != null && !this.defaultValue.equals(value)) {
                    this.setValue(this.defaultValue);
                    throw new IllegalArgumentException("Failed to set '" + this.annotation.name() + "' to '" + value + "', set to default value '" + value + "' instead.", re);
                }
                throw re;
            }
        }

        public void save(Properties configProperties) throws IllegalArgumentException, IllegalAccessException {
            String value = this.getValue();
            if (value == null) {
                configProperties.remove(this.annotation.name());
            } else {
                configProperties.setProperty(this.annotation.name(), this.getValue());
            }
        }

        public void addChangeHandler(PropertyChangeHandler handler) {
            this.changeHandlers.add(handler);
        }

        public void removeChangeHandler(PropertyChangeHandler handler) {
            this.changeHandlers.remove(handler);
        }

        public void appendUsage(UtlTableFormatter.Table table) throws IllegalArgumentException, IllegalAccessException {
            String description = this.annotation.description();
            switch (this.unit) {
                case Bytes: {
                    if (!description.endsWith(".")) {
                        description = description + ".";
                    }
                    description = description + " If no unit suffix is specified the value is interpreted as " + this.annotation.defaultByteUnit().name();
                    break;
                }
                case None: {
                    break;
                }
                case Time: {
                    if (!description.endsWith(".")) {
                        description = description + ".";
                    }
                    description = description + " If no unit suffix is specified the value is interpreted as " + this.annotation.defaultTimeUnit().name();
                    break;
                }
            }
            table.addRow(this.annotation.name(), this.getReadableValue(), description);
        }
    }

    public static interface PropertyChangeHandler {
        public void onPropertyChange(String var1, Object var2);
    }

    public static final class BytesPropertyParser
    implements PropertyParser {
        final UtlUnit.ByteUnit defaultUnit;
        final UtlUnit.ByteUnit targetUnit;

        BytesPropertyParser(UtlUnit.ByteUnit defaultUnit, UtlUnit.ByteUnit targetUnit) {
            this.defaultUnit = defaultUnit;
            this.targetUnit = targetUnit;
        }

        @Override
        public Double parse(String value, String defaultValue) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                value = defaultValue;
            }
            return UtlUnit.parseBytes(value, this.defaultUnit, this.targetUnit);
        }
    }

    public static final class TimePropertyParser
    implements PropertyParser {
        final TimeUnit defaultUnit;
        final TimeUnit targetUnit;

        TimePropertyParser(TimeUnit defaultUnit, TimeUnit targetUnit) {
            this.defaultUnit = defaultUnit;
            this.targetUnit = targetUnit;
        }

        @Override
        public Double parse(String value, String defaultValue) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                value = defaultValue;
            }
            return UtlUnit.parseDuration(value, this.defaultUnit, this.targetUnit);
        }
    }

    public static final class BooleanPropertyParser
    implements PropertyParser {
        @Override
        public Boolean parse(String value, String defaultValue) throws IllegalArgumentException {
            if (value == null || value.trim().length() == 0) {
                value = defaultValue;
            }
            if ("on".equalsIgnoreCase(value) || "enabled".equals(value) || "true".equals(value)) {
                return true;
            }
            return false;
        }
    }

    private static final class PassThroughPropertyParser
    implements PropertyParser {
        private PassThroughPropertyParser() {
        }

        @Override
        public Object parse(String value, String defaultValue) throws IllegalArgumentException {
            return value;
        }
    }

    public static interface PropertyParser {
        public Object parse(String var1, String var2) throws IllegalArgumentException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ConfigProperty {
        public String name();

        public String defaultValue() default "$NIL";

        public String[] validOptions() default {};

        public String description() default "";

        public UtlUnit.Unit unit() default UtlUnit.Unit.None;

        public TimeUnit targetTimeUnit() default TimeUnit.SECONDS;

        public TimeUnit defaultTimeUnit() default TimeUnit.SECONDS;

        public UtlUnit.ByteUnit targetByteUnit() default UtlUnit.ByteUnit.Bytes;

        public UtlUnit.ByteUnit defaultByteUnit() default UtlUnit.ByteUnit.Bytes;

        public Class<? extends PropertyParser> parser() default PassThroughPropertyParser.class;
    }
}

