/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlObjectGraph;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class XStringTest
extends UnitTest {
    private static List<XStringHolder> createTestStrings(String content) {
        ArrayList<XStringHolder> ret = new ArrayList<XStringHolder>();
        ret.add(new XStringHolder(XString.create(content), "XString.create(\"" + content + "\")"));
        ret.add(new XStringHolder(XString.create(content, true), "XString.create(\"" + content + "\", true)"));
        ret.add(new XStringHolder(XString.create(content, false), "XString.create(\"" + content + "\", false)"));
        ret.add(new XStringHolder(XString.create(content, true, true), "XString.create(\"" + content + "\", true, true)"));
        ret.add(new XStringHolder(XString.create(content, true, false), "XString.create(\"" + content + "\", true, false)"));
        ret.add(new XStringHolder(XString.create(content, false, true), "XString.create(\"" + content + "\", false, true)"));
        ret.add(new XStringHolder(XString.create(content, false, false), "XString.create(\"" + content + "\", false, false)"));
        return ret;
    }

    @Test
    public void testImmutability() {
        XString target = XString.create(10, false, false);
        target.initialize("Initial");
        XStringTest.checkImmutable(target);
        target = XString.create(10, false, false);
        target.initializeFrom(XString.create("String1"));
        XStringTest.checkImmutable(target);
        target = XString.create(10, false, false);
        target.initializeFrom(XStringTest.syncDesync(XString.create("String1", true, false)));
        XStringTest.checkImmutable(target);
    }

    private static final void checkImmutable(XString target) {
        XString source = XString.create("String1");
        try {
            target.setValue(source.getValue());
            Assert.fail((String)"Shouldn't have been able to set value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            target.setValue(source.getBackingBuffer(), source.getBackingBufferOffset(), source.getSerializedLength());
            Assert.fail((String)"Shouldn't have been able to set buffer value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            target.initialize(source.getValue());
            Assert.fail((String)"Shouldn't have been able to initialize value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            target.setValue(source.getBackingBuffer(), source.getBackingBufferOffset(), source.getSerializedLength());
            Assert.fail((String)"Shouldn't have been able to initialize buffer value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCopyIntoUnitialized() {
        XString source = XString.create("String1");
        XString target = XString.create(source.length());
        source.copyInto(target);
        Assert.assertSame((Object)source.getValue(), (Object)target.getValue());
    }

    @Test
    public void testCopyIntoWithSourceChange() {
        String originalValue = "String1";
        XString source = XString.create(originalValue.length(), true, false);
        XString target = XString.create(originalValue.length(), true, false);
        source.setValue(originalValue);
        source.copyInto(target);
        Assert.assertSame((Object)source.getValue(), (Object)target.getValue());
        source.setValue("String2");
        Assert.assertEquals((Object)"String2", (Object)source.getValue());
        Assert.assertEquals((Object)"String1", (Object)target.getValue());
        Assert.assertEquals((Object)"String2", (Object)XStringTest.syncDesync(source).getValue());
        Assert.assertEquals((Object)"String1", (Object)XStringTest.syncDesync(target).getValue());
    }

    @Test
    public void testXStringAppendToMutable() {
        XString str1 = XString.create(7, true);
        str1.initialize("String1");
        XString str2 = XString.create("String2");
        XString str3 = str1.append(str2);
        Assert.assertSame((Object)str1, (Object)str3);
        Assert.assertEquals((Object)"String1String2", (Object)str3.getValue());
        Assert.assertEquals((Object)"String1String2", (Object)str1.getValue());
        Assert.assertEquals((Object)"String2", (Object)str2.getValue());
    }

    @Test
    public void testXStringAppendCharArrayToMutable() {
        XString str1 = XString.create(7, true);
        str1.initialize("String1");
        XString str2 = XString.create("String2");
        char[] str2Chars = new char[str2.length()];
        "String2".getChars(0, str2Chars.length, str2Chars, 0);
        XString str3 = str1.append(str2Chars);
        Assert.assertSame((Object)str1, (Object)str3);
        Assert.assertEquals((Object)"String1String2", (Object)str3.getValue());
        Assert.assertEquals((Object)"String1String2", (Object)str1.getValue());
        Assert.assertEquals((Object)"String2", (Object)str2.getValue());
    }

    @Test
    public void testXStringAppendByteArrayToMutable() {
        XString str1 = XString.create(7, true);
        str1.initialize("String1");
        XString str2 = XString.create("String2");
        byte[] str2Bytes = "String2".getBytes();
        XString str3 = str1.append(str2Bytes);
        Assert.assertSame((Object)str1, (Object)str3);
        Assert.assertEquals((Object)"String1String2", (Object)str3.getValue());
        Assert.assertEquals((Object)"String1String2", (Object)str1.getValue());
        Assert.assertEquals((Object)"String2", (Object)str2.getValue());
    }

    @Test
    public void testXStringCopyFromCharArrayToMutable() {
        XString str1 = XString.create(7, true);
        str1.initialize("String1");
        XString str2 = XString.create("StringTwo");
        char[] str2Chars = new char[str2.length()];
        "StringTwo".getChars(0, str2Chars.length, str2Chars, 0);
        str1.copyFrom(str2Chars);
        Assert.assertNotSame((Object)str1, (Object)str2);
        Assert.assertEquals((Object)"StringTwo", (Object)str1.getValue());
        Assert.assertEquals((Object)"StringTwo", (Object)str2.getValue());
    }

    @Test
    public void testXStringAppendCharArrayNonAsciiLeavesTargetUnchanged() {
        XString str1 = XString.create(7, true);
        str1.initialize("String1");
        XString str2 = XString.create("String2");
        char[] str3Chars = new char[str2.length()];
        "String\u5b57".getChars(0, str3Chars.length, str3Chars, 0);
        try {
            XString str3 = str1.append(str3Chars);
            Assert.fail((String)("Shouldn't be able to append non ascii: " + str3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"String1", (Object)str1.getValue());
        Assert.assertEquals((Object)"String2", (Object)str2.getValue());
    }

    @Test(expected=AssertionError.class)
    public void testXStringNonAsciiLengthIncorrect() {
        String str = "String\u5b57";
        XString str1 = XString.create(7, true);
        str1.initialize(str);
        Assert.assertEquals((String)"Wrong raw string length", (long)str.length(), (long)str1.length());
        IOElasticBuffer buffer = IOElasticBuffer.create(null, str1.getSerializedLength(), false);
        str1.copyInto(buffer, 0);
        XString str2 = XString.create(str1.getSerializedLength());
        str2.setValue(buffer, 0, buffer.getLength());
        Assert.assertEquals((String)"Deserialized String doesn't match", (Object)str1.getValue(), (Object)str2.getValue());
        Assert.assertEquals((String)"Deserialized String length is wrong", (long)str1.length(), (long)str2.length());
    }

    @Test
    public void testNonAsciiPassThrough() {
        String str = "\u5b57St\u5b57ring\u5b57";
        XString str1 = XString.create(7, true);
        str1.initialize(str);
        IOElasticBuffer buffer = IOElasticBuffer.create(null, str1.getSerializedLength(), false);
        str1.copyInto(buffer, 0);
        XString str2 = XString.create(str1.getSerializedLength());
        str2.setValue(buffer, 0, buffer.getLength());
        Assert.assertEquals((String)"Deserialized String doesn't match", (Object)str, (Object)str2.getValue());
        Assert.assertEquals((String)"Deserialized String length is wrong", (long)str1.length(), (long)str2.length());
    }

    @Test
    public void testXStringAppendToMutableNoBufferGrowth() {
        XString str1 = XString.create(7, true, false);
        str1.initialize("String1");
        XString str2 = XString.create("String2");
        XString str3 = str1.append(str2);
        Assert.assertSame((Object)str1, (Object)str3);
        Assert.assertEquals((Object)"String1String2", (Object)str3.getValue());
        Assert.assertEquals((Object)"String1String2", (Object)str1.getValue());
        Assert.assertEquals((Object)"String2", (Object)str2.getValue());
    }

    @Test
    public void testAppendToImmutable() {
        XString str1 = XString.create("String");
        try {
            str1.append('1');
            Assert.fail((String)"shouldn't be able to append to immutible raw String");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str1.append(1L);
            Assert.fail((String)"shouldn't be able to append to immutible raw String");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str1.append("String2");
            Assert.fail((String)"shouldn't be able to append to immutible raw String");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str1.append(XString.create("String3", false));
            Assert.fail((String)"shouldn't be able to append to immutible raw String");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            str1.append(str1);
            Assert.fail((String)"shouldn't be able to append to immutible raw String");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringCharAppendCopyToMutable() {
        XString target;
        String originalValue = "String";
        XString source = XString.create(originalValue.length(), true, false);
        source.initialize(originalValue);
        Assert.assertEquals((long)originalValue.length(), (long)source.length());
        XString str2 = target = XString.create(source.length(), true, false);
        for (int i = 0; i < source.length(); ++i) {
            str2 = str2.append(source.charAt(i));
        }
        Assert.assertSame((Object)target, (Object)str2);
        Assert.assertEquals((Object)"String", (Object)str2.getValue());
        Assert.assertEquals((Object)"String", (Object)XStringTest.syncDesync(str2).getValue());
    }

    private static XString syncDesync(XString string) {
        XString source = string;
        XString rc = XString.create();
        rc.setValue(source.getBackingBuffer(), source.getBackingBufferOffset(), source.getSerializedLength());
        return rc;
    }

    @Test
    public void testXStringEquals() {
        XString str1 = XString.create("String1", false);
        XString str2 = XString.create("String1", true);
        Assert.assertTrue((String)"Raw Strings should be equal", (boolean)str1.equals(str2));
        Assert.assertTrue((String)"Raw Strings should have same hashcode", (str1.hashCode() == str2.hashCode() ? 1 : 0) != 0);
        XString str3 = XString.create("String2", false);
        Assert.assertFalse((String)"Raw Strings should not be equal", (boolean)str1.equals(str3));
        Assert.assertFalse((String)"Raw Strings should not have same hashcode", (str1.hashCode() == str3.hashCode() ? 1 : 0) != 0);
        XString str4 = XString.create(256, true);
        Assert.assertEquals((String)"Expected unitialized String hashcode to be 0", (long)0L, (long)str4.hashCode());
        Assert.assertFalse((String)"Raw Strings should not be equal", (boolean)str1.equals(str4));
        str4.initialize(str1.getValue());
        Assert.assertTrue((String)"Raw Strings should be equal", (boolean)str1.equals(str4));
        Assert.assertTrue((String)"Raw Strings should have same hashcode", (str1.hashCode() == str4.hashCode() ? 1 : 0) != 0);
        str3.copyInto(str4);
        Assert.assertTrue((String)"Raw Strings should be equal", (boolean)str3.equals(str4));
        Assert.assertTrue((String)"Raw Strings should have same hashcode", (str3.hashCode() == str4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Raw Strings should not be equal", (boolean)str1.equals(str4));
        Assert.assertFalse((String)"Raw Strings should not have same hashcode", (str1.hashCode() == str4.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testSetXStringAsNumber() {
        int i;
        XString str = XString.create(32, true, true);
        Random random = new Random(System.currentTimeMillis());
        str.setValue(Long.MIN_VALUE);
        Assert.assertEquals((String)"Values don't match", (Object)Long.MIN_VALUE, (Object)Long.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)Long.MIN_VALUE, (long)str.getValueAsLong());
        str.setValue(Long.MAX_VALUE);
        Assert.assertEquals((String)"Values don't match", (Object)Long.MAX_VALUE, (Object)Long.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)Long.MAX_VALUE, (long)str.getValueAsLong());
        str.setValue(0L);
        Assert.assertEquals((String)"Values don't match", (Object)Long.valueOf(str.getValue()), (Object)0L);
        for (i = 0; i < 10000; ++i) {
            long value = random.nextLong();
            str.setValue(value);
            Assert.assertEquals((String)"Values don't match", (Object)Long.valueOf(str.getValue()), (Object)value);
            Assert.assertEquals((String)"Values don't match", (long)value, (long)str.getValueAsLong());
        }
        str.setValue(Integer.MIN_VALUE);
        Assert.assertEquals((String)"Values don't match", (Object)Integer.MIN_VALUE, (Object)Integer.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)Integer.MIN_VALUE, (long)str.getValueAsLong());
        str.setValue(Integer.MAX_VALUE);
        Assert.assertEquals((String)"Values don't match", (Object)Integer.MAX_VALUE, (Object)Integer.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)Integer.MAX_VALUE, (long)str.getValueAsLong());
        for (i = 0; i < 10000; ++i) {
            int value = random.nextInt();
            str.setValue(value);
            Assert.assertEquals((String)"Values don't match", (Object)Integer.valueOf(str.getValue()), (Object)value);
            Assert.assertEquals((String)"Values don't match", (long)value, (long)str.getValueAsLong());
        }
        str.setValue(-32768L);
        Assert.assertEquals((String)"Values don't match", (Object)Short.MIN_VALUE, (Object)Short.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)-32768L, (long)str.getValueAsLong());
        str.setValue(32767L);
        Assert.assertEquals((String)"Values don't match", (Object)Short.MAX_VALUE, (Object)Short.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)32767L, (long)str.getValueAsLong());
        for (i = 0; i < 10000; ++i) {
            short value = UtlObjectGraph.BuiltInHandler.getRandomValue(Short.class, random);
            str.setValue(value);
            Assert.assertEquals((String)"Values don't match", (Object)Short.valueOf(str.getValue()), (Object)value);
            Assert.assertEquals((String)"Values don't match", (long)value, (long)str.getValueAsLong());
        }
        str.setValue(-128L);
        Assert.assertEquals((String)"Values don't match", (Object)-128, (Object)Byte.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)-128L, (long)str.getValueAsLong());
        str.setValue(127L);
        Assert.assertEquals((String)"Values don't match", (Object)127, (Object)Byte.valueOf(str.getValue()));
        Assert.assertEquals((String)"Values don't match", (long)127L, (long)str.getValueAsLong());
        for (i = 0; i < 10000; ++i) {
            byte value = UtlObjectGraph.BuiltInHandler.getRandomValue(Byte.class, random);
            str.setValue(value);
            Assert.assertEquals((String)"Values don't match", (Object)Byte.valueOf(str.getValue()), (Object)value);
            Assert.assertEquals((String)"Values don't match", (long)value, (long)str.getValueAsLong());
        }
    }

    @Test
    public void testRawNumericAppend() {
        XString str = XString.create(32, true, true);
        int b = -10;
        int s = 5;
        int i = -1;
        long l = 12L;
        str.append(b);
        str.append(s);
        str.append(i);
        str.append(l);
        Assert.assertEquals((String)"Values don't match", (Object)("" + b + "" + s + "" + i + "" + l), (Object)str.getValue());
    }

    @Test
    @Ignore
    public void testXStringStringInitializeIsZeroGarbage() {
        String[] strings = new String[]{"TestString1", "TestString2", "TestString\u5b573"};
        XString str = XString.create(strings[2].length(), true, false);
        IOElasticBuffer buf = IOElasticBuffer.create(null, strings[2].length(), false);
        XString str2 = XString.create(strings[2].length(), true, false);
        for (int i = 0; i < 100000000; ++i) {
            str.setValue(strings[i % strings.length]);
            str.copyInto(buf, 0);
            str2.setValue(buf, 0, str.getSerializedLength());
            Assert.assertEquals((String)"String not equal", (Object)str, (Object)str2);
        }
    }

    @Test
    public void testXStringCharSequeceInitialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "Test\u5b57String";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        Assert.assertEquals((String)"Natively copied string doesn't match", (Object)testString, (Object)rawString.getValue());
    }

    @Test
    public void testXStringCharArrayInitialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue(testString.toCharArray());
        Assert.assertEquals((String)"Natively copied string doesn't match", (Object)testString, (Object)rawString.getValue());
    }

    @Test
    public void testXStringNativeInitialize() throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "Test\u5b57String";
        byteBuffer.put(testString.getBytes("UTF-8"));
        byteBuffer.flip();
        long address = UtlBuffer.getNativeBufferAddress(byteBuffer);
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValueFromMemory(address, byteBuffer.remaining());
        Assert.assertEquals((String)"Natively copied string doesn't match", (Object)testString, (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFromByteBuffer() throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "Test\u5b57String";
        byteBuffer.put(testString.getBytes("UTF-8"));
        byteBuffer.flip();
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue(byteBuffer);
        Assert.assertEquals((String)"ByteBuffer copied string doesn't match", (Object)testString, (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFromByteArray() throws UnsupportedEncodingException {
        String testString = "Test\u5b57String";
        byte[] bytes = testString.getBytes("UTF-8");
        XString rawString = XString.create(bytes.length, true, true);
        rawString.setValue(bytes);
        Assert.assertEquals((String)"byte array copied string doesn't match", (Object)testString, (Object)rawString.getValue());
        rawString.setValue("smiles".getBytes(), 1, 4);
        System.out.println(rawString);
    }

    @Test
    public void testXStringInitializeFromByteArrayPortion() throws UnsupportedEncodingException {
        String testString = "Test\u5b57String";
        byte[] bytes = testString.getBytes("UTF-8");
        XString rawString = XString.create(bytes.length, true, true);
        rawString.setValue(bytes, 1, bytes.length - 2);
        Assert.assertEquals((String)"byte array copied string doesn't match", (Object)"est\u5b57Strin", (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFrom0LengthByteArray() throws UnsupportedEncodingException {
        XString rawString = XString.create(1, true, true);
        Assert.assertFalse((String)"New string shouldn't be initialized", (boolean)rawString.isInitialized());
        rawString.setValue(new String("abcde").getBytes(), 1, 0);
        Assert.assertEquals((String)"byte array copied string doesn't match", (Object)"", (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFrom0LengthCharArray() throws UnsupportedEncodingException {
        XString rawString = XString.create(1, true, true);
        Assert.assertFalse((String)"New string shouldn't be initialized", (boolean)rawString.isInitialized());
        rawString.setValue(new String("abcde").toCharArray(), 1, 0);
        Assert.assertEquals((String)"byte array copied string doesn't match", (Object)"", (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFromByteArrayBoundChecks() throws UnsupportedEncodingException {
        byte[] array;
        XString rawString;
        block11: {
            block10: {
                block9: {
                    block8: {
                        rawString = XString.create(1, true, true);
                        Assert.assertFalse((String)"New string shouldn't be initialized", (boolean)rawString.isInitialized());
                        array = new String("abcdefghij").getBytes();
                        try {
                            rawString.setValue(array, array.length, 1);
                            Assert.fail((String)"bounds check should have failed");
                        }
                        catch (IllegalArgumentException e) {
                            if (!XStringTest.verbose()) break block8;
                            System.out.println(e.getMessage());
                        }
                    }
                    try {
                        rawString.setValue(array, -1, 1);
                        Assert.fail((String)"bounds check should have failed");
                    }
                    catch (IllegalArgumentException e) {
                        if (!XStringTest.verbose()) break block9;
                        e.printStackTrace();
                    }
                }
                try {
                    rawString.setValue(array, 0, 11);
                    Assert.fail((String)"bounds check should have failed");
                }
                catch (IllegalArgumentException e) {
                    if (!XStringTest.verbose()) break block10;
                    e.printStackTrace();
                }
            }
            try {
                rawString.setValue(array, 0, -1);
                Assert.fail((String)"bounds check should have failed");
            }
            catch (IllegalArgumentException e) {
                if (!XStringTest.verbose()) break block11;
                e.printStackTrace();
            }
        }
        Assert.assertFalse((String)"string should still be unitialized after illegal calls", (boolean)rawString.isInitialized());
        rawString.setValue(array, array.length - 1, 1);
        Assert.assertEquals((String)"char array copied string doesn't match", (Object)"j", (Object)rawString.getValue());
    }

    @Test
    public void testXStringInitializeFromCharArrayBoundChecks() throws UnsupportedEncodingException {
        char[] array;
        XString rawString;
        block11: {
            block10: {
                block9: {
                    block8: {
                        rawString = XString.create(1, true, true);
                        Assert.assertFalse((String)"New string shouldn't be initialized", (boolean)rawString.isInitialized());
                        array = new String("abcdefghij").toCharArray();
                        try {
                            rawString.setValue(array, array.length, 1);
                            Assert.fail((String)"bounds check should have failed");
                        }
                        catch (IllegalArgumentException e) {
                            if (!XStringTest.verbose()) break block8;
                            System.out.println(e.getMessage());
                        }
                    }
                    try {
                        rawString.setValue(array, -1, 1);
                        Assert.fail((String)"bounds check should have failed");
                    }
                    catch (IllegalArgumentException e) {
                        if (!XStringTest.verbose()) break block9;
                        e.printStackTrace();
                    }
                }
                try {
                    rawString.setValue(array, 0, 11);
                    Assert.fail((String)"bounds check should have failed");
                }
                catch (IllegalArgumentException e) {
                    if (!XStringTest.verbose()) break block10;
                    e.printStackTrace();
                }
            }
            try {
                rawString.setValue(array, 0, -1);
                Assert.fail((String)"bounds check should have failed");
            }
            catch (IllegalArgumentException e) {
                if (!XStringTest.verbose()) break block11;
                e.printStackTrace();
            }
        }
        Assert.assertFalse((String)"string should still be unitialized after illegal calls", (boolean)rawString.isInitialized());
        rawString.setValue(array, array.length - 1, 1);
        Assert.assertEquals((String)"char array copied string doesn't match", (Object)"j", (Object)rawString.getValue());
    }

    @Test
    public void testXStringAppendFromByteBuffer() throws UnsupportedEncodingException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "Test\u5b57String";
        byteBuffer.put(testString.getBytes("UTF-8"));
        byteBuffer.flip();
        XString rawString = XString.create(byteBuffer.remaining() + 4, true, true);
        rawString.setValue("Test");
        rawString.append(byteBuffer);
        Assert.assertEquals((String)"ByteBuffer copied string doesn't match", (Object)("Test" + testString), (Object)rawString.getValue());
    }

    @Test
    public void testXStringAsCharSequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString);
        Assert.assertEquals((String)"Raw String append as charSequence doesn't match", (Object)testString, (Object)builder.toString());
    }

    @Test
    public void testXStringTailCharSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(4, rawString.length()));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(4, testString.length()), (Object)builder.toString());
    }

    @Test
    public void testXStringHeadCharSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(0, 4));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(0, 4), (Object)builder.toString());
    }

    @Test
    public void testXStringInnerCharSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(1, 6));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(1, 6), (Object)builder.toString());
    }

    @Test
    public void testXStringCharSubsequenceEndOutofBounds() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        try {
            rawString.subSequence(4, rawString.length() + 1);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringCharSubsequenceStartOutOfBounds() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        try {
            rawString.subSequence(-1, 2);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringCharSubsequenceStartAfterEnd() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        try {
            rawString.subSequence(2, 1);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringTailCharSubsequenceSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(4, rawString.length()).subSequence(1, rawString.length() - 4));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(4, testString.length()).subSequence(1, testString.length() - 4), (Object)builder.toString());
    }

    @Test
    public void testXStringHeadCharSubsequenceSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(0, 4).subSequence(0, 2));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(0, 4).subSequence(0, 2), (Object)builder.toString());
    }

    @Test
    public void testXStringInnerCharSubsequenceSubsequence() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        XString rawString = XString.create(byteBuffer.remaining(), true, true);
        rawString.setValue((CharSequence)testString);
        StringBuilder builder = new StringBuilder();
        builder.append(rawString.subSequence(1, 6).subSequence(1, 3));
        Assert.assertEquals((String)"Raw String append as charSequence doesn't math", (Object)testString.subSequence(1, 6).subSequence(1, 3), (Object)builder.toString());
    }

    @Test
    public void testXStringCharSubsequenceSubsequenceEndOutofBounds() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        CharSequence cs = rawString.subSequence(1, 4);
        try {
            cs.subSequence(0, 4);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringCharSubsequenceSubsequenceStartOutOfBounds() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        CharSequence cs = rawString.subSequence(1, 5);
        try {
            cs.subSequence(-1, 2);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testXStringCharSubsequenceSubsequenceStartAfterEnd() {
        String testString = "TestString";
        XString rawString = XString.create(testString);
        CharSequence cs = rawString.subSequence(1, 5);
        try {
            cs.subSequence(2, 1);
            Assert.fail((String)"Expected index out of bounds");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testCharSequenceToString() {
        String testString = "TestTest";
        XString rawString = XString.create(testString);
        Assert.assertEquals((String)"XString subsequences should be equal", (Object)"Test", (Object)rawString.subSequence(0, 4).toString());
    }

    @Test
    public void testCharSequenceEquality() {
        String testString = "TestTest";
        XString rawString = XString.create(testString);
        Assert.assertEquals((String)"XString subsequences should be equal", (Object)rawString.subSequence(0, 4), (Object)rawString.subSequence(4, rawString.length()));
        Assert.assertEquals((String)"XString full subsequence should equal XString", (Object)rawString, (Object)rawString.subSequence(0, rawString.length()));
        Assert.assertEquals((String)"XString should equal full subsequence", (Object)rawString.subSequence(0, rawString.length()), (Object)rawString);
        Assert.assertNotEquals((String)"Different XString subsequences should not be equal", (Object)rawString.subSequence(1, 2), (Object)rawString.subSequence(2, 3));
        Assert.assertEquals((String)"XString subsequence hashcodes should be equal", (long)rawString.subSequence(0, 4).hashCode(), (long)rawString.subSequence(4, rawString.length()).hashCode());
        Assert.assertEquals((String)"XString full subsequence hashcodes should equal XString hashcodes", (long)rawString.hashCode(), (long)rawString.subSequence(0, rawString.length()).hashCode());
        Assert.assertNotEquals((String)"XString should equal String with same value", (Object)rawString, (Object)testString);
        Assert.assertNotEquals((String)"String should not equal XString with same value", (Object)testString, (Object)rawString);
        Assert.assertNotEquals((String)"String subequence should not equal XString subsequence with same value", (Object)testString.subSequence(0, 4), (Object)rawString.subSequence(0, 4));
        Assert.assertNotEquals((String)"XString subequence should not equal String subequence with same value", (Object)testString.subSequence(0, 4), (Object)rawString.subSequence(0, 4));
    }

    @Test
    public void testIndexOf() {
        XString uninitialized = XString.create();
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)uninitialized.indexOf(null));
        XString cString = XString.create("c");
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)cString.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)cString.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)cString.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)cString.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)cString.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)cString.indexOf(null));
        XString aString = XString.create("a");
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aString.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aString.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aString.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf('a', 2));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf("a", 2));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf(XString.create("a"), 2));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf('a', -1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf("a", -1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf(XString.create("a"), -1));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aString.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aString.indexOf(null));
        XString aaString = XString.create("aa");
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aaString.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aaString.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aaString.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)aaString.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aaString.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aaString.indexOf(null));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)aaString.indexOf('a', 1));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)aaString.indexOf("a", 1));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)aaString.indexOf(XString.create("a"), 1));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)aaString.indexOf(XString.create(""), 1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)aaString.indexOf(XString.create(), 1));
        Assert.assertEquals((String)"Wrong index", (float)-1.0f, (float)aaString.indexOf(null), (float)1.0f);
        XString abString = XString.create("ab");
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)abString.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)abString.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)abString.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)abString.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf(null));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf('a', 1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf("a", 1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf(XString.create("a"), 1));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)abString.indexOf(XString.create(""), 1));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)abString.indexOf(XString.create(), 1));
        Assert.assertEquals((String)"Wrong index", (float)-1.0f, (float)abString.indexOf(null), (float)1.0f);
        XString baString = XString.create("ba");
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)baString.indexOf('a'));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)baString.indexOf("a"));
        Assert.assertEquals((String)"Wrong index", (long)1L, (long)baString.indexOf(XString.create("a")));
        Assert.assertEquals((String)"Wrong index", (long)0L, (long)baString.indexOf(XString.create("")));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)baString.indexOf(XString.create()));
        Assert.assertEquals((String)"Wrong index", (long)-1L, (long)baString.indexOf(null));
    }

    @Test
    public void testSetChar() {
        XString string = XString.create();
        string.setValue("abc");
        string.setCharAt(0, 'd');
        Assert.assertEquals((String)"Replace failed", (Object)"dbc", (Object)string.toString());
        string.setCharAt(1, 'e');
        Assert.assertEquals((String)"Replace failed", (Object)"dec", (Object)string.toString());
        string.setCharAt(2, 'f');
        Assert.assertEquals((String)"Replace failed", (Object)"def", (Object)string.toString());
        try {
            string.setCharAt(-1, 'q');
            Assert.fail((String)"Shouldn't be able to setChar at index -1");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((String)"String was changed", (Object)"def", (Object)string.toString());
        }
        try {
            string.setCharAt(3, 'q');
            Assert.fail((String)"Shouldn't be able to setChar at index 3");
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertEquals((String)"String was changed", (Object)"def", (Object)string.toString());
        }
        try {
            String s = new String("\u5b57");
            string.setCharAt(1, s.charAt(0));
            Assert.fail((String)"Shouldn't be able to setChar with non ascii");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"String was changed", (Object)"def", (Object)string.toString());
        }
        string = XString.create("abc");
        try {
            string.setCharAt(1, 'q');
            Assert.fail((String)"Shouldn't be able to setChar on immutable string");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)"String was changed", (Object)"abc", (Object)string.toString());
        }
    }

    @Test
    public void testCharAt() {
        for (XStringHolder sh : XStringTest.createTestStrings("foo")) {
            Assert.assertEquals((String)("Wrong char at pos 0 for '" + sh.description + "'"), (Object)new Character('f'), (Object)new Character(sh.str.charAt(0)));
        }
    }

    @Test
    public void testUTFString() throws Exception {
        String str = "1";
        str = str + "\u07ff";
        str = str + "\u5b57";
        str = str + "\ud83d\ude00";
        Assert.assertEquals((long)10L, (long)IOElasticBuffer.calculateUTFLength(str));
        Assert.assertEquals((long)10L, (long)IOBuffer.calculateUTFLength(str));
        XString string1 = XString.create();
        string1.setValue(str);
        Assert.assertEquals((Object)str, (Object)string1.getValue());
        XString string2 = XString.create();
        string2.setValue(string1);
        Assert.assertEquals((Object)str, (Object)string2.getValue());
        XString string3 = XString.create();
        string3.setValue(str.getBytes("UTF-8"));
        Assert.assertEquals((Object)str, (Object)string3.getValue());
        XString string4 = XString.create();
        string4.setValue(str);
        ByteBuffer bytebuf = ByteBuffer.allocate(string4.getSerializedLength());
        string4.copyInto(bytebuf, 0);
        Assert.assertEquals((Object)str, (Object)new String(bytebuf.array(), "UTF-8"));
    }

    private static class XStringHolder {
        XString str;
        String description;

        XStringHolder(XString str, String description) {
            this.str = str;
            this.description = description;
        }
    }
}

