/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.test.unit;

import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public final class DiscoveryCacheFactoryTest
extends UnitTest {
    @Test
    public void testGetInstanceAlwaysReturnsSameFactoryInstance() {
        DiscoveryCacheFactory factory = DiscoveryCacheFactory.getInstance();
        Assert.assertEquals((Object)((Object)factory), (Object)((Object)DiscoveryCacheFactory.getInstance()));
    }

    @Test
    public void testOpenCacheWithNullDescriptorString() throws Exception {
        try {
            DiscoveryCacheFactory.getInstance().createCache(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenCacheWithMalformedDescriptorString1() throws Exception {
        try {
            DiscoveryCacheFactory.getInstance().createCache("invalid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenCacheWithMalformedDescriptorString2() throws Exception {
        try {
            DiscoveryCacheFactory.getInstance().createCache("invalid://");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenCacheWithInvalidProvider() throws Exception {
        try {
            DiscoveryCacheFactory.getInstance().createCache("invalid://address");
            Assert.fail();
        }
        catch (EDiscoveryException eDiscoveryException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDefaultAlwaysReturnsSameCacheInstance() throws Exception {
        IDiscoveryCache defCache = DiscoveryCacheFactory.getInstance().getDefaultCache();
        Assert.assertNotNull((Object)defCache);
        try {
            Assert.assertEquals((Object)defCache, (Object)DiscoveryCacheFactory.getInstance().getDefaultCache());
        }
        finally {
            DiscoveryCacheFactory.getInstance().close();
        }
    }

    @Test
    public void testGetDefaultAlwaysReturnsDiffCacheInstanceAfterClose() throws Exception {
        DiscoveryCacheFactory factory = DiscoveryCacheFactory.getInstance();
        IDiscoveryCache defCache = factory.getDefaultCache();
        Assert.assertNotNull((Object)defCache);
        factory.close();
        try {
            Assert.assertNotSame((Object)defCache, (Object)factory.getDefaultCache());
        }
        finally {
            factory.close();
        }
    }
}

