/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestAppAnnotatedHandlers;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.rog.log.RogLog;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineStateTest
extends AepEngineTest {
    private int counter = 0;

    @Test
    public void testInit() throws Exception {
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Init));
        Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Init));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
    }

    @Test
    public void testInitStop() throws Exception {
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        engine.stop();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Stopped));
        Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Stopped));
    }

    @Test
    public void testInitStartingStarted() throws Exception {
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Started));
        engine.waitForMessagingToStart();
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
    }

    @Test(expected=EAepException.class)
    public void testInitStartingStoppingStopped() throws Exception {
        String engineName = "Engine-" + System.currentTimeMillis() + "-" + this.counter++;
        AepEngine engine = this.createEngine(engineName, null, null, null, null, null, true, true, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        RogLog.failOpen((boolean)true);
        try {
            engine.start();
        }
        finally {
            Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Stopped));
            Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Stopped));
        }
    }

    @Test
    public void testInitStartingStartedStoppingStopped() throws Exception {
        AepEngine engine = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 1, 1, null, null, null, 0, false, false, null, null, null, false, false);
        engine.start();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Started));
        engine.waitForMessagingToStart();
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        engine.stop();
        Assert.assertEquals((Object)((Object)engine.getState()), (Object)((Object)AepEngine.State.Stopped));
        Assert.assertEquals((Object)((Object)engine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Stopped));
    }

    @Test
    public void testInitStartingStartedStoppingStoppedLoad() throws Exception {
        final AepEngineTestAppAnnotatedHandlers app = new AepEngineTestAppAnnotatedHandlers();
        this.startSenderStandaloneReceiverStandalone(app, null, null, null, null, 1, 1, 1, 0, AepEngine.HAPolicy.EventSourcing, false, false);
        final AepEngine senderEngine = (AepEngine)((Object)this.engines.get(0));
        AepEngine receiverEngine = (AepEngine)((Object)this.engines.get(1));
        Thread thread = new Thread(){

            @Override
            public final void run() {
                for (int i = 0; i < 10000; ++i) {
                    senderEngine.sendMessage(app.channel1, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
                }
            }
        };
        thread.start();
        receiverEngine.stop();
        Assert.assertEquals((Object)((Object)receiverEngine.getState()), (Object)((Object)AepEngine.State.Stopped));
        Assert.assertEquals((Object)((Object)receiverEngine.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Stopped));
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

