/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event.test.unit;

import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import org.junit.Test;

public final class EventMultiplexerSingleThreadedTest {
    private static final int EVENT_COUNT = 1000000;

    @Test(expected=IllegalStateException.class)
    public void testOnEventWithoutOpen() {
        EventMultiplexerSingleThreaded.create("Test", true, new Receiver(null, null), null).onEvent(new PublishEvent());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOnEventUsingNullEvent() {
        IEventMultiplexer mux = EventMultiplexerSingleThreaded.create("Test", true, new Receiver(null, null), null);
        mux.open();
        mux.onEvent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStress() throws Exception {
        for (int i = 0; i < 5; ++i) {
            System.out.println("Run " + (i + 1) + "...");
            Forwarder forwarder = new Forwarder();
            IEventMultiplexer mux = forwarder.mux = EventMultiplexerSingleThreaded.create("forwarder", false, forwarder, null);
            Receiver[] receivers = new Receiver[]{new Receiver(mux, InjectionType.Multiplex), new Receiver(mux, InjectionType.Multiplex), new Receiver(mux, InjectionType.Schedule), new Receiver(mux, InjectionType.Schedule), new Receiver(mux, InjectionType.Schedule)};
            Publisher[] pubs = new Publisher[]{new Publisher(1000000, mux, InjectionType.Publish), new Publisher(1000000, mux, InjectionType.Multiplex)};
            forwarder.open(receivers);
            try {
                for (Publisher pub : pubs) {
                    pub.start();
                }
                for (Publisher pub : pubs) {
                    pub.join();
                }
                System.out.println("------------------");
                do {
                    Thread.sleep(100L);
                    for (int k = 0; k < pubs.length; ++k) {
                        System.out.println("Pub" + k + ": " + pubs[k].published);
                    }
                    System.out.println("FwdP: " + forwarder.publishedEventsReceived);
                    System.out.println("FwdF: " + forwarder.forwardedEventsReceived);
                    System.out.println("FwdT: " + forwarder.timerEventsReceived);
                } while (forwarder.publishedEventsReceived != pubs.length * 1000000 || forwarder.forwardedEventsReceived != pubs.length * 1000000 * receivers.length);
                System.out.println("------------------");
                continue;
            }
            finally {
                forwarder.close();
            }
        }
    }

    private static final class Receiver
    implements IEventHandler {
        final IEventMultiplexer mux;
        final InjectionType injectionType;

        Receiver(IEventMultiplexer mux, InjectionType injectionType) {
            this.mux = mux;
            this.injectionType = injectionType;
        }

        @Override
        public final void onEvent(Event event) {
            if (this.mux != null) {
                if (this.injectionType == InjectionType.Multiplex) {
                    this.mux.multiplexEvent(event, 1);
                } else if (this.injectionType == InjectionType.Schedule) {
                    this.mux.scheduleEvent(event);
                } else {
                    throw new IllegalArgumentException("unknown injection type '" + (Object)((Object)this.injectionType) + "'");
                }
            }
        }
    }

    private static final class Forwarder
    implements IEventHandler {
        Receiver[] receivers;
        IEventMultiplexer mux;
        IEventMultiplexer[] rmuxes;
        volatile int publishedEventsReceived;
        volatile int forwardedEventsReceived;
        volatile int timerEventsReceived;

        private Forwarder() {
        }

        private final void scheduleTimer() {
            this.mux.scheduleEvent(new TimerEvent());
        }

        final void open(Receiver[] receivers) {
            this.rmuxes = new IEventMultiplexer[receivers.length];
            for (int i = 0; i < receivers.length; ++i) {
                this.rmuxes[i] = EventMultiplexerSingleThreaded.create("receiver-" + i, false, receivers[i], null);
            }
            for (IEventMultiplexer mux : this.rmuxes) {
                mux.open();
            }
            this.mux.open();
            this.scheduleTimer();
        }

        @Override
        public final void onEvent(Event event) {
            switch (event.getType()) {
                case 10000: {
                    ++this.publishedEventsReceived;
                    ForwardEvent forwardEvent = new ForwardEvent();
                    for (IEventMultiplexer mux : this.rmuxes) {
                        mux.onEvent(forwardEvent);
                    }
                    break;
                }
                case 10001: {
                    ++this.forwardedEventsReceived;
                    break;
                }
                case 10002: {
                    ++this.timerEventsReceived;
                    this.scheduleTimer();
                }
            }
        }

        final void close() {
            this.mux.close();
            for (IEventMultiplexer mux : this.rmuxes) {
                mux.close();
            }
        }
    }

    private static final class Publisher
    extends Thread {
        final int numEvents;
        final IEventMultiplexer mux;
        final InjectionType injectionType;
        int published;

        Publisher(int numEvents, IEventMultiplexer mux, InjectionType injectionType) {
            this.setName("Publisher");
            this.numEvents = numEvents;
            this.mux = mux;
            this.injectionType = injectionType;
        }

        private final void printStats() {
            System.out.println("Pub (" + Thread.currentThread().getId() + ", " + (Object)((Object)this.injectionType) + "): published " + this.published);
        }

        @Override
        public final void run() {
            long ts = System.currentTimeMillis();
            for (int i = 0; i < this.numEvents; ++i) {
                if (this.injectionType == InjectionType.Publish) {
                    this.mux.onEvent(new PublishEvent());
                } else if (this.injectionType == InjectionType.Multiplex) {
                    this.mux.multiplexEvent(new PublishEvent(), 0);
                } else {
                    throw new IllegalArgumentException("unknown injection type '" + (Object)((Object)this.injectionType) + "'");
                }
                ++this.published;
                long now = System.currentTimeMillis();
                if (now - ts < 1000L) continue;
                this.printStats();
                ts = now;
            }
            this.printStats();
        }
    }

    private final class ScheduledEvent
    extends Event {
        ScheduledEvent() {
            super((short)10003);
        }

        @Override
        protected void reset() {
        }
    }

    private static final class TimerEvent
    extends Event {
        TimerEvent() {
            super((short)10002);
            this.setDelay(10);
        }

        @Override
        protected void reset() {
        }
    }

    private static final class ForwardEvent
    extends Event {
        ForwardEvent() {
            super((short)10001);
        }

        @Override
        protected void reset() {
        }
    }

    private static final class PublishEvent
    extends Event {
        PublishEvent() {
            super((short)10000);
        }

        @Override
        protected void reset() {
        }
    }

    private static enum InjectionType {
        Publish,
        Multiplex,
        Schedule;

    }
}

