/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.adm.test.unit.proto.Child1;
import com.neeve.adm.test.unit.proto.ChildEntity;
import com.neeve.adm.test.unit.proto.ChildLongMap;
import com.neeve.adm.test.unit.proto.ChildStringMap;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.proto.NoFieldEntity;
import com.neeve.adm.test.unit.proto.NoFieldLongMap;
import com.neeve.adm.test.unit.proto.Parent;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.test.unit.RogRecoveryAndReplicationTestBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class RogCollectionsTest
extends RogRecoveryAndReplicationTestBase {
    public RogCollectionsTest(boolean persistent, RogRecoveryAndReplicationTestBase.FailureType failureType, boolean compactionEnabled, boolean cdcEnabled) {
        super(persistent, failureType, compactionEnabled, cdcEnabled);
    }

    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        return Arrays.asList(new Factory());
    }

    @Test
    public void testMapClearStringMap() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        this.primaryMember().commit(true);
        ChildStringMap map = parent.getStringMapField();
        for (int i = 0; i < 5; ++i) {
            map.put("" + i, Factory.createChild1());
        }
        this.primaryMember().commit(true);
        Parent replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        ChildStringMap replicatedMap = replicated.getStringMapField();
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)5L, (long)replicatedMap.size());
        map.clear();
        this.primaryMember().commitAndFail(true);
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getStringMapField();
        parent = (Parent)this.primaryMember().getRootObject(map.getGraphId());
        map = parent.getStringMapField();
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getStringMapField();
        Assert.assertEquals((String)"Primary map is incorrect size", (long)0L, (long)map.size());
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)0L, (long)replicatedMap.size());
    }

    @Test
    public void testMapClearLongMap() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        this.primaryMember().commit(true);
        ChildLongMap map = parent.getLongMapField();
        for (int i = 0; i < 5; ++i) {
            map.put((long)i, Factory.createChild1());
        }
        this.primaryMember().commit(true);
        Parent replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        ChildLongMap replicatedMap = replicated.getLongMapField();
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)5L, (long)replicatedMap.size());
        map.clear();
        this.primaryMember().commitAndFail(true);
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getLongMapField();
        parent = (Parent)this.primaryMember().getRootObject(map.getGraphId());
        map = parent.getLongMapField();
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getLongMapField();
        Assert.assertEquals((String)"Primary map is incorrect size", (long)0L, (long)map.size());
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)0L, (long)replicatedMap.size());
    }

    @Test
    public void testMapReadd() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        parent.getLongMapField().put(1L, child1);
        this.primaryMember().commitAndFail(true);
        parent = (Parent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = (Child1)parent.getLongMapField().get(1L);
        parent.getLongMapField().put(1L, child1);
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(1L, child1);
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(2L, child1);
        this.primaryMember().getStore().rollback();
        Assert.assertEquals((String)("Child map value not rolled back to original key. map entries are " + parent.getLongMapField().entrySet()), (Object)child1, parent.getLongMapField().get(1L));
    }

    @Test
    public void testMapReaddRollback() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        parent.getLongMapField().put(1L, child1);
        this.primaryMember().commitAndFail(true);
        parent = (Parent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = (Child1)parent.getLongMapField().get(1L);
        parent.getLongMapField().put(1L, child1);
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(1L, child1);
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(2L, child1);
        this.primaryMember().getStore().rollback();
        Assert.assertEquals((String)("Child map value not rolled back to original key. map entries are " + parent.getLongMapField().entrySet()), (Object)child1, parent.getLongMapField().get(1L));
    }

    @Test
    public void testMapAddUpdateRemove() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        parent.getLongMapField().put(1L, child1);
        ChildEntity grandChild = ChildEntity.create();
        child1.getLongMapField().put(2L, grandChild);
        this.primaryMember().commit(true);
        child1.setDateField(new Date());
        this.primaryMember().commit(true);
        ((Child1)parent.getLongMapField().get(1L)).setLongField(2L);
        parent.getLongMapField().remove(1L);
        this.primaryMember().commit(true);
        this.primaryMember().commitAndFail(true);
        Assert.assertEquals((String)"Child map value not removed", null, parent.getLongMapField().get(1L));
    }

    @Test
    public void testMapReaddUpdateRollback() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        parent.getLongMapField().put(1L, child1);
        child1.setFloatField(1.0f);
        this.primaryMember().commitAndFail(true);
        parent = (Parent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = (Child1)parent.getLongMapField().get(1L);
        parent.getLongMapField().put(1L, child1);
        child1.setFloatField(2.0f);
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(1L, child1);
        parent.getLongMapField().remove(1L);
        child1.setFloatField(3.0f);
        parent.getLongMapField().put(2L, child1);
        this.primaryMember().getStore().rollback();
        Assert.assertEquals((String)("Child map value not rolled back to original key. map entries are " + parent.getLongMapField().entrySet()), (Object)child1, parent.getLongMapField().get(1L));
        Assert.assertEquals((String)"Child field value not rolled back to original value", (float)1.0f, (float)child1.getFloatField(), (float)0.0f);
    }

    @Test
    public void testSetFieldNullAndReaddEntity() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Parent.create(this.nextGraphId()));
        parent.setEntityField(Child1.create());
        Child1 child = parent.getEntityField();
        parent.setEntityField(null);
        parent.setEntityField(child);
        this.primaryMember().commit(true);
        parent.setEntityField(null);
        parent.setEntityField(child);
    }

    @Test
    public void testNoFieldMap() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Factory.createParent(this.nextGraphId()));
        this.primaryMember().commit(true);
        NoFieldLongMap map = parent.getNoFieldLongMap();
        for (long i = 0L; i < 5L; ++i) {
            map.put(i, Factory.createNoFieldEntity());
        }
        this.primaryMember().commit(true);
        Parent replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        NoFieldLongMap replicatedMap = replicated.getNoFieldLongMap();
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)5L, (long)replicatedMap.size());
        Assert.assertEquals((String)"Replicated entry 2 has incorrect id", (Object)((NoFieldEntity)map.get(2L)).getId(), (Object)((NoFieldEntity)replicatedMap.get(2L)).getId());
        map.clear();
        this.primaryMember().commitAndFail(true);
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getNoFieldLongMap();
        parent = (Parent)this.primaryMember().getRootObject(map.getGraphId());
        map = parent.getNoFieldLongMap();
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = replicated.getNoFieldLongMap();
        Assert.assertEquals((String)"Primary map is incorrect size", (long)0L, (long)map.size());
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)0L, (long)replicatedMap.size());
    }

    @Test
    public void teNestedContainerNodeDetach() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Parent.create(this.nextGraphId()));
        Child1 child = Child1.create();
        for (int i = 0; i < 7; ++i) {
            child.getChildQueueField().add(ChildEntity.create());
        }
        HashSet<UUID> idsThatShouldBeRemoved = new HashSet<UUID>();
        for (ChildEntity ce : child.getChildQueueField()) {
            idsThatShouldBeRemoved.add(ce.getId());
        }
        parent.getLongMapField().put(1L, child);
        this.primaryMember().commit(true);
        Child1 removed = (Child1)parent.getLongMapField().remove(1L);
        this.primaryMember().commit(true);
        for (UUID id : idsThatShouldBeRemoved) {
            Assert.assertNull((String)"Descendent node have been removed", (Object)this.primaryMember().getStore().get(id));
        }
    }

    @Test
    public void testStringMapMultipleAddIllegal() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Parent.create(this.nextGraphId()));
        Child1 entity = Child1.create();
        parent.getStringMapField().put("1", entity);
        try {
            parent.getStringMapField().put("2", entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        parent.getStringMapField().remove("1");
        parent.getStringMapField().put("2", entity);
        this.primaryMember().commit(true);
        Parent replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", replicated.getStringMapField().get("2"));
        parent.getStringMapField().put("2", entity);
        this.primaryMember().commit(true);
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", replicated.getStringMapField().get("2"));
        try {
            parent.setEntityField(entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        ((Child1)parent.getStringMapField().remove("2")).acquire();
        this.primaryMember().commit(true);
        parent.setEntityField(entity);
        this.primaryMember().commit(true);
        Assert.assertNotNull((String)"entity was not replicated to backup", (Object)replicated.getEntityField());
    }

    @Test
    public void testLongMapMultipleAddIllegal() throws Exception {
        Parent parent = this.primaryMember().addRootObject(Parent.create(this.nextGraphId()));
        Child1 entity = Child1.create();
        parent.getLongMapField().put(1L, entity);
        try {
            parent.getLongMapField().put(2L, entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        parent.getLongMapField().remove(1L);
        parent.getLongMapField().put(2L, entity);
        this.primaryMember().commit(true);
        Parent replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", replicated.getLongMapField().get(2L));
        parent.getLongMapField().put(2L, entity);
        this.primaryMember().commit(true);
        replicated = (Parent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", replicated.getLongMapField().get(2L));
        try {
            parent.setEntityField(entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        ((Child1)parent.getLongMapField().remove(2L)).acquire();
        this.primaryMember().commit(true);
        parent.setEntityField(entity);
        this.primaryMember().commit(true);
        Assert.assertNotNull((String)"entity was not replicated to backup", (Object)replicated.getEntityField());
    }
}

