/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.ods.IStorePersister;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.rog.log.RogLog;
import com.neeve.test.UnitTest;
import java.util.Properties;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class RogLogStartupExpectationsTest
extends UnitTest {
    private Random random = new Random(System.currentTimeMillis());
    private static int count;

    private final RogLog createLog(String name) throws Exception {
        Properties props = new Properties();
        props.setProperty("initialLogLength", "0.001");
        return RogLog.create(name, props);
    }

    @Test
    public void testLogStartupNoExpectation() throws Exception {
        String name = "logStartupExpectationsTest-" + System.currentTimeMillis() + "-" + ++count;
        RogLog log = this.createLog(name);
        log.open();
        log.close();
        log = this.createLog(name);
        log.open();
        log.close();
    }

    @Test(expected=OdsExpectationNotMetException.class)
    public void testLogStartupPresentExpectationButLogAbsent() throws Exception {
        String name = "logStartupExpectationsTest-" + System.currentTimeMillis() + "-" + ++count;
        RogLog log = this.createLog(name);
        log.setStartupExpectation(IStorePersister.StartupExpectation.LogPresence, IStorePersister.LogPresenceExpectation.Present);
        try {
            log.open();
        }
        catch (OdsExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)IStorePersister.StartupExpectation.LogPresence), e.getUnmetExpectationType());
            Assert.assertSame((Object)((Object)IStorePersister.LogPresenceExpectation.Present), e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test
    public void testLogStartupPresentExpectationAndLogPresent() throws Exception {
        String name = "logStartupExpectationsTest-" + System.currentTimeMillis() + "-" + ++count;
        RogLog log = this.createLog(name);
        log.open();
        log.close();
        log = this.createLog(name);
        log.setStartupExpectation(IStorePersister.StartupExpectation.LogPresence, IStorePersister.LogPresenceExpectation.Present);
        log.open();
        log.close();
    }

    @Test(expected=OdsExpectationNotMetException.class)
    public void testLogStartupAbsentExpectationButLogPresent() throws Exception {
        String name = "logStartupExpectationsTest-" + System.currentTimeMillis() + "-" + ++count;
        RogLog log = this.createLog(name);
        log.open();
        log.close();
        log = this.createLog(name);
        log.setStartupExpectation(IStorePersister.StartupExpectation.LogPresence, IStorePersister.LogPresenceExpectation.Absent);
        try {
            log.open();
        }
        catch (OdsExpectationNotMetException e) {
            Assert.assertSame((Object)((Object)IStorePersister.StartupExpectation.LogPresence), e.getUnmetExpectationType());
            Assert.assertSame((Object)((Object)IStorePersister.LogPresenceExpectation.Absent), e.getUnmetExpectationValue());
            throw e;
        }
    }

    @Test
    public void testLogStartupAbsentExpectationAndLogAbsent() throws Exception {
        String name = "logStartupExpectationsTest-" + System.currentTimeMillis() + "-" + ++count;
        RogLog log = this.createLog(name);
        log.setStartupExpectation(IStorePersister.StartupExpectation.LogPresence, IStorePersister.LogPresenceExpectation.Absent);
        log.open();
        log.close();
    }
}

