/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.google.protobuf.Message;
import com.neeve.io.IOBuffer;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.IRogCollectionNode;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogContainerNode;
import com.neeve.rog.impl.RogField;
import com.neeve.rog.impl.RogNode;
import com.neeve.sma.MessageView;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public abstract class RogCollectionNode<T extends IRogCollectionNodeElement>
extends RogContainerNode
implements IRogCollectionNode<T> {
    protected RogCollectionNode(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
    }

    public static List<RogField<? extends RogNode, ?>> getFields() {
        return Collections.emptyList();
    }

    protected final boolean addChild(T node) {
        this.assertSingleParent((IRogNode)node);
        if (node.getFid() != 0L) {
            if (node.getParent() == this) {
                throw new ERogIllegalParentReferenceException("'" + node.getClass().getSimpleName() + "' cannot be added to this '" + this.getClass().getSimpleName() + "' collection it is already an element of this collection and can only be added once.");
            }
            throw new IllegalArgumentException("Node already has a fid!");
        }
        node.setFid(this.allocFid());
        return this.setChild(node.getFid(), (RogNode)node);
    }

    protected final boolean removeChild(T node) {
        if (node.getFid() == 0L) {
            throw new IllegalArgumentException("node does not have a fid");
        }
        boolean retval = this.setChild(node.getFid(), null);
        this.releaseFid(node.getFid());
        node.setFid(0L);
        return retval;
    }

    @Override
    public IStoreObject setFieldValue(long fid, Object val) {
        if (this.isDynamicFid(fid)) {
            if (val == null) {
                RogNode node = this.getChild(fid);
                ((IRogCollectionNodeElement)((Object)node)).setFid(0L);
                this.releaseFid(fid);
                this.rollbackChildAdd(fid, node);
            } else {
                RogNode node = (RogNode)val;
                long newFid = this.allocFid();
                ((IRogCollectionNodeElement)((Object)node)).setFid(newFid);
                this.rollbackChildRemove(newFid, node);
            }
        } else {
            super.setFieldValue(fid, val);
        }
        return this;
    }

    @Override
    public Message serializeToProtobuf() {
        throw new UnsupportedOperationException();
    }

    public String serializeToJson() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRogNode deserializeFromProtobuf(Message message) {
        throw new UnsupportedOperationException();
    }

    public IRogNode deserializeFromJson(String json) {
        throw new UnsupportedOperationException();
    }

    public byte[] serializeToByteArray() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer serializeToByteBuffer() {
        throw new UnsupportedOperationException();
    }

    public IOBuffer serializeToIOBuffer(boolean useNative) {
        throw new UnsupportedOperationException();
    }

    public PktPacket serializeToPacket() {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromByteArray(byte[] array) {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromByteBuffer(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public MessageView deserializeFromPacket(PktPacket packet) {
        throw new UnsupportedOperationException();
    }

    public void sync() {
        throw new UnsupportedOperationException();
    }

    protected abstract PktPacket getStoreCommitPacket();

    protected PktPacket serializeForStoreCommit() {
        PktPacket packet = this.getStoreCommitPacket();
        ((PktBodyData)packet.getBody()).setBufferLength(0);
        return packet.acquire();
    }

    protected void deserializeFromStoreReplicationOrInit(PktPacket packet) {
        packet.dispose();
    }
}

