/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.Query;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Address;
import com.neeve.query.impl.mock.domain.Customer;
import org.junit.Assert;
import org.junit.Test;

public class QueryCollationTest {
    @Test
    public void testOrderBy() throws Exception {
        QueryEngineImpl<Integer, MockRecord> engine = new QueryEngineImpl<Integer, MockRecord>(MockRecord.class);
        MemQuerySetRepository<Integer, MockRecord> repo1 = new MemQuerySetRepository<Integer, MockRecord>("repo1", MockRecord.keyMapper);
        MemQuerySetRepository<Integer, MockRecord> repo2 = new MemQuerySetRepository<Integer, MockRecord>("repo2", MockRecord.keyMapper);
        repo1.open();
        repo2.open();
        engine.addRepository(repo1, "repo1");
        engine.addRepository(repo2, "repo2");
        for (int i = 1; i <= 25; ++i) {
            Customer cust1 = new Customer(i, "John Doe");
            Address addr1 = i % 2 == 0 ? new Address("12345") : new Address("22222");
            cust1.setAddress(addr1);
            repo1.add(new MockRecord(i, cust1));
            Customer cust2 = new Customer(i, "Jane Doe");
            Address addr2 = i % 2 == 0 ? new Address("12345") : new Address("22222");
            cust2.setAddress(addr2);
            repo2.add(new MockRecord(i, cust2));
        }
        repo1.flushIndexing();
        repo2.flushIndexing();
        Query<MockRecord> query = engine.createQuery();
        query.select(MockRecord.customer).from("repositories").orderBy(MockRecord.customerZipcode).orderBy(MockRecord.customerId, Query.SortOrder.DESCENDING).orderBy(MockRecord.customerName);
        QueryResultSet<MockRecord> rs = engine.execute(query);
        long expectedId = 24L;
        String expectedName = "Jane Doe";
        String expectedZipcode = "12345";
        while (rs.next()) {
            Customer cust = (Customer)rs.getObject(1);
            Assert.assertEquals((String)"zipcode 12345 before 22222", (Object)expectedZipcode, (Object)cust.getAddress().getZipcode());
            Assert.assertEquals((String)"custIds 24-2 then 25-1", (long)expectedId, (long)cust.getId());
            Assert.assertEquals((String)"name Jane then John", (Object)expectedName, (Object)cust.getName());
            if (expectedName.equals("Jane Doe")) {
                expectedName = "John Doe";
                continue;
            }
            expectedName = "Jane Doe";
            if (expectedId == 2L) {
                expectedZipcode = "22222";
                expectedId = 25L;
                continue;
            }
            expectedId -= 2L;
        }
        Assert.assertEquals((String)"expected 25 customers from each repo", (long)50L, (long)rs.getCount());
        rs.close();
        engine.close();
    }
}

