/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.neeve.query.QueryException;
import com.neeve.query.QueryIndexer;
import com.neeve.query.impl.index.IdxComparatorRegistry;
import com.neeve.query.impl.index.IdxIndexManager;
import com.neeve.query.impl.index.IdxKeyComparator;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import org.mapdb.Atomic;
import org.mapdb.DB;

public class IdxIndexerImpl<ID, REC>
implements QueryIndexer<ID, REC> {
    private static final String NVX_REPOSITORY_SIZE = "nvx:repository.size";
    private static final String NVX_INDEX_SCHEMA_VERSION_PROPERTY = "nvx:index.schema.version";
    private static final String NVX_FIRST_UNVERSIONED_SCHEMA = "pre 1.9";
    private static final String NVX_INDEX_SCHEMA_VERSION = "1.9";
    public static final IdxKeyComparator<Currency> CURRENCY_COMPARATOR = IdxKeyComparator.onResult(Currency.class, new CurrencyToSymbol().withResultCaching());
    public static final IdxKeyComparator<Class> CLASS_COMPARATOR = IdxKeyComparator.onResult(Class.class, new ClassToName().withResultCaching());
    private final IdxIndexManager<ID, REC> indexManager;
    private final IdMapper<ID, REC> idMapper;
    private Atomic.Long size;

    public static <ID, REC> IdxIndexerImpl<ID, REC> createFileBased(File directory, String name, IdMapper<ID, REC> idMapper) {
        IdxIndexManager indexManager = IdxIndexManager.createFileBased(directory, name);
        return new IdxIndexerImpl(indexManager, idMapper);
    }

    public static <ID, REC> IdxIndexerImpl<ID, REC> createMemoryBased(IdMapper<ID, REC> idMapper) {
        IdxIndexManager indexManager = IdxIndexManager.createMemoryBased();
        return new IdxIndexerImpl(indexManager, idMapper);
    }

    public static <ID, REC> IdxIndexerImpl<ID, REC> createTemp(IdMapper<ID, REC> idMapper) {
        IdxIndexManager indexManager = IdxIndexManager.createTemp();
        return new IdxIndexerImpl(indexManager, idMapper);
    }

    private IdxIndexerImpl(IdxIndexManager<ID, REC> indexManager, IdMapper<ID, REC> idMapper) {
        this.indexManager = indexManager;
        this.idMapper = idMapper;
    }

    @Override
    public final void rename(String newName) throws QueryException {
        this.indexManager.rename(newName);
    }

    @Override
    public final void delete() throws QueryException, IllegalStateException {
        this.indexManager.delete();
    }

    @Override
    public void rollback() {
        this.indexManager.rollback();
    }

    @Override
    public void commit(long commitSequenceNumber) {
        this.indexManager.commit(commitSequenceNumber);
    }

    @Override
    public long getLiveCommitSequenceNumber() {
        return this.indexManager.getLiveCommitSequenceNumber();
    }

    @Override
    public boolean isLiveCommitSequenceNumber(long commitSequence) {
        return this.indexManager.isLiveCommitSequenceNumber(commitSequence);
    }

    @Override
    public void open() throws Exception {
        boolean newDB = !this.indexManager.exists();
        this.indexManager.open();
        try {
            DB mapDb = this.indexManager.getMapDb();
            if (!newDB) {
                String currentVersion = this.getIndexProperty(NVX_INDEX_SCHEMA_VERSION_PROPERTY);
                if (currentVersion == null) {
                    currentVersion = NVX_FIRST_UNVERSIONED_SCHEMA;
                }
                if (!NVX_INDEX_SCHEMA_VERSION.equals(currentVersion)) {
                    System.err.println("WARNING INCOMPATIBLE INDEX SCHEMA VERSION for " + this.indexManager.getName() + "; not compatible with current " + NVX_INDEX_SCHEMA_VERSION + " version. Indexes will be cleared");
                    this.indexManager.close();
                    this.indexManager.delete();
                    this.indexManager.open();
                    mapDb = this.getMapDb();
                    this.setIndexProperty(NVX_INDEX_SCHEMA_VERSION_PROPERTY, NVX_INDEX_SCHEMA_VERSION);
                    mapDb.commit();
                }
            } else {
                this.setIndexProperty(NVX_INDEX_SCHEMA_VERSION_PROPERTY, NVX_INDEX_SCHEMA_VERSION);
                mapDb.commit();
            }
            this.size = mapDb.getAtomicLong(NVX_REPOSITORY_SIZE);
            if (this.size == null) {
                this.size = mapDb.createAtomicLong(NVX_REPOSITORY_SIZE, 0L);
                mapDb.commit();
            }
            this.size = this.retrieveSize();
        }
        catch (Exception e) {
            this.indexManager.close();
            throw e;
        }
    }

    @Override
    public void close() {
        this.indexManager.close();
    }

    public boolean isOpen() {
        return this.indexManager.isOpen();
    }

    public void awaitShutdown() throws InterruptedException {
        this.indexManager.awaitShutdown();
    }

    public boolean awaitShutdown(long millis) {
        return this.indexManager.awaitShutdown(millis);
    }

    @Override
    public void clear(boolean dropIndexes) {
        this.indexManager.clear(dropIndexes);
        this.size = this.retrieveSize();
        this.size.set(0L);
    }

    private Atomic.Long retrieveSize() {
        DB mapDb = this.indexManager.getMapDb();
        Atomic.Long s = mapDb.getAtomicLong(NVX_REPOSITORY_SIZE);
        if (s == null) {
            s = mapDb.createAtomicLong(NVX_REPOSITORY_SIZE, 0L);
        }
        return s;
    }

    @Override
    public final <T> IdxIndex<T, ID> createIndex(IdxField<REC, T> field, boolean unique, String name) throws QueryException {
        try {
            field.validateIndexable();
        }
        catch (Exception qe) {
            String message = "Can't create index on " + field + " because " + qe.getMessage();
            throw new QueryException(message);
        }
        if (unique) {
            return this.indexManager.createUniqueIndex(field, name);
        }
        return this.indexManager.createNonUniqueIndex(field, name);
    }

    @Override
    public final <T> boolean dropIndex(IdxField<REC, T> field) {
        return this.indexManager.dropIndex(field);
    }

    @Override
    public boolean dropIndex(String indexName) throws QueryException {
        return this.indexManager.dropIndex(indexName);
    }

    @Override
    public final <T> IdxIndex<T, ID> getIndex(IdxField<REC, T> field) {
        return this.indexManager.getIndex(field);
    }

    @Override
    public final <T> IdxUniqueIndex<T, ID> getUniqueIndex(IdxField<REC, T> field) {
        return this.indexManager.getUniqueIndex(field);
    }

    @Override
    public final <T> IdxNonUniqueIndex<T, ID> getNonUniqueIndex(IdxField<REC, T> field) {
        return this.indexManager.getNonUniqueIndex(field);
    }

    @Override
    public final List<IdxIndex<?, ID>> getIndexes() {
        return new ArrayList(this.indexManager.getIndexes());
    }

    @Override
    public final void put(REC record) {
        ID recordId = this.idMapper.getRecordId(record);
        long recordCommitSequence = this.idMapper.getCommitSequence(record);
        boolean liveRecord = this.isLiveCommitSequenceNumber(recordCommitSequence);
        Iterator<IdxIndex<?, ID>> iterator = this.indexManager.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object fieldValue;
            boolean indexApplies;
            IdxIndex<?, ID> ind;
            IdxIndex<?, ID> index = ind = iterator.next();
            IdxField field = index.getField();
            boolean bl = indexApplies = liveRecord || recordCommitSequence > index.getStats().getCommitSequenceNumber();
            if (indexApplies) {
                indexApplies = field.getTypePredicate().apply(record);
            }
            if (!indexApplies || (fieldValue = field.apply(record)) == null) continue;
            index.put(fieldValue, recordId);
        }
        if (liveRecord) {
            this.size.getAndIncrement();
        }
    }

    @Override
    public <T> void updateField(REC record, IdxField<REC, T> updatedField, T oldVal, T newVal) {
        for (IdxIndex<?, ID> ind : this.indexManager.getIndexes()) {
            IdxIndex<?, ID> index = ind;
            IdxField field = index.getField();
            if (!field.getFieldPath().startsWith(updatedField.getFieldPath()) || !field.getTypePredicate().apply(record)) continue;
            Object before = oldVal;
            Object after = newVal;
            if (field.getFieldPath().length() > updatedField.getFieldPath().length()) {
                String subPath = field.getFieldPath().substring(updatedField.getFieldPath().length() + 1);
                if (before != null) {
                    before = UtlQueryReflection.getProperty(before, (String)subPath);
                }
                if (after != null) {
                    after = UtlQueryReflection.getProperty(after, (String)subPath);
                }
            }
            if (before != null) {
                index.remove(before, this.idMapper.getRecordId(record));
            }
            if (after == null) continue;
            index.put(after, this.idMapper.getRecordId(record));
        }
    }

    @Override
    public final void update(REC before, REC after) {
        Iterator<IdxIndex<?, ID>> iterator = this.indexManager.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object valueAfter;
            Object valueBefore;
            IdxIndex<?, ID> ind;
            IdxIndex<?, ID> index = ind = iterator.next();
            IdxField field = index.getField();
            boolean indexApplies = true;
            if (before != null && (indexApplies = field.getTypePredicate().apply(before)) && (valueBefore = field.apply(before)) != null) {
                index.remove(valueBefore, this.idMapper.getRecordId(before));
            }
            if (after == null || !(indexApplies = field.getTypePredicate().apply(after)) || (valueAfter = field.apply(after)) == null) continue;
            index.put(valueAfter, this.idMapper.getRecordId(after));
        }
    }

    @Override
    public void remove(REC record) {
        ID id = this.idMapper.getRecordId(record);
        for (IdxIndex<?, ID> ind : this.indexManager.getIndexes()) {
            Object fieldValue;
            IdxIndex<?, ID> index = ind;
            IdxField field = index.getField();
            boolean indexApplies = field.getTypePredicate().apply(record);
            if (!indexApplies || (fieldValue = field.apply(record)) == null) continue;
            index.remove(fieldValue, id);
        }
        this.size.getAndDecrement();
    }

    @Override
    public final <T> IdxIndex.Stats<T> getIndexStats(IdxField<REC, T> field) {
        return this.indexManager.getIndexStats(field);
    }

    @Override
    public final void setIndexProperty(String name, String value) {
        this.indexManager.setIndexProperty(name, value);
    }

    @Override
    public final String getIndexProperty(String name) {
        return this.indexManager.getIndexProperty(name);
    }

    @Override
    public int getSize() {
        return (int)this.size.get();
    }

    public DB getMapDb() {
        return this.indexManager.getMapDb();
    }

    static {
        IdxComparatorRegistry.registerKeyComparator(Currency.class, CURRENCY_COMPARATOR);
        IdxComparatorRegistry.registerKeyComparator(Class.class, CLASS_COMPARATOR);
    }

    public static final class ClassToName
    extends IdxKeyComparator.FluentKeyTransformation<Class, String> {
        private static final long serialVersionUID = 1L;

        public String apply(Class type) {
            String className = type.getCanonicalName();
            if (className == null) {
                className = type.toString();
                className = className.substring(6);
            }
            return className;
        }
    }

    public static final class CurrencyToSymbol
    extends IdxKeyComparator.FluentKeyTransformation<Currency, String> {
        private static final long serialVersionUID = 1L;

        public String apply(Currency currency) {
            return currency.getSymbol();
        }
    }

    public static interface IdMapper<ID, REC> {
        public ID getRecordId(REC var1);

        public long getCommitSequence(REC var1);
    }
}

