/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.index.IdxField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class QueryAggregateField<REC, T, AGG>
extends QueryAbstractField<REC, AGG> {
    private static final long serialVersionUID = 1L;
    private final IdxField<REC, T> baseField;
    private final String aggregateName;

    private static final boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type);
    }

    private static final double doubleValue(Object obj) {
        double value = obj instanceof BigDecimal ? ((BigDecimal)obj).doubleValue() : (obj instanceof BigInteger ? ((BigInteger)obj).doubleValue() : ((Number)obj).doubleValue());
        return value;
    }

    private static final long longValue(Object obj) {
        long value = obj instanceof BigDecimal ? ((BigDecimal)obj).longValue() : (obj instanceof BigInteger ? ((BigInteger)obj).longValue() : ((Number)obj).longValue());
        return value;
    }

    public static Key createKey(IdxField[] keyFields, Serializable[] keys) {
        return new Key(keyFields, keys);
    }

    public static <REC> Aggregate<REC> createAggregate(Key key) {
        return new Aggregate(key);
    }

    public QueryAggregateField(IdxField<REC, T> baseField, Class<AGG> aggregateType, String aggregateName) {
        super(((QueryAbstractField)baseField).getRecordType(), ((QueryAbstractField)baseField).getFieldPath(), aggregateType, ((QueryAbstractField)baseField).getPathSelector());
        this.baseField = baseField;
        this.aggregateName = aggregateName;
    }

    public Value<REC, T, AGG> createAggregateValue() {
        return this.createAggregateValue(this.baseField);
    }

    protected abstract Value<REC, T, AGG> createAggregateValue(IdxField<REC, T> var1);

    protected abstract AGG transform(T var1);

    @Override
    public String getName() {
        return this.aggregateName + "(" + super.getName() + ")";
    }

    public IdxField<REC, T> getBaseField() {
        return this.baseField;
    }

    public final AGG apply(REC record) {
        Object baseValue = this.baseField.apply(record);
        return this.transform(baseValue);
    }

    @Override
    public String toString() {
        return this.aggregateName + "(" + this.baseField.toString() + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof QueryAggregateField)) {
            return false;
        }
        QueryAggregateField other = (QueryAggregateField)obj;
        return this.getClass().equals(other.getClass()) && this.baseField.equals(other.baseField);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.baseField});
    }

    @Override
    public double getCost() {
        return this.baseField.getCost() + 1.0;
    }

    public static final class Average<REC, N>
    extends QueryAggregateField<REC, N, Double> {
        private static final long serialVersionUID = 1L;

        public Average(IdxField<REC, N> baseField) {
            super(baseField, Double.class, "AVG");
            Class<N> fieldType = baseField.getFieldType();
            if (fieldType != Object.class && !QueryAggregateField.isNumeric(fieldType)) {
                throw new QueryException("Average can only be applied against a numeric field");
            }
        }

        protected AverageValue<REC, N> createAggregateValue(IdxField<REC, N> baseField) {
            return new AverageValue<REC, N>(baseField);
        }

        @Override
        protected Double transform(N baseValue) {
            return QueryAggregateField.doubleValue(baseValue);
        }
    }

    private static final class AverageValue<REC, N>
    extends Value<REC, N, Double> {
        private static final long serialVersionUID = 1L;
        private CountValue<REC, N> count;
        private DoubleSumValue<REC, N> sum;

        public AverageValue(IdxField<REC, N> baseField) {
            super(baseField);
            this.count = new CountValue<REC, N>(baseField);
            this.sum = new DoubleSumValue<REC, N>(baseField);
        }

        @Override
        protected void iterateValue(N baseFieldValue) {
            this.count.iterateValue(baseFieldValue);
            this.sum.iterateValue(baseFieldValue);
        }

        @Override
        public Double yield() {
            int cnt = this.count.yield();
            if (cnt > 0) {
                return this.sum.yield() / (double)cnt;
            }
            return null;
        }

        @Override
        public Value<REC, N, Double> merge(Value<REC, N, Double> value) {
            AverageValue otherAverage = (AverageValue)value;
            AverageValue<REC, N> merged = new AverageValue<REC, N>(this.baseField);
            merged.count = (CountValue)this.count.merge((Value<REC, N, Integer>)otherAverage.count);
            merged.sum = (DoubleSumValue)this.sum.merge(otherAverage.sum);
            return merged;
        }
    }

    public static final class DoubleSum<REC, N>
    extends QueryAggregateField<REC, N, Double> {
        private static final long serialVersionUID = 1L;

        public DoubleSum(IdxField<REC, N> baseField) {
            super(baseField, Double.class, "SUM");
            Class<N> fieldType = baseField.getFieldType();
            if (fieldType != Object.class && !QueryAggregateField.isNumeric(fieldType)) {
                throw new QueryException("Sum can only be applied against a numeric field");
            }
        }

        protected DoubleSumValue<REC, N> createAggregateValue(IdxField<REC, N> baseField) {
            return new DoubleSumValue<REC, N>(baseField);
        }

        @Override
        protected Double transform(N baseValue) {
            return QueryAggregateField.doubleValue(baseValue);
        }
    }

    public static final class LongSum<REC, N>
    extends QueryAggregateField<REC, N, Long> {
        private static final long serialVersionUID = 1L;

        public LongSum(IdxField<REC, N> baseField) {
            super(baseField, Long.class, "SUM");
            Class<N> fieldType = baseField.getFieldType();
            if (fieldType != Object.class && !QueryAggregateField.isNumeric(fieldType)) {
                throw new QueryException("Sum can only be applied against a numeric field");
            }
        }

        protected LongSumValue<REC, N> createAggregateValue(IdxField<REC, N> baseField) {
            return new LongSumValue<REC, N>(baseField);
        }

        @Override
        protected Long transform(N baseValue) {
            return QueryAggregateField.longValue(baseValue);
        }
    }

    private static class DoubleSumValue<REC, N>
    extends Value<REC, N, Double> {
        private static final long serialVersionUID = 1L;
        private double sum = 0.0;

        public DoubleSumValue(IdxField<REC, N> baseField) {
            super(baseField);
        }

        @Override
        protected void iterateValue(N baseFieldValue) {
            this.sum += QueryAggregateField.doubleValue(baseFieldValue);
        }

        @Override
        public Double yield() {
            return this.sum;
        }

        @Override
        public Value<REC, N, Double> merge(Value<REC, N, Double> value) {
            DoubleSumValue otherSum = (DoubleSumValue)value;
            DoubleSumValue<REC, N> merged = new DoubleSumValue<REC, N>(this.baseField);
            merged.sum = this.sum + otherSum.sum;
            return merged;
        }
    }

    private static class LongSumValue<REC, N>
    extends Value<REC, N, Long> {
        private static final long serialVersionUID = 1L;
        private long sum = 0L;

        public LongSumValue(IdxField<REC, N> baseField) {
            super(baseField);
        }

        @Override
        protected void iterateValue(N baseFieldValue) {
            this.sum += QueryAggregateField.longValue(baseFieldValue);
        }

        @Override
        public Long yield() {
            return this.sum;
        }

        @Override
        public Value<REC, N, Long> merge(Value<REC, N, Long> value) {
            LongSumValue otherSum = (LongSumValue)value;
            LongSumValue<REC, N> merged = new LongSumValue<REC, N>(this.baseField);
            merged.sum = this.sum + otherSum.sum;
            return merged;
        }
    }

    public static final class Max<REC, T>
    extends Transformation<REC, T> {
        private static final long serialVersionUID = 1L;

        public Max(IdxField<REC, T> baseField) {
            super(baseField, baseField.getFieldType(), "MAX");
            Class<T> fieldType = baseField.getFieldType();
            if (fieldType != Object.class && !Comparable.class.isAssignableFrom(baseField.getFieldType())) {
                throw new QueryException("Max can only be applied against a Comparable field");
            }
        }

        @Override
        protected MaxValue<REC, T> createAggregateValue(IdxField<REC, T> baseField) {
            return new MaxValue<REC, T>(baseField);
        }
    }

    private static class MaxValue<REC, T>
    extends TransformationValue<REC, T> {
        private static final long serialVersionUID = 1L;
        private T max = null;

        public MaxValue(IdxField<REC, T> baseField) {
            super(baseField);
        }

        private boolean isGreaterThanMax(T value) {
            if (this.max == null) {
                return true;
            }
            if (value == null) {
                return false;
            }
            return ((Comparable)value).compareTo(this.max) > 0;
        }

        @Override
        protected void iterateValue(T baseFieldValue) {
            if (this.isGreaterThanMax(baseFieldValue)) {
                this.max = baseFieldValue;
            }
        }

        @Override
        public T yield() {
            return this.max;
        }

        @Override
        public Value<REC, T, T> merge(Value<REC, T, T> value) {
            MaxValue otherMax = (MaxValue)value;
            MaxValue<REC, T> merged = new MaxValue<REC, T>(this.baseField);
            merged.max = this.isGreaterThanMax(otherMax.max) ? otherMax.max : this.max;
            return merged;
        }
    }

    public static final class Min<REC, T>
    extends Transformation<REC, T> {
        private static final long serialVersionUID = 1L;

        public Min(IdxField<REC, T> baseField) {
            super(baseField, baseField.getFieldType(), "MIN");
            Class<T> fieldType = baseField.getFieldType();
            if (fieldType != Object.class && !Comparable.class.isAssignableFrom(baseField.getFieldType())) {
                throw new QueryException("Min can only be applied against a Comparable field");
            }
        }

        @Override
        protected MinValue<REC, T> createAggregateValue(IdxField<REC, T> baseField) {
            return new MinValue<REC, T>(baseField);
        }
    }

    private static class MinValue<REC, T>
    extends TransformationValue<REC, T> {
        private static final long serialVersionUID = 1L;
        private T min = null;

        public MinValue(IdxField<REC, T> baseField) {
            super(baseField);
        }

        private boolean isLowerThanMin(T value) {
            if (this.min == null) {
                return true;
            }
            if (value == null) {
                return false;
            }
            return ((Comparable)this.min).compareTo(value) > 1;
        }

        @Override
        protected void iterateValue(T baseFieldValue) {
            if (this.isLowerThanMin(baseFieldValue)) {
                this.min = baseFieldValue;
            }
        }

        @Override
        public T yield() {
            return this.min;
        }

        @Override
        public Value<REC, T, T> merge(Value<REC, T, T> value) {
            MinValue otherMin = (MinValue)value;
            MinValue<REC, T> merged = new MinValue<REC, T>(this.baseField);
            merged.min = this.isLowerThanMin(otherMin.min) ? this.min : otherMin.min;
            return merged;
        }
    }

    public static final class Count<REC, T>
    extends QueryAggregateField<REC, T, Integer> {
        private static final long serialVersionUID = 1L;

        public Count(IdxField<REC, T> baseField) {
            super(baseField, Integer.class, "COUNT");
        }

        public CountValue<REC, T> createAggregateValue(IdxField<REC, T> baseField) {
            return new CountValue<REC, T>(baseField);
        }

        @Override
        protected final Integer transform(T baseValue) {
            return baseValue == null ? 0 : 1;
        }
    }

    private static class CountValue<REC, T>
    extends Value<REC, T, Integer> {
        private static final long serialVersionUID = 1L;
        private int count = 0;

        public CountValue(IdxField<REC, T> baseField) {
            super(baseField);
        }

        @Override
        public void iterateValue(T value) {
            ++this.count;
        }

        @Override
        public Integer yield() {
            return this.count;
        }

        @Override
        public Value<REC, T, Integer> merge(Value<REC, T, Integer> value) {
            CountValue otherCount = (CountValue)value;
            CountValue<REC, T> merged = new CountValue<REC, T>(this.baseField);
            merged.count = this.count + otherCount.count;
            return merged;
        }
    }

    private static abstract class Transformation<REC, T>
    extends QueryAggregateField<REC, T, T> {
        private static final long serialVersionUID = 1L;

        public Transformation(IdxField<REC, T> baseField, Class<T> aggregateType, String aggregateName) {
            super(baseField, aggregateType, aggregateName);
        }

        protected abstract TransformationValue<REC, T> createAggregateValue(IdxField<REC, T> var1);

        @Override
        protected T transform(T baseValue) {
            return baseValue;
        }
    }

    private static abstract class TransformationValue<REC, T>
    extends Value<REC, T, T> {
        private static final long serialVersionUID = 1L;

        public TransformationValue(IdxField<REC, T> baseField) {
            super(baseField);
        }
    }

    private static abstract class Value<REC, T, AGG>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected IdxField<REC, T> baseField;

        public Value(IdxField<REC, T> baseField) {
            this.baseField = baseField;
        }

        public void iterateRecord(REC record) {
            Object baseFieldValue = this.baseField.apply(record);
            if (baseFieldValue != null) {
                this.iterateValue(baseFieldValue);
            }
        }

        protected abstract void iterateValue(T var1);

        public abstract AGG yield();

        public abstract Value<REC, T, AGG> merge(Value<REC, T, AGG> var1);
    }

    public static final class Aggregate<REC>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Key key;
        private Map<QueryAggregateField<REC, ?, ?>, Value<REC, ?, ?>> fieldAggValues = Maps.newHashMap();

        private Aggregate(Key key) {
            this.key = key;
        }

        public Key getKey() {
            return this.key;
        }

        public void registerFields(List<QueryAggregateField<REC, ?, ?>> aggregateFields) {
            for (QueryAggregateField<REC, ?, ?> aggregateField : aggregateFields) {
                this.registerField(aggregateField);
            }
        }

        public void registerField(QueryAggregateField<REC, ?, ?> aggregateField) {
            Value<REC, ?, ?> aggValue = aggregateField.createAggregateValue();
            this.fieldAggValues.put(aggregateField, aggValue);
        }

        public void addRecord(REC record) {
            for (Value<REC, ?, ?> aggValue : this.fieldAggValues.values()) {
                aggValue.iterateRecord(record);
            }
        }

        public <T, AGG> AGG yield(QueryAggregateField<REC, T, AGG> field) {
            Value<REC, ?, ?> aggregateValue = this.fieldAggValues.get(field);
            return (AGG)aggregateValue.yield();
        }

        public <T> T yieldKey(IdxField<REC, T> field) {
            return (T)this.key.yield(field);
        }

        public Aggregate<REC> clone() {
            Aggregate<REC> clone = new Aggregate<REC>(this.key);
            clone.fieldAggValues.putAll(this.fieldAggValues);
            return clone;
        }

        public Aggregate<REC> merge(Aggregate<REC> aggregate) {
            Aggregate<REC> merged = new Aggregate<REC>(this.key);
            for (Map.Entry<QueryAggregateField<REC, ?, ?>, Value<REC, ?, ?>> entry : this.fieldAggValues.entrySet()) {
                QueryAggregateField<REC, ?, ?> aggField = entry.getKey();
                Value<REC, ?, ?> value = entry.getValue();
                Value<REC, ?, ?> otherValue = aggregate.fieldAggValues.get(aggField);
                Value<REC, ?, ?> mergedValue = value.merge(otherValue);
                merged.fieldAggValues.put(aggField, mergedValue);
            }
            return merged;
        }
    }

    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IdxField[] keyFields;
        private Object[] keys;

        private Key(IdxField[] keyFields, Object[] keys) {
            this.keyFields = keyFields;
            this.keys = keys;
        }

        private <REC, T> T yield(IdxField<REC, T> field) {
            for (int i = 0; i < this.keyFields.length; ++i) {
                if (!this.keyFields[i].equals(field)) continue;
                return (T)this.keys[i];
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Arrays.equals(this.keys, other.keys);
        }

        public int hashCode() {
            return Arrays.hashCode(this.keys);
        }
    }
}

