/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.LnkContinuousAcceptor;
import com.neeve.link.LnkEvents;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlThread;
import java.util.concurrent.atomic.AtomicInteger;

final class StoreReplicatorLinkAcceptor
extends OdsObject {
    private final StoreReplicator replicator;
    private final LnkContinuousAcceptor acceptor;
    private final IEmxDispatcher dispatcher;
    private final AcceptorThread acceptorThread;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final StartAction startAction;
    private final StopAction stopAction;
    private static AtomicInteger instanceCounter = new AtomicInteger(0);
    private volatile State state;

    StoreReplicatorLinkAcceptor(StoreReplicator replicator, UtlAddressDescriptor descriptor) throws OdsException {
        super(null);
        this.replicator = replicator;
        try {
            this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "X-ODS-StoreLinkAcceptor-" + instanceCounter.incrementAndGet(), IEmxDispatcher.Params.create((boolean)false, (boolean)true));
        }
        catch (EEmxException e) {
            throw new OdsException("Failed to create link acceptor dispatcher [" + e.toString() + "]");
        }
        this.acceptor = LnkContinuousAcceptor.create(null, (UtlAddressDescriptor)descriptor, (ILnkEventHandler)new EventHandler());
        this.acceptorThread = new AcceptorThread(new ThreadStartCoordinator());
        this.actionExecutor = new EmxActionExecutor();
        this.startAction = new StartAction();
        this.stopAction = new StopAction();
        this.state = State.Init;
        if (this.tracer.debug) {
            this.tracer.log(replicator.getTracePrefix() + "Created link acceptor '" + this.acceptorThread.getName() + "' using '" + descriptor.toString() + "'...", Tracer.Level.DEBUG);
        }
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("acceptor has not been opened");
            }
            case OpenFailed: {
                return new IllegalStateException("acceptor was opened but it failed");
            }
            case Open: {
                return new IllegalStateException("acceptor is open");
            }
            case Closed: {
                return new IllegalStateException("acceptor is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() throws OdsException {
        StoreReplicatorLinkAcceptor storeReplicatorLinkAcceptor = this;
        synchronized (storeReplicatorLinkAcceptor) {
            if (this.state == State.Init) {
                this.acceptorThread.start();
                ThreadStartCoordinator threadStartCoordinator = this.acceptorThread.coordinator;
                synchronized (threadStartCoordinator) {
                    while (!this.acceptorThread.coordinator.isStarted) {
                        try {
                            this.acceptorThread.coordinator.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    this.actionExecutor.invoke(this.dispatcher, (IEmxAction)this.startAction, null, 1);
                    this.state = State.Open;
                }
                catch (Exception e) {
                    try {
                        this.actionExecutor.invoke(this.dispatcher, (IEmxAction)this.stopAction, null, 1);
                    }
                    catch (Exception e1) {
                        this.tracer.log(this.replicator.getTracePrefix() + "Error while stopping acceptor thread after failed acceptor start[" + e1.toString() + "].", Tracer.Level.WARNING);
                    }
                    this.state = State.OpenFailed;
                    throw new OdsException("Failed to start acceptor [" + e.toString() + "]");
                }
            }
            throw this.prepareStateValidationErrorException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        StoreReplicatorLinkAcceptor storeReplicatorLinkAcceptor = this;
        synchronized (storeReplicatorLinkAcceptor) {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "Closing link acceptor...", Tracer.Level.DEBUG);
            }
            if (this.state != State.Closed) {
                try {
                    if (this.state == State.Open) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.replicator.getTracePrefix() + "Shutting down the acceptor thread...", Tracer.Level.DEBUG);
                        }
                        try {
                            this.actionExecutor.invoke(this.dispatcher, (IEmxAction)this.stopAction, null, 1);
                            while (true) {
                                try {
                                    this.acceptorThread.join();
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception e) {
                            this.tracer.log(this.replicator.getTracePrefix() + "Failed to stop the acceptor [" + e.toString() + "].", Tracer.Level.WARNING);
                        }
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this.replicator.getTracePrefix() + "Closing acceptor dispatcher...", Tracer.Level.DEBUG);
                    }
                    try {
                        this.dispatcher.setOwner();
                        this.dispatcher.close(false);
                    }
                    catch (Exception e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "Failed to close acceptor dispatcher [" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                }
                finally {
                    this.state = State.Closed;
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "Already closed.", Tracer.Level.DEBUG);
            }
        }
    }

    private final class StopAction
    implements IEmxAction<Object, Object> {
        private StopAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Stopping link acceptor...", Tracer.Level.DEBUG);
            }
            if (StoreReplicatorLinkAcceptor.this.acceptor.getState() == LnkContinuousAcceptor.State.STARTED) {
                StoreReplicatorLinkAcceptor.this.acceptor.stop();
            } else if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "...already stopped.", Tracer.Level.DEBUG);
            }
            ((AcceptorThread)dispatcher.getOwner()).shutdown();
            return null;
        }
    }

    private final class StartAction
    implements IEmxAction<Object, Object> {
        private StartAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Starting link acceptor...", Tracer.Level.DEBUG);
            }
            StoreReplicatorLinkAcceptor.this.acceptor.start(dispatcher);
            return null;
        }
    }

    private final class AcceptorThread
    extends Thread
    implements IEmxDispatcherRunCompletionChecker {
        final ThreadStartCoordinator coordinator;
        private boolean stopped;

        AcceptorThread(ThreadStartCoordinator coordinator) {
            this.coordinator = coordinator;
            this.setName(StoreReplicatorLinkAcceptor.this.dispatcher.getName());
            this.setDaemon(true);
        }

        private final void shutdown() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            try {
                StoreReplicatorLinkAcceptor.this.dispatcher.setOwner();
                ThreadStartCoordinator threadStartCoordinator = this.coordinator;
                synchronized (threadStartCoordinator) {
                    this.coordinator.isStarted = true;
                    this.coordinator.notify();
                }
                StoreReplicatorLinkAcceptor.this.dispatcher.run(-1, (IEmxDispatcherRunCompletionChecker)this);
                if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                    StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Acceptor thread done.", Tracer.Level.DEBUG);
                }
            }
            catch (Throwable e) {
                StoreReplicatorLinkAcceptor.this.tracer.log("Unhandled fault during thread execution [" + e.toString() + "]", Tracer.Level.SEVERE);
                e.printStackTrace();
            }
        }

        public final boolean isDone() {
            return this.stopped;
        }

        public final Object getCompletion() throws Exception {
            return null;
        }
    }

    private final class ThreadStartCoordinator {
        boolean isStarted = false;

        private ThreadStartCoordinator() {
        }
    }

    private static enum State {
        Init,
        OpenFailed,
        Open,
        Closed;

    }

    private final class EventHandler
    implements ILnkEventHandler {
        EventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            if (type == 4) {
                LnkEvents.ContinuousAcceptCompleteEventData eventData = (LnkEvents.ContinuousAcceptCompleteEventData)data;
                if (eventData.status) {
                    try {
                        StoreReplicatorLinkAcceptor.this.replicator.handleLinkAccept(eventData.pep);
                    }
                    catch (Exception e) {
                        StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Failed to process newly accepted link [" + e.toString() + "]. Closing link...", Tracer.Level.SEVERE);
                        try {
                            eventData.pep.close((short)-1);
                        }
                        catch (Exception e1) {
                            StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Failed to close link after accept processing failure [" + e1.toString() + "].", Tracer.Level.WARNING);
                        }
                    }
                } else if (eventData.e instanceof ELnkOpCancelledException) {
                    if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                        StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Link acceptor stopped successfully.", Tracer.Level.DEBUG);
                    }
                } else {
                    StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Link acceptor has failed [" + eventData.e.toString() + "].", Tracer.Level.SEVERE);
                }
            } else {
                throw new InternalError("Received invalid event type [type=" + type + "].");
            }
        }
    }
}

