/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit.dumbentitynames.xbuf;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.dumbentitynames.xbuf.Currency;
import com.neeve.adm.test.unit.dumbentitynames.xbuf.System;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializer;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.util.UtlPool;
import com.neeve.xbuf.XbufHeuristics;
import java.nio.ByteBuffer;
import java.util.Properties;

@AdmGenerated(encoding="Xbuf", compatLevel="4.1.0", admVersion="Unknown Version", date="11/26/24 7:57 AM", buildInfo="${build.version.string}")
public final class EntityFactory
implements IStoreObjectFactory,
MessageViewFactory {
    public static final short OFID = -2;
    public static final short VFID = 0;
    public static final short TFID = -2;
    public static final short ID_Currency = 3;
    public static final short ID_System = 2;
    public static final int PKTID_Currency = -65537;
    public static final int PKTID_System = -65536;
    static final ObjectMapper mapper = new ObjectMapper();

    public static final EntityFactory create(Properties props) {
        return new EntityFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final System createSystemFromXbufContainerPacket(UUID id, PktPacket packet) {
        try {
            System object = (System)packet.getTag(3);
            if (object != null) {
                object.undispose(id);
                System system = object;
                return system;
            }
            System system = new System(id, packet);
            return system;
        }
        finally {
            packet.dispose();
        }
    }

    private static final System createSystemFromSerializedXbufContainerPacket(UUID id, ByteBuffer serializedPacket) {
        try {
            return EntityFactory.createSystemFromXbufContainerPacket(id, PktSerializer.create().deserialize(serializedPacket, null));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final System createSystemFromSerializedXbufContainerPacket(UUID id, byte[] serializedPacket) {
        return EntityFactory.createSystemFromSerializedXbufContainerPacket(id, ByteBuffer.wrap(serializedPacket));
    }

    private static final System createSystemFromSerializedXbufContainer(UUID id, ByteBuffer serializedContainer) {
        try {
            System view = EntityFactory.createSystem();
            PktPacket packet = (PktPacket)view.getMessage();
            packet.acquire();
            view.dispose();
            packet.getBody().deserialize(serializedContainer, serializedContainer.remaining());
            return EntityFactory.createSystemFromXbufContainerPacket(id, packet);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final System createSystemFromSerializedXbufContainer(UUID id, byte[] serializedContainer) {
        try {
            System view = EntityFactory.createSystem();
            PktPacket packet = (PktPacket)view.getMessage();
            packet.acquire();
            view.dispose();
            packet.getBody().deserialize(serializedContainer, 0, serializedContainer.length);
            return EntityFactory.createSystemFromXbufContainerPacket(id, packet);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static final System createSystem() {
        return EntityFactory.createSystemFromXbufContainerPacket(new UUID(), PktFactory.getInstance().createPacket(-65536));
    }

    public static final System createSystem(UUID id) {
        return EntityFactory.createSystemFromXbufContainerPacket(id, PktFactory.getInstance().createPacket(-65536));
    }

    public static final System createSystemFromXbufContainerPacket(PktPacket packet) {
        if (packet.getBody().getType() == -65536) {
            return EntityFactory.createSystemFromXbufContainerPacket(new UUID(), packet);
        }
        throw new IllegalArgumentException("invalid packet type [exp=PKTID_System, actual=packet.getBody().getType()]");
    }

    public static final System createSystemFromSerializedXbufContainerPacket(ByteBuffer serializedPacket) {
        return EntityFactory.createSystemFromSerializedXbufContainerPacket(new UUID(), serializedPacket);
    }

    public static final System createSystemFromSerializedXbufContainerPacket(byte[] serializedPacket) {
        return EntityFactory.createSystemFromSerializedXbufContainerPacket(new UUID(), serializedPacket);
    }

    public static final System createSystemFromSerializedXbufContainer(ByteBuffer serializedContainer) {
        return EntityFactory.createSystemFromSerializedXbufContainer(new UUID(), serializedContainer);
    }

    public static final System createSystemFromSerializedXbufContainer(byte[] serializedContainer) {
        return EntityFactory.createSystemFromSerializedXbufContainer(new UUID(), serializedContainer);
    }

    public static final System createSystemFromJson(String json) {
        return EntityFactory.createSystem().deserializeFromJson(json);
    }

    public static final System createSystemFromRawJson(String json) {
        return EntityFactory.createSystem().deserializeFromRawJson(json);
    }

    @Override
    public final short getOfid() {
        return -2;
    }

    @Override
    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        try {
            switch (encodingType) {
                case Xbuf: {
                    switch (type) {
                        case 2: {
                            return EntityFactory.createSystemFromXbufContainerPacket(id, packet);
                        }
                    }
                    throw new RuntimeException("unknown object type: " + type);
                }
            }
            throw new RuntimeException("unknown encoding type: " + (Object)((Object)encodingType));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final short getVfid() {
        return 0;
    }

    public final MessageView create(short type) {
        try {
            switch (type) {
                default: 
            }
            throw new RuntimeException("unknown messsage type: " + type);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        try {
            switch (encodingType) {
                case 3: {
                    if (message instanceof PktPacket) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof byte[]) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for XBUF encoded message");
                }
                case 4: {
                    if (message instanceof byte[]) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof PktPacket) {
                        switch (type) {
                            default: 
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for PROTOBUF encoded message");
                }
            }
            throw new RuntimeException("unknown encoding type: " + encodingType);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, XRuntime.getValue((String)"nv.indent.json", (boolean)false));
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)-65537, (String)"CurrencyXbufPacket.2.3", (String)"com.neeve.adm.test.unit.dumbentitynames.xbuf.Currency$PacketBody", (int)0, (int)0, (boolean)XbufHeuristics.getProperty(Currency.class, (String)"pool.shouldpool", (boolean)true), (UtlPool.Params)XbufHeuristics.configurePoolParams(Currency.class, (UtlPool.Params)UtlPool.Params.create()), null));
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)-65536, (String)"SystemXbufPacket.2.2", (String)"com.neeve.adm.test.unit.dumbentitynames.xbuf.System$PacketBody", (int)0, (int)0, (boolean)XbufHeuristics.getProperty(System.class, (String)"pool.shouldpool", (boolean)true), (UtlPool.Params)XbufHeuristics.configurePoolParams(System.class, (UtlPool.Params)UtlPool.Params.create()), null));
    }
}

