/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.test.unit.xbuf.Child2;
import com.neeve.adm.test.unit.xbuf.Message;
import com.neeve.io.IOBuffer;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class AdmSerializationGarbage {
    @Test
    public void testXbufEntityArray() throws Exception {
        Message message = Message.create();
        long timestamp = System.currentTimeMillis();
        message.setBooleanField(true);
        message.setCharField('c');
        message.setByteField((byte)127);
        message.setShortField((short)Short.MAX_VALUE);
        message.setIntField(65535);
        message.setLongField(65535L);
        message.setFloatField(65535.0f);
        message.setDoubleField(65535.0);
        message.setDateField(new Date(timestamp));
        Child2[] arrayField = message.getChildArrayFieldEmptyIfNull();
        boolean booleanField = false;
        message.clearChildArrayField();
        message.sync();
        for (int i = 0; i < 1000; ++i) {
            IOBuffer buf = message.serializeToIOBuffer(true);
            Message deserialized = Message.createFrom(buf.takeBuffer());
            buf.releaseBuffer().dispose();
            arrayField = deserialized.getChildArrayField();
            booleanField = deserialized.getBooleanField();
            Assert.assertNull((Object)arrayField);
            Assert.assertTrue((boolean)booleanField);
            Assert.assertTrue((String)"byte field doesn't match", (127 == deserialized.getByteField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"char field doesn't match", ('c' == deserialized.getCharField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"short field doesn't match", (Short.MAX_VALUE == deserialized.getShortField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"int field doesn't match", (65535 == deserialized.getIntField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"long field doesn't match", (65535L == deserialized.getLongField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"float field doesn't match", (65535.0f == deserialized.getFloatField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"double field doesn't match", (65535.0 == deserialized.getDoubleField() ? 1 : 0) != 0);
            Assert.assertTrue((String)"date field doesn't match", (timestamp == deserialized.getDateFieldAsTimestamp() ? 1 : 0) != 0);
            arrayField = deserialized.getChildArrayFieldEmptyIfNull();
            Assert.assertEquals((String)"Expected 0 length", (long)0L, (long)arrayField.length);
            deserialized.dispose();
        }
    }

    static {
        System.setProperty("nv.optimizefor", "latency");
    }
}

