/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkSTRContainer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.tools.interactive.commands.EnquePacket;

public class EnqueType
extends EnquePacket {
    protected final LnkSTRContainer container;

    public EnqueType(LnkSTRContainer container) {
        this.container = container;
    }

    protected void processEnque(String name, String pktType, int numPackets, boolean flushForce, boolean flushSuppress, int flushType) {
        ILnkPeerEndpoint pep = this.container.getLink(name);
        if (pep != null) {
            PktPacket packet;
            System.out.println("Enqueuing packets [type=" + pktType + "] to link ['" + name + "] [numPackets=" + numPackets + " forceFlush=" + flushForce + " flushSuppress=" + flushSuppress + " flushType=" + flushType + "]...");
            try {
                packet = PktFactory.getInstance().createPacket(pktType);
            }
            catch (Exception e) {
                System.out.println("Failed to instantiate a packet [type=" + pktType + "] [" + e.toString() + "] Has the packet type been approprately configured?");
                return;
            }
            this.processEnque(pep, packet, numPackets, flushForce, flushSuppress, flushType, this.container.getReader());
        } else {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public void run(String[] args) {
        if (args.length < 6) {
            System.out.println("Syntax error: enque <name> <pkttype> <numPackets> <flushForce> <flushSuppress> <flushType>");
        } else {
            this.processEnque(args[0], args[1], Integer.parseInt(args[2]), Boolean.parseBoolean(args[3]), Boolean.parseBoolean(args[4]), Integer.parseInt(args[5]));
        }
    }

    public void help() {
        System.out.println("enque <name> <pkttype> <numPackets> <flushForce> <flushSuppress> <flushType>");
        System.out.println("  Enque a set of packets of a particular type in link");
    }

    public String[] keywords() {
        return new String[]{"enque"};
    }
}

