/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktDeserializeException;
import com.neeve.pkt.EPktSerializeException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public abstract class PktSerializable
extends UtlListElement
implements IOElasticBuffer.Sizer {
    private int serializationPolicy = 1;
    private int deserializationPolicy = 1;

    public static final boolean isValidSerializationPolicy(int policy) {
        return policy == 1 || policy == 2 || policy == 3;
    }

    public static final boolean isValidDeserializationPolicy(int policy) {
        return policy == 1 || policy == 2 || policy == 3;
    }

    protected final int resolveSerializationPolicy(int serializationPolicy) {
        return serializationPolicy == 0 ? this.serializationPolicy : serializationPolicy;
    }

    protected final int resolveDeserializationPolicy(int deserializationPolicy) {
        return deserializationPolicy == 0 ? this.deserializationPolicy : deserializationPolicy;
    }

    public void setSerializationPolicy(int policy) {
        if (!PktSerializable.isValidSerializationPolicy(policy)) {
            throw new IllegalArgumentException("invalid policy specified");
        }
        this.serializationPolicy = policy;
    }

    public int getSerializationPolicy() {
        return this.serializationPolicy;
    }

    public abstract void serialize(SerializeContext var1, Tracer var2) throws EPktSerializeException;

    public final void serialize(SerializeContext context) throws EPktSerializeException {
        this.serialize(context, null);
    }

    public void setDeserializationPolicy(int policy) {
        if (!PktSerializable.isValidDeserializationPolicy(policy)) {
            throw new IllegalArgumentException("invalid policy specified");
        }
        this.deserializationPolicy = policy;
    }

    public int getDeserializationPolicy() {
        return this.deserializationPolicy;
    }

    public abstract void deserialize(DeserializeContext var1, int var2, Tracer var3) throws EPktDeserializeException;

    public final void deserialize(DeserializeContext context) throws EPktDeserializeException {
        this.deserialize(context, -1, null);
    }

    public abstract int getSerializedLength();

    public static final class DeserializeContext {
        private ByteBuffer buffer;
        private int policy = 0;
        private boolean packetBodyDesyncDisabled = false;
        private int numBytes;
        private boolean bufferRetained;

        private DeserializeContext() {
        }

        public static DeserializeContext create() {
            return new DeserializeContext();
        }

        public final DeserializeContext setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
            return this;
        }

        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        public final DeserializeContext setPolicy(int policy) {
            if (!PktSerializable.isValidDeserializationPolicy(policy) && policy != 0) {
                throw new IllegalArgumentException("invalid policy");
            }
            this.policy = policy;
            return this;
        }

        public final int getPolicy() {
            return this.policy;
        }

        public final void setPacketBodyDesyncDisabled(boolean val) {
            this.packetBodyDesyncDisabled = val && UtlEnv.getValue((String)"nv.pkt.allowpacketbodydesyncdisable", (boolean)true);
        }

        public final boolean isPacketBodyDesyncDisabled() {
            return this.packetBodyDesyncDisabled;
        }

        final DeserializeContext setNumBytes(int numBytes) {
            this.numBytes += numBytes;
            return this;
        }

        public final int getNumBytes() {
            return this.numBytes;
        }

        final DeserializeContext setBufferRetained(boolean bufferRetained) {
            this.bufferRetained |= bufferRetained;
            return this;
        }

        public final boolean getBufferRetained() {
            return this.bufferRetained;
        }

        public final DeserializeContext reset() {
            this.numBytes = 0;
            this.bufferRetained = false;
            return this;
        }

        public final void trace(Tracer tracer, String prefix) {
            tracer.log(prefix + "policy=" + this.policy, Tracer.Level.DEBUG);
            tracer.log(prefix + "numBytes=" + this.numBytes, Tracer.Level.DEBUG);
            tracer.log(prefix + "buffer=" + UtlBuffer.toString((ByteBuffer)this.buffer), Tracer.Level.DEBUG);
            tracer.log(prefix + "bufferRetained=" + this.bufferRetained, Tracer.Level.DEBUG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final void dumpCorruptedPacketBuffer(String message, ByteBuffer buffer, int packetBufferPos, int packetBufferLimit, Throwable e, Tracer tracer) {
            block8: {
                try {
                    File dumpFile = File.createTempFile("PktCorruption", ".dump");
                    try (PrintStream out = new PrintStream(new FileOutputStream(dumpFile));){
                        out.println("Corrupted Packet Buffer Dump [" + message + "]");
                        out.println("Cause:");
                        out.println(UtlThrowable.prepareStackTrace((Throwable)e));
                        out.println("Corrupted packet buffer offset " + packetBufferPos);
                        int len = packetBufferLimit - packetBufferPos;
                        out.println(UtlBuffer.dump((String)("Read buffer contents (at pos=" + packetBufferPos + " of len=" + len + ")"), (ByteBuffer)buffer, (int)packetBufferPos, (int)len));
                        if (packetBufferPos > 0) {
                            int numBeforePos = Math.min(packetBufferPos, 100);
                            out.println(UtlBuffer.dump((String)("Read buffer contents from " + numBeforePos + " bytes before packet pos (at pos=" + (packetBufferPos - numBeforePos) + " of len=" + numBeforePos + ")"), (ByteBuffer)buffer, (int)(packetBufferPos - numBeforePos), (int)numBeforePos));
                        } else {
                            out.println("Packet pos already at beginning of buffer. Nothing to dump before packet pos");
                        }
                        out.flush();
                    }
                    tracer.log("Corrupted packet dump written to " + dumpFile.getCanonicalPath(), Tracer.Level.WARNING);
                }
                catch (Throwable thrown) {
                    if (!tracer.debug) break block8;
                    tracer.log("Failed to dump corrupted packet buffer: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                }
            }
        }
    }

    public static final class SerializeContext {
        private IOBuffer[] ioBuffers = new IOBuffer[32];
        private ByteBuffer[] byteBuffers = new ByteBuffer[32];
        private int bufferCount = 0;
        private int policy = 0;
        private boolean serializeWithoutMagic;

        private SerializeContext() {
        }

        public static SerializeContext create() {
            return new SerializeContext();
        }

        public final SerializeContext setSerializeWithoutMagic(boolean val) {
            this.serializeWithoutMagic = val;
            return this;
        }

        public final boolean getSerializeWithoutMagic() {
            return this.serializeWithoutMagic;
        }

        public final IOBuffer[] getBuffers() {
            return this.ioBuffers;
        }

        public final IOBuffer getBuffer(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("index cannot be negative");
            }
            if (index >= this.bufferCount) {
                throw new IllegalArgumentException("invalid index '" + index + " (count=" + this.bufferCount + ")");
            }
            return this.ioBuffers[index];
        }

        public final ByteBuffer[] getByteBuffers() {
            return this.byteBuffers;
        }

        public final ByteBuffer getByteBuffer(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("index cannot be negative");
            }
            if (index >= this.bufferCount) {
                throw new IllegalArgumentException("invalid index '" + index + " (count=" + this.bufferCount + ")");
            }
            return this.byteBuffers[index];
        }

        public final int getBufferCount() {
            return this.bufferCount;
        }

        public final SerializeContext addBuffer(IOBuffer ioBuffer) {
            if (this.bufferCount == this.ioBuffers.length) {
                IOBuffer[] newIOBuffers = new IOBuffer[this.ioBuffers.length * 2];
                for (int i = 0; i < this.bufferCount; ++i) {
                    newIOBuffers[i] = this.ioBuffers[i];
                }
                this.ioBuffers = newIOBuffers;
                ByteBuffer[] newByteBuffers = new ByteBuffer[this.byteBuffers.length * 2];
                for (int i = 0; i < this.bufferCount; ++i) {
                    newByteBuffers[i] = this.byteBuffers[i];
                }
                this.byteBuffers = newByteBuffers;
            }
            if (this.ioBuffers[this.bufferCount] != null) {
                this.ioBuffers[this.bufferCount].releaseBuffer().dispose();
            }
            this.ioBuffers[this.bufferCount] = ioBuffer;
            this.byteBuffers[this.bufferCount++] = ioBuffer.takeBuffer();
            return this;
        }

        public final ByteBuffer getByteBufferForCopy(int serializedDataLength) {
            if (this.bufferCount == 0) {
                throw new IllegalStateException("serialization buffer list is empty!");
            }
            IOBuffer lastIOBuffer = this.ioBuffers[this.bufferCount - 1];
            ByteBuffer lastByteBuffer = this.byteBuffers[this.bufferCount - 1];
            if (serializedDataLength > lastByteBuffer.remaining()) {
                if (lastByteBuffer.capacity() >= lastByteBuffer.position() + serializedDataLength) {
                    lastByteBuffer.limit(lastByteBuffer.position() + serializedDataLength);
                } else {
                    this.addBuffer(IOBuffer.create((int)Math.max(lastIOBuffer.getCapacity(), serializedDataLength), (boolean)lastIOBuffer.isNative()));
                    return this.byteBuffers[this.bufferCount - 1];
                }
            }
            return lastByteBuffer;
        }

        public final SerializeContext resizeBuffer(int index, int newSize) {
            if (index >= this.bufferCount) {
                throw new IllegalArgumentException("invalid index '" + index + " (count=" + this.bufferCount + ")");
            }
            IOBuffer ioBuffer = this.ioBuffers[index];
            ByteBuffer byteBuffer = this.byteBuffers[index];
            if (byteBuffer.remaining() > 0) {
                throw new IllegalStateException("buffer is not full");
            }
            if (newSize > byteBuffer.limit()) {
                if (newSize <= byteBuffer.capacity()) {
                    byteBuffer.limit(newSize);
                } else {
                    this.ioBuffers[index] = IOBuffer.create((int)newSize, (boolean)ioBuffer.isNative());
                    this.byteBuffers[index] = this.ioBuffers[index].takeBuffer();
                    ioBuffer.releaseBuffer().dispose();
                }
                this.byteBuffers[index].position(this.byteBuffers[index].limit());
            }
            return this;
        }

        public final SerializeContext flipBuffers() {
            for (int i = 0; i < this.bufferCount; ++i) {
                this.byteBuffers[i].flip();
            }
            return this;
        }

        public final SerializeContext compactBuffers() {
            for (int i = 0; i < this.bufferCount; ++i) {
                this.byteBuffers[i].compact();
            }
            return this;
        }

        public final long getBuffered() {
            long buffered = 0L;
            for (int i = 0; i < this.bufferCount; ++i) {
                buffered += (long)this.byteBuffers[i].position();
            }
            return buffered;
        }

        public final long getRemaining() {
            long remaining = 0L;
            for (int i = 0; i < this.bufferCount; ++i) {
                remaining += (long)this.byteBuffers[i].remaining();
            }
            return remaining;
        }

        public final SerializeContext setBufferCount(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("buffer count must be >= 0");
            }
            if (val > this.bufferCount) {
                throw new IllegalArgumentException("new buffer count cannot be greater than old buffer count");
            }
            this.bufferCount = val;
            return this;
        }

        public final SerializeContext dropLastBuffer() {
            if (this.bufferCount > 0) {
                this.ioBuffers[this.bufferCount - 1].releaseBuffer();
                this.ioBuffers[this.bufferCount - 1] = null;
                this.byteBuffers[this.bufferCount - 1] = null;
                --this.bufferCount;
            }
            return this;
        }

        public final SerializeContext dropBuffers() {
            for (int i = 0; i < this.bufferCount; ++i) {
                this.ioBuffers[i].releaseBuffer();
                this.ioBuffers[i] = null;
                this.byteBuffers[i] = null;
            }
            this.bufferCount = 0;
            return this;
        }

        public final SerializeContext setPolicy(int policy) {
            if (!PktSerializable.isValidSerializationPolicy(policy) && policy != 0) {
                throw new IllegalArgumentException("invalid policy");
            }
            this.policy = policy;
            return this;
        }

        public final int getPolicy() {
            return this.policy;
        }

        public final void trace(Tracer tracer, String prefix) {
            tracer.log(prefix + "policy=" + this.policy, Tracer.Level.DEBUG);
            tracer.log(prefix + "buffers=" + this.bufferCount, Tracer.Level.DEBUG);
            for (int i = 0; i < this.bufferCount; ++i) {
                tracer.log(prefix + "..." + this.ioBuffers[i], Tracer.Level.DEBUG);
            }
        }

        public final void dump(String prefix, StringBuilder to) {
            to.append(prefix).append("SerializeContext [policy: ").append(this.policy).append(", buffers ").append(this.ioBuffers.length).append(", count:").append(this.bufferCount).append("]:\n");
            for (int i = 0; i < this.ioBuffers.length; ++i) {
                if (this.ioBuffers[i] == null) continue;
                to.append(prefix).append("  Buffer ").append(i).append(": ").append(this.ioBuffers[i]);
                to.append(UtlBuffer.dump((ByteBuffer)this.ioBuffers[i].getBuffer()));
            }
        }
    }
}

