/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxObject;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.concurrent.atomic.AtomicReference;

public final class EmxNwLnkAcceptor
extends EmxObject
implements Runnable {
    private final AtomicReference<Thread> runner;
    private final IEmxNwLnkServerEndpoint sep;
    private final Callback cb;
    private boolean stopped = false;

    private EmxNwLnkAcceptor(String descriptor, Callback cb) throws EEmxException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (cb == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.runner = new AtomicReference();
        this.sep = EmxFactory.getInstance().createNwLnkServerEndpoint(EmxFactory.EmxImpl.NIO, descriptor, null);
        this.sep.configureBlocking(true);
        this.cb = cb;
    }

    public static final EmxNwLnkAcceptor create(String descriptor, Callback cb) throws EEmxException {
        return new EmxNwLnkAcceptor(descriptor, cb);
    }

    private final EmxNwLnkAcceptor stop() {
        this.stopped = true;
        Thread runner = this.runner.get();
        if (runner != null) {
            runner.interrupt();
            while (true) {
                try {
                    runner.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EmxNwLnk accept() throws EEmxException {
        IEmxNwLnkPeerEndpoint pep1 = null;
        IEmxNwLnkPeerEndpoint pep2 = null;
        try {
            pep1 = this.sep.accept();
            pep2 = this.sep.accept();
            EmxNwLnk emxNwLnk = new EmxNwLnk(pep2, pep1);
            return emxNwLnk;
        }
        finally {
            if (pep1 == null || pep2 == null) {
                if (pep1 != null) {
                    pep1.close();
                }
                if (pep2 != null) {
                    pep2.close();
                }
            }
        }
    }

    @Override
    public final void run() {
        this.runner.set(Thread.currentThread());
        try {
            try {
                while (!this.stopped) {
                    this.cb.handleAcceptedLink(this.accept());
                }
            }
            finally {
                if (!this.stopped) {
                    this.sep.close();
                }
            }
        }
        catch (Throwable e) {
            if (!this.stopped) {
                this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                this.cb.handleAcceptorFailure(e);
            }
        }
        finally {
            this.runner.set(null);
        }
    }

    public final void close() throws EEmxException {
        this.stop();
        this.sep.close();
    }

    public static interface Callback {
        public void handleAcceptedLink(EmxNwLnk var1);

        public void handleAcceptorFailure(Throwable var1);
    }
}

