/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.ci.XRuntime;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageView;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;

public final class MessageLatencyManager {
    public static final String PROP_MESSAGE_LATENCY_STATS = "nv.msg.latency.stats";
    public static final boolean PROP_MESSAGE_LATENCY_STATS_DEFAULT = false;
    public static final String PROP_MESSAGE_LATENCY_STATS_INTERVAL = "nv.msg.latency.stats.interval";
    public static final String PROP_MESSAGE_LATENCY_STATS_INTERVAL_DEFAULT = "0";
    public static final String PROP_MESSAGETYPE_LATENCY_STATS = "nv.msgtype.latency.stats";
    public static final boolean PROP_MESSAGETYPE_LATENCY_STATS_DEFAULT = false;
    private final String name;
    private final Stats.LatencyManager c2o = new Stats.LatencyManager("c2o");
    private final Stats.LatencyManager o2p = new Stats.LatencyManager("o2p");
    private final Stats.LatencyManager o2s = new Stats.LatencyManager("o2s");
    private final Stats.LatencyManager s = new Stats.LatencyManager("  s");
    private final Stats.LatencyManager s2w = new Stats.LatencyManager("s2w");
    private final Stats.LatencyManager ws = new Stats.LatencyManager(" ws");
    private final Stats.LatencyManager w = new Stats.LatencyManager("  w");
    private final Stats.LatencyManager w2d = new Stats.LatencyManager("w2d");
    private final Stats.LatencyManager d = new Stats.LatencyManager("  d");
    private final Stats.LatencyManager d2i = new Stats.LatencyManager("d2i");
    private final Stats.LatencyManager o2i = new Stats.LatencyManager("o2i");
    private final Stats.LatencyManager w2w = new Stats.LatencyManager("w2w");
    private final OpenIntObjectHashMap msgTypeStatsTable = new OpenIntObjectHashMap(2048, 0.1, 0.5);
    private final MessageTypeStatsComputer msgTypeStatsComputer = new MessageTypeStatsComputer();
    private final MessageTypeStatsGetter msgTypeStatsGetter = new MessageTypeStatsGetter();
    private final MessageTypeStatsResetter msgTypeStatsResetter = new MessageTypeStatsResetter();
    private final MessageBusBinding binding;
    private final long dumpInterval;
    private final Thread outputThread;
    private boolean done;
    private volatile UpdateListener updateListener;
    private final boolean captureMsgTypeLatencyStats;
    public static final boolean captureMsgLatencyStats = XRuntime.getValue((String)"nv.msg.latency.stats", (boolean)false);

    private MessageLatencyManager(MessageBusBinding binding, String name, boolean captureMsgTypeLatencyStats, boolean forMessageTypeStats) {
        this.name = name;
        this.binding = binding;
        this.captureMsgTypeLatencyStats = captureMsgTypeLatencyStats;
        this.dumpInterval = XRuntime.getValue((String)PROP_MESSAGE_LATENCY_STATS_INTERVAL, (long)Long.valueOf(PROP_MESSAGE_LATENCY_STATS_INTERVAL_DEFAULT)) * 1000L;
        this.outputThread = !forMessageTypeStats && this.dumpInterval > 0L ? new Thread(new Runnable(){

            @Override
            public void run() {
                MessageLatencyManager.this.statsDumpLoop();
            }
        }, "X-MessageLatencyManager-" + name) : null;
    }

    public MessageLatencyManager(MessageBusBinding binding, String name) {
        this(binding, name, XRuntime.getValue((String)PROP_MESSAGETYPE_LATENCY_STATS, (boolean)false), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MessageLatencyManager getMessageTypeStats(MessageView view) {
        if (this.captureMsgTypeLatencyStats) {
            MessageLatencyManager typeStats = null;
            int key = view.getVfid() << 16 | view.getType();
            typeStats = (MessageLatencyManager)this.msgTypeStatsTable.get(key);
            if (typeStats == null) {
                typeStats = new MessageLatencyManager(this.binding, view.getClass().getSimpleName(), false, true);
                OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
                synchronized (openIntObjectHashMap) {
                    this.msgTypeStatsTable.put(key, (Object)typeStats);
                }
            }
            return typeStats;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getTypeSpecific(MessageTypeStatsGetter.Metric metric, StringBuilder sb, boolean csv) {
        if (!this.msgTypeStatsTable.isEmpty()) {
            OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
            synchronized (openIntObjectHashMap) {
                if (this.msgTypeStatsTable.size() > 0) {
                    this.msgTypeStatsTable.forEachPair((IntObjectProcedure)this.msgTypeStatsGetter.init(metric, sb, csv));
                }
            }
        }
    }

    public final String name() {
        return this.name;
    }

    public final void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
    }

    public final void setUpdateListener(UpdateListener listener) {
        this.updateListener = listener;
    }

    public final void update(MessageView view, MessagingDirection direction) {
        UpdateListener listener;
        MessageLatencyManager typeStats;
        switch (direction) {
            case Inbound: {
                if (view.getPostWireTs() > 0L && view.getPreWireTs() > 0L) {
                    this.w.add((double)(view.getPostWireTs() - view.getPreWireTs()));
                }
                if (view.getPreDeserializeTs() > 0L && view.getPostWireTs() > 0L) {
                    this.w2d.add((double)(view.getPreDeserializeTs() - view.getPostWireTs()));
                }
                if (view.getPostDeserializeTs() > 0L && view.getPreDeserializeTs() > 0L) {
                    this.d.add((double)(view.getPostDeserializeTs() - view.getPreDeserializeTs()));
                }
                if (view.getReceiveTs() > 0L && view.getPostDeserializeTs() > 0L) {
                    this.d2i.add((double)(view.getReceiveTs() - view.getPostDeserializeTs()));
                }
                if (view.getReceiveTs() <= 0L || view.getOriginTs() <= 0L) break;
                this.o2i.add((double)(view.getReceiveTs() - view.getOriginTs()));
                break;
            }
            case Outbound: {
                if (view.getSendTs() > 0L && view.getCreateTs() > 0L) {
                    this.c2o.add((double)(view.getSendTs() - view.getCreateTs()));
                }
                if (view.getSendStartTs() > 0L && view.getSendTs() > 0L) {
                    this.o2p.add((double)(view.getSendStartTs() - view.getSendTs()));
                }
                if (view.getPreSerializeTs() > 0L && view.getSendTs() > 0L) {
                    if (view.getSendStartTs() > 0L) {
                        this.o2s.add((double)(view.getPreSerializeTs() - view.getSendStartTs()));
                    } else {
                        this.o2s.add((double)(view.getPreSerializeTs() - view.getSendTs()));
                    }
                }
                if (view.getPostSerializeTs() > 0L && view.getPreSerializeTs() > 0L) {
                    this.s.add((double)(view.getPostSerializeTs() - view.getPreSerializeTs()));
                }
                if (view.getPreWireTs() > 0L && view.getPostSerializeTs() > 0L) {
                    this.s2w.add((double)(view.getPreWireTs() - view.getPostSerializeTs()));
                }
                if (view.getPreWireTs() > 0L && view.getPostWireSendTs() > 0L) {
                    this.ws.add((double)(view.getPostWireSendTs() - view.getPreWireTs()));
                }
                if (view.getPostWireTs() <= 0L || view.getPreWireTs() <= 0L) break;
                this.w2w.add((double)(view.getPreWireTs() - view.getPostWireTs()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown messaging direction '" + (Object)((Object)direction) + "'");
            }
        }
        if ((typeStats = this.getMessageTypeStats(view)) != null) {
            typeStats.update(view, direction);
        }
        if ((listener = this.updateListener) != null) {
            listener.onUpdate(this.binding, view, direction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageLatencyManager compute() {
        this.c2o.compute();
        this.o2p.compute();
        this.o2s.compute();
        this.s.compute();
        this.s2w.compute();
        this.ws.compute();
        this.w.compute();
        this.w2d.compute();
        this.d.compute();
        this.d2i.compute();
        this.o2i.compute();
        this.w2w.compute();
        OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
        synchronized (openIntObjectHashMap) {
            this.msgTypeStatsTable.forEachPair((IntObjectProcedure)this.msgTypeStatsComputer);
        }
        return this;
    }

    public final StringBuilder get(StringBuilder sb, boolean csv) {
        if (csv) {
            sb.append("type").append(",").append("segment").append(",").append("sample").append(",").append("min").append(",").append("max").append(",").append("mean").append(",").append("median").append(",").append("75%ile").append(",").append("90%ile").append(",").append("99%ile").append("\n");
        } else {
            sb.append("[Messaging Latencies (" + this.name() + ")]").append("\n");
        }
        if (csv) {
            sb.append("All,");
        }
        this.c2o.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.c2o, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.o2p.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.o2p, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.o2s.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.o2s, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.s.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.s, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.s2w.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.s2w, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.ws.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.ws, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.w.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.w, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.w2d.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.w2d, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.d.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.d, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.d2i.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.d2i, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.o2i.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.c2o, sb, csv);
        if (csv) {
            sb.append("All,");
        }
        this.w2w.get(sb, csv);
        this.getTypeSpecific(MessageTypeStatsGetter.Metric.w2w, sb, csv);
        return sb;
    }

    public final IStats.Latencies getCreateToSendLatencies() {
        return this.c2o;
    }

    public final IStats.Latencies getSendToPollLatencies() {
        return this.o2p;
    }

    public final IStats.Latencies getSendToSerializeLatencies() {
        return this.o2s;
    }

    public final IStats.Latencies getSerializeLatencies() {
        return this.s;
    }

    public final IStats.Latencies getSerializeToWireLatencies() {
        return this.s2w;
    }

    public final IStats.Latencies getWireSendLatencies() {
        return this.ws;
    }

    public final IStats.Latencies getWireLatencies() {
        return this.w;
    }

    public final IStats.Latencies getWireToDeserializeLatencies() {
        return this.w2d;
    }

    public final IStats.Latencies getDeserializeLatencies() {
        return this.d;
    }

    public final IStats.Latencies getDeserializeToReceiveLatencies() {
        return this.d2i;
    }

    public final IStats.Latencies getOriginToReceiveLatencies() {
        return this.o2i;
    }

    public final IStats.Latencies getWireToWireLatencies() {
        return this.w2w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        this.c2o.reset();
        this.o2p.reset();
        this.o2s.reset();
        this.s.reset();
        this.s2w.reset();
        this.ws.reset();
        this.w.reset();
        this.w2d.reset();
        this.d.reset();
        this.d2i.reset();
        this.o2i.reset();
        this.w2w.reset();
        if (!this.msgTypeStatsTable.isEmpty()) {
            OpenIntObjectHashMap openIntObjectHashMap = this.msgTypeStatsTable;
            synchronized (openIntObjectHashMap) {
                if (this.msgTypeStatsTable.size() > 0) {
                    this.msgTypeStatsTable.forEachPair((IntObjectProcedure)this.msgTypeStatsResetter);
                }
            }
        }
    }

    public final void shutdown() {
        this.done = true;
        if (this.outputThread != null) {
            this.outputThread.interrupt();
            try {
                this.outputThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void statsDumpLoop() {
        while (!this.done) {
            try {
                Thread.sleep(this.dumpInterval);
                if (this.c2o.count() <= 0L && this.o2p.count() <= 0L && this.o2s.count() <= 0L && this.s.count() <= 0L && this.s2w.count() <= 0L && this.ws.count() <= 0L && this.w.count() <= 0L && this.w2d.count() <= 0L && this.d.count() <= 0L && this.d2i.count() <= 0L && this.o2i.count() <= 0L && this.w2w.count() <= 0L) continue;
                System.out.println(this.compute().get(new StringBuilder(), false).toString());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static interface UpdateListener {
        public void onUpdate(MessageBusBinding var1, MessageView var2, MessagingDirection var3);
    }

    public static enum MessagingDirection {
        Inbound,
        Outbound;

    }

    private static final class MessageTypeStatsResetter
    implements IntObjectProcedure {
        private MessageTypeStatsResetter() {
        }

        public final boolean apply(int key, Object value) {
            ((MessageLatencyManager)value).reset();
            return true;
        }
    }

    private static final class MessageTypeStatsGetter
    implements IntObjectProcedure {
        Metric metric;
        StringBuilder sb;
        boolean csv;

        private MessageTypeStatsGetter() {
        }

        final MessageTypeStatsGetter init(Metric metric, StringBuilder sb, boolean csv) {
            this.metric = metric;
            this.sb = sb;
            this.csv = csv;
            return this;
        }

        public final boolean apply(int key, Object value) {
            MessageLatencyManager typeStats = (MessageLatencyManager)value;
            if (this.csv) {
                this.sb.append(typeStats.name).append(",");
            } else {
                this.sb.append("......").append(typeStats.name);
            }
            switch (this.metric) {
                case c2o: {
                    typeStats.c2o.get(this.sb, this.csv);
                    break;
                }
                case o2p: {
                    typeStats.o2p.get(this.sb, this.csv);
                    break;
                }
                case o2s: {
                    typeStats.o2s.get(this.sb, this.csv);
                    break;
                }
                case s: {
                    typeStats.s.get(this.sb, this.csv);
                    break;
                }
                case s2w: {
                    typeStats.s2w.get(this.sb, this.csv);
                    break;
                }
                case ws: {
                    typeStats.ws.get(this.sb, this.csv);
                    break;
                }
                case w: {
                    typeStats.w.get(this.sb, this.csv);
                    break;
                }
                case w2d: {
                    typeStats.w2d.get(this.sb, this.csv);
                    break;
                }
                case d: {
                    typeStats.d.get(this.sb, this.csv);
                    break;
                }
                case d2i: {
                    typeStats.d2i.get(this.sb, this.csv);
                    break;
                }
                case o2i: {
                    typeStats.o2i.get(this.sb, this.csv);
                    break;
                }
                case w2w: {
                    typeStats.w2w.get(this.sb, this.csv);
                }
            }
            return true;
        }

        static enum Metric {
            c2o,
            o2p,
            o2s,
            s,
            s2w,
            ws,
            w,
            w2d,
            d,
            d2i,
            o2i,
            w2w;

        }
    }

    private static final class MessageTypeStatsComputer
    implements IntObjectProcedure {
        private MessageTypeStatsComputer() {
        }

        public final boolean apply(int key, Object value) {
            ((MessageLatencyManager)value).compute();
            return true;
        }
    }
}

