/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.types;

import com.akiban.sql.StandardException;
import com.akiban.sql.types.DataTypeDescriptor;

public class TypeId {
    public static final int LONGINT_PRECISION = 19;
    public static final int LONGINT_SCALE = 0;
    public static final int LONGINT_MAXWIDTH = 20;
    public static final int INT_PRECISION = 10;
    public static final int INT_SCALE = 0;
    public static final int INT_MAXWIDTH = 11;
    public static final int SMALLINT_PRECISION = 5;
    public static final int SMALLINT_SCALE = 0;
    public static final int SMALLINT_MAXWIDTH = 6;
    public static final int TINYINT_PRECISION = 3;
    public static final int TINYINT_SCALE = 0;
    public static final int TINYINT_MAXWIDTH = 4;
    public static final int DOUBLE_PRECISION = 52;
    public static final int DOUBLE_PRECISION_IN_DIGITS = 15;
    public static final int DOUBLE_SCALE = 0;
    public static final int DOUBLE_MAXWIDTH = 17;
    public static final int REAL_PRECISION = 23;
    public static final int REAL_PRECISION_IN_DIGITS = 7;
    public static final int REAL_SCALE = 0;
    public static final int REAL_MAXWIDTH = 9;
    public static final int DECIMAL_PRECISION = 31;
    public static final int DECIMAL_SCALE = 31;
    public static final int DECIMAL_MAXWIDTH = 31;
    public static final int DEFAULT_DECIMAL_PRECISION = 5;
    public static final int DEFAULT_DECIMAL_SCALE = 0;
    public static final int BOOLEAN_MAXWIDTH = 5;
    public static final int CHAR_MAXWIDTH = 254;
    public static final int VARCHAR_MAXWIDTH = 32672;
    public static final int LONGVARCHAR_MAXWIDTH = 32700;
    public static final int BIT_MAXWIDTH = 254;
    public static final int VARBIT_MAXWIDTH = 32672;
    public static final int LONGVARBIT_MAXWIDTH = 32700;
    public static final int BLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int CLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int XML_MAXWIDTH = Integer.MAX_VALUE;
    public static final int DATE_MAXWIDTH = 10;
    public static final int TIME_MAXWIDTH = 8;
    public static final int TIMESTAMP_MAXWIDTH = 29;
    public static final int TIME_SCALE = 0;
    public static final int TIMESTAMP_SCALE = 9;
    public static final int INTERVAL_YEAR_MONTH_PRECISION = 8;
    public static final int INTERVAL_YEAR_MONTH_SCALE = 0;
    public static final int INTERVAL_YEAR_MONTH_MAXWIDTH = 11;
    public static final int INTERVAL_DAY_SECOND_PRECISION = 8;
    public static final int INTERVAL_DAY_SECOND_SCALE = 6;
    public static final int INTERVAL_DAY_SECOND_MAXWIDTH = 24;
    public static final String BIT_NAME = "CHAR () FOR BIT DATA";
    public static final String VARBIT_NAME = "VARCHAR () FOR BIT DATA";
    public static final String LONGVARBIT_NAME = "LONG VARCHAR FOR BIT DATA";
    public static final String TINYINT_NAME = "TINYINT";
    public static final String SMALLINT_NAME = "SMALLINT";
    public static final String MEDIUMINT_NAME = "MEDIUMINT";
    public static final String INTEGER_NAME = "INTEGER";
    public static final String INT_NAME = "INT";
    public static final String LONGINT_NAME = "BIGINT";
    public static final String FLOAT_NAME = "FLOAT";
    public static final String REAL_NAME = "REAL";
    public static final String DOUBLE_NAME = "DOUBLE";
    public static final String NUMERIC_NAME = "NUMERIC";
    public static final String DECIMAL_NAME = "DECIMAL";
    public static final String CHAR_NAME = "CHAR";
    public static final String VARCHAR_NAME = "VARCHAR";
    public static final String LONGVARCHAR_NAME = "LONG VARCHAR";
    public static final String DATE_NAME = "DATE";
    public static final String TIME_NAME = "TIME";
    public static final String TIMESTAMP_NAME = "TIMESTAMP";
    public static final String BINARY_NAME = "BINARY";
    public static final String VARBINARY_NAME = "VARBINARY";
    public static final String LONGVARBINARY_NAME = "LONGVARBINARY";
    public static final String BOOLEAN_NAME = "BOOLEAN";
    public static final String REF_NAME = "REF";
    public static final String NATIONAL_CHAR_NAME = "NATIONAL CHAR";
    public static final String NATIONAL_VARCHAR_NAME = "NATIONAL CHAR VARYING";
    public static final String NATIONAL_LONGVARCHAR_NAME = "LONG NVARCHAR";
    public static final String BLOB_NAME = "BLOB";
    public static final String CLOB_NAME = "CLOB";
    public static final String NCLOB_NAME = "NCLOB";
    public static final String TEXT_NAME = "TEXT";
    public static final String TINYBLOB_NAME = "TINYBLOB";
    public static final String TINYTEXT_NAME = "TINYTEXT";
    public static final String MEDIUMBLOB_NAME = "MEDIUMBLOB";
    public static final String MEDIUMTEXT_NAME = "MEDIUMTEXT";
    public static final String LONGBLOB_NAME = "LONGBLOB";
    public static final String LONGTEXT_NAME = "LONGTEXT";
    public static final String INTERVAL_YEAR_NAME = "INTERVAL YEAR";
    public static final String INTERVAL_MONTH_NAME = "INTERVAL MONTH";
    public static final String INTERVAL_YEAR_MONTH_NAME = "INTERVAL YEAR TO MONTH";
    public static final String INTERVAL_DAY_NAME = "INTERVAL DAY";
    public static final String INTERVAL_HOUR_NAME = "INTERVAL HOUR";
    public static final String INTERVAL_MINUTE_NAME = "INTERVAL MINUTE";
    public static final String INTERVAL_SECOND_NAME = "INTERVAL SECOND";
    public static final String INTERVAL_DAY_HOUR_NAME = "INTERVAL DAY TO HOUR";
    public static final String INTERVAL_DAY_MINUTE_NAME = "INTERVAL DAY TO MINUTE";
    public static final String INTERVAL_DAY_SECOND_NAME = "INTERVAL DAY TO SECOND";
    public static final String INTERVAL_HOUR_MINUTE_NAME = "INTERVAL HOUR TO MINUTE";
    public static final String INTERVAL_HOUR_SECOND_NAME = "INTERVAL HOUR TO SECOND";
    public static final String INTERVAL_MINUTE_SECOND_NAME = "INTERVAL MINUTE TO SECOND";
    public static final String XML_NAME = "XML";
    public static final String ARRAY_NAME = "ARRAY";
    public static final String STRUCT_NAME = "STRUCT";
    public static final String DATALINK_NAME = "DATALINK";
    public static final String ROWID_NAME = "ROWID";
    public static final String SQLXML_NAME = "SQLXML";
    public static final String TINYINT_UNSIGNED_NAME = "TINYINT UNSIGNED";
    public static final String SMALLINT_UNSIGNED_NAME = "SMALLINT UNSIGNED";
    public static final String MEDIUMINT_UNSIGNED_NAME = "MEDIUMINT UNSIGNED";
    public static final String INTEGER_UNSIGNED_NAME = "INTEGER UNSIGNED";
    public static final String INT_UNSIGNED_NAME = "INT UNSIGNED";
    public static final String LONGINT_UNSIGNED_NAME = "BIGINT UNSIGNED";
    public static final String FLOAT_UNSIGNED_NAME = "FLOAT UNSIGNED";
    public static final String REAL_UNSIGNED_NAME = "REAL UNSIGNED";
    public static final String DOUBLE_UNSIGNED_NAME = "DOUBLE UNSIGNED";
    public static final String NUMERIC_UNSIGNED_NAME = "NUMERIC UNSIGNED";
    public static final String DECIMAL_UNSIGNED_NAME = "DECIMAL UNSIGNED";
    public static final String DATETIME_NAME = "DATETIME";
    public static final String YEAR_NAME = "YEAR";
    public static final int USER_PRECEDENCE = 1000;
    public static final int XML_PRECEDENCE = 180;
    public static final int BLOB_PRECEDENCE = 170;
    public static final int LONGVARBIT_PRECEDENCE = 160;
    public static final int VARBIT_PRECEDENCE = 150;
    public static final int BIT_PRECEDENCE = 140;
    public static final int BOOLEAN_PRECEDENCE = 130;
    public static final int INTERVAL_PRECEDENCE = 125;
    public static final int TIME_PRECEDENCE = 120;
    public static final int TIMESTAMP_PRECEDENCE = 110;
    public static final int DATE_PRECEDENCE = 100;
    public static final int DOUBLE_PRECEDENCE = 90;
    public static final int REAL_PRECEDENCE = 80;
    public static final int DECIMAL_PRECEDENCE = 70;
    public static final int NUMERIC_PRECEDENCE = 69;
    public static final int LONGINT_PRECEDENCE = 60;
    public static final int INT_PRECEDENCE = 50;
    public static final int SMALLINT_PRECEDENCE = 40;
    public static final int TINYINT_PRECEDENCE = 30;
    public static final int REF_PRECEDENCE = 25;
    public static final int CLOB_PRECEDENCE = 14;
    public static final int LONGVARCHAR_PRECEDENCE = 12;
    public static final int VARCHAR_PRECEDENCE = 10;
    public static final int CHAR_PRECEDENCE = 0;
    public static final TypeId BOOLEAN_ID = new TypeId(1);
    public static final TypeId SMALLINT_ID = new TypeId(13);
    public static final TypeId MEDIUMINT_ID = new TypeId(26);
    public static final TypeId INTEGER_ID = new TypeId(7);
    public static final TypeId CHAR_ID = new TypeId(2);
    public static final TypeId TINYINT_ID = new TypeId(16);
    public static final TypeId BIGINT_ID = new TypeId(8);
    public static final TypeId REAL_ID = new TypeId(11);
    public static final TypeId DOUBLE_ID = new TypeId(6);
    public static final TypeId DECIMAL_ID = new TypeId(4);
    public static final TypeId NUMERIC_ID = new TypeId(5);
    public static final TypeId VARCHAR_ID = new TypeId(20);
    public static final TypeId DATE_ID = new TypeId(3);
    public static final TypeId TIME_ID = new TypeId(14);
    public static final TypeId TIMESTAMP_ID = new TypeId(15);
    public static final TypeId BIT_ID = new TypeId(0);
    public static final TypeId VARBIT_ID = new TypeId(18);
    public static final TypeId REF_ID = new TypeId(12);
    public static final TypeId LONGVARCHAR_ID = new TypeId(10);
    public static final TypeId LONGVARBIT_ID = new TypeId(9);
    public static final TypeId BLOB_ID = new TypeId(19);
    public static final TypeId CLOB_ID = new TypeId(21);
    public static final TypeId XML_ID = new TypeId(22);
    public static final TypeId INTERVAL_YEAR_ID = new TypeId(24, "INTERVAL YEAR");
    public static final TypeId INTERVAL_MONTH_ID = new TypeId(24, "INTERVAL MONTH");
    public static final TypeId INTERVAL_YEAR_MONTH_ID = new TypeId(24, "INTERVAL YEAR TO MONTH");
    public static final TypeId INTERVAL_DAY_ID = new TypeId(25, "INTERVAL DAY");
    public static final TypeId INTERVAL_HOUR_ID = new TypeId(25, "INTERVAL HOUR");
    public static final TypeId INTERVAL_MINUTE_ID = new TypeId(25, "INTERVAL MINUTE");
    public static final TypeId INTERVAL_SECOND_ID = new TypeId(25, "INTERVAL SECOND");
    public static final TypeId INTERVAL_DAY_HOUR_ID = new TypeId(25, "INTERVAL DAY TO HOUR");
    public static final TypeId INTERVAL_DAY_MINUTE_ID = new TypeId(25, "INTERVAL DAY TO MINUTE");
    public static final TypeId INTERVAL_DAY_SECOND_ID = new TypeId(25, "INTERVAL DAY TO SECOND");
    public static final TypeId INTERVAL_HOUR_MINUTE_ID = new TypeId(25, "INTERVAL HOUR TO MINUTE");
    public static final TypeId INTERVAL_HOUR_SECOND_ID = new TypeId(25, "INTERVAL HOUR TO SECOND");
    public static final TypeId INTERVAL_MINUTE_SECOND_ID = new TypeId(25, "INTERVAL MINUTE TO SECOND");
    public static final TypeId SMALLINT_UNSIGNED_ID = new TypeId(13, true);
    public static final TypeId MEDIUMINT_UNSIGNED_ID = new TypeId(26, true);
    public static final TypeId INTEGER_UNSIGNED_ID = new TypeId(7, true);
    public static final TypeId TINYINT_UNSIGNED_ID = new TypeId(16, true);
    public static final TypeId BIGINT_UNSIGNED_ID = new TypeId(8, true);
    public static final TypeId REAL_UNSIGNED_ID = new TypeId(11, true);
    public static final TypeId DOUBLE_UNSIGNED_ID = new TypeId(6, true);
    public static final TypeId DECIMAL_UNSIGNED_ID = new TypeId(4, true);
    public static final TypeId NUMERIC_UNSIGNED_ID = new TypeId(5, true);
    public static final TypeId DATETIME_ID = new TypeId(15, "DATETIME");
    public static final TypeId YEAR_ID = new TypeId(13, "YEAR");
    public static final TypeId TEXT_ID = new TypeId(21, "TEXT");
    public static final TypeId TINYBLOB_ID = new TypeId(19, "TINYBLOB");
    public static final TypeId TINYTEXT_ID = new TypeId(21, "TINYTEXT");
    public static final TypeId MEDIUMBLOB_ID = new TypeId(19, "MEDIUMBLOB");
    public static final TypeId MEDIUMTEXT_ID = new TypeId(21, "MEDIUMTEXT");
    public static final TypeId LONGBLOB_ID = new TypeId(19, "LONGBLOB");
    public static final TypeId LONGTEXT_ID = new TypeId(21, "LONGTEXT");
    private static final TypeId[] ALL_BUILTIN_TYPE_IDS = new TypeId[]{BOOLEAN_ID, SMALLINT_ID, MEDIUMINT_ID, INTEGER_ID, CHAR_ID, TINYINT_ID, BIGINT_ID, REAL_ID, DOUBLE_ID, DECIMAL_ID, NUMERIC_ID, VARCHAR_ID, DATE_ID, TIME_ID, TIMESTAMP_ID, BIT_ID, VARBIT_ID, REF_ID, LONGVARCHAR_ID, LONGVARBIT_ID, BLOB_ID, CLOB_ID, XML_ID, INTERVAL_YEAR_ID, INTERVAL_MONTH_ID, INTERVAL_YEAR_MONTH_ID, INTERVAL_DAY_ID, INTERVAL_HOUR_ID, INTERVAL_MINUTE_ID, INTERVAL_SECOND_ID, INTERVAL_DAY_HOUR_ID, INTERVAL_DAY_MINUTE_ID, INTERVAL_DAY_SECOND_ID, INTERVAL_HOUR_MINUTE_ID, INTERVAL_HOUR_SECOND_ID, INTERVAL_MINUTE_SECOND_ID, SMALLINT_UNSIGNED_ID, INTEGER_UNSIGNED_ID, TINYINT_UNSIGNED_ID, BIGINT_UNSIGNED_ID, REAL_UNSIGNED_ID, DOUBLE_UNSIGNED_ID, DECIMAL_UNSIGNED_ID, NUMERIC_UNSIGNED_ID, DATETIME_ID, YEAR_ID, TEXT_ID, TINYBLOB_ID, TINYTEXT_ID, MEDIUMBLOB_ID, MEDIUMTEXT_ID, LONGBLOB_ID, LONGTEXT_ID};
    private int formatId;
    private String schemaName;
    private String unqualifiedName;
    private int JDBCTypeId;
    private String javaTypeName;
    private boolean classNameWasDelimitedIdentifier;
    private boolean isBitTypeId;
    private boolean isLOBTypeId;
    private boolean isBooleanTypeId;
    private boolean isConcatableTypeId;
    private boolean isDecimalTypeId;
    private boolean isLongConcatableTypeId;
    private boolean isNumericTypeId;
    private boolean isRefTypeId;
    private boolean isStringTypeId;
    private boolean isFloatingPointTypeId;
    private boolean isRealTypeId;
    private boolean isDateTimeTimeStampTypeId;
    private boolean isIntervalTypeId;
    private boolean isUserDefinedTypeId;
    private boolean isComparable;
    private int maxPrecision;
    private int maxScale;
    private int maxMaxWidth;
    private int typePrecedence;
    private boolean unsigned;

    public static TypeId[] getAllBuiltinTypeIds() {
        int count = ALL_BUILTIN_TYPE_IDS.length;
        TypeId[] retval = new TypeId[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = ALL_BUILTIN_TYPE_IDS[i];
        }
        return retval;
    }

    public static TypeId getBuiltInTypeId(int JDBCTypeId) {
        switch (JDBCTypeId) {
            case -6: {
                return TINYINT_ID;
            }
            case 5: {
                return SMALLINT_ID;
            }
            case 4: {
                return INTEGER_ID;
            }
            case -5: {
                return BIGINT_ID;
            }
            case 6: 
            case 7: {
                return REAL_ID;
            }
            case 8: {
                return DOUBLE_ID;
            }
            case 3: {
                return DECIMAL_ID;
            }
            case 2: {
                return NUMERIC_ID;
            }
            case 1: {
                return CHAR_ID;
            }
            case 12: {
                return VARCHAR_ID;
            }
            case 91: {
                return DATE_ID;
            }
            case 92: {
                return TIME_ID;
            }
            case 93: {
                return TIMESTAMP_ID;
            }
            case -7: 
            case 16: {
                return BOOLEAN_ID;
            }
            case -2: {
                return BIT_ID;
            }
            case -3: {
                return VARBIT_ID;
            }
            case -4: {
                return LONGVARBIT_ID;
            }
            case -1: {
                return LONGVARCHAR_ID;
            }
            case 2004: {
                return BLOB_ID;
            }
            case 2005: {
                return CLOB_ID;
            }
            case 2009: {
                return XML_ID;
            }
        }
        return null;
    }

    public static TypeId getUserDefinedTypeId(String className, boolean delimitedIdentifier) throws StandardException {
        return new TypeId(className, delimitedIdentifier);
    }

    public static TypeId getUserDefinedTypeId(String schemaName, String unqualifiedName, String className) throws StandardException {
        return new TypeId(schemaName, unqualifiedName, className);
    }

    public boolean isAnsiUDT() {
        return this.schemaName != null;
    }

    public static TypeId getSQLTypeForJavaType(String javaTypeName) throws StandardException {
        if (javaTypeName.equals("java.lang.Boolean") || javaTypeName.equals("boolean")) {
            return BOOLEAN_ID;
        }
        if (javaTypeName.equals("byte[]")) {
            return VARBIT_ID;
        }
        if (javaTypeName.equals("java.lang.String")) {
            return VARCHAR_ID;
        }
        if (javaTypeName.equals("java.lang.Integer") || javaTypeName.equals("int")) {
            return INTEGER_ID;
        }
        if (javaTypeName.equals("byte")) {
            return TINYINT_ID;
        }
        if (javaTypeName.equals("short")) {
            return SMALLINT_ID;
        }
        if (javaTypeName.equals("java.lang.Long") || javaTypeName.equals("long")) {
            return BIGINT_ID;
        }
        if (javaTypeName.equals("java.lang.Float") || javaTypeName.equals("float")) {
            return REAL_ID;
        }
        if (javaTypeName.equals("java.lang.Double") || javaTypeName.equals("double")) {
            return DOUBLE_ID;
        }
        if (javaTypeName.equals("java.math.BigDecimal")) {
            return DECIMAL_ID;
        }
        if (javaTypeName.equals("java.sql.Date")) {
            return DATE_ID;
        }
        if (javaTypeName.equals("java.sql.Time")) {
            return TIME_ID;
        }
        if (javaTypeName.equals("java.sql.Timestamp")) {
            return TIMESTAMP_ID;
        }
        if (javaTypeName.equals("java.sql.Blob")) {
            return BLOB_ID;
        }
        if (javaTypeName.equals("java.sql.Clob")) {
            return CLOB_ID;
        }
        if (javaTypeName.equals("com.akiban.sql.types.XML")) {
            return XML_ID;
        }
        if (javaTypeName.equals("char")) {
            return null;
        }
        return TypeId.getUserDefinedTypeId(javaTypeName, false);
    }

    public static TypeId getBuiltInTypeId(String SQLTypeName) {
        if (SQLTypeName.equals(BOOLEAN_NAME)) {
            return BOOLEAN_ID;
        }
        if (SQLTypeName.equals(CHAR_NAME)) {
            return CHAR_ID;
        }
        if (SQLTypeName.equals(DATE_NAME)) {
            return DATE_ID;
        }
        if (SQLTypeName.equals(DOUBLE_NAME)) {
            return DOUBLE_ID;
        }
        if (SQLTypeName.equals(FLOAT_NAME)) {
            return REAL_ID;
        }
        if (SQLTypeName.equals(MEDIUMINT_NAME)) {
            return MEDIUMINT_ID;
        }
        if (SQLTypeName.equals(INTEGER_NAME) || SQLTypeName.equals(INT_NAME)) {
            return INTEGER_ID;
        }
        if (SQLTypeName.equals(LONGINT_NAME)) {
            return BIGINT_ID;
        }
        if (SQLTypeName.equals(REAL_NAME)) {
            return REAL_ID;
        }
        if (SQLTypeName.equals(SMALLINT_NAME)) {
            return SMALLINT_ID;
        }
        if (SQLTypeName.equals(TIME_NAME)) {
            return TIME_ID;
        }
        if (SQLTypeName.equals(TIMESTAMP_NAME)) {
            return TIMESTAMP_ID;
        }
        if (SQLTypeName.equals(VARCHAR_NAME)) {
            return VARCHAR_ID;
        }
        if (SQLTypeName.equals(BIT_NAME)) {
            return BIT_ID;
        }
        if (SQLTypeName.equals(VARBIT_NAME)) {
            return VARBIT_ID;
        }
        if (SQLTypeName.equals(TINYINT_NAME)) {
            return TINYINT_ID;
        }
        if (SQLTypeName.equals(DECIMAL_NAME)) {
            return DECIMAL_ID;
        }
        if (SQLTypeName.equals(NUMERIC_NAME)) {
            return NUMERIC_ID;
        }
        if (SQLTypeName.equals(LONGVARCHAR_NAME)) {
            return LONGVARCHAR_ID;
        }
        if (SQLTypeName.equals(LONGVARBIT_NAME)) {
            return LONGVARBIT_ID;
        }
        if (SQLTypeName.equals(BLOB_NAME)) {
            return BLOB_ID;
        }
        if (SQLTypeName.equals(CLOB_NAME)) {
            return CLOB_ID;
        }
        if (SQLTypeName.equals(TEXT_NAME)) {
            return TEXT_ID;
        }
        if (SQLTypeName.equals(TINYBLOB_NAME)) {
            return TINYBLOB_ID;
        }
        if (SQLTypeName.equals(TINYTEXT_NAME)) {
            return TINYTEXT_ID;
        }
        if (SQLTypeName.equals(MEDIUMBLOB_NAME)) {
            return MEDIUMBLOB_ID;
        }
        if (SQLTypeName.equals(MEDIUMTEXT_NAME)) {
            return MEDIUMTEXT_ID;
        }
        if (SQLTypeName.equals(LONGBLOB_NAME)) {
            return LONGBLOB_ID;
        }
        if (SQLTypeName.equals(LONGTEXT_NAME)) {
            return LONGTEXT_ID;
        }
        if (SQLTypeName.equals(XML_NAME)) {
            return XML_ID;
        }
        if (SQLTypeName.equals(INTERVAL_YEAR_NAME)) {
            return INTERVAL_YEAR_ID;
        }
        if (SQLTypeName.equals(INTERVAL_MONTH_NAME)) {
            return INTERVAL_MONTH_ID;
        }
        if (SQLTypeName.equals(INTERVAL_YEAR_MONTH_NAME)) {
            return INTERVAL_YEAR_MONTH_ID;
        }
        if (SQLTypeName.equals(INTERVAL_DAY_NAME)) {
            return INTERVAL_DAY_ID;
        }
        if (SQLTypeName.equals(INTERVAL_HOUR_NAME)) {
            return INTERVAL_HOUR_ID;
        }
        if (SQLTypeName.equals(INTERVAL_MINUTE_NAME)) {
            return INTERVAL_MINUTE_ID;
        }
        if (SQLTypeName.equals(INTERVAL_SECOND_NAME)) {
            return INTERVAL_SECOND_ID;
        }
        if (SQLTypeName.equals(INTERVAL_DAY_HOUR_NAME)) {
            return INTERVAL_DAY_HOUR_ID;
        }
        if (SQLTypeName.equals(INTERVAL_DAY_MINUTE_NAME)) {
            return INTERVAL_DAY_MINUTE_ID;
        }
        if (SQLTypeName.equals(INTERVAL_DAY_SECOND_NAME)) {
            return INTERVAL_DAY_SECOND_ID;
        }
        if (SQLTypeName.equals(INTERVAL_HOUR_MINUTE_NAME)) {
            return INTERVAL_HOUR_MINUTE_ID;
        }
        if (SQLTypeName.equals(INTERVAL_HOUR_SECOND_NAME)) {
            return INTERVAL_HOUR_SECOND_ID;
        }
        if (SQLTypeName.equals(INTERVAL_MINUTE_SECOND_NAME)) {
            return INTERVAL_MINUTE_SECOND_ID;
        }
        if (SQLTypeName.equals(TINYINT_UNSIGNED_NAME)) {
            return TINYINT_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(SMALLINT_UNSIGNED_NAME)) {
            return SMALLINT_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(INTEGER_UNSIGNED_NAME) || SQLTypeName.equals(INT_UNSIGNED_NAME)) {
            return INTEGER_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(LONGINT_UNSIGNED_NAME)) {
            return BIGINT_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(FLOAT_UNSIGNED_NAME)) {
            return REAL_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(REAL_UNSIGNED_NAME)) {
            return REAL_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(DOUBLE_UNSIGNED_NAME)) {
            return DOUBLE_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(NUMERIC_UNSIGNED_NAME)) {
            return NUMERIC_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(DECIMAL_UNSIGNED_NAME)) {
            return DECIMAL_UNSIGNED_ID;
        }
        if (SQLTypeName.equals(DATETIME_NAME)) {
            return DATETIME_ID;
        }
        if (SQLTypeName.equals(YEAR_NAME)) {
            return YEAR_ID;
        }
        if (SQLTypeName.equals(REF_NAME)) {
            return REF_ID;
        }
        return null;
    }

    private TypeId(int formatId) {
        this.formatId = formatId;
        this.isComparable = true;
        switch (formatId) {
            case 0: {
                this.schemaName = null;
                this.unqualifiedName = BIT_NAME;
                this.JDBCTypeId = -2;
                this.typePrecedence = 140;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 254;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 1: {
                this.schemaName = null;
                this.unqualifiedName = BOOLEAN_NAME;
                this.JDBCTypeId = 16;
                this.maxPrecision = 5;
                this.typePrecedence = 130;
                this.javaTypeName = "java.lang.Boolean";
                this.maxMaxWidth = 5;
                this.isBooleanTypeId = true;
                break;
            }
            case 2: {
                this.schemaName = null;
                this.unqualifiedName = CHAR_NAME;
                this.JDBCTypeId = 1;
                this.typePrecedence = 0;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 254;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 3: {
                this.schemaName = null;
                this.unqualifiedName = DATE_NAME;
                this.JDBCTypeId = 91;
                this.typePrecedence = 100;
                this.javaTypeName = "java.sql.Date";
                this.maxMaxWidth = 10;
                this.maxPrecision = 10;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 4: {
                this.schemaName = null;
                this.unqualifiedName = DECIMAL_NAME;
                this.JDBCTypeId = 3;
                this.maxPrecision = 31;
                this.maxScale = 31;
                this.typePrecedence = 70;
                this.javaTypeName = "java.math.BigDecimal";
                this.maxMaxWidth = 31;
                this.isDecimalTypeId = true;
                this.isNumericTypeId = true;
                break;
            }
            case 5: {
                this.schemaName = null;
                this.unqualifiedName = NUMERIC_NAME;
                this.JDBCTypeId = 2;
                this.maxPrecision = 31;
                this.maxScale = 31;
                this.typePrecedence = 70;
                this.javaTypeName = "java.math.BigDecimal";
                this.maxMaxWidth = 31;
                this.isDecimalTypeId = true;
                this.isNumericTypeId = true;
                break;
            }
            case 6: {
                this.schemaName = null;
                this.unqualifiedName = DOUBLE_NAME;
                this.JDBCTypeId = 8;
                this.maxPrecision = 52;
                this.maxScale = 0;
                this.typePrecedence = 90;
                this.javaTypeName = "java.lang.Double";
                this.maxMaxWidth = 17;
                this.isNumericTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 26: {
                this.schemaName = null;
                this.unqualifiedName = MEDIUMINT_NAME;
                this.JDBCTypeId = 1111;
                this.maxPrecision = 10;
                this.maxScale = 0;
                this.typePrecedence = 50;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 11;
                this.isNumericTypeId = true;
                break;
            }
            case 7: {
                this.schemaName = null;
                this.unqualifiedName = INTEGER_NAME;
                this.JDBCTypeId = 4;
                this.maxPrecision = 10;
                this.maxScale = 0;
                this.typePrecedence = 50;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 11;
                this.isNumericTypeId = true;
                break;
            }
            case 8: {
                this.schemaName = null;
                this.unqualifiedName = LONGINT_NAME;
                this.JDBCTypeId = -5;
                this.maxPrecision = 19;
                this.maxScale = 0;
                this.typePrecedence = 60;
                this.javaTypeName = "java.lang.Long";
                this.maxMaxWidth = 20;
                this.isNumericTypeId = true;
                break;
            }
            case 9: {
                this.schemaName = null;
                this.unqualifiedName = LONGVARBIT_NAME;
                this.JDBCTypeId = -4;
                this.typePrecedence = 160;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32700;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 10: {
                this.schemaName = null;
                this.unqualifiedName = LONGVARCHAR_NAME;
                this.JDBCTypeId = -1;
                this.typePrecedence = 12;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32700;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isComparable = false;
                break;
            }
            case 11: {
                this.schemaName = null;
                this.unqualifiedName = REAL_NAME;
                this.JDBCTypeId = 7;
                this.maxPrecision = 23;
                this.maxScale = 0;
                this.typePrecedence = 80;
                this.javaTypeName = "java.lang.Float";
                this.maxMaxWidth = 9;
                this.isNumericTypeId = true;
                this.isRealTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 12: {
                this.schemaName = null;
                this.unqualifiedName = REF_NAME;
                this.JDBCTypeId = 1111;
                this.typePrecedence = 25;
                this.javaTypeName = "java.sql.Ref";
                this.isRefTypeId = true;
                this.isComparable = false;
                break;
            }
            case 13: {
                this.schemaName = null;
                this.unqualifiedName = SMALLINT_NAME;
                this.JDBCTypeId = 5;
                this.maxPrecision = 5;
                this.maxScale = 0;
                this.typePrecedence = 40;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 6;
                this.isNumericTypeId = true;
                break;
            }
            case 14: {
                this.schemaName = null;
                this.unqualifiedName = TIME_NAME;
                this.JDBCTypeId = 92;
                this.typePrecedence = 120;
                this.javaTypeName = "java.sql.Time";
                this.maxScale = 0;
                this.maxMaxWidth = 8;
                this.maxPrecision = 8;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 15: {
                this.schemaName = null;
                this.unqualifiedName = TIMESTAMP_NAME;
                this.JDBCTypeId = 93;
                this.typePrecedence = 110;
                this.javaTypeName = "java.sql.Timestamp";
                this.maxScale = 9;
                this.maxMaxWidth = 29;
                this.maxPrecision = 29;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 16: {
                this.schemaName = null;
                this.unqualifiedName = TINYINT_NAME;
                this.JDBCTypeId = -6;
                this.maxPrecision = 3;
                this.maxScale = 0;
                this.typePrecedence = 30;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                break;
            }
            case 18: {
                this.schemaName = null;
                this.unqualifiedName = VARBIT_NAME;
                this.JDBCTypeId = -3;
                this.typePrecedence = 150;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32672;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 19: {
                this.schemaName = null;
                this.unqualifiedName = BLOB_NAME;
                this.JDBCTypeId = 2004;
                this.typePrecedence = 170;
                this.javaTypeName = "java.sql.Blob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isComparable = false;
                this.isLOBTypeId = true;
                break;
            }
            case 20: {
                this.schemaName = null;
                this.unqualifiedName = VARCHAR_NAME;
                this.JDBCTypeId = 12;
                this.typePrecedence = 10;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32672;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 21: {
                this.schemaName = null;
                this.unqualifiedName = CLOB_NAME;
                this.JDBCTypeId = 2005;
                this.typePrecedence = 14;
                this.javaTypeName = "java.sql.Clob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isComparable = false;
                this.isLOBTypeId = true;
                break;
            }
            case 22: {
                this.schemaName = null;
                this.unqualifiedName = XML_NAME;
                this.JDBCTypeId = 2009;
                this.typePrecedence = 180;
                this.javaTypeName = "com.akiban.sql.types.XML";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isComparable = false;
                break;
            }
            case 24: {
                this.schemaName = null;
                this.typePrecedence = 125;
                this.JDBCTypeId = 1111;
                this.maxPrecision = 8;
                this.maxScale = 0;
                this.maxMaxWidth = 11;
                this.isIntervalTypeId = true;
                break;
            }
            case 25: {
                this.schemaName = null;
                this.typePrecedence = 125;
                this.JDBCTypeId = 1111;
                this.maxPrecision = 8;
                this.maxScale = 6;
                this.maxMaxWidth = 24;
                this.isIntervalTypeId = true;
                break;
            }
            case 17: {
                this.JDBCTypeId = 2000;
                this.maxMaxWidth = -1;
                this.isUserDefinedTypeId = true;
                this.typePrecedence = 1000;
                break;
            }
            case 23: {
                this.schemaName = null;
                this.JDBCTypeId = 1111;
                this.javaTypeName = "java.sql.ResultSet";
                this.maxMaxWidth = -1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    private TypeId(int formatId, boolean unsigned) {
        this(formatId);
        if (unsigned) {
            this.unsigned = true;
            switch (formatId) {
                case 4: {
                    this.unqualifiedName = DECIMAL_UNSIGNED_NAME;
                    break;
                }
                case 5: {
                    this.unqualifiedName = NUMERIC_UNSIGNED_NAME;
                    break;
                }
                case 6: {
                    this.unqualifiedName = DOUBLE_UNSIGNED_NAME;
                    break;
                }
                case 7: {
                    this.unqualifiedName = INTEGER_UNSIGNED_NAME;
                    break;
                }
                case 8: {
                    this.unqualifiedName = LONGINT_UNSIGNED_NAME;
                    break;
                }
                case 11: {
                    this.unqualifiedName = REAL_UNSIGNED_NAME;
                    break;
                }
                case 13: {
                    this.unqualifiedName = SMALLINT_UNSIGNED_NAME;
                    break;
                }
                case 16: {
                    this.unqualifiedName = TINYINT_UNSIGNED_NAME;
                    break;
                }
                case 26: {
                    this.unqualifiedName = MEDIUMINT_UNSIGNED_NAME;
                    break;
                }
                default: {
                    assert (false) : "unknown formatId: " + formatId;
                    break;
                }
            }
        }
    }

    private TypeId(int formatId, String name) {
        this(formatId);
        this.unqualifiedName = name;
    }

    private TypeId(String className, boolean classNameWasDelimitedIdentifier) {
        this(17);
        if (!classNameWasDelimitedIdentifier) {
            this.schemaName = null;
            this.unqualifiedName = className;
        }
        this.javaTypeName = className;
        this.classNameWasDelimitedIdentifier = classNameWasDelimitedIdentifier;
    }

    private TypeId(String schemaName, String unqualifiedName, String className) {
        this(17);
        this.schemaName = schemaName;
        this.unqualifiedName = unqualifiedName;
        this.javaTypeName = className;
    }

    public boolean equals(Object that) {
        if (that instanceof TypeId) {
            return this.getSQLTypeName().equals(((TypeId)that).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    public final int getJDBCTypeId() {
        return this.JDBCTypeId;
    }

    public String getSQLTypeName() {
        if (this.schemaName == null) {
            return this.unqualifiedName;
        }
        return this.schemaName + "." + this.unqualifiedName;
    }

    public final boolean userType() {
        return this.isUserDefinedTypeId;
    }

    public int getMaximumPrecision() {
        return this.maxPrecision;
    }

    public int getMaximumScale() {
        return this.maxScale;
    }

    public boolean getClassNameWasDelimitedIdentifier() {
        return this.classNameWasDelimitedIdentifier;
    }

    public boolean isStringTypeId() {
        return this.isStringTypeId;
    }

    public boolean isDateTimeTimeStampTypeId() {
        return this.isDateTimeTimeStampTypeId;
    }

    public boolean isRealTypeId() {
        return this.isRealTypeId;
    }

    public boolean isFloatingPointTypeId() {
        return this.isFloatingPointTypeId;
    }

    public boolean isDoubleTypeId() {
        return this.isFloatingPointTypeId && !this.isRealTypeId;
    }

    public boolean isFixedStringTypeId() {
        return this.formatId == 2;
    }

    public boolean isClobTypeId() {
        return this.formatId == 21;
    }

    public boolean isBlobTypeId() {
        return this.formatId == 19;
    }

    public boolean isLongVarcharTypeId() {
        return this.formatId == 10;
    }

    public boolean isLongVarbinaryTypeId() {
        return this.formatId == 9;
    }

    public boolean isDateTimeTimeStampTypeID() {
        return this.formatId == 3 || this.formatId == 14 || this.formatId == 15;
    }

    public boolean isXMLTypeId() {
        return this.formatId == 22;
    }

    public boolean isComparable() {
        return this.isComparable;
    }

    public int typePrecedence() {
        return this.typePrecedence;
    }

    public String getCorrespondingJavaTypeName() {
        return this.javaTypeName;
    }

    public String getResultSetMetaDataTypeName() {
        if (BLOB_ID.equals(this)) {
            return "java.sql.Blob";
        }
        if (CLOB_ID.equals(this)) {
            return "java.sql.Clob";
        }
        return this.getCorrespondingJavaTypeName();
    }

    public int getMaximumMaximumWidth() {
        return this.maxMaxWidth;
    }

    public String toParsableString(DataTypeDescriptor dts) {
        String retval = this.getSQLTypeName();
        switch (this.formatId) {
            case 0: 
            case 18: {
                int rparen = retval.indexOf(41);
                String lead = retval.substring(0, rparen);
                retval = lead + dts.getMaximumWidth() + retval.substring(rparen);
                break;
            }
            case 2: 
            case 19: 
            case 20: 
            case 21: {
                retval = retval + "(" + dts.getMaximumWidth() + ")";
                break;
            }
            case 4: {
                if (this.unsigned) {
                    retval = retval.substring(0, retval.length() - 9) + "(" + dts.getPrecision() + "," + dts.getScale() + ")" + retval.substring(retval.length() - 9);
                    break;
                }
                retval = retval + "(" + dts.getPrecision() + "," + dts.getScale() + ")";
                break;
            }
            case 24: 
            case 25: {
                if (this == INTERVAL_SECOND_ID) {
                    if (dts.getPrecision() <= 0) break;
                    retval = retval + "(" + dts.getPrecision();
                    if (dts.getScale() > 0) {
                        retval = retval + ", " + dts.getScale();
                    }
                    retval = retval + ")";
                    break;
                }
                if (dts.getPrecision() > 0) {
                    int idx = retval.indexOf(" ", 9);
                    if (idx < 0) {
                        idx = retval.length();
                    }
                    retval = retval.substring(0, idx) + "(" + dts.getPrecision() + ")" + retval.substring(idx);
                }
                if (dts.getScale() <= 0) break;
                retval = retval + "(" + dts.getScale() + ")";
            }
        }
        return retval;
    }

    public boolean isNumericTypeId() {
        return this.isNumericTypeId;
    }

    public boolean isDecimalTypeId() {
        return this.isDecimalTypeId;
    }

    public boolean isIntegerTypeId() {
        return this.isNumericTypeId && !this.isDecimalTypeId && !this.isFloatingPointTypeId;
    }

    public boolean isBooleanTypeId() {
        return this.isBooleanTypeId;
    }

    public boolean isRefTypeId() {
        return this.isRefTypeId;
    }

    public boolean isConcatableTypeId() {
        return this.isConcatableTypeId;
    }

    public boolean isBitTypeId() {
        return this.isBitTypeId;
    }

    public boolean isLOBTypeId() {
        return this.isLOBTypeId;
    }

    public boolean isLongConcatableTypeId() {
        return this.isLongConcatableTypeId;
    }

    public boolean isUserDefinedTypeId() {
        return this.isUserDefinedTypeId;
    }

    public int getPrecision(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        assert (this.formatId == 4) : this.formatId;
        long val = (long)this.getScale(leftType, rightType) + Math.max(lprec - lscale, rprec - rscale);
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        return (int)val;
    }

    public int getScale(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        assert (this.formatId == 4) : this.formatId;
        return Math.max(leftType.getScale(), rightType.getScale());
    }

    public boolean variableLength() {
        switch (this.formatId) {
            case 0: 
            case 2: 
            case 4: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public static TypeId getRowMultiSet(String[] columnNames, DataTypeDescriptor[] columnTypes) {
        return new RowMultiSetTypeId(columnNames, columnTypes);
    }

    public boolean isRowMultiSet() {
        return false;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public static TypeId intervalTypeId(TypeId startField, TypeId endField) throws StandardException {
        if (startField == INTERVAL_YEAR_ID && endField == INTERVAL_MONTH_ID) {
            return INTERVAL_YEAR_MONTH_ID;
        }
        if (startField == INTERVAL_DAY_ID) {
            if (endField == INTERVAL_HOUR_ID) {
                return INTERVAL_DAY_HOUR_ID;
            }
            if (endField == INTERVAL_MINUTE_ID) {
                return INTERVAL_DAY_MINUTE_ID;
            }
            if (endField == INTERVAL_SECOND_ID) {
                return INTERVAL_DAY_SECOND_ID;
            }
        }
        if (startField == INTERVAL_HOUR_ID) {
            if (endField == INTERVAL_MINUTE_ID) {
                return INTERVAL_HOUR_MINUTE_ID;
            }
            if (endField == INTERVAL_SECOND_ID) {
                return INTERVAL_HOUR_SECOND_ID;
            }
        }
        if (startField == INTERVAL_MINUTE_ID && endField == INTERVAL_SECOND_ID) {
            return INTERVAL_MINUTE_SECOND_ID;
        }
        throw new StandardException("Illegal " + startField.unqualifiedName + " TO " + endField.unqualifiedName.substring("INTERVAL ".length()));
    }

    public boolean isIntervalTypeId() {
        return this.isIntervalTypeId;
    }

    public static class RowMultiSetTypeId
    extends TypeId {
        String[] columnNames;
        DataTypeDescriptor[] columnTypes;

        public RowMultiSetTypeId(String[] columnNames, DataTypeDescriptor[] columnTypes) {
            super(23);
            this.columnNames = columnNames;
            this.columnTypes = columnTypes;
        }

        @Override
        public String getSQLTypeName() {
            StringBuffer buffer = new StringBuffer();
            int count = this.columnNames.length;
            buffer.append("TABLE ( ");
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\"');
                buffer.append(this.columnNames[i]);
                buffer.append('\"');
                buffer.append(' ');
                buffer.append(this.columnTypes[i].getSQLstring());
            }
            buffer.append(" )");
            return buffer.toString();
        }

        @Override
        public boolean isRowMultiSet() {
            return true;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public DataTypeDescriptor[] getColumnTypes() {
            return this.columnTypes;
        }
    }

    public static class FormatIds {
        public static final int BIT_TYPE_ID = 0;
        public static final int BOOLEAN_TYPE_ID = 1;
        public static final int CHAR_TYPE_ID = 2;
        public static final int DATE_TYPE_ID = 3;
        public static final int DECIMAL_TYPE_ID = 4;
        public static final int NUMERIC_TYPE_ID = 5;
        public static final int DOUBLE_TYPE_ID = 6;
        public static final int INT_TYPE_ID = 7;
        public static final int LONGINT_TYPE_ID = 8;
        public static final int LONGVARBIT_TYPE_ID = 9;
        public static final int LONGVARCHAR_TYPE_ID = 10;
        public static final int REAL_TYPE_ID = 11;
        public static final int REF_TYPE_ID = 12;
        public static final int SMALLINT_TYPE_ID = 13;
        public static final int TIME_TYPE_ID = 14;
        public static final int TIMESTAMP_TYPE_ID = 15;
        public static final int TINYINT_TYPE_ID = 16;
        public static final int USERDEFINED_TYPE_ID = 17;
        public static final int VARBIT_TYPE_ID = 18;
        public static final int BLOB_TYPE_ID = 19;
        public static final int VARCHAR_TYPE_ID = 20;
        public static final int CLOB_TYPE_ID = 21;
        public static final int XML_TYPE_ID = 22;
        public static final int ROW_MULTISET_TYPE_ID_IMPL = 23;
        public static final int INTERVAL_YEAR_MONTH_ID = 24;
        public static final int INTERVAL_DAY_SECOND_ID = 25;
        public static final int MEDIUMINT_ID = 26;
    }
}

