/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoCompoundArrayField;
import com.neeve.sto.StoCompoundField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.test.unit.StoCompoundFieldTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class StoCompoundArrayFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    static final StoFieldContainer[] createArray(int len) {
        StoFieldContainer[] array = new StoFieldContainer[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = StoCompoundFieldTest.createContainer(false);
        }
        return array;
    }

    static final StoFieldContainer[] cloneArray(StoFieldContainer[] original) {
        StoFieldContainer[] clone = new StoFieldContainer[original.length];
        for (int i = 0; i < original.length; ++i) {
            clone[i] = (StoFieldContainer)original[i].clone();
        }
        return clone;
    }

    static final void compare(StoFieldContainer[] array1, StoFieldContainer[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else if (array2 == null) {
            Assert.fail();
        } else if (array1.length != array2.length) {
            Assert.fail();
        } else {
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i].contentsEquals(array2[i])) continue;
                Assert.fail();
            }
        }
    }

    private final void validate(StoCompoundArrayField field, String name, ByteBuffer buffer, StoFieldContainer[] val, boolean same) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.COMPOUND_ARRAY), (Object)((Object)field.getType()));
        StoCompoundArrayFieldTest.compare(val, (StoFieldContainer[])field.getValue(), same);
    }

    private final void cloneAndValidate(StoCompoundArrayField field, String name, StoFieldContainer[] val) {
        StoCompoundArrayField clone = (StoCompoundArrayField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val, false);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    private final int expectedSerializedLength(StoFieldContainer[] array) {
        int len = 2 + (array != null && array.length > 0 ? 4 : 0);
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                len += StoCompoundField.getBodySerializedLength(array[i]);
            }
        }
        return len;
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(null), (long)this.expectedSerializedLength(null));
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(0);
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(array), (long)this.expectedSerializedLength(array));
        array = StoCompoundArrayFieldTest.createArray(5);
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(array), (long)this.expectedSerializedLength(array));
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoCompoundArrayField.put(buffer, 5, null);
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(buffer, 5), (long)this.expectedSerializedLength(null));
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, 5), null, false);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer[] array1 = StoCompoundArrayFieldTest.createArray(0);
        StoCompoundArrayField.put(buffer, 5, array1);
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(buffer, 5), (long)this.expectedSerializedLength(array1));
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 10240, 10240);
        array1 = StoCompoundArrayFieldTest.createArray(5);
        StoFieldContainer[] array2 = StoCompoundArrayFieldTest.createArray(5);
        StoCompoundArrayField.put(buffer, 5, array1);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertEquals((long)StoCompoundArrayField.getSerializedLength(buffer, 5), (long)this.expectedSerializedLength(array1));
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, 5), array1, false);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayField.put(buffer, 5, array2);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, 5), array2, false);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        this.validate(field, null, null, null, true);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        this.validate(field, "name", null, null, true);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertTrue((boolean)StoCompoundArrayField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, null, null, array, true);
        this.cloneAndValidate(field, null, array);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(field, "name", null, array, true);
        this.cloneAndValidate(field, "name", array);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, null, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, null, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, buffer, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", buffer, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 10240, 10240);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 10240, 10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        this.validate(buffer, 0, 10240, 10240);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, null, null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, field.shiftForHeader(45)), array, false);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoCompoundArrayField field = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field.setValue(array);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 10240, 10240);
        this.validate(field, "name", null, array, true);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayFieldTest.compare(StoCompoundArrayField.get(buffer, field.shiftForHeader(52)), array, false);
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 10240, 10240);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 10240, 10240);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 10240, 10240);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 10240, 10240);
        this.cloneAndValidate(field2, "name", array);
        this.validate(buffer, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 10240, 10240);
        ByteBuffer buffer2 = ByteBuffer.allocate(10240);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        StoCompoundArrayField field3 = (StoCompoundArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        this.validate(field3, null, buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 10240, 10240);
        this.cloneAndValidate(field3, null, array);
        this.validate(buffer2, 0, 10240, 10240);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(10240);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(5);
        field1.setValue(array);
        field1.setBackingBuffer(buffer1, 32);
        this.validate(buffer1, 0, 10240, 10240);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer1, 32);
        this.validate(buffer1, 0, 10240, 10240);
        ByteBuffer buffer2 = ByteBuffer.allocate(10240);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        StoCompoundArrayField field3 = (StoCompoundArrayField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 10240, 10240);
        this.validate(field3, "name", buffer2, array, false);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 10240, 10240);
        this.cloneAndValidate(field3, "name", array);
        this.validate(buffer2, 0, 10240, 10240);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetNullValueDeserialize() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(null);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateSetEmptyValueDeserialize() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoFieldContainer[] array = StoCompoundArrayFieldTest.createArray(0);
        field1.setValue(array);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, array);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoCompoundArrayField field2 = (StoCompoundArrayField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 65);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundArrayField.create("name").contentsEquals(StoCompoundArrayField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundArrayField.create(null).contentsEquals(StoCompoundArrayField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoCompoundArrayField.create("name1").contentsEquals(StoCompoundArrayField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        field1.setValue(StoCompoundArrayFieldTest.createArray(5));
        field2.setValue(null);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        field1.setValue(null);
        field2.setValue(StoCompoundArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffLengths() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        field1.setValue(StoCompoundArrayFieldTest.createArray(5));
        field2.setValue(StoCompoundArrayFieldTest.createArray(4));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        field1.setValue(StoCompoundArrayFieldTest.createArray(5));
        field2.setValue(StoCompoundArrayFieldTest.createArray(5));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create("name");
        StoCompoundArrayField field2 = StoCompoundArrayField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create(null);
        StoCompoundArrayField field2 = StoCompoundArrayField.create(null);
        field1.setValue(StoCompoundArrayFieldTest.createArray(5));
        field2.setValue(StoCompoundArrayFieldTest.cloneArray((StoFieldContainer[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoCompoundArrayField field1 = StoCompoundArrayField.create("name");
        StoCompoundArrayField field2 = StoCompoundArrayField.create("name");
        field1.setValue(StoCompoundArrayFieldTest.createArray(5));
        field2.setValue(StoCompoundArrayFieldTest.cloneArray((StoFieldContainer[])field1.getValue()));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

