/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheader;
import com.neeve.pkt.PktSubheaderODS;
import org.junit.Assert;
import org.junit.Test;

public final class PktSubheaderODSTest {
    private PktSerializable.SerializeContext serialize(PktSubheaderODS subheader, PktSerializable.SerializeContext sc) {
        sc.setBufferCount(0);
        sc.addBuffer(IOBuffer.create((int)subheader.getSerializedLength(), (boolean)false));
        subheader.serialize(sc);
        Assert.assertEquals((long)7L, (long)PktSubheader.getType(sc.getByteBuffer(0), 0));
        return sc;
    }

    private PktSubheaderODS deserialize(PktSerializable.SerializeContext sc) {
        PktSerializable.DeserializeContext dc = PktSerializable.DeserializeContext.create();
        dc.setBuffer(sc.flipBuffers().getByteBuffer(0));
        PktSubheaderODS subHeader = (PktSubheaderODS)PktSubheaderODS.create();
        subHeader.deserialize(dc, subHeader.getSerializedLength(sc.getByteBuffer(0), 0), null);
        return subHeader;
    }

    @Test
    public void testIOBufferIsNullOnCreate() {
        Assert.assertNull((Object)PktSubheaderODS.create().getBuffer().getIOBuffer());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetEmptyObjectMetadata() {
        ((PktSubheaderODS)PktSubheaderODS.create()).copyObjectMetadataFrom(PktBuffer.create(null, 1, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetEmptyPersisterMetadata() {
        ((PktSubheaderODS)PktSubheaderODS.create()).copyPersisterMetadataFrom(PktBuffer.create(null, 1, false));
    }

    @Test(expected=IllegalStateException.class)
    public void testCopyPersisterMetadataOnV1Subheader() {
        ((PktSubheaderODS)PktSubheaderODS.create((short)1)).copyPersisterMetadataFrom(PktBuffer.create(null, 248, false).setLength(248));
    }

    @Test
    public void testSetCommitEntryTypeOnV1Subheader() {
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create((short)1);
        subheader.setCommitEntryType((short)1);
        Assert.assertFalse((boolean)subheader.getFlagCommitEntryIsPut());
        Assert.assertEquals((long)1L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)2);
        Assert.assertFalse((boolean)subheader.getFlagCommitEntryIsUpdate());
        Assert.assertEquals((long)2L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)3);
        Assert.assertFalse((boolean)subheader.getFlagCommitEntryIsRemove());
        Assert.assertEquals((long)3L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)4);
        Assert.assertFalse((boolean)subheader.getFlagCommitEntryIsSend());
        Assert.assertEquals((long)4L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
    }

    @Test
    public void testSetCommitEntryTypeOnV2Subheader() {
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        subheader.setCommitEntryType((short)1);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsPut());
        Assert.assertEquals((long)1L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)2);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsUpdate());
        Assert.assertEquals((long)2L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)3);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsRemove());
        Assert.assertEquals((long)3L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setCommitEntryType((short)4);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsSend());
        Assert.assertEquals((long)4L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
    }

    @Test
    public void testGetCommitEntryTypeOnV2Subheader() {
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        subheader.setFlagCommitEntryIsPut(true);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsPut());
        Assert.assertEquals((long)1L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setFlagCommitEntryIsUpdate(true);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsUpdate());
        Assert.assertEquals((long)2L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setFlagCommitEntryIsRemove(true);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsRemove());
        Assert.assertEquals((long)3L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
        subheader.setFlagCommitEntryIsSend(true);
        Assert.assertTrue((boolean)subheader.getFlagCommitEntryIsSend());
        Assert.assertEquals((long)4L, (long)subheader.getCommitEntryType());
        subheader.setFlags((byte)0);
    }

    @Test
    public void testFieldPopulation() {
        int expectedFixedLength = 61;
        int minBufferSize = 256;
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertNull((Object)subheader.getObjectId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        UUID id = new UUID();
        subheader.setObjectId(id);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)0L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setObjectFactoryId((short)324);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setObjectType((short)567);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setContentEncodingType((short)100);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        long timestamp = System.currentTimeMillis();
        subheader.setTimestamp(timestamp);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setTransactionId(200L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setStableTransactionId(300L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setCheckpointVersion(400L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.setFlags((byte)96);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(PktBuffer.create(null, 82, false).setLength(82));
        Assert.assertEquals((long)143L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, 22, false).setLength(22));
        Assert.assertEquals((long)165L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)22L, (long)subheader.getPersisterMetadata().getLength());
        int maxMetadataLengthWithoutResize = 195 - subheader.getObjectMetadata().getLength();
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, maxMetadataLengthWithoutResize, false).setLength(maxMetadataLengthWithoutResize));
        Assert.assertEquals((long)256L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)maxMetadataLengthWithoutResize, (long)subheader.getPersisterMetadata().getLength());
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, maxMetadataLengthWithoutResize + 1, false).setLength(maxMetadataLengthWithoutResize + 1));
        Assert.assertEquals((long)257L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)(maxMetadataLengthWithoutResize + 1), (long)subheader.getPersisterMetadata().getLength());
        subheader.copyObjectMetadataFrom(null);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(PktBuffer.create(null, 882, false).setLength(882));
        Assert.assertEquals((long)943L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)882L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(null);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        IOElasticBuffer objectMetadataSource = PktBuffer.create(null, 1082, false).setLength(1082);
        int offset = subheader.prepareForObjectMetadataCopy(objectMetadataSource.getLength());
        subheader.getObjectMetadata().putFrom(offset, objectMetadataSource, 0, 1082);
        Assert.assertEquals((long)1143L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, 248, false).setLength(248));
        Assert.assertEquals((long)1391L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)subheader.getPersisterMetadata().getLength());
        subheader.setObjectId(null);
        Assert.assertEquals((long)1391L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertNull((Object)subheader.getObjectId());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)subheader.getPersisterMetadata().getLength());
    }

    @Test
    public void testFieldPopulationWithSerialization() {
        int expectedFixedLength = 61;
        int minBufferSize = 256;
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create();
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertNull((Object)subheader.getObjectId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        PktSubheaderODS deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertNull((Object)deserialized.getObjectId());
        Assert.assertEquals((long)0L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)0L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        UUID id = new UUID();
        subheader.setObjectId(id);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)0L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)0L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)0L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setObjectFactoryId((short)324);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)0L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setObjectType((short)567);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)0L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)0L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setContentEncodingType((short)100);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        long timestamp = System.currentTimeMillis();
        subheader.setTimestamp(timestamp);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)0L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)0L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setTransactionId(200L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setStableTransactionId(300L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)0L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setCheckpointVersion(400L);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)0L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.setFlags((byte)96);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(PktBuffer.create(null, 82, false).setLength(82));
        Assert.assertEquals((long)143L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)143L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)82L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, 22, false).setLength(22));
        Assert.assertEquals((long)165L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)22L, (long)subheader.getPersisterMetadata().getLength());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)165L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)82L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertEquals((long)22L, (long)deserialized.getPersisterMetadata().getLength());
        int maxMetadataLengthWithoutResize = 195 - subheader.getObjectMetadata().getLength();
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, maxMetadataLengthWithoutResize, false).setLength(maxMetadataLengthWithoutResize));
        Assert.assertEquals((long)256L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)maxMetadataLengthWithoutResize, (long)subheader.getPersisterMetadata().getLength());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)256L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)82L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertEquals((long)maxMetadataLengthWithoutResize, (long)deserialized.getPersisterMetadata().getLength());
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, maxMetadataLengthWithoutResize + 1, false).setLength(maxMetadataLengthWithoutResize + 1));
        Assert.assertEquals((long)257L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)82L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)(maxMetadataLengthWithoutResize + 1), (long)subheader.getPersisterMetadata().getLength());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)257L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)82L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertEquals((long)(maxMetadataLengthWithoutResize + 1), (long)deserialized.getPersisterMetadata().getLength());
        subheader.copyObjectMetadataFrom(null);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(PktBuffer.create(null, 882, false).setLength(882));
        Assert.assertEquals((long)943L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)882L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)943L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)882L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.copyObjectMetadataFrom(null);
        Assert.assertEquals((long)61L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertNull((Object)((Object)subheader.getObjectMetadata()));
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)61L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertNull((Object)((Object)deserialized.getObjectMetadata()));
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        IOElasticBuffer objectMetadataSource = PktBuffer.create(null, 1082, false).setLength(1082);
        int offset = subheader.prepareForObjectMetadataCopy(objectMetadataSource.getLength());
        subheader.getObjectMetadata().putFrom(offset, objectMetadataSource, 0, 1082);
        Assert.assertEquals((long)1143L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)subheader.getPersisterMetadata()));
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)1143L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)1082L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
        subheader.copyPersisterMetadataFrom(PktBuffer.create(null, 248, false).setLength(248));
        Assert.assertEquals((long)1391L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)subheader.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)subheader.getPersisterMetadata().getLength());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)1391L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)1082L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)deserialized.getPersisterMetadata().getLength());
        subheader.setObjectId(null);
        Assert.assertEquals((long)1391L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)2L, (long)subheader.getSubheaderVersion());
        Assert.assertNull((Object)subheader.getObjectId());
        Assert.assertEquals((long)324L, (long)subheader.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)subheader.getObjectType());
        Assert.assertEquals((long)100L, (long)subheader.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)subheader.getTimestamp());
        Assert.assertEquals((long)200L, (long)subheader.getTransactionId());
        Assert.assertEquals((long)300L, (long)subheader.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)subheader.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)subheader.getFlags());
        Assert.assertEquals((long)1082L, (long)subheader.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)subheader.getPersisterMetadata().getLength());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)1391L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)2L, (long)deserialized.getSubheaderVersion());
        Assert.assertNull((Object)deserialized.getObjectId());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)1082L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertEquals((long)248L, (long)deserialized.getPersisterMetadata().getLength());
    }

    @Test
    public void testDeserializeV1Subheader() {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        int expectedFixedLength = 59;
        PktSubheaderODS subheader = (PktSubheaderODS)PktSubheaderODS.create((short)1);
        UUID id = new UUID();
        subheader.setObjectId(id);
        subheader.setObjectFactoryId((short)324);
        subheader.setObjectType((short)567);
        subheader.setContentEncodingType((short)100);
        long timestamp = System.currentTimeMillis();
        subheader.setTimestamp(timestamp);
        subheader.setCommitEntryType((short)1);
        subheader.setTransactionId(200L);
        subheader.setStableTransactionId(300L);
        subheader.setCheckpointVersion(400L);
        subheader.setFlags((byte)96);
        subheader.copyObjectMetadataFrom(PktBuffer.create(null, 82, false).setLength(82));
        PktSubheaderODS deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)141L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)1L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)id.toString(), (Object)deserialized.getObjectId().toString());
        Assert.assertEquals((long)324L, (long)deserialized.getObjectFactoryId());
        Assert.assertEquals((long)567L, (long)deserialized.getObjectType());
        Assert.assertEquals((long)100L, (long)deserialized.getContentEncodingType());
        Assert.assertEquals((long)timestamp, (long)deserialized.getTimestamp());
        Assert.assertEquals((long)1L, (long)deserialized.getCommitEntryType());
        Assert.assertEquals((long)200L, (long)deserialized.getTransactionId());
        Assert.assertEquals((long)300L, (long)deserialized.getStableTransactionId());
        Assert.assertEquals((long)400L, (long)deserialized.getCheckpointVersion());
        Assert.assertEquals((long)96L, (long)deserialized.getFlags());
        Assert.assertEquals((long)82L, (long)deserialized.getObjectMetadata().getLength());
        Assert.assertNull((Object)((Object)deserialized.getPersisterMetadata()));
    }
}

