/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.ci.XRuntime;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.link.ELnkDescriptorFormatException;
import com.neeve.link.ELnkEndpointClassInstantiateException;
import com.neeve.link.ELnkEndpointClassLoadException;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkInvalidLinkTypeException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkServerEndpoint;
import com.neeve.link.LnkLTPAuthority;
import com.neeve.link.LnkObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class LnkFactory
extends LnkObject {
    private final Map<String, LinkType> linkTypeTable = new HashMap<String, LinkType>();
    private static LnkFactory instance = new LnkFactory();

    private LnkFactory() {
        super(null);
        this.tracer.setLevel(XRuntime.getProps(), "nv.link.factory.trace");
        this.initLinkTypeInfo();
    }

    public static LnkFactory getInstance() {
        LnkLTPAuthority.getInstance();
        return instance;
    }

    private final void initLinkTypeInfo() {
        IConfigRepository repo = ConfigRepositoryFactory.getInstance().getLocalRepository();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/links");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                this.tracer.log("Loading config info for link type '" + entity.getName() + "'...", Tracer.Level.VERBOSE);
                String clientEndpointClassName = entity.getProperty("ClientEndpointClass", null);
                String serverEndpointClassName = entity.getProperty("ServerEndpointClass", null);
                if (clientEndpointClassName != null || serverEndpointClassName != null) {
                    String linkTypeName = entity.getName();
                    this.linkTypeTable.put(linkTypeName, new LinkType(linkTypeName, clientEndpointClassName, serverEndpointClassName));
                    this.tracer.log("...success", Tracer.Level.VERBOSE);
                    continue;
                }
                this.tracer.log("The link configuration entity '" + entity.getName() + "' needs to specify atleast the client endpoint or server endpoint class name. The link type represented by that entity will not be loaded.", Tracer.Level.WARNING);
            }
        } else {
            this.tracer.log("No link types configured.", Tracer.Level.VERBOSE);
        }
    }

    private Object createEndpoint(String linkEndpointClassName, UtlAddressDescriptor descriptor) throws ELnkInvalidLinkTypeException, ELnkEndpointClassLoadException, ELnkEndpointClassInstantiateException, ELnkException {
        Class<?> linkEndpointClass = null;
        try {
            linkEndpointClass = Class.forName(linkEndpointClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ELnkEndpointClassLoadException("Link endpoint class [" + linkEndpointClassName + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new ELnkEndpointClassLoadException("Link endpoint class [" + linkEndpointClassName + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method method = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("com.neeve.util.UtlAddressDescriptor")};
            method = linkEndpointClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load com.neeve.root.util.UtlAddressDescriptor during instantiation of link endpoint class [" + linkEndpointClassName + "]");
        }
        catch (SecurityException e) {
            throw new ELnkEndpointClassInstantiateException("Access to instantiation method in link endpoint class [" + linkEndpointClassName + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new ELnkEndpointClassInstantiateException("Instantiation method in link endpoint class [" + linkEndpointClassName + "] could not be found");
        }
        Object ret = null;
        try {
            Object[] parameters = new Object[]{descriptor};
            ret = method.invoke(null, parameters);
            if (ret == null) {
                throw new ELnkEndpointClassInstantiateException("Instantiation method in link endpoint class [" + linkEndpointClassName + "] returned a null object");
            }
        }
        catch (IllegalAccessException e) {
            throw new ELnkEndpointClassInstantiateException("Access to instantiation method in link endpoint class [" + linkEndpointClassName + "] is denied");
        }
        catch (InvocationTargetException e) {
            throw new ELnkEndpointClassInstantiateException(e.getCause());
        }
        return ret;
    }

    public final ILnkClientEndpoint createClientEndpoint(UtlAddressDescriptor descriptor) throws ELnkInvalidLinkTypeException, ELnkEndpointClassLoadException, ELnkEndpointClassInstantiateException, ELnkException {
        LinkType linkType;
        String linkEndpointClassName = null;
        if (descriptor.type != null && (linkType = this.linkTypeTable.get(descriptor.type)) != null) {
            linkEndpointClassName = linkType.clientEndpointClassName;
        }
        if (linkEndpointClassName != null) {
            try {
                return (ILnkClientEndpoint)this.createEndpoint(linkEndpointClassName, descriptor);
            }
            catch (ClassCastException e) {
                throw new ELnkEndpointClassInstantiateException("Class [" + linkEndpointClassName + "] is not a valid link endpoint class <Instantiated object is not of type ILnkClientEndpoint>");
            }
        }
        throw new ELnkInvalidLinkTypeException(descriptor.type);
    }

    public final ILnkClientEndpoint createClientEndpoint(String descriptorStr, HashMap<String, Object> props) throws ELnkDescriptorFormatException, ELnkInvalidLinkTypeException, ELnkEndpointClassLoadException, ELnkEndpointClassInstantiateException, ELnkException {
        UtlAddressDescriptor descriptor;
        if (descriptorStr == null) {
            throw new IllegalArgumentException();
        }
        try {
            descriptor = UtlAddressDescriptor.parse((String)descriptorStr, props);
        }
        catch (IllegalArgumentException e) {
            throw new ELnkDescriptorFormatException(descriptorStr);
        }
        return this.createClientEndpoint(descriptor);
    }

    public final ILnkServerEndpoint createServerEndpoint(UtlAddressDescriptor descriptor) throws ELnkInvalidLinkTypeException, ELnkEndpointClassLoadException, ELnkEndpointClassInstantiateException, ELnkException {
        LinkType linkType;
        String linkEndpointClassName = null;
        if (descriptor.type != null && (linkType = this.linkTypeTable.get(descriptor.type)) != null) {
            linkEndpointClassName = linkType.serverEndpointClassName;
        }
        if (linkEndpointClassName != null) {
            try {
                return (ILnkServerEndpoint)this.createEndpoint(linkEndpointClassName, descriptor);
            }
            catch (ClassCastException e) {
                throw new ELnkEndpointClassInstantiateException("Class [" + linkEndpointClassName + "] is not a valid link endpoint class <Instantiated object is not of type ILnkServerEndpoint>");
            }
        }
        throw new ELnkInvalidLinkTypeException(descriptor.type);
    }

    public final ILnkServerEndpoint createServerEndpoint(String descriptorStr, HashMap<String, Object> props) throws ELnkDescriptorFormatException, ELnkInvalidLinkTypeException, ELnkEndpointClassLoadException, ELnkEndpointClassInstantiateException, ELnkException {
        UtlAddressDescriptor descriptor;
        if (descriptorStr == null) {
            throw new IllegalArgumentException();
        }
        try {
            descriptor = UtlAddressDescriptor.parse((String)descriptorStr, props);
        }
        catch (IllegalArgumentException e) {
            throw new ELnkDescriptorFormatException(descriptorStr);
        }
        return this.createServerEndpoint(descriptor);
    }

    private final class LinkType {
        final String name;
        final String clientEndpointClassName;
        final String serverEndpointClassName;

        LinkType(String name, String clientEndpointClassName, String serverEndpointClassName) {
            this.name = name;
            this.clientEndpointClassName = clientEndpointClassName;
            this.serverEndpointClassName = serverEndpointClassName;
        }
    }
}

