/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import cern.colt.list.ObjectArrayList;
import com.neeve.emx.EEmxAlreadyScheduledException;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNotOwnerException;
import com.neeve.emx.EEmxNotScheduledException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwAcceptReadyEvent;
import com.neeve.emx.IEmxNwConnectReadyEvent;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.emx.test.unit.EmxAlarmEventTest;
import com.neeve.emx.test.unit.EmxNwAcceptReadyEventTest;
import com.neeve.emx.test.unit.EmxNwConnectReadyEventTest;
import com.neeve.emx.test.unit.EmxNwLnkClientEndpointTest;
import com.neeve.emx.test.unit.EmxNwLnkServerEndpointTest;
import com.neeve.emx.test.unit.EmxNwReadReadyEventTest;
import com.neeve.emx.test.unit.EmxNwWriteReadyEventTest;
import com.neeve.emx.test.unit.EmxUserEventTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public final class EmxDispatcherTest
extends UnitTest {
    private static Random random;

    @BeforeClass
    public static void init() {
        random = new Random((int)System.currentTimeMillis());
    }

    static void dispatch(IEmxDispatcher dispatcher, IEmxEvent[] events, EventHandler handler, int timeout) throws Exception {
        int count;
        if (handler != null && handler.events.size() != 0) {
            EmxDispatcherTest.testFailure((String)("Dispatched event list is non-empty [size=" + handler.events.size() + "] before events ready queue has been dispatched!"));
        }
        for (count = 0; dispatcher.getReadyEvCount() + dispatcher.getWaitEvCount() > 0 && (events == null || count < events.length); count += dispatcher.run(timeout)) {
            if (events != null && events.length != 0) continue;
        }
        if (events != null && count != events.length) {
            EmxDispatcherTest.testFailure((String)("Mismatch between number of events reported dispatched and expected to be dispatched [reported=" + count + " exp=" + events.length + "]"));
        }
        if (handler != null && count != handler.events.size()) {
            EmxDispatcherTest.testFailure((String)("Mismatch between number of events reported dispatched and actually dispatched [reported=" + count + " actual=" + handler.events.size() + "]"));
        }
        if (events != null && handler != null) {
            for (int i = 0; i < events.length; ++i) {
                if (events[i] == handler.events.get(i)) continue;
                EmxDispatcherTest.testFailure((String)("Mismatch between dispatched and expected event [exp=" + events[i] + " actual=" + handler.events.get(i) + "]"));
            }
        }
    }

    static void checkValues(IEmxDispatcher dispatcher, String name, Thread owner, IEmxDispatcher.Params params, Object attachment, int waitEvCount, int readyEvCount) {
        if (name != null && dispatcher.getName() != name) {
            EmxDispatcherTest.testFailure((String)("Dispatcher name mismatch [exp=" + name + " actual=" + dispatcher.getName() + "]"));
        }
        if (owner == null) {
            owner = Thread.currentThread();
        }
        if (dispatcher.getOwner() != owner) {
            EmxDispatcherTest.testFailure((String)("Dispatcher owner mismatch [exp=" + owner + " actual=" + dispatcher.getOwner() + "]"));
        }
        if (params == null) {
            params = IEmxDispatcher.Params.create();
        }
        if (!dispatcher.getParams().equals(params)) {
            EmxDispatcherTest.testFailure((String)("Dispatcher params mismatch [exp=" + params + " actual=" + dispatcher.getParams() + "]"));
        }
        if (dispatcher.getThreaded() != params.getThreaded()) {
            EmxDispatcherTest.testFailure((String)("Dispatcher threaded mismatch [exp=" + params.getThreaded() + " actual=" + dispatcher.getThreaded() + "]"));
        }
        if (dispatcher.getAttachment() != attachment) {
            EmxDispatcherTest.testFailure((String)("Dispatcher attachment mismatch [exp=" + attachment + " actual=" + dispatcher.getAttachment() + "]"));
        }
        if (dispatcher.getWaitEvCount() != waitEvCount) {
            EmxDispatcherTest.testFailure((String)("Dispatcher wait event count mismatch [exp=" + waitEvCount + " actual=" + dispatcher.getWaitEvCount() + "]"));
        }
        if (dispatcher.getReadyEvCount() != readyEvCount) {
            EmxDispatcherTest.testFailure((String)("Dispatcher ready event count mismatch [exp=" + readyEvCount + " actual=" + dispatcher.getReadyEvCount() + "]"));
        }
    }

    private IEmxNwAcceptReadyEvent getToAcceptWouldBlockState(IEmxNwLnkServerEndpoint sep) throws Exception {
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        if (sep.accept(waitCond) != null) {
            EmxDispatcherTest.testFailure((String)"Unable to get the server endpoint into a 'accept would block' state");
        }
        return (IEmxNwAcceptReadyEvent)waitCond.list().get(0);
    }

    private void triggerAcceptReady(IEmxNwLnkClientEndpoint cep) throws Exception {
        IEmxNwLnkPeerEndpoint pep;
        do {
            if ((pep = cep.connect(new EmxNwLnkOpWaitCond())) == null) continue;
            pep.close();
        } while (pep == null);
    }

    private IEmxNwConnectReadyEvent getToConnectWouldBlockState(IEmxNwLnkClientEndpoint cep) throws Exception {
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        long ts = System.currentTimeMillis();
        boolean done = false;
        while (System.currentTimeMillis() - ts < 1000L) {
            try {
                IEmxNwLnkPeerEndpoint pep = cep.connect(waitCond);
                if (pep != null) {
                    pep.close();
                    continue;
                }
                done = true;
                break;
            }
            catch (EEmxNwLnkOpFailedException eEmxNwLnkOpFailedException) {
            }
        }
        if (!done) {
            EmxDispatcherTest.testFailure((String)"Unable to get the client endpoint to a 'connect would block' state");
        }
        return (IEmxNwConnectReadyEvent)waitCond.list().get(0);
    }

    private IEmxNwReadReadyEvent getToReadWouldBlockState(IEmxNwLnkPeerEndpoint pep) throws Exception {
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        while (pep.read(ByteBuffer.allocate(8192), waitCond) != 0) {
            EmxDispatcherTest.testFailure((String)"Unable to get the peer endpoint into a 'read would block' state");
        }
        return (IEmxNwReadReadyEvent)waitCond.list().get(0);
    }

    private void triggerReadReady(IEmxNwLnkPeerEndpoint pep) throws Exception {
        this.getToWriteWouldBlockState(pep);
    }

    private IEmxNwWriteReadyEvent getToWriteWouldBlockState(IEmxNwLnkPeerEndpoint pep) throws Exception {
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocate(8192)};
        long ts = System.currentTimeMillis();
        boolean done = false;
        int wouldBlockCount = 0;
        while (System.currentTimeMillis() - ts < 15000L) {
            buffers[0].clear();
            if (pep.write(buffers, buffers.length, waitCond) != 0L) continue;
            if (++wouldBlockCount == 10) {
                done = true;
                break;
            }
            Thread.sleep(100L);
        }
        if (!done) {
            EmxDispatcherTest.testFailure((String)"Unable to get the client endpoint to a 'write would block' state");
        }
        return (IEmxNwWriteReadyEvent)waitCond.list().get(0);
    }

    private void triggerWriteReady(IEmxNwLnkPeerEndpoint pep) throws Exception {
        while (pep.read(ByteBuffer.allocate(8192), new EmxNwLnkOpWaitCond()) != 0) {
        }
    }

    private void scheduleUserEvent(final IEmxUserEvent event, final IEmxDispatcher dispatcher) throws Exception {
        if (random.nextBoolean()) {
            dispatcher.schedUserEv(event);
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    dispatcher.schedUserEv(event);
                }
            };
            thread.start();
            thread.join();
        }
    }

    private IEmxUserEvent scheduleUserEvent(EmxFactory.EmxImpl impl, IEmxDispatcher dispatcher, int priority, IEmxEventHandler handler) throws Exception {
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, handler);
        event.setPriority(priority);
        this.scheduleUserEvent(event, dispatcher);
        return event;
    }

    private void scheduleAlarmEvent(IEmxAlarmEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.schedAlarmEv(event);
    }

    private void unscheduleAlarmEvent(IEmxAlarmEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.unschedAlarmEv(event);
    }

    private IEmxAlarmEvent scheduleAlarmEvent(EmxFactory.EmxImpl impl, IEmxDispatcher dispatcher, int priority, IEmxEventHandler handler, int interval) throws Exception {
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, interval);
        event.setPriority(priority);
        this.scheduleAlarmEvent(event, dispatcher);
        return event;
    }

    private void scheduleNwAcceptReadyEvent(IEmxNwAcceptReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.schedNwAcceptReadyEv(event);
    }

    private void unscheduleNwAcceptReadyEvent(IEmxNwAcceptReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.unschedNwAcceptReadyEv(event);
    }

    private void scheduleNwConnectReadyEvent(IEmxNwConnectReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.schedNwConnectReadyEv(event);
    }

    private void unscheduleNwConnectReadyEvent(IEmxNwConnectReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.unschedNwConnectReadyEv(event);
    }

    private void scheduleNwReadReadyEvent(IEmxNwReadReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.schedNwReadReadyEv(event);
    }

    private void unscheduleNwReadReadyEvent(IEmxNwReadReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.unschedNwReadReadyEv(event);
    }

    private void scheduleNwWriteReadyEvent(IEmxNwWriteReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.schedNwWriteReadyEv(event);
    }

    private void unscheduleNwWriteReadyEvent(IEmxNwWriteReadyEvent event, IEmxDispatcher dispatcher) throws Exception {
        dispatcher.unschedNwWriteReadyEv(event);
    }

    private void testCreateAndElementsSet(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        EmxDispatcherTest.checkValues(dispatcher, null, Thread.currentThread(), null, null, 0, 0);
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, "newname", null);
        EmxDispatcherTest.checkValues(dispatcher1, "newname", Thread.currentThread(), null, null, 0, 0);
        final IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        final IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EmxDispatcherTest.checkValues(dispatcher2, null, Thread.currentThread(), params, null, 0, 0);
        final Object attachment = new Object();
        dispatcher2.setAttachment(attachment);
        EmxDispatcherTest.checkValues(dispatcher2, null, Thread.currentThread(), params, attachment, 0, 0);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher2.setOwner();
                EmxDispatcherTest.checkValues(dispatcher2, null, Thread.currentThread(), params, attachment, 0, 0);
            }
        };
        owner.start();
        owner.join();
    }

    private void testGetWaitEvCountByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.getWaitEvCount();
            EmxDispatcherTest.testFailure((String)"Allowed getWaitEvCount() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testGetReadyEvCountByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.getReadyEvCount();
            EmxDispatcherTest.testFailure((String)"Allowed getReadyEvCount() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testRunByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.run(0);
            EmxDispatcherTest.testFailure((String)"Allowed run() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testScheduleNullUserEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedUserEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null user event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testScheduleUserEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxUserEvent event = this.scheduleUserEvent(impl, dispatcher, 15, null);
        try {
            dispatcher.schedUserEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule the same user event twice with the same dispatcher!");
        }
        catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
            // empty catch block
        }
    }

    private void testScheduleUserEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxUserEvent event = this.scheduleUserEvent(impl, dispatcher1, 15, null);
        try {
            dispatcher2.schedUserEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule the same user event twice across dispatchers!");
        }
        catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
            // empty catch block
        }
    }

    private void testScheduleNullAlarmEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedAlarmEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null alarm event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testScheduleAlarmEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher, 15, null, 100);
        try {
            dispatcher.schedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule the same alarm event twice with the same dispatcher!");
        }
        catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
            // empty catch block
        }
    }

    private void testScheduleAlarmEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher1, 15, null, 100);
        try {
            dispatcher2.schedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule the same alarm event twice across dispatchers!");
        }
        catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
            // empty catch block
        }
    }

    private void testScheduleAlarmEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, null, 100);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.schedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed schedAlarmEv() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testUnscheduleNullAlarmEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.unschedAlarmEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a null alarm event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testUnscheduleAlarmEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher, 15, null, 100);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.unschedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed unschedAlarmEv() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testUnscheduleNonScheduledAlarmEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, null, 100);
        try {
            dispatcher.unschedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a non-scheduled alarm event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
            // empty catch block
        }
    }

    private void testUnscheduleAnotherDispatcherScheduledAlarmEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher1, 15, null, 100);
        try {
            dispatcher2.unschedAlarmEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule an alarm event scheduled with a different dispatcher!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
            // empty catch block
        }
    }

    private void testResetNullAlarmEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.resetAlarmEv(null, 0L);
            EmxDispatcherTest.testFailure((String)"Allowed to reset a null alarm event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testResetAlarmEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher, 15, null, 100);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.resetAlarmEv(event, 0L);
            EmxDispatcherTest.testFailure((String)"Allowed resetEv() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testResetNonScheduledAlarmEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, null, 100);
        try {
            dispatcher.resetAlarmEv(event, 0L);
            EmxDispatcherTest.testFailure((String)"Allowed to reset a non-scheduled alarm event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
            // empty catch block
        }
    }

    private void testResetAnotherDispatcherScheduledAlarmEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = this.scheduleAlarmEvent(impl, dispatcher1, 15, null, 100);
        try {
            dispatcher2.resetAlarmEv(event, 0L);
            EmxDispatcherTest.testFailure((String)"Allowed to reset an alarm event scheduled with a different dispatcher!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
            // empty catch block
        }
    }

    private void testScheduleNullNwAcceptReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedNwAcceptReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null network accept ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwAcceptReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            dispatcher.schedNwAcceptReadyEv(event);
            try {
                dispatcher.schedNwAcceptReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network accept ready event twice with the same dispatcher!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwAcceptReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            dispatcher1.schedNwAcceptReadyEv(event);
            try {
                dispatcher2.schedNwAcceptReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network accept ready event twice across dispatchers!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwAcceptReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.schedNwAcceptReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed schedNwAcceptReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
        }
    }

    private void testUnscheduleNullNwAcceptReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.unschedNwAcceptReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a null network accept ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwAcceptReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.unschedNwAcceptReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed unschedNwAcceptReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNonScheduledNwAcceptReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            dispatcher.unschedNwAcceptReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a non-scheduled network accept ready event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
        }
        finally {
            dispatcher.close(true);
            this.closeServerEndpoint(dispatcher, sep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleAnotherDispatcherScheduledNwAcceptReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            dispatcher1.schedNwAcceptReadyEv(event);
            try {
                dispatcher2.unschedNwAcceptReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to unschedule a network accept ready event scheduled with a different dispatcher!");
            }
            catch (EEmxNotScheduledException eEmxNotScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
        }
    }

    private void testScheduleNullNwConnectReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedNwConnectReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null network connect ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testScheduledNwAcceptReadyEvServerLinkClose(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            dispatcher.schedNwAcceptReadyEv(event);
            sep.close();
            sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        }
        finally {
            dispatcher.close(true);
            if (sep != null) {
                sep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwConnectReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            dispatcher.schedNwConnectReadyEv(event);
            try {
                dispatcher.schedNwConnectReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network connect ready event twice with the same dispatcher!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwConnectReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            dispatcher1.schedNwConnectReadyEv(event);
            try {
                dispatcher2.schedNwConnectReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network connect ready event twice across dispatchers!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwConnectReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.schedNwConnectReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed schedNwConnectReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            cep.close();
        }
    }

    private void testUnscheduleNullNwConnectReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.unschedNwConnectReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a null network connect ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNonScheduledNwConnectReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            dispatcher.unschedNwConnectReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a non-scheduled network connect ready event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
        }
        finally {
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleAnotherDispatcherScheduledNwConnectReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            dispatcher1.schedNwConnectReadyEv(event);
            try {
                dispatcher2.unschedNwConnectReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to unschedule a network connect ready event scheduled with a different dispatcher!");
            }
            catch (EEmxNotScheduledException eEmxNotScheduledException) {
                // empty catch block
            }
        }
        finally {
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwConnectReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.unschedNwConnectReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed unschedNwConnectReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            cep.close();
        }
    }

    private void testScheduleNullNwReadReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedNwReadReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null network read ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        try {
            dispatcher.schedNwReadReadyEv(event);
            try {
                dispatcher.schedNwReadReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network read ready event twice with the same dispatcher!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        try {
            dispatcher1.schedNwReadReadyEv(event);
            try {
                dispatcher2.schedNwReadReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network read ready event twice across dispatchers!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.schedNwReadReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed schedNwReadReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    private void testUnscheduleNullNwReadReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.unschedNwReadReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a null network read ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNonScheduledNwReadReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        try {
            dispatcher.unschedNwReadReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a non-scheduled network read ready event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleAnotherDispatcherScheduledNwReadReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        try {
            dispatcher1.schedNwReadReadyEv(event);
            try {
                dispatcher2.unschedNwReadReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to unschedule a network read ready event scheduled with a different dispatcher!");
            }
            catch (EEmxNotScheduledException eEmxNotScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwReadReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.unschedNwReadReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed unschedNwReadReadyEv() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    private void testScheduleNullNwWriteReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.schedNwWriteReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to schedule a null network write ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwWriteReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        try {
            dispatcher.schedNwWriteReadyEv(event);
            try {
                dispatcher.schedNwWriteReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network write ready event twice with the same dispatcher!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwWriteReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        try {
            dispatcher1.schedNwWriteReadyEv(event);
            try {
                dispatcher2.schedNwWriteReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to schedule the same network write ready event twice across dispatchers!");
            }
            catch (EEmxAlreadyScheduledException eEmxAlreadyScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwWriteReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        try {
            Thread owner = new Thread(){

                @Override
                public void run() {
                    dispatcher.setOwner();
                }
            };
            owner.start();
            owner.join();
            try {
                dispatcher.schedNwWriteReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed schedNwWriteReadyEv() to be executed by non-owner thread!");
            }
            catch (EEmxNotOwnerException eEmxNotOwnerException) {
                // empty catch block
            }
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    private void testUnscheduleNullNwWriteReadyEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        try {
            dispatcher.unschedNwWriteReadyEv(null);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a null network write ready event with the dispatcher!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNonScheduledNwWriteReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        try {
            dispatcher.unschedNwWriteReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed to unschedule a non-scheduled network write ready event!");
        }
        catch (EEmxNotScheduledException eEmxNotScheduledException) {
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleAnotherDispatcherScheduledNwWriteReadyEv(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        try {
            dispatcher1.schedNwWriteReadyEv(event);
            try {
                dispatcher2.unschedNwWriteReadyEv(event);
                EmxDispatcherTest.testFailure((String)"Allowed to unschedule a network write ready event scheduled with a different dispatcher!");
            }
            catch (EEmxNotScheduledException eEmxNotScheduledException) {
                // empty catch block
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwWriteReadyEvByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.unschedNwWriteReadyEv(event);
            EmxDispatcherTest.testFailure((String)"Allowed unschedNwWriteReadyEv() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep != null) {
                pep.close();
            }
        }
    }

    private void testFlushByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.flush();
            EmxDispatcherTest.testFailure((String)"Allowed flush() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testCloseByNonOwnerThread(EmxFactory.EmxImpl impl) throws Exception {
        final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        Thread owner = new Thread(){

            @Override
            public void run() {
                dispatcher.setOwner();
            }
        };
        owner.start();
        owner.join();
        try {
            dispatcher.close(true);
            EmxDispatcherTest.testFailure((String)"Allowed close() to be executed by non-owner thread!");
        }
        catch (EEmxNotOwnerException eEmxNotOwnerException) {
            // empty catch block
        }
    }

    private void testNoScheduledEventsRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        long ts = System.currentTimeMillis();
        int dispatched = dispatcher.run(0);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts > 10L) {
            EmxDispatcherTest.testFailure((String)("Run with zero scheduled events and zero timeout took more than 10ms [" + (ts1 - ts) + "]!"));
        }
        if (dispatched != 0) {
            EmxDispatcherTest.testFailure((String)("Run with zero scheduled events and zero timeout returned dispatched event count=" + dispatched));
        }
    }

    private void testNoScheduledEventsRunNonZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        long ts = System.currentTimeMillis();
        int dispatched = dispatcher.run(100);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts < 100L) {
            EmxDispatcherTest.testFailure((String)("Run with zero scheduled events and 100ms timeout took less than 100ms [" + (ts1 - ts) + "]!"));
        }
        if (dispatched != 0) {
            EmxDispatcherTest.testFailure((String)("Run with zero scheduled events and 100ms timeout returned dispatched event count=" + dispatched));
        }
    }

    private void testScheduleUserEventRunSpecifiedTimeout(EmxFactory.EmxImpl impl, int timeout) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, null);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, null, null);
        long ts = System.currentTimeMillis();
        this.scheduleUserEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, null, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, null, timeout);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts > 10L) {
            EmxDispatcherTest.testFailure((String)("Run with one user event took more than 10ms [" + (ts1 - ts) + "]!"));
        }
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, null, null);
    }

    private void testScheduleUserEventRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleUserEventRunSpecifiedTimeout(impl, 0);
    }

    private void testScheduleUserEventRunNonZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleUserEventRunSpecifiedTimeout(impl, 1000);
    }

    private void testRescheduleUserEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(true);
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, handler);
        this.scheduleUserEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher);
        handler.reset();
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null);
    }

    private void testUserEventHandlerThrowsException(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(false, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(new RuntimeException("forced exception"));
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, handler);
        this.scheduleUserEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null);
    }

    private void testUserEventHandlerThrowsError(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(false, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(new Error("forced error"));
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, handler);
        this.scheduleUserEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null);
    }

    private void testScheduleMultiplePriorityUserEventsRunSpecifiedTimeout(EmxFactory.EmxImpl impl, int timeout) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        IEmxEvent[] events = new IEmxUserEvent[32];
        EventHandler handler = new EventHandler();
        int remaining = 32;
        long ts = System.currentTimeMillis();
        while (true) {
            int prio;
            if (events[31 - (prio = random.nextInt(32))] != null) {
                continue;
            }
            events[31 - prio] = this.scheduleUserEvent(impl, dispatcher, prio, handler);
            if (--remaining == 0) break;
        }
        EmxDispatcherTest.dispatch(dispatcher, events, handler, timeout);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts > 10L) {
            EmxDispatcherTest.testFailure((String)("Run with multiple priority user events took more than 10ms [" + (ts1 - ts) + "]!"));
        }
    }

    private void testScheduleMultiplePriorityUserEventsRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleMultiplePriorityUserEventsRunSpecifiedTimeout(impl, 0);
    }

    private void testScheduleMultiplePriorityUserEventsRunNonZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleMultiplePriorityUserEventsRunSpecifiedTimeout(impl, 1000);
    }

    private void testScheduleAlarmEventRunSpecifiedTimeout(EmxFactory.EmxImpl impl, int interval, int timeout) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, null, interval);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, null, null, interval);
        long ts = System.currentTimeMillis();
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, null, dispatcher, interval);
        EmxDispatcherTest.dispatch(dispatcher, null, null, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, null, dispatcher, interval);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, null, timeout);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts < (long)interval) {
            EmxDispatcherTest.testFailure((String)("Run with " + interval + "ms alarm event and " + timeout + "ms run timeout took less than " + interval + "ms [" + (ts1 - ts) + "]!"));
        }
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, null, null, interval);
    }

    private void testScheduleAlarmEventRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleAlarmEventRunSpecifiedTimeout(impl, 100, 0);
    }

    private void testScheduleAlarmEventRunLessThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 10; i < 100; i += 10) {
            this.testScheduleAlarmEventRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testScheduleAlarmEventRunMoreThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 100; i < 200; i += 10) {
            this.testScheduleAlarmEventRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testRescheduleAlarmEvent(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, false);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(true);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, 100);
        long ts = System.currentTimeMillis();
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts < 100L) {
            EmxDispatcherTest.testFailure((String)("Run with 100ms alarm event and 100ms run timeout took less than 100ms [" + (ts1 - ts) + "]!"));
        }
        if (ts1 - ts > 110L) {
            EmxDispatcherTest.testFailure((String)("Run with 100ms alarm event and 100ms run timeout took more than than 110ms [" + (ts1 - ts) + "]!"));
        }
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        handler.reset();
        ts = System.currentTimeMillis();
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        ts1 = System.currentTimeMillis();
        if (ts1 - ts < 100L) {
            EmxDispatcherTest.testFailure((String)("Run with 100ms alarm event and 100ms run timeout took less than 100ms [" + (ts1 - ts) + "]!"));
        }
        if (ts1 - ts > 110L) {
            EmxDispatcherTest.testFailure((String)("Run with 100ms alarm event and 100ms run timeout took more than than 110ms [" + (ts1 - ts) + "]!"));
        }
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 100);
    }

    private void testAlarmEventHandlerThrowsException(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(false, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(new RuntimeException("forced exception"));
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, 100);
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 100);
    }

    private void testAlarmEventHandlerThrowsError(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(false, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(new Error("forced error"));
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, 100);
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, handler, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 100);
    }

    private void testScheduleMultiplePriorityAlarmEventsRunSpecifiedTimeout(EmxFactory.EmxImpl impl, int interval, int timeout) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        IEmxEvent[] events = new IEmxAlarmEvent[32];
        EventHandler handler = new EventHandler();
        long ts = System.currentTimeMillis();
        int remaining = 32;
        while (true) {
            int prio;
            if (events[31 - (prio = random.nextInt(32))] != null) {
                continue;
            }
            events[31 - prio] = this.scheduleAlarmEvent(impl, dispatcher, prio, handler, interval);
            dispatcher.resetAlarmEv(events[31 - prio], ts);
            if (--remaining == 0) break;
        }
        EmxDispatcherTest.dispatch(dispatcher, events, handler, timeout);
        long ts1 = System.currentTimeMillis();
        if (ts1 - ts < (long)interval) {
            EmxDispatcherTest.testFailure((String)("Run with multiple priority alarm events with" + interval + "ms interval and " + timeout + "ms run timeout took less than " + interval + "ms [" + (ts1 - ts) + "]!"));
        }
    }

    private void testScheduleMultiplePriorityAlarmEventsRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleMultiplePriorityAlarmEventsRunSpecifiedTimeout(impl, 100, 0);
    }

    private void testScheduleMultiplePriorityAlarmEventsRunLessThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 10; i < 100; i += 10) {
            this.testScheduleMultiplePriorityAlarmEventsRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testScheduleMultiplePriorityAlarmEventsRunMoreThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 100; i < 200; i += 10) {
            this.testScheduleMultiplePriorityAlarmEventsRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testScheduleMultipleIntervalAlarmEventsRunSpecifiedTimeout(EmxFactory.EmxImpl impl, int interval, int timeout) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, true);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        IEmxEvent[] events = new IEmxAlarmEvent[3];
        EventHandler handler = new EventHandler();
        events[1] = this.scheduleAlarmEvent(impl, dispatcher, 15, handler, interval);
        events[2] = this.scheduleAlarmEvent(impl, dispatcher, 15, handler, interval * 2);
        events[0] = this.scheduleAlarmEvent(impl, dispatcher, 15, handler, interval / 2);
        EmxDispatcherTest.dispatch(dispatcher, events, handler, timeout);
    }

    private void testScheduleMultipleIntervalAlarmEventsRunZeroTimeout(EmxFactory.EmxImpl impl) throws Exception {
        this.testScheduleMultipleIntervalAlarmEventsRunSpecifiedTimeout(impl, 100, 0);
    }

    private void testScheduleMultipleIntervalAlarmEventsRunLessThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 10; i < 100; i += 10) {
            this.testScheduleMultipleIntervalAlarmEventsRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testScheduleMultipleIntervalAlarmEventsRunMoreThanIntervalTimeout(EmxFactory.EmxImpl impl) throws Exception {
        for (int i = 100; i < 200; i += 10) {
            this.testScheduleMultipleIntervalAlarmEventsRunSpecifiedTimeout(impl, 100, i);
        }
    }

    private void testUnscheduleAlarmEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, false);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(false);
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, 100);
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        this.unscheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 100);
        this.scheduleAlarmEvent(event, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(event, 15, handler, dispatcher, 100);
        IEmxEvent[] events = new IEmxEvent[]{event};
        EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 100);
    }

    private void testUnscheduleAlarmEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher.Params params = IEmxDispatcher.Params.create(true, false);
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, params);
        EventHandler handler = new EventHandler(false);
        IEmxAlarmEvent aevent = EmxFactory.getInstance().createAlarmEvent(impl, handler, 100);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        this.scheduleAlarmEvent(aevent, dispatcher);
        this.scheduleUserEvent(uevent1, dispatcher);
        this.scheduleUserEvent(uevent2, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 2);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler, dispatcher, 100);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
        Thread.sleep(1000L);
        IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
        EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 1);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler, dispatcher, 100);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
        EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, null);
        this.unscheduleAlarmEvent(aevent, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler, null, 100);
        this.scheduleAlarmEvent(aevent, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 1, 0);
        EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler, dispatcher, 100);
        events = new IEmxEvent[]{aevent};
        EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
        EmxDispatcherTest.checkValues(dispatcher, null, null, params, null, 0, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler, null, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwAcceptReadyEventTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        try {
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
            this.scheduleNwAcceptReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            EmxDispatcherTest.dispatch(dispatcher, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            this.triggerAcceptReady(cep);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 1000);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (cep != null) {
                cep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwAcceptReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        EventHandler handler = new EventHandler(false);
        IEmxNwAcceptReadyEvent event = this.getToAcceptWouldBlockState(sep);
        event.setHandler(handler);
        try {
            this.scheduleNwAcceptReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.unscheduleNwAcceptReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
            this.scheduleNwAcceptReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.triggerAcceptReady(cep);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (cep != null) {
                cep.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwAcceptReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        EventHandler handler = new EventHandler(false);
        IEmxNwAcceptReadyEvent nwevent = this.getToAcceptWouldBlockState(sep);
        nwevent.setHandler(handler);
        nwevent.setCritical(true);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        try {
            this.scheduleNwAcceptReadyEvent(nwevent, dispatcher);
            this.scheduleUserEvent(uevent1, dispatcher);
            this.scheduleUserEvent(uevent2, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 2);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
            this.triggerAcceptReady(cep);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 1);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, null);
            this.unscheduleNwAcceptReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
            this.scheduleNwAcceptReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            events = new IEmxEvent[]{nwevent};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
        }
        finally {
            dispatcher.close(true);
            this.closeServerEndpoint(dispatcher, sep);
            if (cep != null) {
                cep.close();
            }
        }
    }

    private final void closeServerEndpoint(IEmxDispatcher dispatcher, IEmxNwLnkServerEndpoint sep) throws EEmxNotOwnerException, EEmxException {
        dispatcher.setOwner();
        dispatcher.close(true);
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        IEmxNwLnkPeerEndpoint cep = null;
        while ((cep = sep.accept(waitCond)) != null) {
            cep.close();
        }
        sep.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwConnectReadyEventTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        try {
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
            this.scheduleNwConnectReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwConnectReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        EventHandler handler = new EventHandler(false);
        IEmxNwConnectReadyEvent event = this.getToConnectWouldBlockState(cep);
        event.setHandler(handler);
        try {
            this.scheduleNwConnectReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.unscheduleNwConnectReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
            this.scheduleNwConnectReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwConnectReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        EventHandler handler = new EventHandler(false);
        IEmxNwConnectReadyEvent nwevent = this.getToConnectWouldBlockState(cep);
        nwevent.setHandler(handler);
        nwevent.setCritical(true);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        try {
            this.scheduleNwConnectReadyEvent(nwevent, dispatcher);
            this.scheduleUserEvent(uevent1, dispatcher);
            this.scheduleUserEvent(uevent2, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 2);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
            IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 1);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, null);
            this.unscheduleNwConnectReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
            this.scheduleNwConnectReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            events = new IEmxEvent[]{nwevent};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            cep.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadReadyEventTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep1);
        try {
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
            this.scheduleNwReadReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            EmxDispatcherTest.dispatch(dispatcher, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            this.triggerReadReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwReadReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler = new EventHandler(false);
        IEmxNwReadReadyEvent event = this.getToReadWouldBlockState(pep1);
        event.setHandler(handler);
        try {
            this.scheduleNwReadReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.unscheduleNwReadReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
            this.scheduleNwReadReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.triggerReadReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwReadReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler = new EventHandler(false);
        IEmxNwReadReadyEvent nwevent = this.getToReadWouldBlockState(pep1);
        nwevent.setHandler(handler);
        nwevent.setCritical(true);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        try {
            this.scheduleNwReadReadyEvent(nwevent, dispatcher);
            this.scheduleUserEvent(uevent1, dispatcher);
            this.scheduleUserEvent(uevent2, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 2);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
            this.triggerReadReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 1);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, null);
            this.unscheduleNwReadReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
            this.scheduleNwReadReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            events = new IEmxEvent[]{nwevent};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwWriteReadyEventTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep1);
        try {
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
            this.scheduleNwWriteReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            EmxDispatcherTest.dispatch(dispatcher, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, dispatcher, false);
            this.triggerWriteReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, null, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwWriteReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler = new EventHandler(false);
        IEmxNwWriteReadyEvent event = this.getToWriteWouldBlockState(pep1);
        event.setHandler(handler);
        try {
            this.scheduleNwWriteReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.unscheduleNwWriteReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
            this.scheduleNwWriteReadyEvent(event, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, dispatcher, false);
            this.triggerWriteReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{event};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, event, 15, handler, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleNwWriteReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler = new EventHandler(false);
        IEmxNwWriteReadyEvent nwevent = this.getToWriteWouldBlockState(pep1);
        nwevent.setHandler(handler);
        nwevent.setCritical(true);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        try {
            this.scheduleNwWriteReadyEvent(nwevent, dispatcher);
            this.scheduleUserEvent(uevent1, dispatcher);
            this.scheduleUserEvent(uevent2, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 2);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
            this.triggerWriteReady(pep2);
            cep = null;
            IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 1);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, null);
            this.unscheduleNwWriteReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
            this.scheduleNwWriteReadyEvent(nwevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 1, 0);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, dispatcher, true);
            events = new IEmxEvent[]{nwevent};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, nwevent, 15, handler, null, true);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadWriteReadyEventSameDispatcherTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler = new EventHandler();
        IEmxNwReadReadyEvent revent1 = this.getToReadWouldBlockState(pep1);
        IEmxNwWriteReadyEvent wevent1 = this.getToWriteWouldBlockState(pep1);
        revent1.setHandler(handler);
        wevent1.setHandler(handler);
        try {
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler, null, false);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler, null, false);
            this.scheduleNwReadReadyEvent(revent1, dispatcher);
            this.scheduleNwWriteReadyEvent(wevent1, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 2, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler, dispatcher, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler, dispatcher, false);
            EmxDispatcherTest.dispatch(dispatcher, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 2, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler, dispatcher, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler, dispatcher, false);
            cep = null;
            handler.retval = true;
            this.triggerReadReady(pep2);
            IEmxEvent[] events = new IEmxEvent[]{revent1};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 2, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler, dispatcher, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler, dispatcher, false);
            handler.reset();
            this.triggerWriteReady(pep2);
            events = new IEmxEvent[]{revent1, wevent1};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler, null, false);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler, null, false);
        }
        finally {
            this.closeServerEndpoint(dispatcher, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadWriteReadyEventDiffDispatcherSameOwnerTriggerAndRun(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler1 = new EventHandler();
        EventHandler handler2 = new EventHandler();
        IEmxNwReadReadyEvent revent1 = this.getToReadWouldBlockState(pep1);
        IEmxNwWriteReadyEvent wevent1 = this.getToWriteWouldBlockState(pep1);
        revent1.setHandler(handler1);
        wevent1.setHandler(handler2);
        try {
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 0, 0);
            EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, null, false);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, null, false);
            this.scheduleNwReadReadyEvent(revent1, dispatcher1);
            this.scheduleNwWriteReadyEvent(wevent1, dispatcher2);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, dispatcher2, false);
            EmxDispatcherTest.dispatch(dispatcher1, null, null, 100);
            EmxDispatcherTest.dispatch(dispatcher2, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, dispatcher2, false);
            cep = null;
            handler1.retval = true;
            this.triggerReadReady(pep2);
            IEmxEvent[] events = new IEmxEvent[]{revent1};
            EmxDispatcherTest.dispatch(dispatcher1, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, dispatcher2, false);
            handler2.reset();
            this.triggerWriteReady(pep2);
            events = new IEmxEvent[]{wevent1};
            EmxDispatcherTest.dispatch(dispatcher2, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 0, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, null, false);
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScheduleNwReadWriteReadyEventDiffDispatcherDiffOwnerTriggerAndRun(final EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher1 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        final IEmxDispatcher dispatcher2 = EmxFactory.getInstance().createDispatcher(impl, null, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep, new EmxNwLnkOpWaitCond());
        EventHandler handler1 = new EventHandler();
        final EventHandler handler2 = new EventHandler();
        IEmxNwReadReadyEvent revent1 = this.getToReadWouldBlockState(pep1);
        final IEmxNwWriteReadyEvent wevent1 = this.getToWriteWouldBlockState(pep1);
        revent1.setHandler(handler1);
        wevent1.setHandler(handler2);
        try {
            Thread writer = new Thread(){

                @Override
                public final void run() {
                    try {
                        dispatcher2.setOwner();
                        EmxDispatcherTest.this.scheduleNwWriteReadyEvent(wevent1, dispatcher2);
                        EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 1, 0);
                        EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, dispatcher2, false);
                        EmxDispatcherTest.dispatch(dispatcher2, null, null, 100);
                        EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 1, 0);
                        EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, dispatcher2, false);
                        IEmxEvent[] events = new IEmxEvent[]{wevent1};
                        EmxDispatcherTest.dispatch(dispatcher2, events, null, -1);
                        EmxDispatcherTest.checkValues(dispatcher2, null, null, null, null, 0, 0);
                        EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wevent1, 15, handler2, null, false);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            WriterUncaughtExceptionHandler uncaughtExceptionHandler = new WriterUncaughtExceptionHandler();
            writer.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            writer.start();
            this.scheduleNwReadReadyEvent(revent1, dispatcher1);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            EmxDispatcherTest.dispatch(dispatcher1, null, null, 100);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            cep = null;
            handler1.retval = true;
            this.triggerReadReady(pep2);
            IEmxEvent[] events = new IEmxEvent[]{revent1};
            EmxDispatcherTest.dispatch(dispatcher1, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher1, null, null, null, null, 1, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, revent1, 15, handler1, dispatcher1, false);
            handler2.reset();
            this.triggerWriteReady(pep2);
            writer.join();
            if (uncaughtExceptionHandler.status != null) {
                EmxDispatcherTest.testFailure((String)("Writer thread encountered failure [" + uncaughtExceptionHandler.status + "]"));
            }
        }
        finally {
            dispatcher2.setOwner();
            dispatcher2.close(true);
            this.closeServerEndpoint(dispatcher1, sep);
            if (pep1 != null) {
                pep1.close();
            }
            if (pep2 != null) {
                pep2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnscheduleEventsFromDispatchQueue(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        EventHandler handler = new EventHandler(false);
        UnscheduleEventHandler handler1 = new UnscheduleEventHandler();
        IEmxNwLnkClientEndpoint cep1 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkServerEndpoint sep1 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4400", null);
        IEmxNwLnkClientEndpoint cep2 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4401", null);
        IEmxNwLnkServerEndpoint sep2 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4401", null);
        IEmxNwLnkClientEndpoint cep3 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, "tcp://localhost:4402", null);
        IEmxNwLnkServerEndpoint sep3 = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, "tcp://localhost:4402", null);
        IEmxNwLnkPeerEndpoint pep1 = EmxNwLnkClientEndpointTest.connect(cep3, new EmxNwLnkOpWaitCond());
        IEmxNwLnkPeerEndpoint pep2 = EmxNwLnkServerEndpointTest.accept(sep3, new EmxNwLnkOpWaitCond());
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxAlarmEvent aevent = EmxFactory.getInstance().createAlarmEvent(impl, handler1, 0);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler1);
        IEmxNwAcceptReadyEvent arevent = this.getToAcceptWouldBlockState(sep1);
        IEmxNwConnectReadyEvent crevent = this.getToConnectWouldBlockState(cep2);
        IEmxNwReadReadyEvent rrevent = this.getToReadWouldBlockState(pep1);
        IEmxNwWriteReadyEvent wrevent = this.getToWriteWouldBlockState(pep1);
        arevent.setHandler(handler1);
        crevent.setHandler(handler1);
        rrevent.setHandler(handler1);
        wrevent.setHandler(handler1);
        arevent.setCritical(true);
        crevent.setCritical(true);
        rrevent.setCritical(true);
        wrevent.setCritical(true);
        IEmxEvent[] unscheduleEvents = new IEmxEvent[]{arevent, crevent, rrevent, wrevent, aevent};
        handler1.events = unscheduleEvents;
        try {
            this.scheduleUserEvent(uevent1, dispatcher);
            this.scheduleUserEvent(uevent2, dispatcher);
            this.scheduleAlarmEvent(aevent, dispatcher);
            this.scheduleNwReadReadyEvent(rrevent, dispatcher);
            this.scheduleNwWriteReadyEvent(wrevent, dispatcher);
            this.scheduleNwAcceptReadyEvent(arevent, dispatcher);
            this.scheduleNwConnectReadyEvent(crevent, dispatcher);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 5, 2);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
            EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 15, handler1, dispatcher);
            EmxAlarmEventTest.scheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler1, dispatcher, 0);
            EmxNwReadReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, rrevent, 15, handler1, dispatcher, true);
            EmxNwWriteReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, wrevent, 15, handler1, dispatcher, true);
            EmxNwAcceptReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, arevent, 15, handler1, dispatcher, true);
            EmxNwConnectReadyEventTest.scheduledEventCheckValuesAndTestElementsSet(impl, crevent, 15, handler1, dispatcher, true);
            Thread.sleep(100L);
            this.triggerAcceptReady(cep1);
            this.triggerReadReady(pep2);
            this.triggerWriteReady(pep2);
            IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2};
            EmxDispatcherTest.dispatch(dispatcher, events, null, 0);
            EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, null);
            EmxUserEventTest.unscheduledEventCheckValuesAndTestElementsSet(uevent2, 15, handler1, null);
            EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(aevent, 15, handler1, null, 0);
            EmxNwReadReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, rrevent, 15, handler1, null, true);
            EmxNwWriteReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, wrevent, 15, handler1, null, true);
            EmxNwAcceptReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, arevent, 15, handler1, null, true);
            EmxNwConnectReadyEventTest.unscheduledEventCheckValuesAndTestElementsSet(impl, crevent, 15, handler1, null, true);
        }
        finally {
            dispatcher.close(true);
            sep1.close();
            cep2.close();
            sep2.close();
            sep3.close();
            pep1.close();
            pep2.close();
        }
    }

    private void testFlushDispatchesReadyEvents(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        EventHandler handler = new EventHandler(false);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        IEmxUserEvent uevent3 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent3.setPriority(29);
        this.scheduleUserEvent(uevent1, dispatcher);
        this.scheduleUserEvent(uevent2, dispatcher);
        this.scheduleUserEvent(uevent3, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 3);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent3, 29, handler, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2, uevent3};
        dispatcher.flush();
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
        for (int i = 0; i < events.length; ++i) {
            if (events[i] == handler.events.get(i)) continue;
            EmxDispatcherTest.testFailure((String)("Mismatch between dispatched and expected event [exp=" + events[i] + " actual=" + handler.events.get(i) + "]"));
        }
    }

    private void testCloseDispatchesReadyEvents(EmxFactory.EmxImpl impl) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        EventHandler handler = new EventHandler(false);
        IEmxUserEvent uevent1 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent1.setPriority(31);
        IEmxUserEvent uevent2 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent2.setPriority(30);
        IEmxUserEvent uevent3 = EmxFactory.getInstance().createUserEvent(impl, handler);
        uevent3.setPriority(29);
        this.scheduleUserEvent(uevent1, dispatcher);
        this.scheduleUserEvent(uevent2, dispatcher);
        this.scheduleUserEvent(uevent3, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 3);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent3, 29, handler, dispatcher);
        IEmxEvent[] events = new IEmxEvent[]{uevent1, uevent2, uevent3};
        dispatcher.close(true);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 0);
        for (int i = 0; i < events.length; ++i) {
            if (events[i] == handler.events.get(i)) continue;
            EmxDispatcherTest.testFailure((String)("Mismatch between dispatched and expected event [exp=" + events[i] + " actual=" + handler.events.get(i) + "]"));
        }
        dispatcher = EmxFactory.getInstance().createDispatcher(impl, null, null);
        this.scheduleUserEvent(uevent1, dispatcher);
        this.scheduleUserEvent(uevent2, dispatcher);
        this.scheduleUserEvent(uevent3, dispatcher);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 3);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent1, 31, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent2, 30, handler, dispatcher);
        EmxUserEventTest.scheduledEventCheckValuesAndTestElementsSet(uevent3, 29, handler, dispatcher);
        handler.reset();
        dispatcher.close(false);
        EmxDispatcherTest.checkValues(dispatcher, null, null, null, null, 0, 3);
        if (handler.events.size() > 0) {
            EmxDispatcherTest.testFailure((String)"Close dispatched events when flush was not requested!");
        }
    }

    @Test
    public void testCreateAndElementsSetNIOImpl() {
        try {
            this.testCreateAndElementsSet(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testGetWaitEvCountByNonOwnerThreadNIOImpl() {
        try {
            this.testGetWaitEvCountByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testGetReadyEvCountByNonOwnerThreadNIOImpl() {
        try {
            this.testGetReadyEvCountByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testRunByNonOwnerThreadNIOImpl() {
        try {
            this.testRunByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullUserEventNIOImpl() {
        try {
            this.testScheduleNullUserEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleUserEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleUserEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleUserEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleUserEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullAlarmEventNIOImpl() {
        try {
            this.testScheduleNullAlarmEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleAlarmEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleAlarmEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEvByNonOwnerThreadNIOImpl() {
        try {
            this.testScheduleAlarmEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNullAlarmEventNIOImpl() {
        try {
            this.testUnscheduleNullAlarmEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAlarmEvByNonOwnerThreadNIOImpl() {
        try {
            this.testUnscheduleAlarmEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNonScheduledAlarmEvNIOImpl() {
        try {
            this.testUnscheduleNonScheduledAlarmEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAnotherDispatcherScheduledAlarmEvNIOImpl() {
        try {
            this.testUnscheduleAnotherDispatcherScheduledAlarmEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testResetNullAlarmEventNIOImpl() {
        try {
            this.testResetNullAlarmEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testResetAlarmEvByNonOwnerThreadNIOImpl() {
        try {
            this.testResetAlarmEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testResetNonScheduledAlarmEvNIOImpl() {
        try {
            this.testResetNonScheduledAlarmEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testResetAnotherDispatcherScheduledAlarmEvNIOImpl() {
        try {
            this.testResetAnotherDispatcherScheduledAlarmEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullNwAcceptReadyEventNIOImpl() {
        try {
            this.testScheduleNullNwAcceptReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwAcceptReadyEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleNwAcceptReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwAcceptReadyEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleNwAcceptReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwAcceptReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testScheduleNwAcceptReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNullNwAcceptReadyEventNIOImpl() {
        try {
            this.testUnscheduleNullNwAcceptReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwAcceptReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testUnscheduleNwAcceptReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNonScheduledNwAcceptReadyEvNIOImpl() {
        try {
            this.testUnscheduleNonScheduledNwAcceptReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAnotherDispatcherScheduledNwAcceptReadyEvNIOImpl() {
        try {
            this.testUnscheduleAnotherDispatcherScheduledNwAcceptReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullNwConnectReadyEventNIOImpl() {
        try {
            this.testScheduleNullNwConnectReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public final void testScheduledNwAcceptReadyEvServerLinkCloseNIO() throws Exception {
        try {
            this.testScheduledNwAcceptReadyEvServerLinkClose(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwConnectReadyEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleNwConnectReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwConnectReadyEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleNwConnectReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwConnectReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testScheduleNwConnectReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNullNwConnectReadyEventNIOImpl() {
        try {
            this.testUnscheduleNullNwConnectReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwConnectReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testUnscheduleNwConnectReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNonScheduledNwConnectReadyEvNIOImpl() {
        try {
            this.testUnscheduleNonScheduledNwConnectReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAnotherDispatcherScheduledNwConnectReadyEvNIOImpl() {
        try {
            this.testUnscheduleAnotherDispatcherScheduledNwConnectReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullNwReadReadyEventNIOImpl() {
        try {
            this.testScheduleNullNwReadReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadReadyEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleNwReadReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadReadyEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleNwReadReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testScheduleNwReadReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNullNwReadReadyEventNIOImpl() {
        try {
            this.testUnscheduleNullNwReadReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwReadReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testUnscheduleNwReadReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNonScheduledNwReadReadyEvNIOImpl() {
        try {
            this.testUnscheduleNonScheduledNwReadReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAnotherDispatcherScheduledNwReadReadyEvNIOImpl() {
        try {
            this.testUnscheduleAnotherDispatcherScheduledNwReadReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNullNwWriteReadyEventNIOImpl() {
        try {
            this.testScheduleNullNwWriteReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwWriteReadyEventTwiceSameDispatcherNIOImpl() {
        try {
            this.testScheduleNwWriteReadyEventTwiceSameDispatcher(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwWriteReadyEventTwiceAcrossDispatchersNIOImpl() {
        try {
            this.testScheduleNwWriteReadyEventTwiceAcrossDispatchers(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwWriteReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testScheduleNwWriteReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNullNwWriteReadyEventNIOImpl() {
        try {
            this.testUnscheduleNullNwWriteReadyEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwWriteReadyEvByNonOwnerThreadNIOImpl() {
        try {
            this.testUnscheduleNwWriteReadyEvByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseByNonOwnerThreadNIOImpl() {
        try {
            this.testCloseByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testFlushByNonOwnerThreadNIOImpl() {
        try {
            this.testFlushByNonOwnerThread(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNonScheduledNwWriteReadyEvNIOImpl() {
        try {
            this.testUnscheduleNonScheduledNwWriteReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAnotherDispatcherScheduledNwWriteReadyEvNIOImpl() {
        try {
            this.testUnscheduleAnotherDispatcherScheduledNwWriteReadyEv(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testNoScheduledEventsRunZeroTimeoutNIOImpl() {
        try {
            this.testNoScheduledEventsRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testNoScheduledEventsRunNonZeroTimeoutNIOImpl() {
        try {
            this.testNoScheduledEventsRunNonZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleUserEventRunZeroTimeoutNIOImpl() {
        try {
            this.testScheduleUserEventRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleUserEventRunNonZeroTimeoutNIOImpl() {
        try {
            this.testScheduleUserEventRunNonZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testRescheduleUserEventNIOImpl() {
        try {
            this.testRescheduleUserEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUserEventHandlerThrowsExceptionNIOImpl() {
        try {
            this.testUserEventHandlerThrowsException(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testUserEventHandlerThrowsErrorNIOImpl() {
        try {
            this.testUserEventHandlerThrowsError(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultiplePriorityUserEventsRunZeroTimeoutNIOImpl() {
        try {
            this.testScheduleMultiplePriorityUserEventsRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultiplePriorityUserEventsRunNonZeroTimeoutNIOImpl() {
        try {
            this.testScheduleMultiplePriorityUserEventsRunNonZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEventRunZeroTimeoutNIOImpl() {
        try {
            this.testScheduleAlarmEventRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEventRunLessThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleAlarmEventRunLessThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleAlarmEventRunMoreThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleAlarmEventRunMoreThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testRescheduleAlarmEventNIOImpl() {
        try {
            this.testRescheduleAlarmEvent(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testAlarmEventHandlerThrowsExceptionNIOImpl() {
        try {
            this.testAlarmEventHandlerThrowsException(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testAlarmEventHandlerThrowsErrorNIOImpl() {
        try {
            this.testAlarmEventHandlerThrowsError(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultiplePriorityAlarmEventsRunZeroTimeoutNIOImpl() {
        try {
            this.testScheduleMultiplePriorityAlarmEventsRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultiplePriorityAlarmEventsRunLessThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleMultiplePriorityAlarmEventsRunLessThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultiplePriorityAlarmEventsRunMoreTThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleMultiplePriorityAlarmEventsRunMoreThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultipleIntervalAlarmEventsRunZeroTimeoutNIOImpl() {
        try {
            this.testScheduleMultipleIntervalAlarmEventsRunZeroTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultipleIntervalAlarmEventsRunLessThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleMultipleIntervalAlarmEventsRunLessThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleMultipleIntervalAlarmEventsRunMoreThanIntervalTimeoutNIOImpl() {
        try {
            this.testScheduleMultipleIntervalAlarmEventsRunMoreThanIntervalTimeout(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAlarmEventFromWaitQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleAlarmEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleAlarmEventFromReadyQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleAlarmEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwAcceptReadyEventTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwAcceptReadyEventTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwAcceptReadyEventFromWaitQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwAcceptReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwAcceptReadyEventFromReadyQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwAcceptReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwConnectReadyEventTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwConnectReadyEventTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwConnectReadyEventFromWaitQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwConnectReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwConnectReadyEventFromReadyQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwConnectReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadReadyEventTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwReadReadyEventTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwReadReadyEventFromWaitQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwReadReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwWriteReadyEventTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwWriteReadyEventTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwReadReadyEventFromReadyQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwReadReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwWriteReadyEventFromWaitQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwWriteReadyEventFromWaitQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleNwWriteReadyEventFromReadyQueueAndRescheduleNIOImpl() {
        try {
            this.testUnscheduleNwWriteReadyEventFromReadyQueueAndReschedule(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadWriteReadyEventTriggerSameDispatcherAndRunNIOImpl() {
        try {
            this.testScheduleNwReadWriteReadyEventSameDispatcherTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadWriteReadyEventDiffDispatcherSameOwnerTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwReadWriteReadyEventDiffDispatcherSameOwnerTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testScheduleNwReadWriteReadyEventDiffDispatcherDiffOwnerTriggerAndRunNIOImpl() {
        try {
            this.testScheduleNwReadWriteReadyEventDiffDispatcherDiffOwnerTriggerAndRun(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testUnscheduleEventsFromDispatchQueueNIOImpl() {
        try {
            this.testUnscheduleEventsFromDispatchQueue(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testFlushDispatchesReadyEventsNIOImpl() {
        try {
            this.testFlushDispatchesReadyEvents(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseDispatchesReadyEventsNIOImpl() {
        try {
            this.testCloseDispatchesReadyEvents(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            e.printStackTrace();
            EmxDispatcherTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    private final class WriterUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Throwable status = null;

        private WriterUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
            this.status = e;
        }
    }

    private final class UnscheduleEventHandler
    implements IEmxEventHandler {
        IEmxEvent[] events;

        private UnscheduleEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            for (int i = 0; i < this.events.length; ++i) {
                dispatcher.unschedEv(this.events[i]);
            }
            return false;
        }
    }

    private final class EventHandler
    implements IEmxEventHandler {
        boolean retval;
        RuntimeException exception;
        Error error;
        ObjectArrayList events = new ObjectArrayList();

        EventHandler() {
            this(false);
        }

        EventHandler(boolean retval) {
            this.retval = retval;
        }

        EventHandler(RuntimeException exception) {
            this.exception = exception;
        }

        EventHandler(Error error) {
            this.error = error;
        }

        final void reset() {
            this.retval = false;
            this.exception = null;
            this.error = null;
            this.events.clear();
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            this.events.add((Object)event);
            if (this.error != null) {
                throw this.error;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.retval;
        }
    }
}

