/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio.tcp;

import com.neeve.NativeKernel;
import com.neeve.ci.XRuntime;
import com.neeve.command.Command;
import com.neeve.command.ECommandException;
import com.neeve.command.ECommandInvalidDataTypeException;
import com.neeve.command.ECommandNotSupportedException;
import com.neeve.command.ICommandHandler;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.nio.EmxNioNwLnkEndpoint;
import com.neeve.emx.nio.EmxNioNwReadReadyEvent;
import com.neeve.emx.nio.EmxNioNwWriteReadyEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public final class EmxNioTcpNwLnkPeerEndpoint
extends EmxNioNwLnkEndpoint
implements IEmxNwLnkPeerEndpoint,
ICommandHandler {
    private final EmxNioNwLnkEndpoint.StringProperty localIfAddr = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
    private final EmxNioNwLnkEndpoint.IntProperty localPort = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.localport.toString(), 0);
    private final EmxNioNwLnkEndpoint.StringProperty remoteIfAddr = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.remoteifaddr.toString(), "0.0.0.0");
    private final EmxNioNwLnkEndpoint.IntProperty remotePort = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.remoteport.toString(), 0);
    private final EmxNioNwLnkEndpoint.BooleanProperty tcpKeepAlive = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Tcp.keepalive.toString(), false);
    private final EmxNioNwLnkEndpoint.BooleanProperty tcpNoDelay = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Tcp.nodelay.toString(), XRuntime.optimizeForLatency());
    private final EmxNioNwLnkEndpoint.IntProperty sendBufferSize = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.sendbuffersize.toString(), Short.MAX_VALUE);
    private final EmxNioNwLnkEndpoint.IntProperty recvBufferSize = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.recvbuffersize.toString(), Short.MAX_VALUE);
    private final EmxNioNwLnkEndpoint.BooleanProperty linger = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Socket.linger.toString(), true);
    private final EmxNioNwLnkEndpoint.IntProperty lingerTime = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.lingertime.toString(), 10);
    private final EmxNioNwLnkEndpoint.BooleanProperty nativeIO = new EmxNioNwLnkEndpoint.BooleanProperty(EmxNwLnkProps.Socket.nativeio.toString(), XRuntime.optimizeForLatency() | XRuntime.optimizeForThroughput());
    private final String name;
    private final SocketChannel sc;
    private final long nsc;
    private final EmxNioNwReadReadyEvent rrevent;
    private final EmxNioNwWriteReadyEvent wrevent;
    private final UtlAddressDescriptor descriptor;
    private boolean closed;
    private static final boolean nativeKernelLoaded;

    public static final boolean isNativeNetworkIOEnabled() {
        return nativeKernelLoaded;
    }

    EmxNioTcpNwLnkPeerEndpoint(String name, SocketChannel sc, UtlAddressDescriptor descriptor) throws Exception {
        this.name = name;
        this.sc = sc;
        this.descriptor = descriptor;
        this.localIfAddr.init(this.descriptor.props).save(this.descriptor.props);
        this.localPort.init(this.descriptor.props).save(this.descriptor.props);
        this.remoteIfAddr.init(this.descriptor.props).save(this.descriptor.props);
        this.remotePort.init(this.descriptor.props).save(this.descriptor.props);
        this.tcpKeepAlive.init(this.descriptor.props).save(this.descriptor.props);
        this.tcpNoDelay.init(this.descriptor.props).save(this.descriptor.props);
        this.sendBufferSize.init(this.descriptor.props).save(this.descriptor.props);
        this.recvBufferSize.init(this.descriptor.props).save(this.descriptor.props);
        this.linger.init(this.descriptor.props).save(this.descriptor.props);
        this.lingerTime.init(this.descriptor.props).save(this.descriptor.props);
        this.nativeIO.init(this.descriptor.props).save(this.descriptor.props);
        try {
            sc.configureBlocking(false);
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring the TCP network link peer endpoint socket to non-blocking [" + e.toString() + "]", Tracer.Level.WARNING);
            throw e;
        }
        this.tracer.log("TCP Network Link Peer Endpoint Configuration...", Tracer.Level.CONFIG);
        try {
            this.tracer.log("....localaddr = " + this.localIfAddr.value() + ":" + this.localPort.value() + " {actual = " + sc.socket().getLocalAddress().getHostAddress() + ":" + sc.socket().getLocalPort() + "}", Tracer.Level.CONFIG);
            this.tracer.log("....remoteaddr = " + this.remoteIfAddr.value() + ":" + this.remotePort.value() + " {actual = " + sc.socket().getInetAddress().getHostAddress() + ":" + sc.socket().getPort() + "}", Tracer.Level.CONFIG);
            sc.socket().setKeepAlive(this.tcpKeepAlive.value());
            this.tracer.log("....tcp keepalive = " + this.tcpKeepAlive.value() + " {actual = " + sc.socket().getKeepAlive() + "}", Tracer.Level.CONFIG);
            sc.socket().setTcpNoDelay(this.tcpNoDelay.value());
            this.tracer.log("....tcp nodelay = " + this.tcpNoDelay.value() + " {actual = " + sc.socket().getTcpNoDelay() + "}", Tracer.Level.CONFIG);
            sc.socket().setSoLinger(this.linger.value(), this.linger.value() ? this.lingerTime.value() : 0);
            this.tracer.log("....socket linger = " + this.linger.value() + " (" + (this.linger.value() ? this.lingerTime.value() : 0) + ") {actual = " + sc.socket().getSoLinger() + "}", Tracer.Level.CONFIG);
            if (this.sendBufferSize.value() > 0) {
                sc.socket().setSendBufferSize(this.sendBufferSize.value());
            }
            this.tracer.log("....socket send buffer size = " + this.sendBufferSize.value() + " {actual = " + sc.socket().getSendBufferSize() + "}", Tracer.Level.CONFIG);
            if (this.recvBufferSize.value() > 0) {
                sc.socket().setReceiveBufferSize(this.recvBufferSize.value());
            }
            this.tracer.log("....socket recv buffer size = " + this.recvBufferSize.value() + " {actual = " + sc.socket().getReceiveBufferSize() + "}", Tracer.Level.CONFIG);
            this.tracer.log("....native IO = " + this.nativeIO.value(), Tracer.Level.CONFIG);
            if (this.nativeIO.value()) {
                if (nativeKernelLoaded) {
                    Field field = sc.getClass().getDeclaredField("fdVal");
                    if (field != null) {
                        field.setAccessible(true);
                        Integer fdVal = (Integer)field.get(sc);
                        if (fdVal != null) {
                            this.nsc = this.nativeWrap(fdVal);
                            this.tracer.log("........successfully configured to use native IO (fd = " + fdVal + ")", Tracer.Level.CONFIG);
                        } else {
                            this.nsc = -1L;
                            this.tracer.log("........configured to use native IO but could not obtain value for 'fdVal' field", Tracer.Level.CONFIG);
                        }
                    } else {
                        this.nsc = -1L;
                        this.tracer.log("........configured to use native IO but could not find field named 'fdVal' in socket channel impl class", Tracer.Level.CONFIG);
                    }
                } else {
                    this.nsc = -1L;
                    this.tracer.log("........cannot use native IO [native kernel not loaded]", Tracer.Level.CONFIG);
                }
            } else {
                this.nsc = -1L;
                this.tracer.log("........not configured to use native IO", Tracer.Level.CONFIG);
            }
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring a TCP network link peer endpoint socket property [" + e.toString() + "]", Tracer.Level.WARNING);
            throw e;
        }
        this.rrevent = new EmxNioNwReadReadyEvent(sc);
        this.wrevent = new EmxNioNwWriteReadyEvent(sc);
    }

    private final native long nativeWrap(int var1) throws Exception;

    private final native int nativeRead(long var1, ByteBuffer var3, int var4, int var5) throws Exception;

    private final native long nativeWrite(long var1, ByteBuffer[] var3, int var4) throws Exception;

    private final native void nativeDestroy(long var1);

    private final void onGetpropsCommand(HashMap<String, Object> props) throws SocketException {
        this.getSocketNTcpProps(this.sc, props);
    }

    private final void configureBlockingInternal(boolean blocking) throws IOException {
        this.sc.configureBlocking(blocking);
    }

    private final boolean isBlockingInternal() {
        return this.sc.isBlocking();
    }

    private final int readInternalCore(ByteBuffer buffer) throws Exception {
        int bytesRead = 0;
        if (this.nsc >= 0L) {
            int lim;
            int pos = buffer.position();
            bytesRead = this.nativeRead(this.nsc, buffer, pos, lim = buffer.limit());
            if (bytesRead > 0) {
                buffer.position(pos + bytesRead);
            }
        } else {
            bytesRead = this.sc.read(buffer);
        }
        return bytesRead;
    }

    private final int readInternal(ByteBuffer buffer, EmxNwLnkOpWaitCond waitCond) throws EEmxNwLnkOpFailedException {
        int bytesRead;
        block8: {
            if (waitCond != null) {
                waitCond.reset();
                if (!this.isBlockingInternal()) {
                    waitCond.add(this.rrevent);
                }
            }
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Reading " + buffer.remaining() + " bytes...", Tracer.Level.DEBUG);
                }
                if ((bytesRead = this.readInternalCore(buffer)) > 0) break block8;
                if (bytesRead == 0) {
                    if (this.tracer.debug) {
                        this.tracer.log("Read pending completion.", Tracer.Level.DEBUG);
                    }
                    break block8;
                }
                throw new EEmxNwLnkClosedGracefullyException();
            }
            catch (Exception e) {
                this.tracer.log("Read failed [" + e.toString() + "]", Tracer.Level.FINE);
                if (!(e instanceof EEmxNwLnkOpFailedException)) {
                    throw new EEmxNwLnkOpFailedException(e);
                }
                throw (EEmxNwLnkOpFailedException)((Object)e);
            }
        }
        return bytesRead;
    }

    private final long writeInternal(ByteBuffer[] buffers, int count, EmxNwLnkOpWaitCond waitCond) throws EEmxNwLnkOpFailedException {
        long bytesWritten;
        if (count <= 0) {
            return 0L;
        }
        if (waitCond != null) {
            waitCond.reset();
            if (!this.isBlockingInternal()) {
                waitCond.add(this.wrevent);
            }
        }
        try {
            if (this.tracer.debug) {
                int bytesToWrite = 0;
                for (int i = 0; i < count; ++i) {
                    bytesToWrite += buffers[i].remaining();
                }
                this.tracer.log("Writing " + bytesToWrite + " bytes (# buffers=" + count + ")...", Tracer.Level.DEBUG);
            }
            if ((bytesWritten = this.nsc >= 0L ? this.nativeWrite(this.nsc, buffers, count) : this.sc.write(buffers, 0, count)) == 0L && this.tracer.debug) {
                this.tracer.log("Write pending completion.", Tracer.Level.DEBUG);
            }
        }
        catch (Exception e) {
            this.tracer.log("Write failed [" + e.toString() + "]", Tracer.Level.FINE);
            throw new EEmxNwLnkOpFailedException(e);
        }
        return bytesWritten;
    }

    private final void closeInternal() throws IOException {
        if (this.sc != null) {
            try {
                if (!this.sc.socket().isOutputShutdown()) {
                    this.sc.socket().shutdownOutput();
                }
                if (!this.sc.socket().isInputShutdown()) {
                    this.sc.socket().shutdownInput();
                }
            }
            finally {
                if (this.sc.socket().isConnected()) {
                    this.sc.socket().close();
                }
                if (this.nsc >= 0L) {
                    this.nativeDestroy(this.nsc);
                }
            }
        }
    }

    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            try {
                this.configureBlockingInternal(blocking);
            }
            catch (Exception e) {
                this.tracer.log("Failure in configuring the TCP network link peer endpoint socket to " + (blocking ? "blocking" : "non-blocking") + " [" + e.toString() + "]", Tracer.Level.WARNING);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new EEmxNwLnkOpFailedException(e);
            }
        } else {
            throw new EEmxInvalidStateException("network link peer endpoint configure blocking", "closed");
        }
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return this.isBlockingInternal();
        }
        throw new EEmxInvalidStateException("network link peer endpoint is blocking", "closed");
    }

    @Override
    public final int read(ByteBuffer buffer, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            return this.readInternal(buffer, waitCond);
        }
        throw new EEmxInvalidStateException("network link client endpoint read", "closed");
    }

    @Override
    public final int read(ByteBuffer buffer) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        return this.read(buffer, null);
    }

    @Override
    public final IEmxNwReadReadyEvent getReadReadyEvent() {
        return this.rrevent;
    }

    @Override
    public final long write(ByteBuffer[] buffers, int count, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            return this.writeInternal(buffers, count, waitCond);
        }
        throw new EEmxInvalidStateException("network link client endpoint write", "closed");
    }

    @Override
    public final long write(ByteBuffer[] buffers, int count) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.write(buffers, count, null);
    }

    @Override
    public final IEmxNwWriteReadyEvent getWriteReadyEvent() {
        return this.wrevent;
    }

    @Override
    public void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            this.tracer.log("Closing TCP network link peer endpoint...", Tracer.Level.FINE);
            try {
                this.closeInternal();
            }
            catch (IOException e) {
                this.tracer.log("Failure in closing TCP network link peer endpoint [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public final Object procCommand(String command, Object data) throws ECommandException {
        try {
            switch (Command.valueOf((String)command)) {
                case getprops: {
                    try {
                        HashMap props = (HashMap)data;
                        if (props != null) {
                            this.onGetpropsCommand(props);
                            return props;
                        }
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", "null");
                    }
                    catch (ClassCastException e) {
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", data.getClass().getName());
                    }
                }
            }
            throw new ECommandNotSupportedException(command.toString());
        }
        catch (Exception e) {
            throw new ECommandException((Throwable)e);
        }
    }

    static {
        boolean val = false;
        try {
            NativeKernel.initialize();
            val = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nativeKernelLoaded = val;
        if (XRuntime.getValue((String)"nv.native.configtrace", (boolean)false)) {
            System.out.println("NATIVE NETWORK IO IS " + (nativeKernelLoaded ? "ENABLED" : "DISABLED"));
        }
    }
}

