/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.config.IConfigRepository;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.StoreObjectFactoryDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlReflection;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class OdsConfigToolPlugin {
    private final LinkedHashMap<String, StoreDescriptor> stores;
    private final LinkedHashMap<String, StoreReplicatorDescriptor> replicators;
    private final LinkedHashMap<String, StorePersisterDescriptor> persisters;
    private final LinkedHashMap<String, StoreInterClusterReplicatorDescriptor> icrs;
    private final LinkedHashMap<String, StoreObjectFactoryDescriptor> objectFactories;
    private final IConfigRepository repo;
    private final Tracer tracer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setStoreReplicator(String storeName, String replicatorName) {
        StoreDescriptor store = this.stores.get(storeName.toLowerCase());
        if (store != null) {
            if (replicatorName != null) {
                this.tracer.log("Setting '" + replicatorName + "' as the replicator for store '" + storeName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Clearing the replicator of store '" + storeName + "'...", Tracer.Level.INFO);
            }
            try {
                if (replicatorName != null) {
                    if (!StoreReplicatorDescriptor.exists(this.repo, replicatorName)) throw new Exception("replicator does not exist in repository");
                    store.setReplicator(replicatorName);
                } else {
                    store.setReplicator(null);
                }
                store.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed Setting '" + replicatorName + "' as the replicator for store '" + storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("Store '" + storeName + "' does not exist.", Tracer.Level.SEVERE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setStorePersister(String storeName, String persisterName) {
        StoreDescriptor store = this.stores.get(storeName.toLowerCase());
        if (store != null) {
            if (persisterName != null) {
                this.tracer.log("Setting '" + persisterName + "' as the persister for store '" + storeName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Clearing the persister of store '" + storeName + "'...", Tracer.Level.INFO);
            }
            try {
                if (persisterName != null) {
                    if (!StorePersisterDescriptor.exists(this.repo, persisterName)) throw new Exception("persister does not exist in repository");
                    store.setPersister(persisterName);
                } else {
                    store.setPersister(null);
                }
                store.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed Setting '" + persisterName + "' as the persister for store '" + storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("Store '" + storeName + "' does not exist.", Tracer.Level.SEVERE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void setStoreInterClusterReplicator(String storeName, String icrName) {
        StoreDescriptor store = this.stores.get(storeName.toLowerCase());
        if (store != null) {
            if (icrName != null) {
                this.tracer.log("Setting '" + icrName + "' as the inter-cluster replicator for store '" + storeName + "'...", Tracer.Level.INFO);
            } else {
                this.tracer.log("Clearing the inter-cluster replicator of store '" + storeName + "'...", Tracer.Level.INFO);
            }
            try {
                if (icrName != null) {
                    if (!StoreInterClusterReplicatorDescriptor.exists(this.repo, icrName)) throw new Exception("inter-cluster replicator does not exist in repository");
                    store.setInterClusterReplicator(icrName);
                } else {
                    store.setInterClusterReplicator(null);
                }
                store.save(this.repo);
                this.tracer.log("Success.", Tracer.Level.INFO);
                return;
            }
            catch (Exception e) {
                this.tracer.log("Failed setting '" + icrName + "' as the inter-cluster replicator for store '" + storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
            return;
        } else {
            this.tracer.log("Store '" + storeName + "' does not exist, inter-cluster replicator can't be set.", Tracer.Level.SEVERE);
        }
    }

    private OdsConfigToolPlugin(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        this.tracer = tracer;
        this.repo = repo;
        interactiveTool.registerCommand((Command)new CreateStoreReplicator());
        interactiveTool.registerCommand((Command)new SetStoreReplicatorProperty());
        interactiveTool.registerCommand((Command)new ListStoreReplicators());
        interactiveTool.registerCommand((Command)new DeleteStoreReplicator());
        interactiveTool.registerCommand((Command)new CreateStorePersister());
        interactiveTool.registerCommand((Command)new SetStorePersisterProperty());
        interactiveTool.registerCommand((Command)new ListStorePersisters());
        interactiveTool.registerCommand((Command)new DeleteStorePersister());
        interactiveTool.registerCommand((Command)new CreateStoreInterClusterReplicator());
        interactiveTool.registerCommand((Command)new SetStoreInterClusterReplicatorProperty());
        interactiveTool.registerCommand((Command)new ListStoreInterClusterReplicators());
        interactiveTool.registerCommand((Command)new DeleteStoreInterClusterReplicator());
        interactiveTool.registerCommand((Command)new CreateStore());
        interactiveTool.registerCommand((Command)new SetStoreReplicator());
        interactiveTool.registerCommand((Command)new ClearStoreReplicator());
        interactiveTool.registerCommand((Command)new SetStorePersister());
        interactiveTool.registerCommand((Command)new ClearStorePersister());
        interactiveTool.registerCommand((Command)new SetStorePersistenceQuorum());
        interactiveTool.registerCommand((Command)new SetStoreMaxPersistSyncBacklog());
        interactiveTool.registerCommand((Command)new SetStoreInterClusterReplicator());
        interactiveTool.registerCommand((Command)new ClearStoreInterClusterReplicator());
        interactiveTool.registerCommand((Command)new SetStoreInterClusterReplicationQuorum());
        interactiveTool.registerCommand((Command)new SetStoreMaxInterClusterReplicationSyncBacklog());
        interactiveTool.registerCommand((Command)new StoreSetCheckpointingType());
        interactiveTool.registerCommand((Command)new SetStoreCheckpointingThreshold());
        interactiveTool.registerCommand((Command)new SetStoreCheckpointingMaxInterval());
        interactiveTool.registerCommand((Command)new SetStoreQueryable());
        interactiveTool.registerCommand((Command)new SetStoreProperty());
        interactiveTool.registerCommand((Command)new ListStores());
        interactiveTool.registerCommand((Command)new DeleteStore());
        interactiveTool.registerCommand((Command)new CreateObjectFactory());
        interactiveTool.registerCommand((Command)new ListObjectFactories());
        interactiveTool.registerCommand((Command)new DeleteObjectFactory());
        interactiveTool.registerAnnotatedCommands((Object)this);
        this.replicators = new LinkedHashMap();
        this.initReplicatorDescriptorTable();
        this.persisters = new LinkedHashMap();
        this.initPersisterDescriptorTable();
        this.icrs = new LinkedHashMap();
        this.initInterClusterReplicatorDescriptorTable();
        this.stores = new LinkedHashMap();
        this.initStoreDescriptorTable();
        this.objectFactories = new LinkedHashMap();
        this.initObjectFactoryDescriptorTable();
    }

    private final void initReplicatorDescriptorTable() throws Exception {
        this.tracer.log("Loading configured store replicators...", Tracer.Level.INFO);
        this.replicators.clear();
        Set<StoreReplicatorDescriptor> replicatorSet = StoreReplicatorDescriptor.loadAll(this.repo);
        if (replicatorSet.size() > 0) {
            for (StoreReplicatorDescriptor replicator : replicatorSet) {
                this.tracer.log("...." + replicator.getName(), Tracer.Level.INFO);
                this.replicators.put(replicator.getName().toLowerCase(), replicator);
            }
        } else {
            this.tracer.log("....No configured replicators", Tracer.Level.INFO);
        }
    }

    private final void initPersisterDescriptorTable() throws Exception {
        this.tracer.log("Loading configured store persisters...", Tracer.Level.INFO);
        this.persisters.clear();
        Set<StorePersisterDescriptor> persisterSet = StorePersisterDescriptor.loadAll(this.repo);
        if (persisterSet.size() > 0) {
            for (StorePersisterDescriptor persister : persisterSet) {
                this.tracer.log("...." + persister.getName(), Tracer.Level.INFO);
                this.persisters.put(persister.getName().toLowerCase(), persister);
            }
        } else {
            this.tracer.log("....No configured persisters", Tracer.Level.INFO);
        }
    }

    private final void initInterClusterReplicatorDescriptorTable() throws Exception {
        this.tracer.log("Loading configured store inter-cluster replicators...", Tracer.Level.INFO);
        this.icrs.clear();
        Set<StoreInterClusterReplicatorDescriptor> icrSet = StoreInterClusterReplicatorDescriptor.loadAll(this.repo);
        if (icrSet.size() > 0) {
            for (StoreInterClusterReplicatorDescriptor icr : icrSet) {
                this.tracer.log("...." + icr.getName(), Tracer.Level.INFO);
                this.icrs.put(icr.getName().toLowerCase(), icr);
            }
        } else {
            this.tracer.log("....No configured inter-cluster replicators", Tracer.Level.INFO);
        }
    }

    private final void initStoreDescriptorTable() throws Exception {
        this.tracer.log("Loading configured stores...", Tracer.Level.INFO);
        this.stores.clear();
        Set<StoreDescriptor> storeSet = StoreDescriptor.loadAll(this.repo);
        if (storeSet.size() > 0) {
            for (StoreDescriptor store : storeSet) {
                this.tracer.log("...." + store.getName(), Tracer.Level.INFO);
                this.stores.put(store.getName().toLowerCase(), store);
            }
        } else {
            this.tracer.log("....No configured stores", Tracer.Level.INFO);
        }
    }

    private final void initObjectFactoryDescriptorTable() throws Exception {
        this.tracer.log("Loading configured object factories...", Tracer.Level.INFO);
        this.objectFactories.clear();
        Collection<StoreObjectFactoryDescriptor> objectFactoryCollection = StoreObjectFactoryDescriptor.loadAll(this.repo).values();
        if (objectFactoryCollection.size() > 0) {
            for (StoreObjectFactoryDescriptor objectFactory : objectFactoryCollection) {
                this.tracer.log("...." + objectFactory.getName(), Tracer.Level.INFO);
                this.objectFactories.put(objectFactory.getName().toLowerCase(), objectFactory);
            }
        } else {
            this.tracer.log("....No configured object factories", Tracer.Level.INFO);
        }
    }

    public static final Object create(InteractiveTool interactiveTool, IConfigRepository repo, Tracer tracer) throws Exception {
        return new OdsConfigToolPlugin(interactiveTool, repo, tracer);
    }

    public final class DeleteObjectFactory
    extends Command {
        public final void doDelete(String objectFactoryName) {
            StoreObjectFactoryDescriptor objectFactory = (StoreObjectFactoryDescriptor)((Object)OdsConfigToolPlugin.this.objectFactories.get(objectFactoryName.toLowerCase()));
            if (objectFactory != null) {
                OdsConfigToolPlugin.this.tracer.log("Deleting store object factory '" + objectFactory.getName() + "'...", Tracer.Level.INFO);
                try {
                    objectFactory.delete(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.objectFactories.remove(objectFactoryName);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed deleting store object factory '" + objectFactory.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store object factory '" + objectFactoryName + "' does not exist and cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: object_factory_delete <objectFactoryName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("object_factory_delete");
            System.out.println("  Deletes a store object factory from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"object_factory_delete"};
        }
    }

    public final class ListObjectFactories
    extends Command {
        public final void doList() {
            if (OdsConfigToolPlugin.this.objectFactories.size() > 0) {
                Iterator iterator = OdsConfigToolPlugin.this.objectFactories.keySet().iterator();
                while (iterator.hasNext()) {
                    StoreObjectFactoryDescriptor objectFactory = (StoreObjectFactoryDescriptor)((Object)OdsConfigToolPlugin.this.objectFactories.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + objectFactory.getName() + " - " + (Object)((Object)objectFactory));
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("No store object factories in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: object_factories");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("object_factories");
            System.out.println("  Lists the store object factories in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"object_factories"};
        }
    }

    public final class CreateObjectFactory
    extends Command {
        public final void doCreate(String objectFactoryName, short objectFactoryId, String objectFactoryClassName) {
            if (OdsConfigToolPlugin.this.objectFactories.get(objectFactoryName.toLowerCase()) == null) {
                OdsConfigToolPlugin.this.tracer.log("Creating new store object factory '" + objectFactoryName + "'...", Tracer.Level.INFO);
                try {
                    StoreObjectFactoryDescriptor objectFactory = StoreObjectFactoryDescriptor.create(objectFactoryName, objectFactoryId, objectFactoryClassName);
                    objectFactory.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.objectFactories.put(objectFactoryName.toLowerCase(), objectFactory);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed creating new store object factory '" + objectFactoryName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store object factory '" + objectFactoryName + "' already exists.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: object_factory_create <objectFactoryName> <objectFactoryId> <objectFactoryClassName>");
            } else {
                this.doCreate(args[0], Short.valueOf(args[1]), args[2]);
            }
        }

        public final void help() {
            System.out.println("object_factory_create");
            System.out.println("  Creates a new store object factory in the repository");
        }

        public final String[] keywords() {
            return new String[]{"object_factory_create"};
        }
    }

    public final class DeleteStore
    extends Command {
        public final void doDelete(String storeName) {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Deleting data store '" + store.getName() + "'...", Tracer.Level.INFO);
                try {
                    store.delete(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.stores.remove(storeName.toLowerCase());
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed deleting data store '" + store.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("Store '" + storeName + "' does not exist, it cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_delete <storeName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_delete");
            System.out.println("  Deletes a data store from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_delete"};
        }
    }

    public final class ListStores
    extends Command {
        public final void doList() {
            if (OdsConfigToolPlugin.this.stores.size() > 0) {
                Iterator iterator = OdsConfigToolPlugin.this.stores.keySet().iterator();
                while (iterator.hasNext()) {
                    StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(iterator.next()));
                    System.out.println("\n  Store " + (Object)((Object)store));
                }
                OdsConfigToolPlugin.this.tracer.log("", Tracer.Level.INFO);
            } else {
                OdsConfigToolPlugin.this.tracer.log("No stores in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: stores");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("stores, stores");
            System.out.println("  Lists the data stores in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"stores"};
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_property"}, description="Sets a store property.")
    public final class SetStoreProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store to be configured")
        String storeName;
        @AnnotatedCommand.Argument(name="propertyName", position=1, required=true, description="The name of the property to configure")
        String propertyName;
        @AnnotatedCommand.Argument(name="propertyValue", position=2, required=false, description="The value to set, or omitted for null")
        String propertyValue;

        public void execute() throws Exception {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                try {
                    OdsConfigToolPlugin.this.tracer.log("Setting '" + this.propertyName + "' to '" + this.propertyValue + "' for ODS Store'" + this.storeName + "'...", Tracer.Level.INFO);
                    UtlReflection.setNonNestedProperty((Object)((Object)store), (String)this.propertyName, (Object)this.propertyValue);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (InvocationTargetException ite) {
                    String message = ite.getClass() != null ? ite.getCause().getMessage() : ite.toString();
                    OdsConfigToolPlugin.this.tracer.log("Failed to set store descriptor property '" + this.propertyName + "' to '" + this.propertyValue + "' for store '" + this.storeName + "' [" + message + "]", Tracer.Level.SEVERE);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed to set store descriptor property '" + this.propertyName + "' to '" + this.propertyValue + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("ODS Store '" + this.storeName + "' does not exist, cannot set descriptor properties.", Tracer.Level.SEVERE);
            }
        }

        public void usage(PrintStream out) {
            super.usage(out);
            StringBuilder validProperties = new StringBuilder();
            validProperties.append("  Where propertyName is one of: " + UtlReflection.getProperties(StoreDescriptor.class));
            out.println(validProperties);
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_queryable"}, description="Sets whether a store is queryable or not.")
    public final class SetStoreQueryable
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="queryable", position=1, required=true, description="Whether queryable or not")
        boolean queryable;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store queryability to '" + this.queryable + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setQueryable(this.queryable);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed to set store's queryability to '" + this.queryable + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, queryablity can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_checkpointing_max_interval"}, description="Sets the store's checkpointing max interval.")
    public final class SetStoreCheckpointingMaxInterval
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="maxInterval", position=1, required=true, description="The max interval to set")
        int maxInterval;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store checkpointing max interval to '" + this.maxInterval + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setCheckpointMaxInterval(this.maxInterval);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting store checkpointing max interval to '" + this.maxInterval + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, checkpointing max interval can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_checkpointing_threshold"}, description="Sets the store's checkpointing threshold.")
    public final class SetStoreCheckpointingThreshold
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="threshold", position=1, required=true, description="The threshold to set")
        int threshold;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store checkpointing threshold to '" + this.threshold + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setCheckpointThreshold(this.threshold);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting store checkpointing threshold to '" + this.threshold + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, its checkpointing threshold can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_checkpointing_type"}, description="Set a store's checkpointing type.")
    public final class StoreSetCheckpointingType
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="type", position=1, required=true, description="The checkpointing type to set [Default|CDC|Conflation]")
        String type;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store checkpointing type to '" + this.type + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setCheckpointingType(IStoreCheckpointingController.Type.valueOf(this.type));
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting store checkpointing type to '" + this.type + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, its store checkpointing type can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_max_icr_sync_backlog"}, description="Sets the store's max ICR sync backlog.")
    public final class SetStoreMaxInterClusterReplicationSyncBacklog
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="backlog", position=1, required=true, description="The size of the backlog")
        int backlog;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store max icr sync backlog to '" + this.backlog + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setMaxInterClusterReplicationSyncBacklog(this.backlog);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting store max icr sync backlog to '" + this.backlog + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, its max icr sync backlog can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    public final class SetStoreInterClusterReplicationQuorum
    extends Command {
        public final void doSet(String storeName, int quorum) {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting inter-cluster replication quorum for store '" + storeName + "' to '" + quorum + "'...", Tracer.Level.INFO);
                try {
                    store.setInterClusterReplicationQuorum(quorum);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting inter-cluster replication quorum for store '" + storeName + "' to '" + quorum + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("Store '" + storeName + "' does not exist, its inter-cluster replication quorum can't be set.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_set_icr_quorum <storeName> <icrQuorum>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("store_set_icr_quorum");
            System.out.println("  Set a data store's inter-cluster replication quorum.");
        }

        public final String[] keywords() {
            return new String[]{"store_set_icr_quorum"};
        }
    }

    public final class ClearStoreInterClusterReplicator
    extends Command {
        public final void doClear(String storeName) {
            OdsConfigToolPlugin.this.setStoreInterClusterReplicator(storeName, null);
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_clear_icr <storeName>");
            } else {
                this.doClear(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_clear_icr");
            System.out.println("  Clear a data store's inter-cluster replicator.");
        }

        public final String[] keywords() {
            return new String[]{"store_clear_icr"};
        }
    }

    public final class SetStoreInterClusterReplicator
    extends Command {
        public final void doSet(String storeName, String icrName) {
            OdsConfigToolPlugin.this.setStoreInterClusterReplicator(storeName, icrName);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_set_icr <storeName> <icrName>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("store_set_icr");
            System.out.println("  Set a data store's inter-cluster replicator.");
        }

        public final String[] keywords() {
            return new String[]{"store_set_icr"};
        }
    }

    @AnnotatedCommand.Command(keywords={"store_set_max_persist_sync_backlog"}, description="Sets the store's max persist sync backlog.")
    public final class SetStoreMaxPersistSyncBacklog
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="storeName", position=0, required=true, description="The name of the store")
        String storeName;
        @AnnotatedCommand.Argument(name="backlog", position=1, required=true, description="The size of the backlog")
        int backlog;

        public final void execute() {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(this.storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting store max persist sync backlog to '" + this.backlog + "' for store '" + this.storeName + "'...", Tracer.Level.INFO);
                try {
                    store.setMaxPersistSyncBacklog(this.backlog);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting store max persist sync backlog to '" + this.backlog + "' for store '" + this.storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store '" + this.storeName + "' does not exist, its max persist sync backlog can't be set.", Tracer.Level.SEVERE);
            }
        }
    }

    public final class SetStorePersistenceQuorum
    extends Command {
        public final void doSet(String storeName, int quorum) {
            StoreDescriptor store = (StoreDescriptor)((Object)OdsConfigToolPlugin.this.stores.get(storeName.toLowerCase()));
            if (store != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting persistence quorum for store '" + storeName + "' to '" + quorum + "'...", Tracer.Level.INFO);
                try {
                    store.setPersistenceQuorum(quorum);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting persistence quorum for store '" + storeName + "' to '" + quorum + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("Store '" + storeName + "' does not exist, its persistence quorum can't be set.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_set_persistence_quorum <storeName> <persistenceQuorum>");
            } else {
                this.doSet(args[0], Integer.parseInt(args[1]));
            }
        }

        public final void help() {
            System.out.println("store_set_persistence_quorum");
            System.out.println("  Set a data store's persistence quorum.");
        }

        public final String[] keywords() {
            return new String[]{"store_set_persistence_quorum"};
        }
    }

    public final class ClearStorePersister
    extends Command {
        public final void doClear(String storeName) {
            OdsConfigToolPlugin.this.setStorePersister(storeName, null);
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_clear_persister <storeName>");
            } else {
                this.doClear(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_clear_persister");
            System.out.println("  Clear a data store's persister.");
        }

        public final String[] keywords() {
            return new String[]{"store_clear_persister"};
        }
    }

    public final class SetStorePersister
    extends Command {
        public final void doSet(String storeName, String persisterName) {
            OdsConfigToolPlugin.this.setStorePersister(storeName, persisterName);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_set_persister <storeName> <persisterName>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("store_set_persister");
            System.out.println("  Set a data store's persister.");
        }

        public final String[] keywords() {
            return new String[]{"store_set_persister"};
        }
    }

    public final class ClearStoreReplicator
    extends Command {
        public final void doClear(String storeName) {
            OdsConfigToolPlugin.this.setStoreReplicator(storeName, null);
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_clear_replicator <storeName>");
            } else {
                this.doClear(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_clear_replicator");
            System.out.println("  Clear a data store's replicator.");
        }

        public final String[] keywords() {
            return new String[]{"store_clear_replicator"};
        }
    }

    public final class SetStoreReplicator
    extends Command {
        public final void doSet(String storeName, String replicatorName) {
            OdsConfigToolPlugin.this.setStoreReplicator(storeName, replicatorName);
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_set_replicator <storeName> <replicatorName>");
            } else {
                this.doSet(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("store_set_replicator");
            System.out.println("  Set a data store's replicator.");
        }

        public final String[] keywords() {
            return new String[]{"store_set_replicator"};
        }
    }

    public final class CreateStore
    extends Command {
        public final void doCreate(String storeName) {
            if (OdsConfigToolPlugin.this.stores.get(storeName.toLowerCase()) == null) {
                OdsConfigToolPlugin.this.tracer.log("Creating new data store '" + storeName + "'...", Tracer.Level.INFO);
                try {
                    StoreDescriptor store = StoreDescriptor.create(storeName);
                    store.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.stores.put(storeName.toLowerCase(), store);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed creating new data store '" + storeName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("Store '" + storeName + "' already exists, it cannot be created.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_create <storeName>");
            } else {
                this.doCreate(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_create");
            System.out.println("  Creates a new data store in the repository");
        }

        public final String[] keywords() {
            return new String[]{"store_create"};
        }
    }

    public final class DeleteStoreInterClusterReplicator
    extends Command {
        public final void doDelete(String icrName) {
            StoreInterClusterReplicatorDescriptor icr = (StoreInterClusterReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.icrs.get(icrName.toLowerCase()));
            if (icr != null) {
                OdsConfigToolPlugin.this.tracer.log("Deleting store inter-cluster replicator '" + icr.getName() + "'...", Tracer.Level.INFO);
                try {
                    icr.delete(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.icrs.remove(icrName);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed deleting store inter-cluster replicator '" + icr.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store inter-cluster replicator '" + icrName + "' does not exist, it cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_icr_delete <icrName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_icr_delete");
            System.out.println("  Deletes a store inter-cluster replicator from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_icr_delete"};
        }
    }

    public final class ListStoreInterClusterReplicators
    extends Command {
        public final void doList() {
            if (OdsConfigToolPlugin.this.icrs.size() > 0) {
                Iterator iterator = OdsConfigToolPlugin.this.icrs.keySet().iterator();
                while (iterator.hasNext()) {
                    StoreInterClusterReplicatorDescriptor icr = (StoreInterClusterReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.icrs.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + icr.getName() + " - " + (Object)((Object)icr));
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("No store inter-cluster replicators in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: store_icrs");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("store_icrs");
            System.out.println("  Lists the store inter-cluster replicators in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_icrs"};
        }
    }

    public final class SetStoreInterClusterReplicatorProperty
    extends Command {
        public final void doSet(String icrName, String propName, String propVal) {
            StoreInterClusterReplicatorDescriptor icr = (StoreInterClusterReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.icrs.get(icrName.toLowerCase()));
            if (icr != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting property '" + propName + "=" + propVal + " property in store inter-cluster replicator '" + icrName + "'...", Tracer.Level.INFO);
                try {
                    icr.setProperty(propName, propVal);
                    icr.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting property '" + propName + "=" + propVal + " property in store inter-cluster replicator '" + icrName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store inter-cluster replicator '" + icrName + "' does not exist, cannot set its properties.", Tracer.Level.SEVERE);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: store_icr_set_property <icrName> <propName> <propVal>");
            } else {
                this.doSet(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("store_icr_set_property");
            System.out.println("  Sets a store inter-cluster replicator property");
        }

        public final String[] keywords() {
            return new String[]{"store_icr_set_property"};
        }
    }

    public final class CreateStoreInterClusterReplicator
    extends Command {
        public final void doCreate(String icrName, String icrRole, String icrUrl) {
            if (OdsConfigToolPlugin.this.icrs.get(icrName.toLowerCase()) == null) {
                OdsConfigToolPlugin.this.tracer.log("Creating new store inter-cluster replicator '" + icrName + "'...", Tracer.Level.INFO);
                try {
                    StoreInterClusterReplicatorDescriptor icr = StoreInterClusterReplicatorDescriptor.create(icrName, IStoreBinding.InterClusterReplicationRole.valueOf(icrRole), icrUrl);
                    icr.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.icrs.put(icrName.toLowerCase(), icr);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed creating new store inter-cluster replicator '" + icrName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store inter-cluster replicator '" + icrName + "' already exists, it cannot be created.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: store_icr_create <icrName> <icrRole> <icrUrl>");
            } else {
                this.doCreate(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("store_icr_create");
            System.out.println("  Creates a new store inter-cluster replicator in the repository");
        }

        public final String[] keywords() {
            return new String[]{"store_icr_create"};
        }
    }

    public final class DeleteStorePersister
    extends Command {
        public final void doDelete(String persisterName) {
            StorePersisterDescriptor persister = (StorePersisterDescriptor)((Object)OdsConfigToolPlugin.this.persisters.get(persisterName.toLowerCase()));
            if (persister != null) {
                OdsConfigToolPlugin.this.tracer.log("Deleting store persister '" + persister.getName() + "'...", Tracer.Level.INFO);
                try {
                    persister.delete(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.persisters.remove(persisterName);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed deleting store persister '" + persister.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store persister '" + persisterName + "' does not exist, it cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_persister_delete <persisterName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_persister_delete");
            System.out.println("  Deletes a store persister from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_persister_delete"};
        }
    }

    public final class ListStorePersisters
    extends Command {
        public final void doList() {
            if (OdsConfigToolPlugin.this.persisters.size() > 0) {
                Iterator iterator = OdsConfigToolPlugin.this.persisters.keySet().iterator();
                while (iterator.hasNext()) {
                    StorePersisterDescriptor persister = (StorePersisterDescriptor)((Object)OdsConfigToolPlugin.this.persisters.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + persister.getName() + " - " + (Object)((Object)persister));
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("No store persisters in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: store_persisters");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("store_persisters");
            System.out.println("  Lists the store persisters in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_persisters"};
        }
    }

    @AnnotatedCommand.Command(keywords={"store_persister_set_cdc_property"}, description="Sets a cdc property for a persister.")
    public final class SetStorePersisterCdcProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="persisterName", position=0, required=true, description="The name of the persister")
        String persisterName;
        @AnnotatedCommand.Argument(name="propName", position=1, required=true, description="The property name")
        String propName;
        @AnnotatedCommand.Argument(name="propVal", position=2, required=true, description="The property value")
        String propVal;

        public final void execute() {
            StorePersisterDescriptor persister = (StorePersisterDescriptor)((Object)OdsConfigToolPlugin.this.persisters.get(this.persisterName.toLowerCase()));
            if (persister != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting cdc property '" + this.propName + "=" + this.propVal + " in store persister '" + this.persisterName + "'...", Tracer.Level.INFO);
                try {
                    persister.setCdcProperty(this.propName, this.propVal);
                    persister.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting '" + this.propName + "=" + this.propVal + " cdc property in store persister '" + this.persisterName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store persister '" + this.persisterName + "' does not exist, cannot set its cdc properties.", Tracer.Level.WARNING);
            }
        }
    }

    @AnnotatedCommand.Command(keywords={"store_persister_set_compaction_property"}, description="Sets a compaction property for a persister.")
    public final class SetStorePersisterCompactionProperty
    extends AnnotatedCommand {
        @AnnotatedCommand.Argument(name="persisterName", position=0, required=true, description="The name of the persister")
        String persisterName;
        @AnnotatedCommand.Argument(name="propName", position=1, required=true, description="The property name")
        String propName;
        @AnnotatedCommand.Argument(name="propVal", position=2, required=true, description="The property value")
        String propVal;

        public final void execute() {
            StorePersisterDescriptor persister = (StorePersisterDescriptor)((Object)OdsConfigToolPlugin.this.persisters.get(this.persisterName.toLowerCase()));
            if (persister != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting compactor property '" + this.propName + "=" + this.propVal + " in store persister '" + this.persisterName + "'...", Tracer.Level.INFO);
                try {
                    persister.setCompactorProperty(this.propName, this.propVal);
                    persister.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting '" + this.propName + "=" + this.propVal + " compaction property in store persister '" + this.persisterName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store persister '" + this.persisterName + "' does not exist, cannot set its compaction properties.", Tracer.Level.WARNING);
            }
        }
    }

    public final class SetStorePersisterProperty
    extends Command {
        public final void doSet(String persisterName, String propName, String propVal) {
            StorePersisterDescriptor persister = (StorePersisterDescriptor)((Object)OdsConfigToolPlugin.this.persisters.get(persisterName.toLowerCase()));
            if (persister != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting property '" + propName + "=" + propVal + " property in store persister '" + persisterName + "'...", Tracer.Level.INFO);
                try {
                    persister.setProperty(propName, propVal);
                    persister.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting property '" + propName + "=" + propVal + " property in store persister '" + persisterName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store persister '" + persisterName + "' does not exist, cannot set its properties.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: store_persister_set_property <persisterName> <propName> <propVal>");
            } else {
                this.doSet(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("store_persister_set_property");
            System.out.println("  Sets a store persister property");
        }

        public final String[] keywords() {
            return new String[]{"store_persister_set_property"};
        }
    }

    public final class CreateStorePersister
    extends Command {
        public final void doCreate(String persisterName, String persisterClassName) {
            if (OdsConfigToolPlugin.this.persisters.get(persisterName.toLowerCase()) == null) {
                OdsConfigToolPlugin.this.tracer.log("Creating new store persister '" + persisterName + "'...", Tracer.Level.INFO);
                try {
                    StorePersisterDescriptor persister = StorePersisterDescriptor.create(persisterName, persisterClassName.equalsIgnoreCase("native") ? "com.neeve.rog.log.RogLog" : persisterClassName);
                    persister.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.persisters.put(persisterName.toLowerCase(), persister);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed creating new store persister '" + persisterName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store persister '" + persisterName + "' already exists and cannot be created.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: store_persister_create <persisterName> <native | persisterClassName>");
            } else {
                this.doCreate(args[0], args[1]);
            }
        }

        public final void help() {
            System.out.println("store_persister_create");
            System.out.println("  Creates a new store persister in the repository");
        }

        public final String[] keywords() {
            return new String[]{"store_persister_create"};
        }
    }

    public final class DeleteStoreReplicator
    extends Command {
        public final void doDelete(String replicatorName) {
            StoreReplicatorDescriptor replicator = (StoreReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.replicators.get(replicatorName.toLowerCase()));
            if (replicator != null) {
                OdsConfigToolPlugin.this.tracer.log("Deleting store replicator '" + replicator.getName() + "'...", Tracer.Level.INFO);
                try {
                    replicator.delete(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.replicators.remove(replicatorName);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed deleting store replicator '" + replicator.getName() + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store replicator '" + replicatorName + "' does not exist, it cannot be deleted.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_replicator_delete <replicatorName>");
            } else {
                this.doDelete(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_replicator_delete");
            System.out.println("  Deletes a store replicator from the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_replicator_delete"};
        }
    }

    public final class ListStoreReplicators
    extends Command {
        public final void doList() {
            if (OdsConfigToolPlugin.this.replicators.size() > 0) {
                Iterator iterator = OdsConfigToolPlugin.this.replicators.keySet().iterator();
                while (iterator.hasNext()) {
                    StoreReplicatorDescriptor replicator = (StoreReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.replicators.get(((String)iterator.next()).toLowerCase()));
                    System.out.println("  " + replicator.getName() + " - " + (Object)((Object)replicator));
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("No store replicators in repository.", Tracer.Level.INFO);
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: store_replicators");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("store_replicators");
            System.out.println("  Lists the store replicators in the repository.");
        }

        public final String[] keywords() {
            return new String[]{"store_replicators"};
        }
    }

    public final class SetStoreReplicatorProperty
    extends Command {
        public final void doSet(String replicatorName, String propName, String propVal) {
            StoreReplicatorDescriptor replicator = (StoreReplicatorDescriptor)((Object)OdsConfigToolPlugin.this.replicators.get(replicatorName.toLowerCase()));
            if (replicator != null) {
                OdsConfigToolPlugin.this.tracer.log("Setting property '" + propName + "=" + propVal + " property in store replicator '" + replicatorName + "'...", Tracer.Level.INFO);
                try {
                    replicator.setProperty(propName, propVal);
                    replicator.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed setting property '" + propName + "=" + propVal + " property in store replicator '" + replicatorName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store replicator '" + replicatorName + "' does not exist, cannot set its properties.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 3) {
                System.out.println("Syntax error: store_replicator_set_property <replicatorName> <propName> <propVal>");
            } else {
                this.doSet(args[0], args[1], args[2]);
            }
        }

        public final void help() {
            System.out.println("store_replicator_set_property");
            System.out.println("  Sets a store replicator property");
        }

        public final String[] keywords() {
            return new String[]{"store_replicator_set_property"};
        }
    }

    public final class CreateStoreReplicator
    extends Command {
        public final void doCreate(String replicatorName) {
            if (OdsConfigToolPlugin.this.replicators.get(replicatorName.toLowerCase()) == null) {
                OdsConfigToolPlugin.this.tracer.log("Creating new store replicator '" + replicatorName + "'...", Tracer.Level.INFO);
                try {
                    StoreReplicatorDescriptor replicator = StoreReplicatorDescriptor.create(replicatorName);
                    replicator.save(OdsConfigToolPlugin.this.repo);
                    OdsConfigToolPlugin.this.replicators.put(replicatorName.toLowerCase(), replicator);
                    OdsConfigToolPlugin.this.tracer.log("Success.", Tracer.Level.INFO);
                }
                catch (Exception e) {
                    OdsConfigToolPlugin.this.tracer.log("Failed creating new store replicator '" + replicatorName + "' [" + e.toString() + "]", Tracer.Level.SEVERE);
                }
            } else {
                OdsConfigToolPlugin.this.tracer.log("store replicator '" + replicatorName + "' already exists and cannot be created.", Tracer.Level.WARNING);
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: store_replicator_create <replicatorName>");
            } else {
                this.doCreate(args[0]);
            }
        }

        public final void help() {
            System.out.println("store_replicator_create");
            System.out.println("  Creates a new store replicator in the repository");
        }

        public final String[] keywords() {
            return new String[]{"store_replicator_create"};
        }
    }
}

