/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.neeve.adm.test.unit.proto.Child1;
import com.neeve.adm.test.unit.proto.Child2;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.proto.Parent;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreQueryEngine;
import com.neeve.ods.IStoreQueryResultSet;
import com.neeve.ods.StoreDescriptor;
import com.neeve.query.QueryException;
import com.neeve.query.impl.util.UtlQueryResultFormatter;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import com.neeve.util.UtlTableFormatter;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class RogOdsStateQueryTest
extends RogReplicatedStoreTestBase {
    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        return Arrays.asList(new Factory());
    }

    @Before
    public void setup() {
        this.persistent = false;
    }

    @Before
    public void after() throws InterruptedException {
        RogOdsStateQueryTest.closeOpenMembers();
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        descriptor.setQueryable(true);
    }

    @Test
    public final void testNestedEntityPathsUnsupported() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        queryEngine.getField("Child1.childField");
        queryEngine.getField("Child1.childField.intField");
        queryEngine.getField("Object.childField.intField");
        queryEngine.getField("childField.intField");
        try {
            queryEngine.getField("Parent.entityField.intField");
            Assert.fail((String)"Shouldn't be able to create nested entity field");
        }
        catch (QueryException qe) {
            Assert.assertTrue((String)("Wrong error message: " + qe.getMessage()), (qe.getMessage().indexOf("nested") != -1 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField((Class)Child2.class, "intField");
            Assert.fail((String)"Shouldn't be able to create non entity field");
        }
        catch (QueryException qe) {
            Assert.assertTrue((String)("Wrong error message: " + qe.getMessage()), (qe.getMessage().indexOf("field type must be an entity") != -1 ? 1 : 0) != 0);
        }
        try {
            queryEngine.getField((Class)Child2.class, "intField");
            Assert.fail((String)"Shouldn't be able to create non entity field");
        }
        catch (QueryException qe) {
            Assert.assertTrue((String)("Wrong error message: " + qe.getMessage()), (qe.getMessage().indexOf("field type must be an entity") != -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public final void testQueryAfterPut() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        queryEngine.createIndex("Parent.fixlenField", false);
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent", (Object)parent, (Object)result.getStoreObject());
        result.close();
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent on backup", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    public final void testQueryAfterPutPreCommit() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        queryEngine.createIndex("Parent.fixlenField", false);
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent", (Object)parent, (Object)result.getStoreObject());
        result.close();
        m1.commit(true);
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    @Ignore(value="Modifications to nested fields are invisible to the store. Need to fix this.")
    public final void testQueryNestedFieldAfterPut() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField nestedIntField = queryEngine.getField("Child1.childField.intField");
        queryEngine.createIndex(nestedIntField, false);
        this.backupMember().getQueryEngine().createIndex(nestedIntField, false);
        Parent parent = Parent.create(this.nextGraphId());
        m1.addRootObject(parent);
        m1.commit(true);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(nestedIntField);
        parent.setFixlenField(10);
        Child1 child = Child1.create();
        parent.setEntityField(child);
        Child2 nested = Child2.create();
        child.setChildField(nested);
        nested.setIntField(10);
        m1.commit(true);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, childField.intField FROM " + this.getStoreName() + " WHERE Child1.childField.intField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find entity", (Object)child, (Object)result.getStoreObject());
        result.close();
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, childField.intField FROM " + this.getStoreName() + " WHERE Child1.childField.intField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find entity on backup", (Object)child.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    @Ignore(value="Modifications to nested fields are invisible to the store. Need to fix this.")
    public final void testQueryNestedFieldAfterPutPreCommit() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField nestedIntField = queryEngine.getField("Child1.childField.intField");
        queryEngine.createIndex(nestedIntField, false);
        this.backupMember().getQueryEngine().createIndex(nestedIntField, false);
        Parent parent = Parent.create(this.nextGraphId());
        m1.addRootObject(parent);
        m1.commit(true);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(nestedIntField);
        parent.setFixlenField(10);
        Child1 child = Child1.create();
        parent.setEntityField(child);
        Child2 nested = Child2.create();
        child.setChildField(nested);
        nested.setIntField(10);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, childField.intField FROM " + this.getStoreName() + " WHERE Child1.childField.intField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find entity", (Object)parent, (Object)result.getStoreObject());
        result.close();
        m1.commit(true);
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, childField.intField FROM " + this.getStoreName() + " WHERE Child1.childField.intField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find entity on backup", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    public final void testQueryAfterRemove() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        queryEngine.createIndex("Parent.fixlenField", false);
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent", (Object)parent, (Object)result.getStoreObject());
        result.close();
        m1.removeRootObject(parent);
        m1.commit(true);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)index.containsKey(10));
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
    }

    @Test
    public final void testQueryAfterRemovePreCommit() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        queryEngine.createIndex("Parent.fixlenField", false);
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(10));
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.first();
        Assert.assertEquals((String)"Didn't find parent", (Object)parent, (Object)result.getStoreObject());
        result.close();
        m1.commit(true);
        m1.removeRootObject(parent);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)index.containsKey(10));
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        m1.commit(true);
        result = this.backupMember().getQueryEngine().execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results on backup", (long)0L, (long)result.getCount());
        result.close();
    }

    @Test
    public final void testQueryAfterUpdate() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        queryEngine.createIndex("Parent.fixlenField", false);
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Got unexpected results", (long)1L, (long)result.getCount());
        result.close();
        parent.setFixlenField(20);
        m1.commit(true);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)index.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(20));
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent, (Object)result.getStoreObject());
        result.close();
        IStoreQueryEngine backupQueryEngine = this.backupMember().getQueryEngine();
        IdxNonUniqueIndex backupIndex = this.backupMember().getStore().asQueryRepository().getNonUniqueIndex(fixLenField);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)backupIndex.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)backupIndex.containsKey(20));
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    public final void testQueryAfterUpdatePreCommit() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        queryEngine.createIndex("Parent.fixlenField", false);
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Got unexpected results", (long)1L, (long)result.getCount());
        result.close();
        m1.commit(true);
        parent.setFixlenField(20);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)index.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(20));
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent, (Object)result.getStoreObject());
        result.close();
        IStoreQueryEngine backupQueryEngine = this.backupMember().getQueryEngine();
        IdxNonUniqueIndex backupIndex = this.backupMember().getStore().asQueryRepository().getNonUniqueIndex(fixLenField);
        m1.commit(true);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)backupIndex.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)backupIndex.containsKey(20));
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    public final void testQueryAfterSavepointUpdateRollback() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField fixLenField = queryEngine.getField("Parent.fixlenField");
        queryEngine.createIndex("Parent.fixlenField", false);
        this.backupMember().getQueryEngine().createIndex("Parent.fixlenField", false);
        IdxNonUniqueIndex index = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(fixLenField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        IStoreQueryResultSet result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Got unexpected results", (long)1L, (long)result.getCount());
        result.close();
        parent.setFixlenField(20);
        int savePoint = m1.getStore().createSavepoint();
        parent.setFixlenField(30);
        m1.getStore().rollback(savePoint);
        m1.commit(true);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)index.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)index.containsKey(20));
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = queryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent, (Object)result.getStoreObject());
        result.close();
        IStoreQueryEngine backupQueryEngine = this.backupMember().getQueryEngine();
        IdxNonUniqueIndex backupIndex = this.backupMember().getStore().asQueryRepository().getNonUniqueIndex(fixLenField);
        Assert.assertFalse((String)"Index should no longer have the old value", (boolean)backupIndex.containsKey(10));
        Assert.assertTrue((String)"Index should have the new value", (boolean)backupIndex.containsKey(20));
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 10");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        result.beforeFirst();
        Assert.assertEquals((String)"Got unexpected results", (long)0L, (long)result.getCount());
        result.close();
        result = backupQueryEngine.execute("SELECT transactionId, fixlenField FROM " + this.getStoreName() + " WHERE Parent.fixlenField = 20");
        UtlQueryResultFormatter.dumpNext(result, 10, UtlTableFormatter.Format.TABULAR, System.out);
        Assert.assertEquals((String)"Didn't get updated result", (long)1L, (long)result.getCount());
        result.first();
        Assert.assertEquals((String)"Got unexpected result", (Object)parent.getId(), (Object)result.getStoreObject().getId());
        result.close();
    }

    @Test
    public final void testQueryAfterSavepointPutRollback() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField intField = queryEngine.getField("Child1.intField");
        queryEngine.createIndex("Child1.intField", false);
        this.backupMember().getQueryEngine().createIndex("Child1.intField", false);
        IdxNonUniqueIndex intFieldIndex = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(intField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        int savePoint = m1.getStore().createSavepoint();
        Child1 child = Child1.create();
        child.setIntField(20);
        parent.setEntityField(child);
        Assert.assertTrue((String)"Index should have indexed Child.intFieldValue", (boolean)intFieldIndex.containsKey(20));
        m1.getStore().rollback(savePoint);
        Assert.assertFalse((String)"Index should have removed Child.intFieldValue on remove", (boolean)intFieldIndex.containsKey(20));
        m1.commit(true);
    }

    @Test
    public final void testQueryAfterSavepointRemoveRollback() throws Exception {
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        IStoreQueryEngine queryEngine = m1.getQueryEngine();
        IdxField intField = queryEngine.getField("Child1.intField");
        queryEngine.createIndex("Child1.intField", false);
        this.backupMember().getQueryEngine().createIndex("Child1.intField", false);
        IdxNonUniqueIndex intFieldIndex = queryEngine.getRepositories().iterator().next().getNonUniqueIndex(intField);
        Parent parent = Parent.create(this.nextGraphId());
        parent.setFixlenField(10);
        m1.addRootObject(parent);
        m1.commit(true);
        Child1 child = Child1.create();
        child.setIntField(20);
        parent.setEntityField(child);
        m1.commit(true);
        int savePoint = m1.getStore().createSavepoint();
        parent.setEntityField(null);
        Assert.assertFalse((String)"Index should have removed Child.intFieldValue on remove", (boolean)intFieldIndex.containsKey(20));
        m1.getStore().rollback(savePoint);
        Assert.assertTrue((String)"Index should have indexed Child.intFieldValue", (boolean)intFieldIndex.containsKey(20));
        m1.commit(true);
    }

    static {
        XRuntime.getProps().setProperty("nv.discovery.descriptor", "loopback://discovery&initWaitTime=1");
    }
}

