/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.event.Event;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.ods.impl.StorePersisterCompactionCompletedEvent;
import com.neeve.ods.impl.StorePersisterCompactionErrorEvent;
import com.neeve.ods.impl.StorePersisterCompactionStartedEvent;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCheckpointReaderParams;
import com.neeve.rog.log.RogLogCompactionReader;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public final class RogLogCompactor
extends RogObject {
    private static final Tracer tracer = Tracer.get((String)"nv.rog.compaction");
    private final RogLog log;
    private final Params params;
    private long maxCompactionWindowSize;
    private volatile long newLogInitialLogSize = -1L;
    private volatile State state;
    private Exception compactionCompletionStatus;
    private long logPosAtCompactStartTime;
    private Runner runner;
    public static final String PROP_ENTRY_RETENTION_THRESHOLD = "compaction.entryRetentionThreshold";
    public static final String PROP_CONFLATE_CHECKPOINTS = "compaction.conflateCheckpoints";
    public static final String PROP_SKIP_CDC_CHECKPOINTED = "compaction.skipCdcCheckpointed";
    public static final String PROP_OFF_HEAP_BUFFERING = "compaction.offheapBuffering";
    public static final String PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY = "compaction.offheapBufferingLoadStrategy";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_LOAD = "compaction.memMappedReadBufferLoad";
    public static final String PROP_MEM_MAPPED_READ_BUFFER_MAX_SIZE = "compaction.memMappedReadBufferMaxSize";
    public static final String PROP_MAX_COMPACTION_WINDOW_SIZE = "compaction.maxCompactionWindowSize";
    public static final String PROP_COMPACTION_THRESHOLD = "compaction.compactionThreshold";

    RogLogCompactor(RogLog log, Params params) {
        this.log = log;
        this.maxCompactionWindowSize = params.maxCompactionWindowSize;
        this.params = params;
        this.state = State.NotStarted;
        this.runner = new Runner(log);
    }

    static Properties loadProperties(Properties props, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Properties compactorProps = new Properties();
        compactorProps.putAll((Map<?, ?>)RogLogCheckpointReaderParams.defaultProps);
        compactorProps.put("conflateCheckpoints", "true");
        compactorProps.put("entryRetentionThreshold", "0");
        compactorProps.put("offheapBuffering", "true");
        compactorProps.put("offheapBufferingLoadStrategy", RogLogCheckpointReaderParams.PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT.name());
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key = String.valueOf(prop.getKey());
            if (!key.startsWith(prefix)) continue;
            compactorProps.put(key.substring(prefix.length() + 1), prop.getValue());
        }
        return compactorProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setState(State state) {
        RogLogCompactor rogLogCompactor = this;
        synchronized (rogLogCompactor) {
            this.state = state;
            switch (this.state) {
                case Complete: 
                case Failed: 
                case InProgress: {
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }
    }

    final void start() {
        if (this.runner == null || !this.runner.isAlive()) {
            tracer.log("[Compactor] starting up.", Tracer.Level.INFO);
            this.runner = new Runner(this.log);
            this.runner.start();
        }
    }

    public final synchronized void setMaxCompactionWindowSize(double size, UtlUnit.ByteUnit byteUnit) {
        if (size <= 0.0) {
            throw new IllegalArgumentException(size + " is invalid. Compaction windows size must be positive");
        }
        if (this.isCompactionInProgress()) {
            throw new IllegalStateException("Cannot change compaction window size will compaction is in progress.");
        }
        this.maxCompactionWindowSize = (long)UtlUnit.convertBytes((double)size, (UtlUnit.ByteUnit)byteUnit, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
    }

    public final synchronized double getMaxCompactionWindowSize(UtlUnit.ByteUnit unit) {
        return UtlUnit.convertBytes((double)this.maxCompactionWindowSize, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)unit);
    }

    public final synchronized void setMaxCompactionWindowSize(long size) {
        this.setMaxCompactionWindowSize(size, UtlUnit.ByteUnit.Megabytes);
    }

    public final synchronized long getMaxCompactionWindowSize() {
        return this.maxCompactionWindowSize;
    }

    public final void setNewLogInitialLogSize(long initialLogSize) {
        this.newLogInitialLogSize = initialLogSize;
    }

    public final long getNewLogInitialLogSize() {
        return this.newLogInitialLogSize;
    }

    public final State getState() {
        return this.state;
    }

    public final RogLogCompactor compact(long forceCheckpointCompletionOn) {
        if (!this.log.isOpen()) {
            throw new IllegalStateException("log is not open");
        }
        switch (this.state) {
            case InProgress: 
            case Compacted: {
                throw new IllegalStateException("compaction in progress (state='" + (Object)((Object)this.state) + "')");
            }
        }
        tracer.log("[Compactor] Compacting log '" + this.log.getName() + "'...", Tracer.Level.INFO);
        this.logPosAtCompactStartTime = this.log.getNextWritePointer();
        if (RogLogCompactor.tracer.fine) {
            tracer.log("[Compactor] Compaction marker is " + this.logPosAtCompactStartTime + ".", Tracer.Level.FINE);
        }
        this.compactionCompletionStatus = null;
        this.start();
        this.runner.setForceCheckpointCompletionOn(forceCheckpointCompletionOn);
        this.setState(State.InProgress);
        return this;
    }

    public final RogLogCompactor compact() {
        return this.compact(0L);
    }

    public final boolean isCompactionInProgress() {
        switch (this.state) {
            case InProgress: 
            case Compacted: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForCompactionToComplete() throws Exception {
        RogLogCompactor rogLogCompactor = this;
        synchronized (rogLogCompactor) {
            if (this.state == State.NotStarted) {
                throw new IllegalStateException("compact not started");
            }
            while (this.state != State.Complete && this.state != State.Failed) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.state != State.Failed) continue;
                throw this.compactionCompletionStatus;
            }
        }
    }

    public final void stop() {
        if (this.runner != null) {
            this.runner.shutdown();
            while (true) {
                try {
                    this.runner.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static enum State {
        NotStarted,
        InProgress,
        Compacted,
        Complete,
        Failed;

    }

    public static final class Params
    extends RogLogCheckpointReaderParams {
        public static final String PROP_COMPACTION_THRESHOLD = "compactionThreshold";
        public static final String PROP_COMPACTION_THRESHOLD_DEFAULT = "0";
        public static final String PROP_MAX_COMPACTION_WINDOW_SIZE = "maxCompactionWindowSize";
        public static final String PROP_MAX_COMPACTION_WINDOW_SIZE_DEFAULT = "1gb";
        public static final String PROP_COMPACT_ON_START = "compactOnStart";
        public static final boolean PROP_COMPACT_ON_START_DEFAULT = false;
        long maxCompactionWindowSize;
        long compactionThreshold;
        boolean compactOnStart;

        private Params(Properties props) {
            super(props);
            this.compactionThreshold = (long)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)props, (String)PROP_COMPACTION_THRESHOLD, (String)PROP_COMPACTION_THRESHOLD_DEFAULT), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            this.maxCompactionWindowSize = (long)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)props, (String)PROP_MAX_COMPACTION_WINDOW_SIZE, (String)PROP_MAX_COMPACTION_WINDOW_SIZE_DEFAULT), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            this.compactOnStart = UtlProps.getValue((Properties)props, (String)PROP_COMPACT_ON_START, (boolean)false);
        }

        public static Params create(Properties props) {
            String prefix = "compaction.";
            Properties compactorProps = new Properties();
            compactorProps.putAll((Map<?, ?>)defaultProps);
            compactorProps.put("conflateCheckpoints", "true");
            compactorProps.put("entryRetentionThreshold", PROP_COMPACTION_THRESHOLD_DEFAULT);
            compactorProps.put("offheapBuffering", "true");
            compactorProps.put("offheapBufferingLoadStrategy", PROP_OFF_HEAP_BUFFERING_LOAD_STRATEGY_DEFAULT.name());
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                String key = String.valueOf(prop.getKey());
                if (!key.startsWith("compaction.")) continue;
                compactorProps.put(key.substring("compaction.".length()), prop.getValue());
            }
            return new Params(compactorProps);
        }

        void dump(String prefix, StringBuilder sb) {
            sb.append(prefix).append("compactor {\n");
            sb.append(prefix).append("...").append(PROP_COMPACTION_THRESHOLD).append("=").append(this.compactionThreshold).append(" (").append(UtlUnit.readableBytesSize((long)this.compactionThreshold)).append(")\n");
            sb.append(prefix).append("...").append(PROP_MAX_COMPACTION_WINDOW_SIZE).append("=").append(this.maxCompactionWindowSize).append(" (").append(UtlUnit.readableBytesSize((long)this.maxCompactionWindowSize)).append(")");
            sb.append(this.conflateCheckpoints ? " (N/A)" : "").append("\n");
            sb.append(prefix).append("...").append(PROP_COMPACT_ON_START).append("=").append(this.compactOnStart);
            sb.append("\n");
            sb.append(prefix).append("...reader {\n");
            super.dump(sb, prefix + "......");
            sb.append(prefix).append("...}\n");
            sb.append(prefix).append("}\n");
        }
    }

    private final class Runner
    extends Thread {
        private final CompactionReadHandler handler;
        private final RogLogCompactionReader reader;
        private volatile boolean closed;
        private long forceCheckpointCompletionOn;

        Runner(RogLog log) {
            super("X-RogLogCompactor-" + log.getName());
            this.handler = new CompactionReadHandler();
            this.reader = RogLogCompactionReader.create(log, this.handler, tracer, RogLogCompactor.this.params);
        }

        final void setForceCheckpointCompletionOn(long forceCheckpointCompletionOn) {
            this.forceCheckpointCompletionOn = forceCheckpointCompletionOn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void shutdown() {
            RogLogCompactor rogLogCompactor = RogLogCompactor.this;
            synchronized (rogLogCompactor) {
                this.closed = true;
                if (this.reader != null) {
                    this.reader.close();
                }
                ((Object)((Object)RogLogCompactor.this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            while (true) {
                RogLogCompactor rogLogCompactor = RogLogCompactor.this;
                synchronized (rogLogCompactor) {
                    if (this.closed || !RogLogCompactor.this.log.isOpen()) {
                        if (tracer.fine) {
                            tracer.log("[Compactor] Exiting run (closed)...", Tracer.Level.FINE);
                        }
                        // MONITOREXIT @DISABLED, blocks:[33, 22, 7] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                        tracer.log("[Compactor] Shutting down...", Tracer.Level.INFO);
                        return;
                    }
                    if (RogLogCompactor.this.state != State.InProgress) {
                        try {
                            if (tracer.fine) {
                                tracer.log("[Compactor] Waiting to compact (state=" + (Object)((Object)RogLogCompactor.this.state) + ")", Tracer.Level.FINE);
                            }
                            ((Object)((Object)RogLogCompactor.this)).wait();
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                RogLogMetadata metadata = RogLogCompactor.this.log.getMetadata();
                PktRecoveryLog pktlog = RogLogCompactor.this.log.getPacketLog();
                int liveLogNumber = metadata.getLiveLogNumber();
                PktRecoveryLog compactLog = null;
                try {
                    long originalSize = RogLogCompactor.this.log.getSize();
                    long originalFileSize = RogLogCompactor.this.log.getAllocatedSize();
                    tracer.log("[Compactor] Starting compaction  (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [size: " + UtlFile.readableFileSize((long)originalSize) + ", fileSize=" + UtlFile.readableFileSize((long)originalFileSize) + "] ...", Tracer.Level.INFO);
                    RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionStartedEvent.create(null, RogLogCompactor.this.log, originalSize, originalFileSize));
                    RogLogCompactor.this.log.backupLog(liveLogNumber + 1, true);
                    compactLog = PktRecoveryLog.create((String)pktlog.getDirname(), (String)RogLogCompactor.this.log.logFilename(liveLogNumber + 1), (PktRecoveryLog.FileOpenMode)PktRecoveryLog.FileOpenMode.rw, (long)(RogLogCompactor.this.newLogInitialLogSize >= 0L ? RogLogCompactor.this.newLogInitialLogSize : pktlog.getInitialLength()), (boolean)pktlog.isZeroOutInitial(), (boolean)pktlog.isFlushUsingMappedMemory(), (int)pktlog.getAutoFlushSize(), (int)pktlog.getPageSize());
                    compactLog.open(pktlog.supportsTailing() ? 128 : 0);
                    long ts = System.currentTimeMillis();
                    this.handler.initialize(compactLog);
                    if (this.closed) {
                        throw new Exception("compactor was closed before run completed");
                    }
                    RogLogCompactionReader.RunCompletionReason completionReason = this.reader.run(liveLogNumber, RogLogCompactor.this.logPosAtCompactStartTime);
                    switch (completionReason) {
                        case LogNotCheckpointed: {
                            throw new Exception("log is not checkpointed and so cannot be compacted.");
                        }
                        case EndOfFile: {
                            throw new Exception("end of file reached during compaction run");
                        }
                        case MaxFilePointerReached: {
                            break;
                        }
                        case Closed: {
                            throw new Exception("compactor was closed before run completed");
                        }
                        default: {
                            throw new IllegalStateException("Received unknown error from compaction reader [" + (Object)((Object)completionReason) + "]");
                        }
                    }
                    this.handler.flush(true);
                    tracer.log("[Compactor] Compaction of stablized checkpoint entries complete (" + this.handler.numWritten + " entries written out of " + this.handler.numEntries + " across " + this.handler.numCheckpoints + " checkpoints in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - ts), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
                    RogLogCompactor.this.setState(State.Compacted);
                    if (tracer.fine) {
                        tracer.log("[Compactor] Copying uncompacted entries...", Tracer.Level.FINE);
                    }
                    int count = 0;
                    long compactedEntriesSize = 0L;
                    long uncompactedEntriesSize = 0L;
                    long uncompactCopyStart = System.currentTimeMillis();
                    RogLogCompactor.this.log.getCompactionSynchronizer().lock();
                    try {
                        PktPacket entry;
                        RogLogCompactor.this.log.doFlush(false);
                        if (this.closed) {
                            throw new Exception("compactor was closed before run completed");
                        }
                        compactedEntriesSize = compactLog.getSize();
                        while ((entry = this.reader.next()) != null) {
                            if (this.closed) {
                                throw new Exception("compactor was closed before run completed");
                            }
                            compactLog.write(entry, 0);
                            entry.dispose();
                            ++count;
                        }
                        uncompactedEntriesSize = compactLog.getSize();
                        metadata.setLiveLogNumber(liveLogNumber + 1);
                        RogLogCompactor.this.log.setPacketLog(compactLog);
                        compactLog = null;
                        if (tracer.fine) {
                            tracer.log("[Compactor] Switched live log to '" + RogLogCompactor.this.log.logFilename(), Tracer.Level.FINE);
                        }
                    }
                    finally {
                        RogLogCompactor.this.log.getCompactionSynchronizer().unlock();
                    }
                    long uncompactedCopyTime = Math.max(1L, System.currentTimeMillis() - uncompactCopyStart);
                    if (tracer.fine) {
                        tracer.log("[Compactor] Uncompacted copy completed in " + UtlUnit.formatDuration((double)uncompactedCopyTime, (TimeUnit)TimeUnit.MILLISECONDS) + " (" + count + " entries @ " + (long)(count * 1000) / uncompactedCopyTime + "/sec - " + UtlUnit.readableBytesSize((long)(uncompactedEntriesSize - compactedEntriesSize)) + " @ " + UtlUnit.readableBytesSize((long)((uncompactedEntriesSize - compactedEntriesSize) * 1000L / uncompactedCopyTime)) + "/sec)...", Tracer.Level.FINE);
                    }
                    long newSize = RogLogCompactor.this.log.getSize();
                    long newFileSize = RogLogCompactor.this.log.getAllocatedSize();
                    long originalEntryCount = this.handler.numEntries;
                    long newEntryCount = count + this.handler.numWritten;
                    tracer.log("[Compactor] Compaction complete (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [entries: " + originalEntryCount + "->" + newEntryCount + ", size: " + UtlUnit.readableBytesSize((long)originalSize) + "->" + UtlUnit.readableBytesSize((long)newSize) + ", fileSize:" + UtlUnit.readableBytesSize((long)originalFileSize) + "->" + UtlUnit.readableBytesSize((long)newFileSize) + ")].", Tracer.Level.INFO);
                    this.reader.releaseReaderFiles();
                    RogLogCompactor.this.setState(State.Complete);
                    RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionCompletedEvent.create(null, RogLogCompactor.this.log, originalSize, originalFileSize, newSize, newFileSize));
                    RogLogCompactor.this.log.scavenge();
                    continue;
                }
                catch (Exception e) {
                    tracer.log("[Compactor] Error encountered in compaction " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    try {
                        if (compactLog != null) {
                            compactLog.close();
                        }
                        if (this.reader != null) {
                            this.reader.releaseReaderFiles();
                        }
                    }
                    catch (Throwable thrown) {
                        tracer.log("[Compactor] Error cleaning up compaction files after run: " + thrown.getMessage(), Tracer.Level.SEVERE);
                    }
                    RogLogCompactor.this.compactionCompletionStatus = e;
                    RogLogCompactor.this.setState(State.Failed);
                    try {
                        RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionErrorEvent.create(null, RogLogCompactor.this.log, RogLogCompactor.this.compactionCompletionStatus));
                    }
                    catch (Throwable thrown) {
                        tracer.log("[Compactor] Error dispatching compaction exception event: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                    continue;
                }
                finally {
                    if (!tracer.verbose) continue;
                    tracer.log("[Compactor] Finished compaction run...", Tracer.Level.VERBOSE);
                    continue;
                }
                break;
            }
        }

        private final class CompactionReadHandler
        implements RogLogCompactionReader.ReadHandler {
            private final XIndexedList<RogLogCompactionReader.CompactionReaderEntry> writeEntries = new XIndexedList();
            private PktRecoveryLog compactLog;
            private long currentCompactionWindowSize;
            private boolean compactionWindowExceeded;
            private long currentCheckpointVersion;
            private long processingCheckpoint;
            int numCheckpoints;
            int numEntries;
            int numWritten;

            CompactionReadHandler() {
            }

            private final CompactionReadHandler initialize(PktRecoveryLog compactLog) {
                this.compactLog = compactLog;
                this.writeEntries.clear();
                this.currentCompactionWindowSize = 0L;
                this.compactionWindowExceeded = false;
                this.currentCheckpointVersion = 0L;
                this.processingCheckpoint = 0L;
                this.numCheckpoints = 0;
                this.numEntries = 0;
                this.numWritten = 0;
                return this;
            }

            private final PktPacket touch(PktPacket packet, RogLogCompactionReader.ReadHandler.ChangeType changeType, boolean last) {
                PktSubheaderODS subheader = packet.getHeader().getODSSubheader();
                subheader.setStableTransactionId(this.currentCheckpointVersion);
                subheader.setTransactionId(this.currentCheckpointVersion);
                subheader.setCheckpointVersion(this.currentCheckpointVersion);
                subheader.setFlagCommitStart(false);
                subheader.setFlagCommitEnd(last);
                switch (changeType) {
                    case Put: {
                        subheader.setCommitEntryType((short)1);
                        break;
                    }
                    case Update: {
                        subheader.setCommitEntryType((short)2);
                        break;
                    }
                    case Remove: {
                        subheader.setCommitEntryType((short)3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown change type '" + (Object)((Object)changeType) + "'");
                    }
                }
                return packet;
            }

            private final RogLogCompactionReader.CompactionReaderEntry updateCompactionWindowSize(RogLogCompactionReader.CompactionReaderEntry entry) {
                this.currentCompactionWindowSize += (long)entry.getSizeOnDisk();
                if (tracer.debug) {
                    tracer.log("[Compactor] ...compaction window [current=" + this.currentCompactionWindowSize + ", max=" + RogLogCompactor.this.maxCompactionWindowSize + "]", Tracer.Level.DEBUG);
                }
                return entry;
            }

            final void flush(boolean endsTransaction) {
                if (this.writeEntries.size() > 0) {
                    this.writeEntries(this.writeEntries.size(), (Iterator<RogLogCompactionReader.CompactionReaderEntry>)this.writeEntries.iterator(), endsTransaction);
                    this.writeEntries.clear();
                }
            }

            final void writeEntries(int numEntries, Iterator<RogLogCompactionReader.CompactionReaderEntry> iterator, boolean endsTransaction) {
                IStats.Latencies writeLatencies;
                long start = System.currentTimeMillis();
                long initialLogSize = this.compactLog.getNextWritePointer();
                StringBuilder sb = new StringBuilder();
                if (tracer.verbose) {
                    tracer.log("[Compactor] ...Writing " + numEntries + " from checkpoint #" + this.processingCheckpoint + " into #" + this.currentCheckpointVersion, Tracer.Level.VERBOSE);
                }
                long count = 0L;
                long lastReport = start;
                long lastSize = initialLogSize;
                IStats.Latencies readLatencies = tracer.verbose ? StatsFactory.createLatencyStat((String)"read", (int)100000) : null;
                IStats.Latencies latencies = writeLatencies = tracer.verbose ? StatsFactory.createLatencyStat((String)"write", (int)100000) : null;
                while (iterator.hasNext()) {
                    RogLogCompactionReader.CompactionReaderEntry entry = iterator.next();
                    boolean last = endsTransaction && !iterator.hasNext();
                    long rs = System.nanoTime();
                    PktPacket packet = entry.getPacket();
                    if (tracer.verbose) {
                        readLatencies.add((double)(System.nanoTime() - rs));
                    }
                    long ws = System.nanoTime();
                    this.compactLog.write(this.touch(packet, entry.getEntryType(), last), 0);
                    packet.dispose();
                    if (tracer.verbose) {
                        writeLatencies.add((double)(System.nanoTime() - ws));
                    }
                    ++this.numWritten;
                    if (tracer.verbose && ++count % 100000L == 0L) {
                        long now = System.currentTimeMillis();
                        long currentSize = this.compactLog.getNextWritePointer();
                        tracer.log("[Compactor] ......Wrote " + count + " from checkpoint #" + this.processingCheckpoint + " into #" + this.currentCheckpointVersion + " in " + UtlUnit.formatDuration((double)(now - lastReport), (TimeUnit)TimeUnit.MILLISECONDS) + " [size=" + UtlUnit.readableBytesSize((long)this.compactLog.getNextWritePointer()) + " (" + UtlUnit.readableBytesSize((long)(currentSize - lastSize)) + ")]", Tracer.Level.VERBOSE);
                        readLatencies.compute();
                        readLatencies.get(sb, DecimalFormat.getNumberInstance());
                        writeLatencies.compute();
                        writeLatencies.get(sb, DecimalFormat.getNumberInstance());
                        tracer.log("[Compactor] ...Latencies:\n" + sb, Tracer.Level.VERBOSE);
                        sb.setLength(0);
                        lastReport = now;
                        lastSize = currentSize;
                    }
                    iterator.remove();
                    entry.dispose();
                }
                long end = System.currentTimeMillis();
                long currentSize = this.compactLog.getNextWritePointer();
                if (tracer.verbose) {
                    tracer.log("[Compactor] ...Wrote " + count + " from checkpoint #" + this.processingCheckpoint + " into #" + this.currentCheckpointVersion + " in " + UtlUnit.formatDuration((double)(end - start), (TimeUnit)TimeUnit.MILLISECONDS) + " [size=" + UtlUnit.readableBytesSize((long)this.compactLog.getNextWritePointer()) + " (" + UtlUnit.readableBytesSize((long)(currentSize - initialLogSize)) + ")]", Tracer.Level.VERBOSE);
                }
            }

            @Override
            public final boolean onCheckpointStart(long checkpointVersion) {
                boolean checkpointComplete;
                if (tracer.verbose) {
                    tracer.log("[Compactor] Checkpoint #" + checkpointVersion + " is stable. Compacting...", Tracer.Level.VERBOSE);
                }
                if (this.currentCheckpointVersion == 0L) {
                    this.currentCheckpointVersion = checkpointVersion;
                }
                ++this.numCheckpoints;
                boolean bl = checkpointComplete = this.compactionWindowExceeded || Runner.this.forceCheckpointCompletionOn > 0L && this.currentCheckpointVersion <= Runner.this.forceCheckpointCompletionOn && checkpointVersion > Runner.this.forceCheckpointCompletionOn;
                if (!this.writeEntries.isEmpty()) {
                    this.flush(checkpointComplete);
                }
                this.processingCheckpoint = checkpointVersion;
                if (checkpointComplete) {
                    this.currentCheckpointVersion = checkpointVersion;
                }
                return false;
            }

            @Override
            public void handleConflatedChanges(XLinkedHashMap<UUID, RogLogCompactionReader.CompactionReaderEntry> entries) {
                if (tracer.debug) {
                    tracer.log("[Compactor] Received conflated change set, entries=" + entries.size() + ")...", Tracer.Level.DEBUG);
                }
                this.numEntries += entries.size();
                this.writeEntries(entries.size(), (Iterator<RogLogCompactionReader.CompactionReaderEntry>)entries.reuseableValueIterator(), true);
                entries.clear();
            }

            @Override
            public final void handleChange(RogLogCompactionReader.ReadHandler.ChangeType changeType, List<RogLogCompactionReader.CompactionReaderEntry> entries) {
                this.numEntries += entries.size();
                if (tracer.debug) {
                    tracer.log("[Compactor] Received change (type=" + (Object)((Object)changeType) + "', entries=" + entries.size() + ")...", Tracer.Level.DEBUG);
                }
                switch (changeType) {
                    case Put: 
                    case Update: 
                    case Remove: {
                        RogLogCompactionReader.CompactionReaderEntry lastEntry = entries.get(entries.size() - 1);
                        lastEntry.type = changeType;
                        this.writeEntries.add((Object)this.updateCompactionWindowSize(entries.get(entries.size() - 1)));
                        break;
                    }
                    case Send: {
                        if (!tracer.debug) break;
                        tracer.log("[Compactor] ...entry is a send. Nothing to be done .", Tracer.Level.DEBUG);
                        break;
                    }
                    case Noop: {
                        if (!tracer.debug) break;
                        tracer.log("[Compactor] ...entry is a noop. Nothing to be done .", Tracer.Level.DEBUG);
                    }
                }
                for (int i = 0; i < entries.size() - 1; ++i) {
                    entries.get(i).dispose();
                }
                entries.clear();
            }

            @Override
            public final void onCheckpointComplete(long checkpointVersion, int numEntriesConflated, int numCheckpointsConflated) {
                this.numEntries += numEntriesConflated;
                this.numCheckpoints += numCheckpointsConflated;
                if (tracer.verbose) {
                    tracer.log("[Compactor] Checkpoint #" + checkpointVersion + " complete... [window " + this.currentCompactionWindowSize + "/" + RogLogCompactor.this.maxCompactionWindowSize + "]", Tracer.Level.VERBOSE);
                }
                if (this.compactionWindowExceeded = this.currentCompactionWindowSize >= RogLogCompactor.this.maxCompactionWindowSize) {
                    this.currentCompactionWindowSize = 0L;
                    if (tracer.verbose) {
                        tracer.log("[Compactor] Compaction window exceeded. Checkpoint version = " + this.currentCheckpointVersion + "...", Tracer.Level.VERBOSE);
                    }
                }
            }

            @Override
            public final void onWait() {
                tracer.log("[Compactor] Waiting for additional entries to compact...", Tracer.Level.WARNING);
            }
        }
    }
}

