/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreReplicatorStats;
import com.neeve.ods.IStoreSenderStats;
import com.neeve.ods.impl.StoreBindingImpl;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;

final class StoreBindingStats
extends Stats
implements IStoreBindingStats {
    private final NumberFormat format;
    private long startTime;
    private long deltaStartTime;
    private StoreBindingImpl binding;
    private long numCommitsSentLast;
    private long numCommitEntriesSentLast;
    private long numCommitsReceivedLast;
    private long numCommitEntriesReceivedLast;
    private long numCommitCompletionsSentLast;
    private long numCommitCompletionsReceivedLast;
    volatile long numCommitsSent;
    volatile long numCommitEntriesSent;
    volatile long numCommitsReceived;
    volatile long numCommitEntriesReceived;
    volatile long numCommitCompletionsSent;
    volatile long numCommitCompletionsReceived;
    volatile long storeDataSize;
    final Stats.LatencyManager cqs = new Stats.LatencyManager("cqs");
    final Stats.LatencyManager s = new Stats.LatencyManager("  s");
    final Stats.LatencyManager s2w = new Stats.LatencyManager("s2w");
    final Stats.LatencyManager s2p = new Stats.LatencyManager("s2p");
    final Stats.LatencyManager w = new Stats.LatencyManager("  w");
    final Stats.LatencyManager w2d = new Stats.LatencyManager("w2d");
    final Stats.LatencyManager d = new Stats.LatencyManager("  d");
    final Stats.LatencyManager per = new Stats.LatencyManager("per");
    final Stats.LatencyManager icr = new Stats.LatencyManager("icr");
    final Stats.LatencyManager idx = new Stats.LatencyManager("idx");
    final Stats.LatencyManager c = new Stats.LatencyManager("  c");

    StoreBindingStats(StoreBindingImpl binding, String name, String startProp) {
        super("nv.ods", name, "nv.ods.stats", startProp);
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.binding = binding;
        this.startPeriodicOutputIfConfigured();
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numCommitsSentLast = this.numCommitsSent;
        this.numCommitEntriesSentLast = this.numCommitEntriesSent;
        this.numCommitsReceivedLast = this.numCommitsReceived;
        this.numCommitEntriesReceivedLast = this.numCommitEntriesReceived;
        this.numCommitCompletionsSentLast = this.numCommitCompletionsSent;
        this.numCommitCompletionsReceivedLast = this.numCommitCompletionsReceived;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numCommitsSentCurrent = this.numCommitsSent;
        long numCommitEntriesSentCurrent = this.numCommitEntriesSent;
        long numCommitsReceivedCurrent = this.numCommitsReceived;
        long numCommitEntriesReceivedCurrent = this.numCommitEntriesReceived;
        long numCommitCompletionsSentCurrent = this.numCommitCompletionsSent;
        long numCommitCompletionsReceivedCurrent = this.numCommitCompletionsReceived;
        this.cqs.compute();
        this.s.compute();
        this.s2w.compute();
        this.s2p.compute();
        this.w.compute();
        this.w2d.compute();
        this.d.compute();
        this.per.compute();
        this.icr.compute();
        this.idx.compute();
        this.c.compute();
        String commitsSentStr = this.format.format(numCommitsSentCurrent);
        String commitSendRateStr = this.format.format(numCommitsSentCurrent * 1000L / deltaTotalTime);
        String deltaCommitSendRateStr = this.format.format((numCommitsSentCurrent - this.numCommitsSentLast) * 1000L / deltaTime);
        String packetsSentStr = this.format.format(numCommitEntriesSentCurrent);
        String packetSendRateStr = this.format.format(numCommitEntriesSentCurrent * 1000L / deltaTotalTime);
        String deltaPacketSendRateStr = this.format.format((numCommitEntriesSentCurrent - this.numCommitEntriesSentLast) * 1000L / deltaTime);
        String commitsReceivedStr = this.format.format(numCommitsReceivedCurrent);
        String commitReceiptRateStr = this.format.format(numCommitsReceivedCurrent * 1000L / deltaTotalTime);
        String deltaCommitReceiptRateStr = this.format.format((numCommitsReceivedCurrent - this.numCommitsReceivedLast) * 1000L / deltaTime);
        String packetsReceivedStr = this.format.format(numCommitEntriesReceivedCurrent);
        String packetReceiptStr = this.format.format(numCommitEntriesReceivedCurrent * 1000L / deltaTotalTime);
        String deltaPacketReceiptStr = this.format.format((numCommitEntriesReceivedCurrent - this.numCommitEntriesReceivedLast) * 1000L / deltaTime);
        String commitCompletionsSentStr = this.format.format(numCommitCompletionsSentCurrent);
        String commitCompletionSendRateStr = this.format.format(numCommitCompletionsSentCurrent * 1000L / deltaTotalTime);
        String deltaCommitCompletionSendRateStr = this.format.format((numCommitCompletionsSentCurrent - this.numCommitCompletionsSentLast) * 1000L / deltaTime);
        String commitCompletionsReceivedStr = this.format.format(numCommitCompletionsReceivedCurrent);
        String commitCompletionReceiveRateStr = this.format.format(numCommitCompletionsReceivedCurrent * 1000L / deltaTotalTime);
        String deltaCommitCompletionReceiveRateStr = this.format.format((numCommitCompletionsReceivedCurrent - this.numCommitCompletionsReceivedLast) * 1000L / deltaTime);
        sb.append("{");
        sb.append("role=").append((Object)this.getRole()).append(" ");
        sb.append("state=").append((Object)this.getState());
        sb.append("size=").append(this.binding.sizeUnprotected());
        sb.append("}").append("\n");
        sb.append("Commit..{").append("\n");
        sb.append("...In{");
        sb.append(commitsReceivedStr).append("(").append(commitReceiptRateStr).append(" ").append(deltaCommitReceiptRateStr).append(") ");
        sb.append(packetsReceivedStr).append("(").append(packetReceiptStr).append(" ").append(deltaPacketReceiptStr).append(") ");
        sb.append("}").append("\n");
        sb.append("...Out{");
        sb.append(commitsSentStr).append("(").append(commitSendRateStr).append(" ").append(deltaCommitSendRateStr).append(") ");
        sb.append(packetsSentStr).append("(").append(packetSendRateStr).append(" ").append(deltaPacketSendRateStr).append(") ");
        sb.append("}").append("\n");
        sb.append("...Complete{");
        sb.append(commitCompletionsReceivedStr).append("(").append(commitCompletionReceiveRateStr).append(" ").append(deltaCommitCompletionReceiveRateStr).append(") ");
        sb.append(commitCompletionsSentStr).append("(").append(commitCompletionSendRateStr).append(" ").append(deltaCommitCompletionSendRateStr).append(") ");
        sb.append("}").append("\n");
        sb.append("}").append("\n");
        sb.append("[Store Latencies]\n");
        this.cqs.get(sb);
        this.s.get(sb);
        this.s2w.get(sb);
        this.s2p.get(sb);
        this.w.get(sb);
        this.w2d.get(sb);
        this.d.get(sb);
        this.per.get(sb);
        this.icr.get(sb);
        this.idx.get(sb);
        this.c.get(sb);
        sb.append("\n").append("[Replicator]").append("\n");
        IStoreReplicatorStats repStats = this.getReplicatorStats();
        if (repStats != null) {
            repStats.get(sb);
        } else {
            sb.append("<No replicator>").append("\n");
        }
        sb.append("\n").append("[Persister]").append("\n");
        IStorePersisterStats perStats = this.getPersisterStats();
        if (perStats != null) {
            perStats.get(sb);
        } else {
            sb.append("<No persister>").append("\n");
        }
        sb.append("\n").append("[ICRSender]").append("\n");
        IStoreSenderStats icrStats = this.getICRSenderStats();
        if (icrStats != null) {
            icrStats.get(sb);
        } else {
            sb.append("<No ICR Sender>").append("\n");
        }
        this.stamp();
    }

    @Override
    public final IStoreBinding getBinding() {
        return this.binding;
    }

    @Override
    public final IStoreBinding.Role getRole() {
        return this.binding.getState() == IStoreBinding.State.Open ? this.binding.getRole() : null;
    }

    @Override
    public final IStoreBinding.State getState() {
        return this.binding.getState();
    }

    @Override
    public final long getNumCommitsSent() {
        return this.numCommitsSent;
    }

    @Override
    public final long getNumCommitEntriesSent() {
        return this.numCommitEntriesSent;
    }

    @Override
    public final long getNumCommitsReceived() {
        return this.numCommitsReceived;
    }

    @Override
    public final long getNumCommitEntriesReceived() {
        return this.numCommitEntriesReceived;
    }

    @Override
    public final long getNumCommitCompletionsSent() {
        return this.numCommitCompletionsSent;
    }

    @Override
    public final long getNumCommitCompletionsReceived() {
        return this.numCommitCompletionsReceived;
    }

    @Override
    public final IStoreReplicatorStats getReplicatorStats() {
        if (this.binding.getState() != IStoreBinding.State.Closed) {
            try {
                return !this.binding.isStandalone() ? this.binding.getReplicator().getStats() : null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final IStorePersisterStats getPersisterStats() {
        if (this.binding.getState() != IStoreBinding.State.Closed) {
            try {
                return this.binding.getPersister() != null ? this.binding.getPersister().getStats() : null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final IStoreSenderStats getICRSenderStats() {
        if (this.binding.getState() != IStoreBinding.State.Closed) {
            try {
                return this.binding.getICRSender() != null ? this.binding.getICRSender().getStats() : null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IStats.Latencies getIndexLatencies() {
        return this.idx.count() > 0L ? this.idx : null;
    }

    @Override
    public IStats.Latencies getPersisterLatencies() {
        if (this.binding.getState() != IStoreBinding.State.Closed) {
            try {
                return this.binding.getPersister() != null ? this.per : null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IStats.Latencies getIcrSendLatencies() {
        if (this.binding.getState() != IStoreBinding.State.Closed) {
            try {
                return this.binding.getICRSender() != null ? this.icr : null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final IStats.Latencies getCommitLatencies() {
        return this.c;
    }

    @Override
    public final IStats.Series getCommitQueueSizes() {
        return this.cqs;
    }

    @Override
    public IStats.Latencies getSerializeLatencies() {
        return this.s;
    }

    @Override
    public IStats.Latencies getSerializeToPersistLatencies() {
        return this.s2p;
    }

    @Override
    public IStats.Latencies getSerializeToWireLatencies() {
        return this.s2w;
    }

    @Override
    public IStats.Latencies getWireLatencies() {
        return this.w;
    }

    @Override
    public IStats.Latencies getWireToDeserializeLatencies() {
        return this.w2d;
    }

    @Override
    public IStats.Latencies getDeserializeLatencies() {
        return this.d;
    }

    @Override
    public final long getDataSize() {
        return this.storeDataSize;
    }
}

