/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit.evo.v1.xbuf;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity;
import com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializer;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.util.UtlPool;
import com.neeve.xbuf.XbufHeuristics;
import java.nio.ByteBuffer;
import java.util.Properties;

@AdmGenerated(encoding="Xbuf", compatLevel="4.1.0", admVersion="Unknown Version", date="11/26/24 7:56 AM", buildInfo="${build.version.string}")
public final class Factory
implements IStoreObjectFactory,
MessageViewFactory {
    public static final short OFID = -100;
    public static final short VFID = -100;
    public static final short TFID = -100;
    public static final short ID_EvoEntity = 200;
    public static final short ID_EvoMessage = 1;
    public static final int PKTID_EvoEntity = -3276900;
    public static final int PKTID_EvoMessage = -3276701;
    static final ObjectMapper mapper = new ObjectMapper();

    public static final Factory create(Properties props) {
        return new Factory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EvoMessage createEvoMessageFromXbufContainerPacket(UUID id, PktPacket packet) {
        try {
            EvoMessage object = (EvoMessage)packet.getTag(3);
            if (object != null) {
                object.undispose(id);
                EvoMessage evoMessage = object;
                return evoMessage;
            }
            EvoMessage evoMessage = new EvoMessage(id, packet);
            return evoMessage;
        }
        finally {
            packet.dispose();
        }
    }

    private static final EvoMessage createEvoMessageFromSerializedXbufContainerPacket(UUID id, ByteBuffer serializedPacket) {
        try {
            return Factory.createEvoMessageFromXbufContainerPacket(id, PktSerializer.create().deserialize(serializedPacket, null));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final EvoMessage createEvoMessageFromSerializedXbufContainerPacket(UUID id, byte[] serializedPacket) {
        return Factory.createEvoMessageFromSerializedXbufContainerPacket(id, ByteBuffer.wrap(serializedPacket));
    }

    private static final EvoMessage createEvoMessageFromSerializedXbufContainer(UUID id, ByteBuffer serializedContainer) {
        try {
            EvoMessage view = Factory.createEvoMessage();
            PktPacket packet = (PktPacket)view.getMessage();
            packet.acquire();
            view.dispose();
            packet.getBody().deserialize(serializedContainer, serializedContainer.remaining());
            return Factory.createEvoMessageFromXbufContainerPacket(id, packet);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static final EvoMessage createEvoMessageFromSerializedXbufContainer(UUID id, byte[] serializedContainer) {
        try {
            EvoMessage view = Factory.createEvoMessage();
            PktPacket packet = (PktPacket)view.getMessage();
            packet.acquire();
            view.dispose();
            packet.getBody().deserialize(serializedContainer, 0, serializedContainer.length);
            return Factory.createEvoMessageFromXbufContainerPacket(id, packet);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static final EvoMessage createEvoMessage() {
        return Factory.createEvoMessageFromXbufContainerPacket(null, PktFactory.getInstance().createPacket(-3276701));
    }

    public static final EvoMessage createEvoMessage(UUID id) {
        return Factory.createEvoMessageFromXbufContainerPacket(id, PktFactory.getInstance().createPacket(-3276701));
    }

    public static final EvoMessage createEvoMessageFromXbufContainerPacket(PktPacket packet) {
        if (packet.getBody().getType() == -3276701) {
            return Factory.createEvoMessageFromXbufContainerPacket(null, packet);
        }
        throw new IllegalArgumentException("invalid packet type [exp=PKTID_EvoMessage, actual=packet.getBody().getType()]");
    }

    public static final EvoMessage createEvoMessageFromSerializedXbufContainerPacket(ByteBuffer serializedPacket) {
        return Factory.createEvoMessageFromSerializedXbufContainerPacket(null, serializedPacket);
    }

    public static final EvoMessage createEvoMessageFromSerializedXbufContainerPacket(byte[] serializedPacket) {
        return Factory.createEvoMessageFromSerializedXbufContainerPacket(null, serializedPacket);
    }

    public static final EvoMessage createEvoMessageFromSerializedXbufContainer(ByteBuffer serializedContainer) {
        return Factory.createEvoMessageFromSerializedXbufContainer(null, serializedContainer);
    }

    public static final EvoMessage createEvoMessageFromSerializedXbufContainer(byte[] serializedContainer) {
        return Factory.createEvoMessageFromSerializedXbufContainer(null, serializedContainer);
    }

    public static final EvoMessage createEvoMessageFromJson(String json) {
        return Factory.createEvoMessage().deserializeFromJson(json);
    }

    public static final EvoMessage createEvoMessageFromRawJson(String json) {
        return Factory.createEvoMessage().deserializeFromRawJson(json);
    }

    @Override
    public final short getOfid() {
        return -100;
    }

    @Override
    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        try {
            switch (encodingType) {
                case Xbuf: {
                    switch (type) {
                        case 1: {
                            return Factory.createEvoMessageFromXbufContainerPacket(id, packet);
                        }
                    }
                    throw new RuntimeException("unknown object type: " + type);
                }
            }
            throw new RuntimeException("unknown encoding type: " + (Object)((Object)encodingType));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final short getVfid() {
        return -100;
    }

    public final MessageView create(short type) {
        try {
            switch (type) {
                case 1: {
                    return Factory.createEvoMessage();
                }
            }
            throw new RuntimeException("unknown messsage type: " + type);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        try {
            switch (encodingType) {
                case 3: {
                    if (message instanceof PktPacket) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromXbufContainerPacket(null, (PktPacket)message);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof byte[]) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromSerializedXbufContainer(null, (byte[])message);
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromSerializedXbufContainer(null, (ByteBuffer)message);
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for XBUF encoded message");
                }
                case 4: {
                    if (message instanceof byte[]) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromSerializedXbufContainer(null, (byte[])message);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromSerializedXbufContainer(null, (ByteBuffer)message);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof PktPacket) {
                        switch (type) {
                            case 1: {
                                return Factory.createEvoMessageFromXbufContainerPacket(null, (PktPacket)message);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for PROTOBUF encoded message");
                }
            }
            throw new RuntimeException("unknown encoding type: " + encodingType);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, XRuntime.getValue((String)"nv.indent.json", (boolean)false));
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)-3276900, (String)"EvoEntityXbufPacket.100.200", (String)"com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity$PacketBody", (int)0, (int)0, (boolean)XbufHeuristics.getProperty(EvoEntity.class, (String)"pool.shouldpool", (boolean)true), (UtlPool.Params)XbufHeuristics.configurePoolParams(EvoEntity.class, (UtlPool.Params)UtlPool.Params.create()), null));
        PktFactory.getInstance().registerPacketType(PktFactory.PktType.create((int)-3276701, (String)"EvoMessageXbufPacket.100.1", (String)"com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage$PacketBody", (int)0, (int)0, (boolean)XbufHeuristics.getProperty(EvoMessage.class, (String)"pool.shouldpool", (boolean)true), (UtlPool.Params)XbufHeuristics.configurePoolParams(EvoMessage.class, (UtlPool.Params)UtlPool.Params.create()), null));
    }
}

