/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.google.common.base.Objects;
import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmFactoryType;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.util.UtlObjectGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.junit.Test;

public class AepEventDispatchPerfTest
extends AepEngineTest {
    @Test
    public void testDispatchPerformance() throws Exception {
    }

    @Test
    public void testPrivateMethodDispatch() {
        int i;
        EventHandlerContainer container = new EventHandlerContainer();
        AepEventDispatcher dispatcher = AepEventDispatcher.create(new LinkedHashSet<Object>(Arrays.asList(container)), new IEventHandler(){

            public void onEvent(Event event) {
            }
        });
        PublicObject pubObj = new PublicObject();
        PrivateObject privObj = new PrivateObject();
        int count = 100000;
        long start = System.nanoTime();
        for (int i2 = 0; i2 < count; ++i2) {
            dispatcher.dispatchToEventHandlers(pubObj);
        }
        long end = System.nanoTime();
        System.out.println("Dispatched " + container.publicCount + " public in " + (end - start) / (long)container.publicCount + " nsec/object");
        start = System.nanoTime();
        for (i = 0; i < count; ++i) {
            dispatcher.dispatchToEventHandlers(privObj);
        }
        end = System.nanoTime();
        System.out.println("Dispatched " + container.privateCount + " private in " + (end - start) / (long)container.privateCount + " nsec/object");
        count = 100000000;
        container.privateCount = 0;
        container.publicCount = 0;
        start = System.nanoTime();
        for (i = 0; i < count; ++i) {
            dispatcher.dispatchToEventHandlers(pubObj);
        }
        end = System.nanoTime();
        System.out.println("Dispatched " + container.publicCount + " public in " + (end - start) / (long)container.publicCount + " nsec/object");
        start = System.nanoTime();
        for (i = 0; i < count; ++i) {
            dispatcher.dispatchToEventHandlers(privObj);
        }
        end = System.nanoTime();
        System.out.println("Dispatched " + container.privateCount + " private in " + (end - start) / (long)container.privateCount + " nsec/object");
        count = 100000000;
        container.privateCount = 0;
        container.publicCount = 0;
        start = System.nanoTime();
        for (i = 0; i < count; ++i) {
            dispatcher.dispatchToEventHandlers(pubObj);
        }
        end = System.nanoTime();
        System.out.println("Dispatched " + container.publicCount + " public in " + (end - start) / (long)container.publicCount + " nsec/object");
        start = System.nanoTime();
        for (i = 0; i < count; ++i) {
            dispatcher.dispatchToEventHandlers(privObj);
        }
        end = System.nanoTime();
        System.out.println("Dispatched " + container.privateCount + " private in " + (end - start) / (long)container.privateCount + " nsec/object");
    }

    public static final void main(String[] args) {
        DispatcherTraceParser parser = new DispatcherTraceParser();
        try {
            parser.parse("c:/temp/blackbirdHandlers.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DispatcherGenerator generator = new DispatcherGenerator();
        try {
            generator.parse("c:/temp/handlerList.csv");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class PrivateObject {
        private PrivateObject() {
        }
    }

    private static class PublicObject {
        private PublicObject() {
        }
    }

    public static class EventHandlerContainer {
        int privateCount = 0;
        int publicCount = 0;

        @EventHandler
        private final void testPrivate(PrivateObject object) {
            ++this.privateCount;
        }

        @EventHandler
        public final void testPublic(PublicObject object) {
            ++this.publicCount;
        }
    }

    private static class HandlerMethodModel {
        private final String methodName;
        private final String eventType;
        private final String source;
        private final String subsource;
        private final int hashCode;

        HandlerMethodModel(String methodName, String eventType, String source, String subsource) {
            this.methodName = methodName;
            this.eventType = eventType;
            this.source = source == null || source.equals("null") ? null : source;
            this.subsource = subsource == null || subsource.equals("null") ? null : subsource;
            this.hashCode = Objects.hashCode((Object[])new Object[]{methodName, eventType, source, subsource});
        }

        public void writeHandlerMethod(BufferedWriter writer) throws IOException {
            String sourceString = null;
            if (this.source != null || this.subsource != null) {
                if (this.subsource != null) {
                    sourceString = this.subsource;
                }
                if (this.source != null) {
                    sourceString = this.subsource != null ? sourceString + "@" + this.source : this.source;
                }
            }
            writer.write("    @EventHandler(");
            if (sourceString != null) {
                writer.write("source=" + sourceString);
            }
            writer.write(")");
            writer.newLine();
            writer.write("    public final void " + this.methodName + "(final " + this.eventType + " object) {");
            writer.newLine();
            writer.write("    }");
            writer.newLine();
        }

        public boolean equals(Object object) {
            if (object instanceof HandlerMethodModel) {
                HandlerMethodModel other = (HandlerMethodModel)object;
                if (!UtlObjectGraph.equals((Object)other.methodName, (Object)this.methodName)) {
                    return false;
                }
                if (!UtlObjectGraph.equals((Object)other.eventType, (Object)this.eventType)) {
                    return false;
                }
                if (!UtlObjectGraph.equals((Object)other.source, (Object)this.source)) {
                    return false;
                }
                return UtlObjectGraph.equals((Object)other.subsource, (Object)this.subsource);
            }
            return false;
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }

    private static class HandlerModel {
        private final HashSet<HandlerMethodModel> handlers = new HashSet();
        private final String typeName;

        HandlerModel(String typeName) {
            this.typeName = typeName;
        }

        public void addAnnotatedHandler(String methodName, String eventType, String source, String subsource) {
            this.handlers.add(new HandlerMethodModel(methodName, eventType, source, subsource));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateClasses(File outputDir) throws IOException {
            String handlerPackage = this.getPackageName();
            String handlerClassName = this.typeName.substring(this.typeName.lastIndexOf(".") + 1);
            File dir = new File(outputDir, handlerPackage.replace(".", "/"));
            dir.mkdirs();
            File sourceFile = new File(dir, handlerClassName + ".java");
            BufferedWriter writer = new BufferedWriter(new FileWriter(sourceFile, false));
            try {
                writer.write("package " + handlerPackage + ";");
                writer.newLine();
                writer.newLine();
                writer.write("import " + EventHandler.class.getName() + ";");
                writer.newLine();
                writer.newLine();
                writer.write("public final class " + handlerClassName + "{");
                writer.newLine();
                writer.write("    public " + handlerClassName + "() {}");
                writer.newLine();
                for (HandlerMethodModel handler : this.handlers) {
                    writer.newLine();
                    handler.writeHandlerMethod(writer);
                }
                writer.write("}");
            }
            finally {
                writer.flush();
                writer.close();
            }
        }

        public String getPackageName() {
            return this.typeName.substring(0, this.typeName.lastIndexOf("."));
        }
    }

    private static class DispatcherGenerator {
        private DispatcherGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(String fileName) throws IOException {
            Iterator line;
            File file = new File(fileName);
            if (!file.exists()) {
                throw new FileNotFoundException(fileName);
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            HashMap<String, HandlerModel> handlers = new HashMap<String, HandlerModel>();
            HashMap<String, AdmModel> models = new HashMap<String, AdmModel>();
            int factoryId = 1;
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] tokens = ((String)((Object)line)).split(",");
                String containerType = tokens[1];
                String methodName = tokens[2];
                String eventType = tokens[0];
                String subsource = tokens[4];
                String source = tokens[3];
                HandlerModel handler = (HandlerModel)handlers.get(containerType);
                if (handler == null) {
                    handler = new HandlerModel(containerType);
                    handlers.put(containerType, handler);
                }
                handler.addAnnotatedHandler(methodName, eventType, source, subsource);
                Class<?> eventClass = null;
                try {
                    eventClass = Class.forName(eventType);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (eventClass != null) continue;
                String eventClassPackage = eventType.substring(0, eventType.lastIndexOf("."));
                String eventClassName = eventType.substring(eventType.lastIndexOf(".") + 1);
                AdmModel model = (AdmModel)models.get(eventClassPackage);
                AdmFactory factory = null;
                if (model == null) {
                    model = new AdmModel(eventClassPackage);
                    factory = new AdmFactory(model, eventClassPackage, "Factory", factoryId++);
                    model.addFactory("Factory", factory);
                    models.put(eventClassPackage, model);
                } else {
                    factory = model.getFactoryLocal("Factory");
                }
                if (model.getMessage(eventClassName) != null) continue;
                try {
                    AdmMessage message = new AdmMessage(model, eventClassPackage, eventClassName, null, factory, model.getMessageCount() + 1, false);
                    model.addMessage(eventClassName, message);
                    factory.addType((AdmFactoryType)message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Object model : models.values()) {
                try {
                    model.generateClasses(new File(AepEventDispatchPerfTest.getProjectBaseDirectory(), "target/generated-test-sources/dispatcher-test").getCanonicalFile(), AdmEncodingType.Protobuf, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Object model : handlers.values()) {
                try {
                    ((HandlerModel)model).generateClasses(new File(AepEventDispatchPerfTest.getProjectBaseDirectory(), "target/generated-test-sources/dispatcher-test"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String factoryPackage = AepEventDispatchPerfTest.class.getPackage().getName();
            File dir = new File(AepEventDispatchPerfTest.getProjectBaseDirectory(), "target/generated-test-sources/dispatcher-test/" + factoryPackage.replace(".", "/"));
            dir.mkdirs();
            File sourceFile = new File(dir, "DispatcherFactory.java");
            BufferedWriter writer = new BufferedWriter(new FileWriter(sourceFile, false));
            try {
                writer.write("package " + factoryPackage + ";");
                writer.newLine();
                writer.newLine();
                writer.write("import java.util.Set;");
                writer.newLine();
                writer.write("import java.util.HashSet;");
                writer.newLine();
                writer.newLine();
                writer.write("public final class DispatcherFactory {");
                writer.newLine();
                writer.write("    public DispatcherFactory() {}");
                writer.newLine();
                writer.write("    public static final Set<Object> getEventHandlers() {");
                writer.newLine();
                writer.write("        final HashSet<Object> handlers = new HashSet<Object>();");
                for (HandlerModel handler : handlers.values()) {
                    writer.write("        handlers.add(new " + handler.typeName + "());");
                    writer.newLine();
                }
                writer.write("        return handlers;");
                writer.write("    }");
                writer.newLine();
                writer.write("}");
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
    }

    private static class DispatcherTraceParser {
        private DispatcherTraceParser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(String fileName) throws IOException {
            File file = new File(fileName);
            if (!file.exists()) {
                throw new FileNotFoundException(fileName);
            }
            File outputFile = new File(file.getParentFile(), "handlerList.csv");
            BufferedReader br = new BufferedReader(new FileReader(file));
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            String lastLine = null;
            String line = null;
            int lineNum = 0;
            bw.write("EventType,Handler,Method,Source,Subsource");
            bw.newLine();
            String entry = "%s,%s,%s,%s,%s";
            try {
                while (true) {
                    ++lineNum;
                    lastLine = line;
                    line = br.readLine();
                    if (line == null) {
                        break;
                    }
                    if (line.indexOf(".....added") == -1) continue;
                    if (lastLine == null) {
                        System.err.println("Found annotation, but no preceding line (line=" + lineNum + ")");
                    }
                    String containerType = null;
                    String methodName = null;
                    String eventType = null;
                    String subsource = null;
                    String source = null;
                    lastLine = lastLine.substring(lastLine.lastIndexOf(32) + 1);
                    int openIndex = lastLine.indexOf("(");
                    eventType = lastLine.substring(openIndex + 1, lastLine.length() - 1);
                    String classAndMethod = lastLine.substring(0, openIndex);
                    containerType = classAndMethod.substring(0, classAndMethod.lastIndexOf("."));
                    methodName = classAndMethod.substring(classAndMethod.lastIndexOf(".") + 1);
                    line = line.substring(line.lastIndexOf(40) + 1, line.length() - 1);
                    String[] tokens = line.split(",");
                    subsource = tokens[0].substring(tokens[0].indexOf(61) + 1);
                    source = tokens[1].substring(tokens[1].indexOf(61) + 1);
                    bw.write(String.format(entry, eventType, containerType, methodName, source, subsource));
                    bw.newLine();
                }
            }
            finally {
                bw.flush();
                bw.close();
                br.close();
            }
        }
    }
}

