/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.event.test.unit;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.neeve.aep.AepSendCommitCompletionEvent;
import com.neeve.stats.Stats;
import com.neeve.test.ConditionalIgnoreRule;
import com.neeve.util.UtlTime;
import org.junit.Rule;
import org.junit.Test;

public class AepSendCommitCompletionEventTest {
    @Rule
    public ConditionalIgnoreRule rule = new ConditionalIgnoreRule();

    @Test
    @ConditionalIgnoreRule.ConditionalIgnore(condition=PoolingDisabled.class)
    public void testCreatePerf() throws Exception {
        CarrierEventProcessor processor = new CarrierEventProcessor();
        RingBuffer ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

            public CarrierEvent newInstance() {
                return new CarrierEvent();
            }
        }, (ClaimStrategy)new SingleThreadedClaimStrategy(1024), (WaitStrategy)new BusySpinWaitStrategy());
        SequenceBarrier sequenceBarrier = ringBuffer.newBarrier(new Sequence[0]);
        BatchEventProcessor batchProcessor = new BatchEventProcessor(ringBuffer, sequenceBarrier, (EventHandler)processor);
        ringBuffer.setGatingSequences(new Sequence[]{batchProcessor.getSequence()});
        new WriterThread((BatchEventProcessor<CarrierEvent>)batchProcessor).start();
        com.neeve.event.EventFactory.getInstance().getEventType((short)506).getPool().setSingleThreaded();
        for (int i = 0; i < 100000000; ++i) {
            long sequence = ringBuffer.next();
            CarrierEvent carrierEvent = (CarrierEvent)ringBuffer.get(sequence);
            carrierEvent.event = AepSendCommitCompletionEvent.create(null, false, false);
            carrierEvent.publishTs = UtlTime.now();
            ringBuffer.publish(sequence);
            if (i % 100000 != 0) continue;
            System.out.println("..." + i + "(size=" + ringBuffer.remainingCapacity() + ")");
        }
        StringBuilder sb = new StringBuilder();
        processor.stats.compute();
        processor.stats.get(sb);
        System.out.println(sb.toString());
    }

    public final class PoolingDisabled
    implements ConditionalIgnoreRule.IgnoreCondition {
        public final boolean isSatisfied() {
            return !com.neeve.event.EventFactory.getInstance().getEventType((short)506).isPooled();
        }
    }

    private final class WriterThread
    extends Thread {
        WriterThread(BatchEventProcessor<CarrierEvent> batchProcessor) {
            super((Runnable)batchProcessor);
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            super.run();
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent> {
        final Stats.LatencyManager stats = new Stats.LatencyManager("test", 1000000);

        private CarrierEventProcessor() {
        }

        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            this.stats.add((double)(UtlTime.now() - event.publishTs));
            event.event.dispose();
        }
    }

    private final class CarrierEvent {
        long publishTs;
        AepSendCommitCompletionEvent event;

        private CarrierEvent() {
        }
    }
}

