/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepEnvironmentData;
import com.neeve.aep.IAepEnvironmentProvider;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyAepEnvironmentDataPacket;
import com.neeve.rog.IRogMessage;
import java.nio.ByteBuffer;

final class AepEnvironmentProviderProxy
implements IAepEnvironmentProvider.BufferManager {
    private final short id;
    private final IAepEnvironmentProvider provider;
    private IAepEnvironmentProvider.TransactionAction action;
    private AepEnvironmentData data;
    private PktBodyAepEnvironmentDataPacket body;
    private ByteBuffer buffer;
    private int pos;

    AepEnvironmentProviderProxy(int id, IAepEnvironmentProvider provider) {
        this.id = (short)id;
        this.provider = provider;
        provider.setBufferManager(this);
    }

    static final int getId(IRogMessage message) {
        if (message instanceof AepEnvironmentData) {
            return ((PktBodyAepEnvironmentDataPacket)((PktPacket)message.getMessage()).getBody()).getProviderId();
        }
        return -1;
    }

    final short getId() {
        return this.id;
    }

    final IAepEnvironmentProvider getProvider() {
        return this.provider;
    }

    final void startRecording() {
        this.data = AepEnvironmentData.create();
        this.body = (PktBodyAepEnvironmentDataPacket)((PktPacket)this.data.getMessage()).getBody();
        this.buffer = this.body.getDataBufferForRecord();
        this.pos = this.buffer.position();
        this.action = IAepEnvironmentProvider.TransactionAction.Record;
        this.provider.onTransactionStart(this.buffer, this.action);
    }

    final boolean inRecord() {
        return this.action == IAepEnvironmentProvider.TransactionAction.Record;
    }

    final IRogMessage endRecording() {
        try {
            this.provider.onTransactionEnd();
            int len = this.buffer.position() - this.pos;
            if (len < 0) {
                throw new IllegalStateException("buffer corrupted by environment provider [pos before=" + this.pos + ", pos after=" + this.buffer.position() + "]");
            }
            this.body.setProviderId(this.id);
            this.body.setDataLength(len);
            if (len > 0) {
                AepEnvironmentData aepEnvironmentData = this.data;
                return aepEnvironmentData;
            }
            this.data.dispose();
            IRogMessage iRogMessage = null;
            return iRogMessage;
        }
        finally {
            this.action = null;
            this.data = null;
            this.body = null;
            this.buffer = null;
        }
    }

    final void startPlayback(IRogMessage message) {
        this.data = (AepEnvironmentData)message;
        this.data.acquire();
        this.body = (PktBodyAepEnvironmentDataPacket)((PktPacket)this.data.getMessage()).getBody();
        this.buffer = this.body.getDataBufferForPlayback();
        this.action = IAepEnvironmentProvider.TransactionAction.Playback;
        this.provider.onTransactionStart(this.buffer, this.action);
    }

    final boolean inPlayback() {
        return this.action == IAepEnvironmentProvider.TransactionAction.Playback;
    }

    final void endPlayback() {
        try {
            this.provider.onTransactionEnd();
            this.data.dispose();
        }
        finally {
            this.action = null;
            this.data = null;
            this.body = null;
            this.buffer = null;
        }
    }

    @Override
    public final ByteBuffer resize(int size) {
        if (this.action == null) {
            throw new IllegalStateException("buffer cannot be resized outside of a transaction");
        }
        if (this.action == IAepEnvironmentProvider.TransactionAction.Playback) {
            throw new IllegalStateException("buffer cannot be resized during playback");
        }
        this.buffer = this.body.resize(size);
        return this.buffer;
    }

    final void close() {
        try {
            this.provider.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

