/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.lang.XStringIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufStringField;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;

public class XbufRepeatedStringFieldBuffer
implements XStringIterator {
    static final String[] EMPTY_ARRAY = new String[0];
    final PktBuffer val;
    private final XbufField.VarintDesyncLength desyncLength = new XbufField.VarintDesyncLength();
    private final boolean allowsNullValues;
    private final XbufField.NullValueCheckPolicy nullValueCheckPolicy;
    final short id;
    int current;
    int length;
    int count;

    XbufRepeatedStringFieldBuffer(short id, boolean allowsNullValues, XbufField.NullValueCheckPolicy nullValueCheckPolicy, int initialLength, boolean isNative) {
        this.val = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)initialLength, (boolean)isNative);
        this.val.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.allowsNullValues = allowsNullValues;
        this.nullValueCheckPolicy = nullValueCheckPolicy;
        this.id = id;
    }

    public short getFieldId() {
        return this.id;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    final XbufRepeatedStringFieldBuffer reset() {
        if (this.count > 0) {
            this.val.setLength(0);
            this.count = 0;
            this.current = 0;
            this.length = 0;
        }
        return this;
    }

    final int desyncAndAddValue(PktBuffer buffer, int offset, int length) {
        this.copyDesynced(buffer, offset, length);
        return Math.max(0, length);
    }

    final int copyInto(IOElasticBuffer buffer, int offset) {
        if (this.length == 0) {
            return 0;
        }
        buffer.putFrom(offset, (IOElasticBuffer)this.val, 0, this.length);
        return this.length;
    }

    final int serializedLength() {
        return this.length;
    }

    final int count() {
        return this.count;
    }

    public final void add(String v) {
        if (this.assertEncodable(v)) {
            this.length += XbufStringField.serializeField(this.val, this.length, this.id, v);
            ++this.count;
        }
    }

    public final void add(XString v) {
        if (this.assertEncodable(v)) {
            this.length += XbufStringField.serializeField(this.val, this.length, this.id, v);
            ++this.count;
        }
    }

    public final void setValuesFrom(XbufRepeatedStringFieldBuffer values) {
        this.reset();
        if (this.isBufferCopyPossibleFrom(values)) {
            this.val.putFrom(0, (IOElasticBuffer)values.val, 0, values.length);
            this.length = values.length;
            this.count = values.count;
        } else {
            values.toFirst();
            while (values.hasNext()) {
                this.add(values.next());
            }
            values.toFirst();
        }
    }

    public final void setValuesFrom(XIterator<String> values) {
        if (values instanceof XbufRepeatedStringFieldBuffer) {
            this.setValuesFrom((XbufRepeatedStringFieldBuffer)values);
        } else {
            this.reset();
            values.toFirst();
            while (values.hasNext()) {
                this.add((String)values.next());
            }
            values.toFirst();
        }
    }

    public final boolean hasNext() {
        return this.current < this.length;
    }

    public final String next() {
        if (this.hasNext()) {
            String v = XbufStringField.deserializeField(this.val, this.current, this.id, this.desyncLength);
            this.current += this.desyncLength.value;
            return v;
        }
        throw new NoSuchElementException("no more elements");
    }

    public final void nextInto(XString target) {
        int valueLength = XbufStringField.deserializeStringLength(this.val, this.current, this.id, this.desyncLength);
        if (valueLength >= 0) {
            target.setValue((IOElasticBuffer)this.val, this.current + this.desyncLength.value, valueLength);
            this.current += valueLength + this.desyncLength.value;
        } else {
            target.setValue((String)null);
            this.current += this.desyncLength.value;
        }
    }

    public final void remove() {
        throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
    }

    public final XbufRepeatedStringFieldBuffer toFirst() {
        this.current = 0;
        return this;
    }

    final void copyDesynced(PktBuffer buffer, int offset, int valueLength) {
        int headerLength = XbufStringField.syncHeader(this.val, this.length, this.id, XbufField.Type.STRING, valueLength);
        if (valueLength > 0) {
            this.val.putFrom(this.length + headerLength, (IOElasticBuffer)buffer, offset, valueLength);
            this.length += valueLength;
        }
        this.length += headerLength;
        ++this.count;
    }

    final boolean allowsNullValues() {
        return this.allowsNullValues;
    }

    private final boolean assertEncodable(String str) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (str != null) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    private final boolean assertEncodable(XString str) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (str != null && !str.isNull()) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    private final boolean isBufferCopyPossibleFrom(XbufRepeatedStringFieldBuffer source) {
        if (source.getFieldId() != this.getFieldId()) {
            return false;
        }
        if (this.allowsNullValues()) {
            return true;
        }
        if (!source.allowsNullValues()) {
            switch (source.nullValueCheckPolicy) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String[] toArray() {
        if (this.count == 0) {
            return EMPTY_ARRAY;
        }
        String[] ret = new String[this.count];
        int c = this.current;
        try {
            this.toFirst();
            int i = 0;
            while (this.hasNext()) {
                ret[i++] = this.next();
            }
        }
        finally {
            this.current = c;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Appendable toString(Appendable to) {
        int c = this.current;
        try {
            this.toFirst();
            while (this.hasNext()) {
                try {
                    to.append(String.valueOf(this.next()));
                    if (!this.hasNext()) continue;
                    to.append(",");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                    return to;
                }
            }
        }
        finally {
            this.current = c;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

