/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeGroupsResponse
extends AbstractResponse {
    private static final String GROUPS_KEY_NAME = "groups";
    private static final String GROUP_STATE_KEY_NAME = "state";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final String PROTOCOL_KEY_NAME = "protocol";
    private static final String MEMBERS_KEY_NAME = "members";
    private static final String CLIENT_ID_KEY_NAME = "client_id";
    private static final String CLIENT_HOST_KEY_NAME = "client_host";
    private static final String MEMBER_METADATA_KEY_NAME = "member_metadata";
    private static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    private static final Schema DESCRIBE_GROUPS_RESPONSE_MEMBER_V0 = new Schema(CommonFields.MEMBER_ID, new Field("client_id", Type.STRING, "The client id used in the member's latest join group request"), new Field("client_host", Type.STRING, "The client host used in the request session corresponding to the member's join group."), new Field("member_metadata", Type.BYTES, "The metadata corresponding to the current group protocol in use (will only be present if the group is stable)."), new Field("member_assignment", Type.BYTES, "The current assignment provided by the group leader (will only be present if the group is stable)."));
    private static final Schema DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.GROUP_ID, new Field("state", Type.STRING, "The current state of the group (one of: Dead, Stable, CompletingRebalance, PreparingRebalance, or empty if there is no active group)"), new Field("protocol_type", Type.STRING, "The current group protocol type (will be empty if there is no active group)"), new Field("protocol", Type.STRING, "The current group protocol (only provided if the group is Stable)"), new Field("members", new ArrayOf(DESCRIBE_GROUPS_RESPONSE_MEMBER_V0), "Current group members (only provided if the group is not Dead)"));
    private static final Schema DESCRIBE_GROUPS_RESPONSE_V0 = new Schema(new Field("groups", new ArrayOf(DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0)));
    private static final Schema DESCRIBE_GROUPS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("groups", new ArrayOf(DESCRIBE_GROUPS_RESPONSE_GROUP_METADATA_V0)));
    public static final String UNKNOWN_STATE = "";
    public static final String UNKNOWN_PROTOCOL_TYPE = "";
    public static final String UNKNOWN_PROTOCOL = "";
    private final Map<String, GroupMetadata> groups;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_GROUPS_RESPONSE_V0, DESCRIBE_GROUPS_RESPONSE_V1};
    }

    public DescribeGroupsResponse(Map<String, GroupMetadata> groups) {
        this(0, groups);
    }

    public DescribeGroupsResponse(int throttleTimeMs, Map<String, GroupMetadata> groups) {
        this.throttleTimeMs = throttleTimeMs;
        this.groups = groups;
    }

    public DescribeGroupsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.groups = new HashMap<String, GroupMetadata>();
        for (Object groupObj : struct.getArray(GROUPS_KEY_NAME)) {
            Struct groupStruct = (Struct)groupObj;
            String groupId = groupStruct.get(CommonFields.GROUP_ID);
            Errors error = Errors.forCode(groupStruct.get(CommonFields.ERROR_CODE));
            String state = groupStruct.getString(GROUP_STATE_KEY_NAME);
            String protocolType = groupStruct.getString(PROTOCOL_TYPE_KEY_NAME);
            String protocol = groupStruct.getString(PROTOCOL_KEY_NAME);
            ArrayList<GroupMember> members = new ArrayList<GroupMember>();
            for (Object memberObj : groupStruct.getArray(MEMBERS_KEY_NAME)) {
                Struct memberStruct = (Struct)memberObj;
                String memberId = memberStruct.get(CommonFields.MEMBER_ID);
                String clientId = memberStruct.getString(CLIENT_ID_KEY_NAME);
                String clientHost = memberStruct.getString(CLIENT_HOST_KEY_NAME);
                ByteBuffer memberMetadata = memberStruct.getBytes(MEMBER_METADATA_KEY_NAME);
                ByteBuffer memberAssignment = memberStruct.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
                members.add(new GroupMember(memberId, clientId, clientHost, memberMetadata, memberAssignment));
            }
            this.groups.put(groupId, new GroupMetadata(error, state, protocolType, protocol, members));
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, GroupMetadata> groups() {
        return this.groups;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (GroupMetadata response : this.groups.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static DescribeGroupsResponse fromError(Errors error, List<String> groupIds) {
        return DescribeGroupsResponse.fromError(0, error, groupIds);
    }

    public static DescribeGroupsResponse fromError(int throttleTimeMs, Errors error, List<String> groupIds) {
        GroupMetadata errorMetadata = GroupMetadata.forError(error);
        HashMap<String, GroupMetadata> groups = new HashMap<String, GroupMetadata>();
        for (String groupId : groupIds) {
            groups.put(groupId, errorMetadata);
        }
        return new DescribeGroupsResponse(throttleTimeMs, groups);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_GROUPS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> groupStructs = new ArrayList<Struct>();
        for (Map.Entry<String, GroupMetadata> groupEntry : this.groups.entrySet()) {
            Struct groupStruct = struct.instance(GROUPS_KEY_NAME);
            GroupMetadata group = groupEntry.getValue();
            groupStruct.set(CommonFields.GROUP_ID, groupEntry.getKey());
            groupStruct.set(CommonFields.ERROR_CODE, group.error.code());
            groupStruct.set(GROUP_STATE_KEY_NAME, (Object)group.state);
            groupStruct.set(PROTOCOL_TYPE_KEY_NAME, (Object)group.protocolType);
            groupStruct.set(PROTOCOL_KEY_NAME, (Object)group.protocol);
            ArrayList<Struct> membersList = new ArrayList<Struct>();
            for (GroupMember member : group.members) {
                Struct memberStruct = groupStruct.instance(MEMBERS_KEY_NAME);
                memberStruct.set(CommonFields.MEMBER_ID, member.memberId);
                memberStruct.set(CLIENT_ID_KEY_NAME, (Object)member.clientId);
                memberStruct.set(CLIENT_HOST_KEY_NAME, (Object)member.clientHost);
                memberStruct.set(MEMBER_METADATA_KEY_NAME, (Object)member.memberMetadata);
                memberStruct.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)member.memberAssignment);
                membersList.add(memberStruct);
            }
            groupStruct.set(MEMBERS_KEY_NAME, (Object)membersList.toArray());
            groupStructs.add(groupStruct);
        }
        struct.set(GROUPS_KEY_NAME, (Object)groupStructs.toArray());
        return struct;
    }

    public static DescribeGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsResponse(ApiKeys.DESCRIBE_GROUPS.parseResponse(version, buffer));
    }

    public static class GroupMember {
        private final String memberId;
        private final String clientId;
        private final String clientHost;
        private final ByteBuffer memberMetadata;
        private final ByteBuffer memberAssignment;

        public GroupMember(String memberId, String clientId, String clientHost, ByteBuffer memberMetadata, ByteBuffer memberAssignment) {
            this.memberId = memberId;
            this.clientId = clientId;
            this.clientHost = clientHost;
            this.memberMetadata = memberMetadata;
            this.memberAssignment = memberAssignment;
        }

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public ByteBuffer memberMetadata() {
            return this.memberMetadata;
        }

        public ByteBuffer memberAssignment() {
            return this.memberAssignment;
        }
    }

    public static class GroupMetadata {
        private final Errors error;
        private final String state;
        private final String protocolType;
        private final String protocol;
        private final List<GroupMember> members;

        public GroupMetadata(Errors error, String state, String protocolType, String protocol, List<GroupMember> members) {
            this.error = error;
            this.state = state;
            this.protocolType = protocolType;
            this.protocol = protocol;
            this.members = members;
        }

        public Errors error() {
            return this.error;
        }

        public String state() {
            return this.state;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public String protocol() {
            return this.protocol;
        }

        public List<GroupMember> members() {
            return this.members;
        }

        public static GroupMetadata forError(Errors error) {
            return new GroupMetadata(error, "", "", "", Collections.emptyList());
        }
    }
}

