/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.server.app.annotations.AppInitializer;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.test.UnitTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SrvAppStartFailTest
extends UnitTest {
    private EmbeddedXVM xvm;

    private final SrvConfigDescriptor createTestServer(String testName, Class<?> appClass, boolean stopOnStartFail) throws Exception {
        SrvConfigDescriptor descriptor = SrvConfigDescriptor.create(testName + "Server");
        descriptor.setDiscoveryDescriptor("loopback://test");
        descriptor.setAutoStopOnAppStartFail(stopOnStartFail);
        descriptor.save();
        SrvConfigAppDescriptor appDescriptor1 = SrvConfigAppDescriptor.create(testName + "_App1");
        appDescriptor1.setMainClass(appClass.getName());
        appDescriptor1.setAutoStart(true);
        appDescriptor1.save(descriptor.getName());
        descriptor.addApp(appDescriptor1);
        SrvConfigAppDescriptor appDescriptor2 = SrvConfigAppDescriptor.create(testName + "_App2");
        appDescriptor2.setMainClass(appClass.getName());
        appDescriptor2.setAutoStart(true);
        appDescriptor2.save(descriptor.getName());
        descriptor.addApp(appDescriptor2);
        descriptor.save();
        return descriptor;
    }

    @Test
    public void testNoStopOnAppStartFail_NoAppStartFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, false)).verifyAppsLoaded(false);
        this.xvm.start();
        Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Started), (Object)((Object)this.xvm.getState()));
        Assert.assertNull((Object)this.xvm.getStartupError());
    }

    @Test
    public void testNoStopOnAppStartFail_FirstAppInitFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, false)).verifyAppsLoaded(false);
        this.xvm.start();
        Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Started), (Object)((Object)this.xvm.getState()));
        Assert.assertNull((Object)this.xvm.getStartupError());
    }

    @Test
    public void testNoStopOnAppStartFail_SecondAppInitFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, false)).verifyAppsLoaded(false);
        this.xvm.start();
        Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Started), (Object)((Object)this.xvm.getState()));
        Assert.assertNull((Object)this.xvm.getStartupError());
    }

    @Test
    public void testStopOnAppStartFail_NoAppStartFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, true)).verifyAppsLoaded(false);
        this.xvm.start();
        Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Started), (Object)((Object)this.xvm.getState()));
        Assert.assertNull((Object)this.xvm.getStartupError());
    }

    @Test
    public void testStopOnAppStartFail_FirstAppInitFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, true)).verifyAppsLoaded(false);
        try {
            this.xvm.start();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Failed), (Object)((Object)this.xvm.getState()));
            Assert.assertTrue((this.xvm.getStartupError() != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStopOnAppStartFail_SecondAppInitFail() throws Throwable {
        this.xvm = EmbeddedXVM.create(this.createTestServer(this.testcaseName.getMethodName(), App.class, true)).verifyAppsLoaded(false);
        try {
            this.xvm.start();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)((Object)EmbeddedXVM.State.Failed), (Object)((Object)this.xvm.getState()));
            Assert.assertTrue((this.xvm.getStartupError() != null ? 1 : 0) != 0);
        }
    }

    @After
    public void after() {
        this.xvm.shutdown(true);
    }

    public static final class App {
        private String name;

        @AppInjectionPoint
        public final void setEngine(AepEngine engine) {
            this.name = engine.getName();
            System.out.println(this.name + " LOADED");
        }

        @AppInitializer
        public final void init() {
            if (this.name.contains("App1") && this.name.contains("FirstAppInitFail") || this.name.contains("App2") && this.name.contains("SecondAppInitFail")) {
                throw new RuntimeException("Intentionally failed");
            }
        }
    }
}

