/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.aep.test.unit.generated.xbuf.ReceiverMessage1;
import com.neeve.rog.IRogMessage;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppIntrospectionPoints;
import com.neeve.server.test.unit.AbstractAepServerTest;
import com.neeve.server.test.unit.AbstractAepServerTestApp;
import com.neeve.server.test.unit.ChannelJoin;
import java.util.Date;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationAppIntrospectionPointsTest
extends AbstractAepServerTest {
    @Test
    public void testMessageHandlingFromAppIntrospectionPoints() throws Throwable {
        ReceiverApp receiverApp = AnnotationAppIntrospectionPointsTest.createApp("testMessageHandlingFromAppIntrospectionPointsReceiver", "standalone", ReceiverApp.class);
        SenderApp senderApp = AnnotationAppIntrospectionPointsTest.createApp("testMessageHandlingFromAppIntrospectionPointsSender", "standalone", SenderApp.class);
        ReceiverMessage1 msg = ReceiverMessage1.create();
        senderApp.sendMessage("ReceiverChannel1@aeptest1", (IRogMessage)msg);
        if (!receiverApp.waitForMessages(10, 1)) {
            Assert.assertEquals((String)"Receiver got wrong number of messages", (long)1L, (long)receiverApp.receivedMessageCount);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class SenderApp
    extends AbstractAepServerTestApp {
        @AppInjectionPoint
        public void onEngineInjected(AepEngine engine) {
            engine.registerFactory((Object)new Factory());
            super.setAepEngine(engine);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    @ChannelJoin(value={"ReceiverChannel1@aeptest1"})
    public static final class ReceiverApp
    extends AbstractAepServerTestApp {
        private AppEventHandlerBean appEventHandlerBean = new AppEventHandlerBean(this);

        public AppEventHandlerBean getAppEventHandlerBean() {
            return this.appEventHandlerBean;
        }

        @AppIntrospectionPoints
        public void getAppIntrospectionPoints(Set<Object> appBeans) {
            appBeans.add(this.appEventHandlerBean);
        }
    }

    public static class AppEventHandlerBean {
        private ReceiverApp context;

        public AppEventHandlerBean(ReceiverApp context) {
            this.context = context;
        }

        @EventHandler
        public void onReceivedMessage(ReceiverMessage1 message) {
            System.out.println(new Date() + " RECEIVER Received message");
            this.context.recordReceipt((IRogMessage)message);
        }
    }
}

