/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solace;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SingleThreadedClaimStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XPooledString;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.event.MessageBusBindingReconnectedEvent;
import com.neeve.sma.event.MessageBusBindingReconnectingEvent;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.solace.SolaceMessageChannel;
import com.neeve.solace.SolaceOrphanSubscriptionCheckPolicy;
import com.neeve.solace.SolaceSession;
import com.neeve.solxf.ISolContext;
import com.neeve.solxf.ISolDynamicTopic;
import com.neeve.solxf.ISolValidator;
import com.neeve.solxf.SolFactory;
import com.neeve.solxf.impl.SolDefaultContext;
import com.neeve.solxf.impl.SolNoopValidator;
import com.neeve.solxf.impl.SolTopic;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public final class SolaceMessageBusBinding
extends MessageBusBindingBase {
    private SolaceSession sendSession;
    private SolaceSession receiveSession;
    private UtlPool<SolaceAcknowledger> acknowledgerPool;
    private UtlPool<SolTopic> dynamicTopicPool;
    private int queueQuota;
    private boolean detachedSends;
    private int detachedSendsQueueDepth;
    private WaitStrategy detachedSendsQueueWaitStrategy;
    private long detachedSendsCpuAffinityMask;
    private boolean detachedDispatch;
    private int detachedDispatchQueueDepth;
    private WaitStrategy detachedDispatchQueueWaitStrategy;
    private long dispatcherCpuAffinityMask;
    private long consumerCpuAffinityMask;
    private long producerCpuAffinityMask;
    private boolean singleSession;
    private String queueName;
    private String vpnName;
    private boolean provisionQueue;
    private long enforceMaxBindCount;
    private boolean failOnInboundMessageHandlingFault;
    private boolean useJNIBinding;
    private boolean setTopicInInboundMsg;
    private String clientName;
    private int failOnSendAfter;
    private long sleepBeforeSempChecks;
    private String address;
    private boolean enableSempRequests;
    private volatile String sempVersion;
    private long sempRequestTimeout;
    private SolaceOrphanSubscriptionCheckPolicy orphanSubscriptionCheckPolicy;
    private int orphanSubscriptionCheckBatchSize;
    private boolean discardSempPrestartMessages;
    private String subscriptionValidationClassName;
    private int smaMetadataVersion;
    private int sessionOpenRetryCount;
    private int sessionOpenRetryInterval;
    private boolean writePayloadInXmlContent;
    private boolean readPayloadFromXmlContent;
    private boolean treatNonXInboundMessagesAsFault;
    private ISolValidator subscriptionValidator;
    private ISolContext solaceContext;
    private XString messageChannelNameBuilder = XString.create((int)256, (boolean)true, (boolean)true);
    private RingBuffer<CarrierEvent> ringBuffer;
    private SequenceBarrier sequenceBarrier;
    private CarrierEventProcessor processor;
    private BatchEventProcessor<CarrierEvent> batchProcessor;
    private Thread dispatcherThread;
    private static final XString.Factory<XPooledString> rcvdTopicFactory = XPooledString.newFactory((String)"solace_rvcdtopic", (int)256, (boolean)true, (int)0, (boolean)true, (boolean)true);

    SolaceMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    private final boolean rationalizePropertyName(Properties providerConfig, String rationalizedPropertyName, boolean defaultValue, String jcsmpPropertyName, String jniPropertyName) {
        return Boolean.parseBoolean(this.rationalizePropertyName(providerConfig, rationalizedPropertyName, (Object)defaultValue, jcsmpPropertyName, jniPropertyName));
    }

    private final int rationalizePropertyName(Properties providerConfig, String rationalizedPropertyName, int defaultValue, String jcsmpPropertyName, String jniPropertyName) {
        return Integer.parseInt(this.rationalizePropertyName(providerConfig, rationalizedPropertyName, (Object)defaultValue, jcsmpPropertyName, jniPropertyName));
    }

    private final String rationalizePropertyName(Properties providerConfig, String rationalizedPropertyName, Object defaultValue, String jcsmpPropertyName, String jniPropertyName) {
        String defaultValueString;
        String propValue = UtlProps.getValue((Properties)providerConfig, (String)rationalizedPropertyName);
        String string = defaultValueString = defaultValue != null ? String.valueOf(defaultValue) : null;
        if (null == propValue) {
            String string2 = propValue = jcsmpPropertyName != null ? UtlProps.getValue((Properties)providerConfig, (String)jcsmpPropertyName) : null;
            if (null == propValue) {
                String string3 = propValue = jniPropertyName != null ? UtlProps.getValue((Properties)providerConfig, (String)jniPropertyName, (String)defaultValueString) : defaultValueString;
                if (null != jniPropertyName) {
                    providerConfig.remove(jniPropertyName);
                }
            } else {
                providerConfig.remove(jcsmpPropertyName);
            }
        } else {
            providerConfig.remove(rationalizedPropertyName);
        }
        if (null != propValue && null != jcsmpPropertyName && null != jniPropertyName) {
            if (defaultValue != null && defaultValue instanceof Boolean) {
                if ("1".equals(propValue)) {
                    propValue = "true";
                } else if ("0".equals(propValue)) {
                    propValue = "false";
                }
            }
            if (this.useJNIBinding) {
                if (defaultValue != null && defaultValue instanceof Boolean) {
                    providerConfig.setProperty(jniPropertyName, Boolean.valueOf(propValue) != false ? "1" : "0");
                } else {
                    providerConfig.setProperty(jniPropertyName, propValue);
                }
            } else {
                providerConfig.setProperty(jcsmpPropertyName, propValue);
            }
        }
        return propValue;
    }

    private final void registerSubscriptionValidator(String address, String vpnName, String userName, String password) {
        this.solaceContext = new SolDefaultContext(address, vpnName, userName, password, this.queueName);
        this.subscriptionValidator = new SolNoopValidator();
        if (null != this.subscriptionValidationClassName) {
            try {
                Class<?> validationClazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.subscriptionValidationClassName);
                if (ISolValidator.class.isAssignableFrom(validationClazz)) {
                    this.subscriptionValidator = (ISolValidator)validationClazz.newInstance();
                } else {
                    this.tracer.log(this.tracePrefix + "Subscription validation class '" + this.subscriptionValidationClassName + "' does not implement validate() method. Will default to noop validator", Tracer.Level.WARNING);
                }
            }
            catch (Exception e) {
                this.tracer.log(this.tracePrefix + "Fail to load subscription validation class '" + this.subscriptionValidationClassName + "'.", Tracer.Level.WARNING);
                e.printStackTrace();
            }
        }
    }

    final void dispatchMessage(SolaceMessageChannel channel, long messageId, IOBuffer serializedMessage, IOBuffer serializedMetadata, XString topic, boolean ackRequired, long originTs, long preWireTs, long postWireTs) throws Exception {
        try {
            channel.onMessage(messageId, serializedMessage, serializedMetadata, topic, ackRequired, originTs, preWireTs, postWireTs);
        }
        catch (Throwable e) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Fault in handling of inbound message by channel [" + e.toString() + "].", Tracer.Level.DEBUG);
            }
            this.onInboundMessageHandlingFault(messageId, topic, serializedMessage, serializedMetadata, (Exception)((Object)new SmaException("Fault in handling of inbound message by channel [id=" + messageId + ", topic=" + topic + "]: " + e.getMessage(), e)));
        }
    }

    final int getSmaMetadataVersion() {
        return this.smaMetadataVersion;
    }

    final int getSessionOpenRetryCount() {
        return this.sessionOpenRetryCount;
    }

    final int getSessionOpenRetryInterval() {
        return this.sessionOpenRetryInterval;
    }

    final SolaceAcknowledger createAcknowledger(long messageId) {
        return ((SolaceAcknowledger)this.acknowledgerPool.get(null)).init(messageId);
    }

    final ISolDynamicTopic createDynamicTopic() {
        return (ISolDynamicTopic)this.dynamicTopicPool.get(null);
    }

    final boolean markAsComplete(MessageBusBinding.FlushContext flushContext) {
        if (flushContext != null) {
            switch (flushContext.flushMode) {
                case SYNC_BLOCKING: {
                    MessageBusBinding.SynchronousBlockingFlushContext syncBlockingFlushContext = (MessageBusBinding.SynchronousBlockingFlushContext)flushContext;
                    syncBlockingFlushContext.complete = true;
                    break;
                }
                case SYNC_NON_BLOCKING: {
                    MessageBusBinding.SynchronousNonBlockingFlushContext syncNonBlockingFlushContext = (MessageBusBinding.SynchronousNonBlockingFlushContext)flushContext;
                    syncNonBlockingFlushContext.complete = true;
                    break;
                }
                case ASYNC: {
                    MessageBusBinding.AsynchronousFlushContext asyncFlushContext = (MessageBusBinding.AsynchronousFlushContext)flushContext;
                    asyncFlushContext.inProgress = false;
                    asyncFlushContext.syncComplete = true;
                    asyncFlushContext.status = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported flush mode '" + flushContext.flushMode + "'");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onMessage(long messageId, IOBuffer serializedMessage, IOBuffer serializedMetadata, XString topic, boolean ackRequired, long originTs, long preWireTs, long postWireTs) throws Exception {
        short channelId;
        this.messageChannelNameBuilder.clear();
        ByteBuffer serializedMetadataByteBuffer = serializedMetadata.takeBuffer();
        try {
            MessageMetadata.getMessageChannelNameToRaw((ByteBuffer)serializedMetadataByteBuffer, (XString)this.messageChannelNameBuilder);
        }
        finally {
            serializedMetadata.releaseBuffer();
        }
        serializedMetadataByteBuffer = serializedMetadata.takeBuffer();
        try {
            channelId = MessageMetadata.getMessageChannelId((ByteBuffer)serializedMetadataByteBuffer);
        }
        finally {
            serializedMetadata.releaseBuffer();
        }
        SolaceMessageChannel channel = (SolaceMessageChannel)this.findMessageChannelForInboundMessageDispatch(this.messageChannelNameBuilder, channelId);
        if (this.enableSempRequests && this.discardSempPrestartMessages && !this.receiveSession.isStarted()) {
            if (ackRequired) {
                if (this.enableSempRequests) {
                    this.tracer.log("Guaranteed message received prior to session start on bus with SEMP requests enabled: [channel=" + (channel == null ? "null" : channel.getNameAsRaw()) + ", topic=" + topic + ", messageId=" + messageId + "] ... dispatching", Tracer.Level.WARNING);
                }
            } else if (this.enableSempRequests) {
                if (this.tracer.fine) {
                    this.tracer.log("Discarding BestEffort message received prior to session start on bus with SEMP requests enabled: [channel=" + (channel == null ? "null" : channel.getNameAsRaw()) + ", topic=" + topic + ", messageId=" + messageId + "]", Tracer.Level.FINE);
                }
                return;
            }
        }
        if (channel != null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Dispatching message sent on channel '" + this.messageChannelNameBuilder + "' via channel '" + channel.getName() + "'.", Tracer.Level.DEBUG);
            }
            if (this.detachedDispatch()) {
                long sequence = this.ringBuffer.next();
                CarrierEvent carrierEvent = (CarrierEvent)this.ringBuffer.get(sequence);
                carrierEvent.receiver = channel;
                carrierEvent.messageId = messageId;
                carrierEvent.serializedMessage = serializedMessage;
                carrierEvent.serializedMetadata = serializedMetadata;
                carrierEvent.topic = topic != null ? rcvdTopicFactory.create(topic, false) : topic;
                carrierEvent.ackRequired = ackRequired;
                carrierEvent.originTs = originTs;
                carrierEvent.preWireTs = preWireTs;
                carrierEvent.postWireTs = postWireTs;
                this.ringBuffer.publish(sequence);
            } else {
                this.dispatchMessage(channel, messageId, serializedMessage, serializedMetadata, topic, ackRequired, originTs, preWireTs, postWireTs);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Channel (name=" + this.messageChannelNameBuilder + ", id=" + channelId + ") not found (or not joined) for inbound message with [id=" + messageId + ", topic=" + topic + "].", Tracer.Level.DEBUG);
            }
            this.onInboundMessageHandlingFault(messageId, topic, serializedMessage, serializedMetadata, (Exception)((Object)new SmaException("Channel (name=" + this.messageChannelNameBuilder + ", id=" + channelId + ") not found (or not joined) for inbound message with [id=" + messageId + ", topic=" + topic + "]")));
        }
    }

    final void onNonXMessage(long messageId, IOBuffer serializedMessage, XString topic) {
        try {
            byte[] serializedMessageBytes = null;
            if (serializedMessage != null) {
                try {
                    serializedMessageBytes = new byte[serializedMessage.getLength()];
                    UtlBuffer.copy((ByteBuffer)serializedMessage.getBufferUnsafe(), (int)0, (byte[])serializedMessageBytes, (int)0, (int)serializedMessageBytes.length);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error copying serialized message buffer to byte array to byte array on non X message.", Tracer.Level.SEVERE);
                }
            }
            super.onNonXMessage((Object)messageId, topic != null ? topic.getValue() : null, (Object)serializedMessage, serializedMessageBytes, (MessageBusBindingBase.Acknowledger)this.createAcknowledger(messageId));
        }
        catch (Throwable e) {
            this.onInboundMessageHandlingFault(messageId, topic, serializedMessage, null, (Exception)((Object)new SmaException("Fault in handling of inbound non X message by channel [id=" + messageId + ", topic=" + topic + "]: " + e.getMessage(), e)));
        }
    }

    final void onInboundMessageHandlingFault(long messageId, XString topic, IOBuffer serializedMessage, IOBuffer serializedMetadata, Exception status) {
        try {
            byte[] serializedMessageBytes = null;
            if (serializedMessage != null) {
                try {
                    serializedMessageBytes = new byte[serializedMessage.getLength()];
                    UtlBuffer.copy((ByteBuffer)serializedMessage.getBufferUnsafe(), (int)0, (byte[])serializedMessageBytes, (int)0, (int)serializedMessageBytes.length);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error copying serialized message buffer to byte array to byte array on inbound fault.", Tracer.Level.SEVERE);
                }
            }
            byte[] serializedMetadataBytes = null;
            if (serializedMetadata != null) {
                try {
                    serializedMetadataBytes = new byte[serializedMetadata.getLength()];
                    UtlBuffer.copy((ByteBuffer)serializedMetadata.getBufferUnsafe(), (int)0, (byte[])serializedMetadataBytes, (int)0, (int)serializedMetadataBytes.length);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error copying serialized serializedMetadata buffer to byte array on inbound fault.", Tracer.Level.SEVERE);
                }
            }
            String topicName = "unknown";
            try {
                topicName = topic != null ? topic.getValue() : null;
            }
            catch (Throwable thrown) {
                ByteBuffer buffer = topic.getBackingBuffer().getIOBuffer().getBufferUnsafe();
                this.tracer.log("Error deserializing recevied topic on inbound message handling fault: [" + UtlBuffer.dump((ByteBuffer)buffer), Tracer.Level.SEVERE);
            }
            super.onInboundMessageHandlingFault((Object)messageId, topicName, null, (Object)serializedMessage, serializedMetadataBytes, serializedMessageBytes, (MessageBusBindingBase.Acknowledger)this.createAcknowledger(messageId), (Throwable)status);
        }
        catch (Throwable thrown) {
            this.tracer.log("Failed to dispatch inbound message handling fault: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
        }
        if (this.failOnInboundMessageHandlingFault) {
            this.onSessionFail(status);
        }
    }

    final void onChannelClose(SolaceMessageChannel channel) {
    }

    final void onSessionReconnecting() {
        this.onEvent((Event)MessageBusBindingReconnectingEvent.create((MessageBusBinding)this));
    }

    final void onSessionReconnected() {
        this.onEvent((Event)MessageBusBindingReconnectedEvent.create((MessageBusBinding)this));
    }

    final void onSessionFail(Exception e) {
        this.doClose();
        this.onFail(e);
    }

    final void onDisruptorFail(Exception e) {
        this.doClose();
        this.onFail(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doOpen() throws SmaException {
        boolean preferJNIBinding;
        Properties providerConfig = new Properties();
        providerConfig.putAll((Map<?, ?>)this.descriptor.getProviderConfig());
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening binding (props=" + providerConfig + ")...", Tracer.Level.DEBUG);
        }
        String vpnUserName = null;
        String password = null;
        try {
            boolean jniExplicitlyConfigured = providerConfig.getProperty("usejni") != null;
            this.useJNIBinding = this.rationalizePropertyName(providerConfig, "usejni", false, (String)null, (String)null);
            preferJNIBinding = this.rationalizePropertyName(providerConfig, "preferjni", true, (String)null, (String)null);
            if (!jniExplicitlyConfigured) {
                if (preferJNIBinding) {
                    try {
                        SolFactory.onlyInstance().assertJNIAvailable();
                        this.useJNIBinding = true;
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "JNI binding prefered, and is unavailable.", Tracer.Level.DEBUG);
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "JNI binding prefered, but is unavailable [" + throwable.getMessage() + "], will fall back to JCSMP.", Tracer.Level.DEBUG);
                        }
                        this.useJNIBinding = false;
                    }
                }
            } else {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Use JNI explicitly configured to " + this.useJNIBinding + ".", Tracer.Level.DEBUG);
                }
                if (this.useJNIBinding) {
                    try {
                        SolFactory.onlyInstance().assertJNIAvailable();
                    }
                    catch (Throwable throwable) {
                        throw new SmaPermanentException(this.tracePrefix + "Binding explicitly configured to use JNI, but JNI implementation is not available: " + throwable.getMessage() + "!", throwable);
                    }
                }
            }
            this.enableSempRequests = this.rationalizePropertyName(providerConfig, "enable_semp", false, (String)null, (String)null);
            this.sempRequestTimeout = this.rationalizePropertyName(providerConfig, "semp_request_timeout", 10000, (String)null, (String)null);
            this.sempVersion = this.rationalizePropertyName(providerConfig, "semp_version", "soltr/7_1_1", null, null);
            this.rationalizePropertyName(providerConfig, "semp_vpn_index", 0, (String)null, (String)null);
            String string = this.rationalizePropertyName(providerConfig, "orphan_subscription_check", "None", null, null);
            this.orphanSubscriptionCheckPolicy = null;
            for (SolaceOrphanSubscriptionCheckPolicy p : SolaceOrphanSubscriptionCheckPolicy.values()) {
                if (!p.name().equalsIgnoreCase(string)) continue;
                this.orphanSubscriptionCheckPolicy = p;
                break;
            }
            if (this.orphanSubscriptionCheckPolicy == null) {
                throw new SmaPermanentException("invalid 'orphan_subscription_check' value (" + string + ") ... permissible values are " + Arrays.asList(UtlDataTypes.getEnumNames(SolaceOrphanSubscriptionCheckPolicy.class)) + " (case insensitive)");
            }
            if (this.orphanSubscriptionCheckPolicy != SolaceOrphanSubscriptionCheckPolicy.None && !this.enableSempRequests) {
                throw new SmaPermanentException("'orphan_subscription_check' of '" + (Object)((Object)this.orphanSubscriptionCheckPolicy) + " requires '" + "enable_semp" + "' to be 'true'.");
            }
            this.orphanSubscriptionCheckBatchSize = this.rationalizePropertyName(providerConfig, "orphan_subscription_check_batch_size", 200, (String)null, (String)null);
            this.smaMetadataVersion = this.rationalizePropertyName(providerConfig, "sma_metadata_version", 1, (String)null, (String)null);
            if (this.smaMetadataVersion > 2 || this.smaMetadataVersion < 1) {
                throw new SmaPermanentException("Invalid SMA metadata version '" + this.smaMetadataVersion + "'.");
            }
            boolean bl = this.rationalizePropertyName(providerConfig, "use_default_queue_name", true, (String)null, (String)null);
            boolean useDefaultQueueNameAsDefaultClientId = this.rationalizePropertyName(providerConfig, "use_default_queue_name_as_default_client_id", false, (String)null, (String)null);
            String defaultQueueName = String.format("X-SMA-%s-%s", this.getName(), this.getUserName());
            this.rationalizePropertyName(providerConfig, "topic_starts_with_channel", "true", null, null);
            this.queueQuota = this.rationalizePropertyName(providerConfig, "queue_quota", 2048, (String)null, (String)null);
            this.detachedSends = Boolean.parseBoolean(this.rationalizePropertyName(providerConfig, "detached_sends", "false", null, null));
            this.detachedSendsQueueDepth = this.rationalizePropertyName(providerConfig, "detached_sends_queue_depth", 1024, (String)null, (String)null);
            this.detachedSendsQueueWaitStrategy = XRuntime.createWaitStrategy((String)this.rationalizePropertyName(providerConfig, "detached_sends_queue_wait_strategy", null, null, null), (boolean)true);
            String senderCpuAffinityMaskDeprecated = this.rationalizePropertyName(providerConfig, "sender_cpu_affinity_mask", "0", null, null);
            this.detachedSendsCpuAffinityMask = UtlThread.parseAffinityMask((String)this.rationalizePropertyName(providerConfig, "detached_sends_cpu_affinity_mask", senderCpuAffinityMaskDeprecated, null, null));
            this.detachedDispatch = Boolean.parseBoolean(this.rationalizePropertyName(providerConfig, "detached_dispatch", "false", null, null));
            this.detachedDispatchQueueDepth = this.rationalizePropertyName(providerConfig, "detached_dispatch_queue_depth", 128, (String)null, (String)null);
            this.detachedDispatchQueueWaitStrategy = XRuntime.createWaitStrategy((String)this.rationalizePropertyName(providerConfig, "detached_dispatch_queue_wait_strategy", null, null, null), (boolean)true);
            this.dispatcherCpuAffinityMask = UtlThread.parseAffinityMask((String)this.rationalizePropertyName(providerConfig, "dispatcher_cpu_affinity_mask", "0", null, null));
            this.consumerCpuAffinityMask = UtlThread.parseAffinityMask((String)this.rationalizePropertyName(providerConfig, "consumer_cpu_affinity_mask", "0", null, null));
            this.producerCpuAffinityMask = UtlThread.parseAffinityMask((String)this.rationalizePropertyName(providerConfig, "producer_cpu_affinity_mask", "0", null, null));
            this.singleSession = this.rationalizePropertyName(providerConfig, "single_session", false, (String)null, (String)null);
            this.provisionQueue = this.rationalizePropertyName(providerConfig, "provision_queue", true, (String)null, (String)null);
            this.enforceMaxBindCount = this.rationalizePropertyName(providerConfig, "enforce_max_bind_count", 0, (String)null, (String)null);
            this.queueName = this.rationalizePropertyName(providerConfig, "queue_name", bl ? defaultQueueName : null, null, null);
            if (this.queueName != null && this.queueName.trim().length() == 0) {
                this.queueName = null;
            }
            this.failOnInboundMessageHandlingFault = this.rationalizePropertyName(providerConfig, "fail_on_inbound_message_handling_fault", false, (String)null, (String)null);
            this.setTopicInInboundMsg = this.rationalizePropertyName(providerConfig, "set_topic_in_inbound_msg", false, (String)null, (String)null);
            this.clientName = this.rationalizePropertyName(providerConfig, "client_name", useDefaultQueueNameAsDefaultClientId ? defaultQueueName : this.getUserName(), null, null);
            this.failOnSendAfter = Integer.parseInt(this.rationalizePropertyName(providerConfig, "fail_on_send_after", "-1", null, null));
            this.address = this.rationalizePropertyName(providerConfig, "Address", null, "jcsmp.HOST", "SESSION_HOST");
            this.sessionOpenRetryCount = this.rationalizePropertyName(providerConfig, "session_open_retry_count", 5, (String)null, (String)null);
            this.sessionOpenRetryInterval = this.rationalizePropertyName(providerConfig, "session_open_retry_interval", 1, (String)null, (String)null);
            this.vpnName = this.rationalizePropertyName(providerConfig, "vpn_name", "default", "jcsmp.VPN_NAME", "SESSION_VPN_NAME");
            vpnUserName = this.rationalizePropertyName(providerConfig, "username", this.vpnName, "jcsmp.USERNAME", "SESSION_USERNAME");
            password = this.rationalizePropertyName(providerConfig, "password", vpnUserName, "jcsmp.PASSWORD", "SESSION_PASSWORD");
            this.rationalizePropertyName(providerConfig, "publish_window_size", 255, "jcsmp.PUB_ACK_WINDOW_SIZE", "SESSION_PUB_WINDOW_SIZE");
            this.rationalizePropertyName(providerConfig, "reconnect_retry_count", 100, "jcsmp.CLIENT_CHANNEL_PROPERTIES.ReconnectRetries", "SESSION_RECONNECT_RETRIES");
            this.rationalizePropertyName(providerConfig, "connect_retry_count", 3, "jcsmp.CLIENT_CHANNEL_PROPERTIES.connectRetries", "SESSION_CONNECT_RETRIES");
            this.sleepBeforeSempChecks = (long)UtlUnit.parseDuration((String)this.rationalizePropertyName(providerConfig, "sleep_before_semp_checks", "0", null, null), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
            this.discardSempPrestartMessages = this.rationalizePropertyName(providerConfig, "discard_semp_prestart_messages", true, (String)null, (String)null);
            if (XRuntime.optimizeForLatency()) {
                this.rationalizePropertyName(providerConfig, "tcp_nodelay", true, "jcsmp.CLIENT_CHANNEL_PROPERTIES.tcpNoDelay", "SESSION_TCP_NODELAY");
            } else {
                this.rationalizePropertyName(providerConfig, "tcp_nodelay", false, "jcsmp.CLIENT_CHANNEL_PROPERTIES.tcpNoDelay", "SESSION_TCP_NODELAY");
            }
            this.rationalizePropertyName(providerConfig, "reapply_subscriptions", true, "jcsmp.REAPPLY_SUBSCRIPTIONS", "SESSION_REAPPLY_SUBSCRIPTIONS");
            providerConfig.remove("set_bus_and_channel_on_receipt");
            providerConfig.remove("set_key_on_receipt");
            boolean ignoreSubscription = this.rationalizePropertyName(providerConfig, "ignore_subscriptions_error", true, "jcsmp.IGNORE_DUPLICATE_SUBSCRIPTION_ERROR", "SESSION_IGNORE_DUP_SUBSCRIPTION_ERROR");
            if (!this.useJNIBinding) {
                providerConfig.setProperty("jcsmp.IGNORE_SUBSCRIPTION_NOT_FOUND_ERROR", "" + ignoreSubscription);
            }
            providerConfig.keySet().removeAll(MessageBusBindingBase.knownProperties);
            this.subscriptionValidationClassName = this.rationalizePropertyName(providerConfig, "subscription_validator", null, null, null);
            this.writePayloadInXmlContent = this.rationalizePropertyName(providerConfig, "write_payload_in_xml_content", false, (String)null, (String)null);
            this.readPayloadFromXmlContent = this.rationalizePropertyName(providerConfig, "read_payload_from_xml_content", false, (String)null, (String)null);
            this.treatNonXInboundMessagesAsFault = this.rationalizePropertyName(providerConfig, "treat_non_x_inbound_as_fault", true, (String)null, (String)null);
        }
        catch (SmaPermanentException e) {
            throw e;
        }
        catch (RuntimeException re) {
            throw new SmaPermanentException(this.tracePrefix + "Error configuring binding: " + re.getMessage(), (Throwable)re);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...address=" + this.address + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...topicStartsWithChannel=" + this.topicStartsWithChannel + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...queueQuota=" + this.queueQuota + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...detachedSends=" + this.detachedSends + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...detachedSendsQueueDepth=" + this.detachedSendsQueueDepth + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...detachedDispatch=" + this.detachedDispatch + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...detachedDispatchQueueDepth=" + this.detachedDispatchQueueDepth + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...singleSession=" + this.singleSession + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...sessionOpenRetryCount=" + this.sessionOpenRetryCount + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...sessionOpenRetryInterval=" + this.sessionOpenRetryInterval + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...queueName=" + this.queueName + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...failOnInboundMessageHandlingFault=" + this.failOnInboundMessageHandlingFault + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...useJNIBinding=" + this.useJNIBinding + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...preferJNIBinding=" + preferJNIBinding + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...senderCpuAffinityMask=" + this.detachedSendsCpuAffinityMask + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...dispatcherCpuAffinityMask=" + this.dispatcherCpuAffinityMask + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...consumerCpuAffinityMask=" + this.consumerCpuAffinityMask + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...producerCpuAffinityMask=" + this.producerCpuAffinityMask + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...setTopicInInboundMsg=" + this.setTopicInInboundMsg + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...setBusAndChannelOnReceipt=" + this.setBusAndChannelOnReceipt + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...setKeyOnReceipt=" + this.setKeyOnReceipt + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...clientName=" + this.clientName + ".", Tracer.Level.DEBUG);
        }
        if (this.failOnSendAfter > 0 && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...failOnSendAfter=" + this.failOnSendAfter + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...enableSempRequests=" + this.enableSempRequests + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...sempRequestTimeout=" + UtlUnit.formatDuration((double)this.sempRequestTimeout, (TimeUnit)TimeUnit.MILLISECONDS) + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...sempVersion=" + this.sempVersion + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...orphanSubscriptionCheckPolicyName=" + (Object)((Object)this.orphanSubscriptionCheckPolicy) + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...orphanSubscriptionCheckBatchSize=" + this.orphanSubscriptionCheckBatchSize + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...enforceMaxBindCount=" + this.enforceMaxBindCount + ".", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...discardSempPrestartMessages=" + this.discardSempPrestartMessages + ".", Tracer.Level.DEBUG);
        }
        if (this.sleepBeforeSempChecks > 0L && this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...sleepBeforeSempChecks=" + UtlUnit.formatDuration((double)this.sleepBeforeSempChecks, (TimeUnit)TimeUnit.MILLISECONDS) + ".", Tracer.Level.DEBUG);
        }
        if (this.writePayloadInXmlContent || this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...writePayloadInXmlContent=" + this.writePayloadInXmlContent + ".", Tracer.Level.SEVERE);
        }
        if (this.readPayloadFromXmlContent || this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...readPayloadFromXmlContent=" + this.readPayloadFromXmlContent + ".", Tracer.Level.WARNING);
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...treatNonXInboundMessagesAsFault=" + this.treatNonXInboundMessagesAsFault + ".", Tracer.Level.DEBUG);
        }
        if (this.writePayloadInXmlContent) {
            this.tracer.log(this.tracePrefix + "write_payload_in_xml_content" + "  IS NOT SUPPORTED FOR PRODUCTION USE IT IS ONLY INTENDED FOR TESTING SCENARIOS.", Tracer.Level.SEVERE);
        }
        if (this.readPayloadFromXmlContent) {
            this.tracer.log(this.tracePrefix + "read_payload_from_xml_content" + " IS ENABLED. THIS IS UNSUPPORTED FUNCTIONALITY AND IS NOT RECOMMENDED FOR PRODUCTION.", Tracer.Level.SEVERE);
        }
        if (this.tracer.debug) {
            for (Map.Entry<Object, Object> entry : providerConfig.entrySet()) {
                String string = (String)entry.getKey();
                if (!this.tracer.debug) continue;
                this.tracer.log(this.tracePrefix + "..." + string + "=" + providerConfig.getProperty(string) + ".", Tracer.Level.DEBUG);
            }
        }
        HashSet<String> unKnownProperties = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : providerConfig.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.useJNIBinding && !key.toLowerCase().startsWith("jcsmp")) {
                this.tracer.log(this.tracePrefix + "Unknown property  '" + key + "' specified, Ignoring ...", Tracer.Level.WARNING);
                unKnownProperties.add(key);
                continue;
            }
            if (!this.useJNIBinding || key.toLowerCase().startsWith("session") || key.toLowerCase().startsWith("flow")) continue;
            this.tracer.log(this.tracePrefix + "Unknown property  '" + key + "' specified, Ignoring ...", Tracer.Level.WARNING);
            unKnownProperties.add(key);
        }
        providerConfig.keySet().removeAll(unKnownProperties);
        SolFactory.onlyInstance().setIsJNI(this.useJNIBinding);
        this.acknowledgerPool = UtlPool.create((String)"sol-acknowledger", (String)(this.getUserName() + "." + this.getName()), (UtlPool.Factory)new AcknowledgerFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
        this.dynamicTopicPool = UtlPool.create((String)"sol-dynamic-topic", (String)(this.getUserName() + "." + this.getName()), (UtlPool.Factory)new DynamicTopicFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(this.detachedSends));
        if (this.detachedDispatch()) {
            SingleThreadedClaimStrategy singleThreadedClaimStrategy = new SingleThreadedClaimStrategy(this.getDetachedDispatchQueueDepth());
            WaitStrategy waitStrategy = this.getDetachedDispatchQueueWaitStrategy();
            this.processor = new CarrierEventProcessor();
            this.ringBuffer = new RingBuffer((EventFactory)new EventFactory<CarrierEvent>(){

                public CarrierEvent newInstance() {
                    return new CarrierEvent();
                }
            }, (ClaimStrategy)singleThreadedClaimStrategy, waitStrategy);
            this.sequenceBarrier = UtlThread.asIntrumentedSequenceBarrier((SequenceBarrier)this.ringBuffer.newBarrier(new Sequence[0]));
            this.batchProcessor = new BatchEventProcessor(this.ringBuffer, this.sequenceBarrier, (EventHandler)this.processor);
            this.batchProcessor.setExceptionHandler((ExceptionHandler)this.processor);
            this.ringBuffer.setGatingSequences(new Sequence[]{this.batchProcessor.getSequence()});
        } else {
            this.processor = null;
            this.ringBuffer = null;
            this.sequenceBarrier = null;
            this.batchProcessor = null;
            this.dispatcherThread = null;
        }
        if (this.address != null) {
            this.sendSession = new SolaceSession(this, true, this.singleSession, this.userName, this.descriptor, providerConfig, this.useJNIBinding, this.treatNonXInboundMessagesAsFault);
            this.receiveSession = this.singleSession ? this.sendSession : new SolaceSession(this, false, true, this.userName, this.descriptor, providerConfig, this.useJNIBinding, this.treatNonXInboundMessagesAsFault);
            this.sendSession.open();
            if (!this.singleSession) {
                try {
                    this.receiveSession.open();
                }
                catch (Throwable throwable) {
                    try {
                        this.receiveSession.close();
                    }
                    finally {
                        this.sendSession.close();
                    }
                    if (throwable instanceof SmaPermanentException) {
                        throw (SmaPermanentException)throwable;
                    }
                    if (throwable instanceof SmaException) {
                        throw (SmaException)throwable;
                    }
                    throw new SmaException(throwable);
                }
            }
        } else {
            throw new SmaException("Invalid provider configuration [missing 'Address' property]");
        }
        this.registerSubscriptionValidator(this.address, this.vpnName, vpnUserName, password);
    }

    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new SolaceMessageChannel(descriptor, this, this.sendSession, this.receiveSession, this.useJNIBinding);
    }

    protected final void doStart() throws SmaException {
        if (this.detachedDispatch()) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Starting dispatcher thread...", Tracer.Level.DEBUG);
            }
            this.dispatcherThread = new Thread((Runnable)this.batchProcessor){

                @Override
                public final void run() {
                    if (SolaceMessageBusBinding.this.getDispatcherCpuAffinityMask() != 0L) {
                        UtlThread.setCPUAffinityMask((long)SolaceMessageBusBinding.this.getDispatcherCpuAffinityMask());
                    } else {
                        UtlThread.setDefaultCPUAffinityMask();
                    }
                    super.run();
                }
            };
            this.dispatcherThread.setName("X-SMA-Solace-Dispatcher-" + this.getName());
            this.dispatcherThread.setDaemon(true);
            this.dispatcherThread.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Starting binding...", Tracer.Level.DEBUG);
        }
        ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-solace");
        String productInfoString = "X Solace Binding : [" + productInfo.getComponentVersionString() + " / " + (this.useJNIBinding ? "JNI]" : "JCSMP]");
        this.tracer.log(this.tracePrefix + "Solace version : " + this.sendSession.getVersion() + " / " + productInfoString, Tracer.Level.INFO);
        this.sendSession.start();
        if (!this.singleSession) {
            try {
                this.receiveSession.start();
            }
            catch (Throwable e) {
                if (e instanceof SmaException) {
                    throw (SmaException)e;
                }
                throw new SmaException(e);
            }
        }
    }

    protected final void doFlush(MessageBusBinding.FlushContext flushContext) throws SmaException {
        this.markAsComplete(flushContext);
    }

    protected final boolean doCanFail() {
        return true;
    }

    protected final boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() {
        if (!this.singleSession && this.receiveSession != null) {
            this.receiveSession.close();
        }
        if (this.sendSession != null) {
            this.sendSession.close();
        }
        if (this.acknowledgerPool != null) {
            this.acknowledgerPool.close();
        }
        if (this.batchProcessor != null) {
            this.batchProcessor.halt();
        }
        if (this.dispatcherThread != null && Thread.currentThread() != this.dispatcherThread) {
            int attempts = 0;
            while (++attempts <= 5 && this.dispatcherThread.isAlive()) {
                try {
                    if (this.batchProcessor != null) {
                        this.batchProcessor.halt();
                    }
                    this.dispatcherThread.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UtlThread.deregister((Thread)this.dispatcherThread);
            }
            this.dispatcherThread = null;
        }
    }

    final boolean detachedSends() {
        return this.detachedSends;
    }

    final int getDetachedSendsQueueDepth() {
        return this.detachedSendsQueueDepth;
    }

    final WaitStrategy getDetachedSendsQueueWaitStrategy() {
        return this.detachedSendsQueueWaitStrategy;
    }

    final long getDetachedSendsCpuAffinityMask() {
        return this.detachedSendsCpuAffinityMask;
    }

    final boolean detachedDispatch() {
        return this.detachedDispatch;
    }

    final int getDetachedDispatchQueueDepth() {
        return this.detachedDispatchQueueDepth;
    }

    final WaitStrategy getDetachedDispatchQueueWaitStrategy() {
        return this.detachedDispatchQueueWaitStrategy;
    }

    final long getDispatcherCpuAffinityMask() {
        return this.dispatcherCpuAffinityMask;
    }

    final long getConsumerSessionCpuAffinityMask() {
        return this.consumerCpuAffinityMask;
    }

    final long getProducerSessionCpuAffinityMask() {
        return this.producerCpuAffinityMask;
    }

    final String vpnName() {
        return this.vpnName;
    }

    final String queueName() {
        return this.queueName;
    }

    final boolean isProvisionQueue() {
        return this.provisionQueue;
    }

    final long enforceMaxBindCount() {
        return this.enforceMaxBindCount;
    }

    final int queueQuota() {
        return this.queueQuota;
    }

    final boolean isSetTopicInInboundMsg() {
        return this.setTopicInInboundMsg || this.setKeyOnReceipt;
    }

    final String clientName() {
        return this.clientName;
    }

    final String getAddress() {
        return this.address;
    }

    SolaceOrphanSubscriptionCheckPolicy orphanSubscriptionCheckPolicy() {
        return this.orphanSubscriptionCheckPolicy;
    }

    int orphanSubscriptionCheckBatchSize() {
        return this.orphanSubscriptionCheckBatchSize;
    }

    boolean enableSempRequests() {
        return this.enableSempRequests;
    }

    String sempVersion() {
        return this.sempVersion;
    }

    void setSempVersion(String sempVersion) {
        this.sempVersion = sempVersion;
    }

    public long sempRequestTimeout() {
        return this.sempRequestTimeout;
    }

    final boolean discardSempPrestartMessages() {
        return this.discardSempPrestartMessages;
    }

    final ISolValidator getSubscriptionValidationHandler() {
        return this.subscriptionValidator;
    }

    public final boolean isWritePayloadInXmlContent() {
        return this.writePayloadInXmlContent;
    }

    public final boolean isReadPayloadFromXmlContent() {
        return this.readPayloadFromXmlContent;
    }

    public final ISolContext getSolaceContext() {
        return this.solaceContext;
    }

    final boolean isSingleSession() {
        return this.singleSession;
    }

    final boolean isUseJNIBinding() {
        return this.useJNIBinding;
    }

    final boolean isFailOnNextSend() {
        if (this.failOnSendAfter > 0) {
            --this.failOnSendAfter;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Fail on send after '" + this.failOnSendAfter + "'.", Tracer.Level.DEBUG);
            }
            return this.failOnSendAfter == 0;
        }
        return false;
    }

    final long sleepBeforeSempChecksMillis() {
        return this.sleepBeforeSempChecks;
    }

    public final void getStats(StringBuilder buffer) {
        if (this.receiveSession != null) {
            this.receiveSession.getStats(buffer);
        }
        if (this.sendSession != null) {
            this.sendSession.getStats(buffer);
        }
    }

    private final class CarrierEventProcessor
    implements EventHandler<CarrierEvent>,
    ExceptionHandler {
        private CarrierEventProcessor() {
        }

        public final void onEvent(CarrierEvent event, long sequence, boolean endOfBatch) throws Exception {
            SolaceMessageBusBinding.this.dispatchMessage(event.receiver, event.messageId, event.serializedMessage, event.serializedMetadata, event.topic, event.ackRequired, event.originTs, event.preWireTs, event.postWireTs);
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            try {
                if (SolaceMessageBusBinding.this.failOnInboundMessageHandlingFault) {
                    SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Detached dispatch event loop exception, failing binding: " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.SEVERE);
                    SolaceMessageBusBinding.this.onDisruptorFail((Exception)((Object)new SmaException("Detached dispatch event loop exception", ex)));
                } else {
                    SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Detached dispatch event loop exception (ignoring) : " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.WARNING);
                }
            }
            catch (Throwable thrown) {
                SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Detached dispatch event loop exception: " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.WARNING);
            }
        }

        public void handleOnStartException(Throwable ex) {
            try {
                SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Error starting detached dispatch disruptor event loop, failing binding ': " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.SEVERE);
                SolaceMessageBusBinding.this.onDisruptorFail((Exception)((Object)new SmaException("Error starting detached dispatch event loop", ex)));
            }
            catch (Throwable thrown) {
                SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Detached dispatch event loop exception: " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.WARNING);
            }
        }

        public void handleOnShutdownException(Throwable ex) {
            SolaceMessageBusBinding.this.tracer.log(SolaceMessageBusBinding.this.tracePrefix + "Error in detached dispatch disruptor close: " + UtlThrowable.prepareStackTrace((Throwable)ex), Tracer.Level.WARNING);
        }
    }

    private final class CarrierEvent {
        SolaceMessageChannel receiver;
        long messageId;
        IOBuffer serializedMessage;
        IOBuffer serializedMetadata;
        XString topic;
        boolean ackRequired;
        long originTs;
        long preWireTs;
        long postWireTs;

        private CarrierEvent() {
        }
    }

    private final class DynamicTopicFactory
    implements UtlPool.Factory<SolTopic> {
        private DynamicTopicFactory() {
        }

        public final SolTopic createItem(Object object) {
            return (SolTopic)((Object)SolFactory.onlyInstance().createDynamicTopic());
        }

        public final SolTopic[] createItemArray(int size) {
            return new SolTopic[size];
        }
    }

    private final class AcknowledgerFactory
    implements UtlPool.Factory<SolaceAcknowledger> {
        private AcknowledgerFactory() {
        }

        public final SolaceAcknowledger createItem(Object object) {
            return new SolaceAcknowledger();
        }

        public final SolaceAcknowledger[] createItemArray(int size) {
            return new SolaceAcknowledger[size];
        }
    }

    private final class SolaceAcknowledger
    extends MessageBusBindingBase.Acknowledger<SolaceAcknowledger> {
        private long _messageId;

        SolaceAcknowledger() {
            super((MessageBusBindingBase)SolaceMessageBusBinding.this);
        }

        final SolaceAcknowledger init(long messageId) {
            this._messageId = messageId;
            return this;
        }

        protected final void doAck() {
            SolaceMessageBusBinding.this.receiveSession.ack(this._messageId);
        }

        protected final void doReset() {
            this.init(0L);
        }
    }
}

