/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.xbuf2;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.serialization.rumi.xbuf2.IFuelFigure;
import com.neeve.perf.serialization.rumi.xbuf2.MessageFactory;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="12/6/25 1:35 PM", buildInfo="nvx-perf-models-3.17-SNAPSHOT (nvx-codegen-plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=102)
@JsonPropertyOrder(value={"speed", "mpg"})
public final class FuelFigure
implements IFuelFigure,
UtlPool.Item<FuelFigure>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final FuelFigurePoolFactory _fuelFigureFactory = new FuelFigurePoolFactory();
    private static final FuelFigurePojoPoolFactory _fuelFigurePojoFactory = new FuelFigurePojoPoolFactory();
    private static final FuelFigureSerializerPoolFactory _fuelFigureSerializerFactory = new FuelFigureSerializerPoolFactory();
    private static final FuelFigureDeserializerPoolFactory _fuelFigureDeserializerFactory = new FuelFigureDeserializerPoolFactory();
    static final UtlPool<FuelFigure> _entityPool = UtlPool.create((String)"quark.entity", (String)"FuelFigureQuarkEntity.1.102", (UtlPool.Factory)_fuelFigureFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(FuelFigure.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new FuelFigurePoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"FuelFigureQuarkEntityPojo.1.102", (UtlPool.Factory)_fuelFigurePojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new FuelFigurePojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"FuelFigureQuarkEntitySerializer.1.102", (UtlPool.Factory)_fuelFigureSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new FuelFigureSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"FuelFigureQuarkEntityDeserializer.1.102", (UtlPool.Factory)_fuelFigureDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new FuelFigureDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<FuelFigure> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final FuelFigure[] EMPTY_ARRAY = new FuelFigure[0];

    FuelFigure() {
    }

    public static FuelFigure create() {
        FuelFigure entity = (FuelFigure)_entityPool.get(null);
        _memoryStats.onEntityAllocated(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(-32869);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final FuelFigure deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final FuelFigure deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final FuelFigure deserializeFrom(FuelFigure val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final FuelFigure deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final FuelFigure wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final FuelFigure deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final FuelFigure deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final FuelFigure deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final FuelFigure deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FuelFigure deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            FuelFigure fuelFigure = this.deserializeFrom(bytebuf);
            return fuelFigure;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final FuelFigure deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final FuelFigure deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final FuelFigure deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            FuelFigure fuelFigure = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return fuelFigure;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final FuelFigure deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final FuelFigure deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final FuelFigure deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(FuelFigure copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final FuelFigure copy() {
        FuelFigure copy = FuelFigure.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getSpeedFieldId() {
        return 16;
    }

    @Override
    @JsonProperty(value="speed")
    public final void setSpeed(short val) {
        this.pojo().setSpeed(val);
    }

    @Override
    @JsonIgnore
    public final void setSpeedAsObject(Short val) {
        if (val == null) {
            this.clearSpeed();
        } else {
            this.setSpeed(val);
        }
    }

    @Override
    @JsonIgnore
    public final short getSpeed() {
        return this.pojo().getSpeed();
    }

    @Override
    @JsonProperty(value="speed")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Short getSpeedAsObject() {
        if (!this.hasSpeed()) {
            return null;
        }
        return this.getSpeed();
    }

    @Override
    public final boolean hasSpeed() {
        return this.pojo().hasSpeed();
    }

    @Override
    public final void clearSpeed() {
        this.pojo().clearSpeed();
    }

    public static final int getMpgFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="mpg")
    public final void setMpg(float val) {
        this.pojo().setMpg(val);
    }

    @Override
    @JsonIgnore
    public final void setMpgAsObject(Float val) {
        if (val == null) {
            this.clearMpg();
        } else {
            this.setMpg(val.floatValue());
        }
    }

    @Override
    @JsonIgnore
    public final float getMpg() {
        return this.pojo().getMpg();
    }

    @Override
    @JsonProperty(value="mpg")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Float getMpgAsObject() {
        if (!this.hasMpg()) {
            return null;
        }
        return Float.valueOf(this.getMpg());
    }

    @Override
    public final boolean hasMpg() {
        return this.pojo().hasMpg();
    }

    @Override
    public final void clearMpg() {
        this.pojo().clearMpg();
    }

    public final FuelFigure init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final FuelFigure setPool(UtlPool<FuelFigure> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<FuelFigure> getPool() {
        return this._pool;
    }

    public final FuelFigure acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        FuelFigure clonee = FuelFigure.create();
        if (this.hasSpeed()) {
            clonee.setSpeed(this.getSpeed());
        }
        if (this.hasMpg()) {
            clonee.setMpg(this.getMpg());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasSpeed()) {
            builder.append(0 == c++ ? "" : ",").append("Speed=").append(this.getSpeed());
        }
        if (this.hasMpg()) {
            builder.append(0 == c++ ? "" : ",").append("Mpg=").append(this.getMpg());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private short _usrSpeed;
        private float _usrMpg;

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasSpeed() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final short getSpeed() {
            return this._usrSpeed;
        }

        public final void setSpeed(short val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrSpeed = val;
            this._dirty = true;
        }

        public final void clearSpeed() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasSpeed()) {
                return;
            }
            this._usrSpeed = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final boolean hasMpg() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final float getMpg() {
            return this._usrMpg;
        }

        public final void setMpg(float val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            this._usrMpg = val;
            this._dirty = true;
        }

        public final void clearMpg() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasMpg()) {
                return;
            }
            this._usrMpg = 0.0f;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._usrSpeed = 0;
            this._usrMpg = 0.0f;
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasSpeed()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)16, (short)this._usrSpeed);
            }
            if (this.hasMpg()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)17, (float)this._usrMpg);
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasSpeed()) {
                serializer.speed(this._usrSpeed);
            }
            if (this.hasMpg()) {
                serializer.mpg(this._usrMpg);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleSpeed(short val) {
                Pojo.this.setSpeed(val);
            }

            @Override
            public final void handleMpg(float val) {
                Pojo.this.setMpg(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block10: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 16: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 16");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleSpeed((short)QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block10;
                    }
                    case 17: {
                        if (ftype != 5) {
                            throw new IllegalStateException("field type mismatch (exp=0x05, actual=" + ftype + ") for field 17");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleMpg(QuarkBuffer.getFloat((long)addr, (int)(pos + tlen)));
                        flen = 4;
                        continue block10;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block10;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block10;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleSpeed(short var1);

            public void handleMpg(float var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private FuelFigure _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(FuelFigure entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer speed(short val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)16, (short)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)128);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer mpg(float val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)17, (float)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)141);
            QuarkBuffer.putFloat((long)this._addr, (int)this._len, (float)val);
            this._len += 4;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class FuelFigureDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private FuelFigureDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class FuelFigureDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private FuelFigureDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class FuelFigureSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private FuelFigureSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class FuelFigureSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private FuelFigureSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class FuelFigurePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private FuelFigurePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class FuelFigurePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private FuelFigurePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class FuelFigurePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<FuelFigure> {
        private FuelFigurePoolEvictedItemReceiver() {
        }

        public final void process(FuelFigure evictedItem) {
            _memoryStats.onEntityLeaked(FuelFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class FuelFigurePoolFactory
    implements UtlPool.Factory<FuelFigure> {
        private FuelFigurePoolFactory() {
        }

        public final FuelFigure createItem(Object object) {
            return new FuelFigure();
        }

        public final FuelFigure[] createItemArray(int size) {
            return new FuelFigure[size];
        }
    }

    static final class FuelFigurePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        FuelFigurePoolFactoryItemCreateArgument() {
        }

        FuelFigurePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(-32869, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

