/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.xbuf2;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedList;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.serialization.rumi.xbuf2.Acceleration;
import com.neeve.perf.serialization.rumi.xbuf2.IPerformanceFigure;
import com.neeve.perf.serialization.rumi.xbuf2.MessageFactory;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="11/16/25 4:17 AM", buildInfo="nvx-perf-models-3.16-SNAPSHOT (nvx-codegen-plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=103)
@JsonPropertyOrder(value={"octaneRating", "acceleration"})
public final class PerformanceFigure
implements IPerformanceFigure,
UtlPool.Item<PerformanceFigure>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final PerformanceFigurePoolFactory _performanceFigureFactory = new PerformanceFigurePoolFactory();
    private static final PerformanceFigurePojoPoolFactory _performanceFigurePojoFactory = new PerformanceFigurePojoPoolFactory();
    private static final PerformanceFigureSerializerPoolFactory _performanceFigureSerializerFactory = new PerformanceFigureSerializerPoolFactory();
    private static final PerformanceFigureDeserializerPoolFactory _performanceFigureDeserializerFactory = new PerformanceFigureDeserializerPoolFactory();
    static final UtlPool<PerformanceFigure> _entityPool = UtlPool.create((String)"quark.entity", (String)"PerformanceFigureQuarkEntity.1.103", (UtlPool.Factory)_performanceFigureFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(PerformanceFigure.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigurePoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"PerformanceFigureQuarkEntityPojo.1.103", (UtlPool.Factory)_performanceFigurePojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigurePojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"PerformanceFigureQuarkEntitySerializer.1.103", (UtlPool.Factory)_performanceFigureSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigureSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"PerformanceFigureQuarkEntityDeserializer.1.103", (UtlPool.Factory)_performanceFigureDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new PerformanceFigureDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<PerformanceFigure> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final PerformanceFigure[] EMPTY_ARRAY = new PerformanceFigure[0];

    PerformanceFigure() {
    }

    public static PerformanceFigure create() {
        PerformanceFigure entity = (PerformanceFigure)_entityPool.get(null);
        _memoryStats.onEntityAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(-32870);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final PerformanceFigure deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final PerformanceFigure deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final PerformanceFigure deserializeFrom(PerformanceFigure val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final PerformanceFigure deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final PerformanceFigure wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final PerformanceFigure deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final PerformanceFigure deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final PerformanceFigure deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final PerformanceFigure deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PerformanceFigure deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            PerformanceFigure performanceFigure = this.deserializeFrom(bytebuf);
            return performanceFigure;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final PerformanceFigure deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final PerformanceFigure deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final PerformanceFigure deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            PerformanceFigure performanceFigure = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return performanceFigure;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final PerformanceFigure deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final PerformanceFigure deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final PerformanceFigure deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(PerformanceFigure copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final PerformanceFigure copy() {
        PerformanceFigure copy = PerformanceFigure.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getOctaneRatingFieldId() {
        return 16;
    }

    @Override
    @JsonProperty(value="octaneRating")
    public final void setOctaneRating(byte val) {
        this.pojo().setOctaneRating(val);
    }

    @Override
    @JsonIgnore
    public final byte getOctaneRating() {
        return this.pojo().getOctaneRating();
    }

    @Override
    @JsonProperty(value="octaneRating")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Byte getOctaneRatingAsObject() {
        if (!this.hasOctaneRating()) {
            return null;
        }
        return this.getOctaneRating();
    }

    @Override
    public final boolean hasOctaneRating() {
        return this.pojo().hasOctaneRating();
    }

    @Override
    public final void clearOctaneRating() {
        this.pojo().clearOctaneRating();
    }

    public static final int getAccelerationFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void setAcceleration(Acceleration[] val) {
        this.pojo().clearAcceleration();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToAcceleration(val[i]);
            }
        }
    }

    @Override
    public final void lendAcceleration(Acceleration[] val) {
        this.pojo().clearAcceleration();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToAcceleration(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setAccelerationFrom(XIterator<Acceleration> val) {
        this.pojo().clearAcceleration();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                Acceleration v = (Acceleration)val.next();
                if (v == null) continue;
                this.pojo().addToAcceleration(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendAccelerationFrom(XIterator<Acceleration> val) {
        this.pojo().clearAcceleration();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                Acceleration v = (Acceleration)val.next();
                if (v == null) continue;
                this.pojo().lendToAcceleration(v);
            }
        }
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void addAcceleration(Acceleration val) {
        this.pojo().addToAcceleration(val);
    }

    @Override
    @JsonProperty(value="acceleration")
    public final void lendAcceleration(Acceleration val) {
        this.pojo().lendToAcceleration(val);
    }

    @Override
    @JsonProperty(value="acceleration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Acceleration[] getAcceleration() {
        int count = this.pojo().getAccelerationCount();
        if (count > 0) {
            Acceleration[] val = new Acceleration[count];
            XIterator<Acceleration> iterator = this.pojo().getAccelerationIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (Acceleration)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final Acceleration[] getAccelerationEmptyIfNull() {
        Acceleration[] val = this.getAcceleration();
        return val != null ? val : Acceleration.EMPTY_ARRAY;
    }

    @Override
    public final XIterator<Acceleration> getAccelerationIterator() {
        return this.pojo().getAccelerationIterator();
    }

    @Override
    public final Acceleration[] takeAcceleration() {
        int count = this.pojo().getAccelerationCount();
        if (count > 0) {
            Acceleration[] val = new Acceleration[count];
            XIterator<Acceleration> iterator = this.pojo().getAccelerationIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (Acceleration)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearAcceleration() {
        this.pojo().clearAcceleration();
    }

    public final PerformanceFigure init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final PerformanceFigure setPool(UtlPool<PerformanceFigure> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<PerformanceFigure> getPool() {
        return this._pool;
    }

    public final PerformanceFigure acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        Acceleration[] cloner_acceleration;
        PerformanceFigure clonee = PerformanceFigure.create();
        if (this.hasOctaneRating()) {
            clonee.setOctaneRating(this.getOctaneRating());
        }
        if ((cloner_acceleration = this.getAcceleration()) != null) {
            Acceleration[] clonee_acceleration = new Acceleration[cloner_acceleration.length];
            for (int i = 0; i < cloner_acceleration.length; ++i) {
                clonee_acceleration[i] = (Acceleration)cloner_acceleration[i].clone();
            }
            clonee.setAcceleration(clonee_acceleration);
        } else {
            clonee.setAcceleration(null);
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasOctaneRating()) {
            builder.append(0 == c++ ? "" : ",").append("OctaneRating=").append(this.getOctaneRating());
        }
        builder.append(0 == c++ ? "" : ",").append("Acceleration=").append(Arrays.toString(this.getAcceleration()));
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private byte _usrOctaneRating;
        private final XLinkedList<Acceleration> _usrAcceleration = new XLinkedList();

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasOctaneRating() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final byte getOctaneRating() {
            return this._usrOctaneRating;
        }

        public final void setOctaneRating(byte val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrOctaneRating = val;
            this._dirty = true;
        }

        public final void clearOctaneRating() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasOctaneRating()) {
                return;
            }
            this._usrOctaneRating = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final int getAccelerationCount() {
            return this._usrAcceleration.size();
        }

        public final XIterator<Acceleration> getAccelerationIterator() {
            return this._usrAcceleration.reusableIterator();
        }

        public final void addToAcceleration(Acceleration val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void addToAccelerationFrom(Acceleration.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            Acceleration val = Acceleration.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void lendToAcceleration(Acceleration val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrAcceleration.add((Object)val);
            this._dirty = true;
        }

        public final void clearAcceleration() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrAcceleration.size() == 0) {
                return;
            }
            XIterator<Acceleration> iterator = this.getAccelerationIterator();
            while (iterator.hasNext()) {
                Acceleration val = (Acceleration)iterator.next();
                iterator.remove();
                val.dispose();
            }
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._usrOctaneRating = 0;
            this.clearAcceleration();
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasOctaneRating()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)16, (byte)this._usrOctaneRating);
            }
            XIterator<Acceleration> accelerationIterator = this.getAccelerationIterator();
            while (accelerationIterator.hasNext()) {
                Acceleration val = (Acceleration)accelerationIterator.next();
                len += val.hasDirtyPojo() ? XbufUtil.varlenFieldSerializedLength((int)17, (int)val.pojo().getSerializedLength()) : XbufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedBufferLength());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasOctaneRating()) {
                serializer.octaneRating(this._usrOctaneRating);
            }
            XIterator<Acceleration> accelerationIterator = this.getAccelerationIterator();
            while (accelerationIterator.hasNext()) {
                Acceleration val = (Acceleration)accelerationIterator.next();
                serializer.acceleration(val);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleOctaneRating(byte val) {
                Pojo.this.setOctaneRating(val);
            }

            @Override
            public final void handleAcceleration(Acceleration.Deserializer val) {
                Pojo.this.addToAccelerationFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final Acceleration.Deserializer _accelerationDeserializer = Acceleration.Deserializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block10: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 16: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 16");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleOctaneRating((byte)QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block10;
                    }
                    case 17: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 17");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleAcceleration(this._accelerationDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block10;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block10;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block10;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleOctaneRating(byte var1);

            public void handleAcceleration(Acceleration.Deserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final Acceleration.Serializer _accelerationSerializer = Acceleration.Serializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private PerformanceFigure _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(PerformanceFigure entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer octaneRating(byte val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)16, (byte)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)128);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer acceleration(Acceleration val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)17, (int)serializedEntityLength));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer acceleration(Acceleration.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer acceleration(Acceleration.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer acceleration(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)17, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class PerformanceFigureDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private PerformanceFigureDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigureDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private PerformanceFigureDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class PerformanceFigureSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private PerformanceFigureSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigureSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private PerformanceFigureSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class PerformanceFigurePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private PerformanceFigurePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigurePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private PerformanceFigurePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class PerformanceFigurePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<PerformanceFigure> {
        private PerformanceFigurePoolEvictedItemReceiver() {
        }

        public final void process(PerformanceFigure evictedItem) {
            _memoryStats.onEntityLeaked(PerformanceFigure.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class PerformanceFigurePoolFactory
    implements UtlPool.Factory<PerformanceFigure> {
        private PerformanceFigurePoolFactory() {
        }

        public final PerformanceFigure createItem(Object object) {
            return new PerformanceFigure();
        }

        public final PerformanceFigure[] createItemArray(int size) {
            return new PerformanceFigure[size];
        }
    }

    static final class PerformanceFigurePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        PerformanceFigurePoolFactoryItemCreateArgument() {
        }

        PerformanceFigurePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(-32870, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

