/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.sma;

import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.perf.common.LatencyWriter;
import com.neeve.perf.common.SystemProperties;
import com.neeve.perf.serialization.MessageFactory;
import com.neeve.perf.sma.Common;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlTime;
import java.text.DecimalFormat;

@AnnotatedCommand.Command(keywords={"Sender"}, description="A sender to benchmark SMA Performance")
public final class Sender
extends Common
implements IEventHandler {
    @AnnotatedCommand.Option(shortForm=112, longForm="dontPopulateMessage", description="whether to not populate outbound messages with full content i.e. only timestamp is sent")
    boolean _dontPopulate;
    @AnnotatedCommand.Option(shortForm=97, longForm="cpuAffinityMask", description="which CPU(s) to affinitize the sending thread to")
    private String _cpuAffinityMask;

    private final void sendMessage(MessageView message, MessageChannel channel) throws SmaException {
        this._channel.sendMessage(message, null, 50);
    }

    public final void onEvent(Event event) {
    }

    public final void execute() throws Exception {
        if (this._cpuAffinityMask != null) {
            System.out.println("[Sender] Affinitizing thread to CPU " + this._cpuAffinityMask);
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this._cpuAffinityMask));
        }
        SystemProperties.dump();
        DecimalFormat dfmt = new DecimalFormat("#,###");
        System.out.println("[Sender] Bus Descriptor......" + this._descriptor);
        System.out.println("[Sender] Test Count.........." + dfmt.format(this._testCount));
        System.out.println("[Sender] Test Rate..........." + dfmt.format(this._testRate));
        System.out.println("[Sender] Message Encoding...." + this._encoding);
        System.out.println("[Sender] Populate Message...." + !this._dontPopulate);
        System.out.println("[Sender] Channel Key........." + this._channelKey);
        System.out.println("[Sender] Channel Qos........." + this._channelQos);
        System.out.println("[Sender] CPU affinity mask..." + this._cpuAffinityMask);
        this.connect(false);
        MessageView message = new MessageFactory(this._encoding).createCar(!this._dontPopulate);
        System.out.println("[Sender] Calculating UtlTime.now() overhead...");
        long nanoTimeOverhead = 0L;
        long start = System.nanoTime();
        int i = 0;
        while ((long)i < 100000000L) {
            UtlTime.now();
            ++i;
        }
        nanoTimeOverhead = (System.nanoTime() - start) / 100000000L;
        System.out.println("[Sender] ..." + nanoTimeOverhead + "ns");
        LatencyWriter lw = new LatencyWriter("nw-write", this._dontWriteLatenciesToFile ? null : "latencies.write.bin", this._printIntervalStats);
        int numSent = 0;
        long nanosPerMsg = this._testRate > 0 ? 1000000000L / (long)this._testRate : 0L;
        System.out.println("[Sender] Running test (" + dfmt.format(this._testCount) + " messages @ " + this._testRate + " msgs/sec)...");
        long next = System.nanoTime() + nanosPerMsg;
        lw.start(this._testRate, this._testCount);
        start = System.currentTimeMillis();
        while (numSent < this._testCount) {
            long ts1 = System.nanoTime();
            if (ts1 < next) continue;
            long ts3 = UtlTime.now();
            message.setOriginTs(UtlTime.nowSinceEpoch());
            this.sendMessage(message, this._channel);
            ++numSent;
            long ts2 = message.getPreWireTs();
            int writeTime = (int)((ts2 - ts3) * 1000L - nanoTimeOverhead);
            lw.write(writeTime);
            next += nanosPerMsg;
        }
        long stop = System.currentTimeMillis();
        lw.close();
        this._binding.close();
        long overallRate = (long)numSent * 1000L / (stop - start);
        System.out.println("[Sender] Sent " + dfmt.format(numSent) + " messages at " + dfmt.format(overallRate) + " msgs/sec.");
        if (!this._dontWriteLatenciesToFile) {
            System.out.println("[Sender] Test complete (run rumi-reporter on latencies.write.bin to calculate latency stats).");
        } else {
            System.out.println("[Sender] Test complete.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.enablecpuaffinitymasks", "true");
        new Sender().run(args);
    }
}

