/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.sma;

import com.neeve.event.Event;
import com.neeve.perf.common.LatencyWriter;
import com.neeve.perf.common.SystemProperties;
import com.neeve.perf.sma.Common;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageEvent;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlTime;
import java.text.DecimalFormat;

@AnnotatedCommand.Command(keywords={"Receiver"}, description="A receiver to benchmark SMA Performance")
public final class Receiver
extends Common {
    private LatencyWriter _lw;
    private int _numReceived;
    private boolean _done;

    public final void onEvent(Event event) {
        switch (event.getType()) {
            case 105: {
                try {
                    MessageView message = ((MessageEvent)event).getMessageView();
                    if (this._numReceived == 0) {
                        this._lw.start(this._testRate, this._testCount);
                    }
                    int latency = (int)(UtlTime.nowSinceEpoch() - message.getOriginTs());
                    this._lw.write(latency * 1000);
                    if (++this._numReceived != this._testCount) break;
                    this._lw.close();
                    this._done = true;
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this._done = true;
                }
            }
            default: {
                System.out.println("Received unprocessed event [" + event + "]");
            }
        }
    }

    public final void execute() throws Exception {
        SystemProperties.dump();
        DecimalFormat dfmt = new DecimalFormat("#,###");
        System.out.println("[Receiver] Bus Descriptor......" + this._descriptor);
        System.out.println("[Receiver] Test Count.........." + dfmt.format(this._testCount));
        System.out.println("[Receiver] Message Encoding...." + this._encoding);
        System.out.println("[Receiver] Channel Key........." + this._channelKey);
        System.out.println("[Receiver] Channel Filter......" + this._channelFilter);
        System.out.println("[Receiver] Channel Qos........." + this._channelQos);
        this.connect(true);
        this._lw = new LatencyWriter("nw-lat", this._dontWriteLatenciesToFile ? null : "latencies.send.bin", this._printIntervalStats);
        while (!this._done) {
            Thread.sleep(100L);
        }
        this._binding.close();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("nv.enablecpuaffinitymasks", "true");
        new Receiver().run(args);
    }
}

