/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.neeve.event.Event;
import com.neeve.event.EventMultiplexer;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public final class EventMultiplexerFreeThreadedSerialized
extends EventMultiplexer {
    private final EventMultiplexer.Queue queue1;
    private final EventMultiplexer.Queue queue2;
    private final AtomicBoolean semaphore;
    private volatile EventMultiplexer.Queue fillQueue;

    private EventMultiplexerFreeThreadedSerialized(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        super(name, administrative, eventHandler);
        int initialQCapacity = UtlProps.getValue((Properties)props, (String)"initialQueueCapacity", (int)256);
        this.queue1 = new EventMultiplexer.Queue(initialQCapacity, this.tracer);
        this.queue2 = new EventMultiplexer.Queue(initialQCapacity, this.tracer);
        this.semaphore = new AtomicBoolean(false);
        this.fillQueue = this.queue1;
    }

    public static IEventMultiplexer create(String name, boolean administrative, IEventHandler eventHandler, Properties props) {
        return new EventMultiplexerFreeThreadedSerialized(name, administrative, eventHandler, props == null ? new Properties() : props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EventMultiplexer.Queue flipFillQueue() {
        EventMultiplexerFreeThreadedSerialized eventMultiplexerFreeThreadedSerialized = this;
        synchronized (eventMultiplexerFreeThreadedSerialized) {
            EventMultiplexer.Queue queue = this.fillQueue;
            this.fillQueue = this.fillQueue == this.queue1 ? this.queue2 : this.queue1;
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dispatch(EventMultiplexer.Queue queue) {
        int count = queue.size();
        if (this.tracer.debug) {
            this.tracer.log("", Tracer.Level.DEBUG);
            this.tracer.log("Queue dispatch start (Q=" + queue + ")", Tracer.Level.DEBUG);
        }
        for (int i = 0; i < count; ++i) {
            Event event = queue.poll();
            event.setEndOfBatch(i == count - 1);
            try {
                this.dispatchEvent(event);
                continue;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("Multiplexer event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                sb.append("Ignoring...");
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                continue;
            }
            finally {
                event.dispose();
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("Queue dispatch end (Q=" + queue + ")", Tracer.Level.DEBUG);
        }
    }

    @Override
    protected final void doOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doMultiplex(Event event, int flags) {
        if (this.semaphore.compareAndSet(false, true)) {
            boolean scheduleDrain;
            EventMultiplexer.Queue drainQueue = this.flipFillQueue();
            if (event != null) {
                drainQueue.offer(event.acquire());
            }
            this.dispatch(drainQueue);
            EventMultiplexerFreeThreadedSerialized eventMultiplexerFreeThreadedSerialized = this;
            synchronized (eventMultiplexerFreeThreadedSerialized) {
                scheduleDrain = this.fillQueue.size() > 0;
                this.semaphore.set(false);
            }
            if (scheduleDrain) {
                this.doMultiplex(null, flags);
            }
        } else if (event != null) {
            EventMultiplexerFreeThreadedSerialized eventMultiplexerFreeThreadedSerialized = this;
            synchronized (eventMultiplexerFreeThreadedSerialized) {
                this.fillQueue.offer(event.acquire());
            }
            this.doMultiplex(null, flags);
        }
    }

    @Override
    protected final void doClose() {
    }

    @Override
    public final IEventMultiplexerStats getStats() {
        return null;
    }
}

