/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkSTRContainer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.tools.interactive.commands.EnqueType;

public final class EnqueData
extends EnqueType {
    public EnqueData(LnkSTRContainer container) {
        super(container);
    }

    private void processEnqueData(String name, int numPackets, int dataSize, boolean flushForce, boolean flushSuppress, int flushType) {
        ILnkPeerEndpoint pep = this.container.getLink(name);
        if (pep != null) {
            PktPacket packet;
            System.out.println("Enqueuing packets to link ['" + name + "] [numPackets=" + numPackets + " dataSize=" + dataSize + " forceFlush=" + flushForce + " flushSuppress=" + flushSuppress + " flushType=" + flushType + "]...");
            try {
                packet = PktFactory.getInstance().createPacket("data");
            }
            catch (Exception e) {
                System.out.println("Failed to instantiate a data buffer packet [" + e.toString() + "] Has the 'data' packet type been approprately configured?");
                return;
            }
            ((PktBodyData)packet.getBody()).setBufferLength(dataSize);
            this.processEnque(pep, packet, numPackets, flushForce, flushSuppress, flushType, this.container.getReader());
        } else {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    @Override
    public final void run(String[] args) {
        if (args.length < 6) {
            System.out.println("Syntax error: enque <name> <numPackets> <dataSize> <flushForce> <flushSuppress> <flushType>");
        } else {
            this.processEnqueData(args[0], Integer.parseInt(args[1]), Integer.parseInt(args[2]), Boolean.parseBoolean(args[3]), Boolean.parseBoolean(args[4]), Integer.parseInt(args[5]));
        }
    }

    @Override
    public final void help() {
        System.out.println("enquedata <name> <numPackets> <dataSize> <flushForce> <flushSuppress> <flushType>");
        System.out.println("  Enque a set of data packets in link.");
    }

    @Override
    public final String[] keywords() {
        return new String[]{"enquedata"};
    }
}

