/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoDateField;
import com.neeve.sto.StoField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public final class StoDateFieldTest
extends UnitTest {
    private final void validate(StoDateField field, String name, ByteBuffer buffer, Date val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.DATE), (Object)((Object)field.getType()));
        Assert.assertEquals((Object)field.getValue(), (Object)val);
    }

    private final void cloneAndValidate(StoDateField field, String name, Date val) {
        StoDateField clone = (StoDateField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoDateField.getSerializedLength(null, 0), (long)8L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoDateField.put(buffer, 5, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoDateField.get(buffer, 5), (Object)new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        StoDateField.put(buffer, 5, new Date(4295857941L));
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoDateField.get(buffer, 5), (Object)new Date(4295857941L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoDateField field = StoDateField.create(null);
        this.validate(field, null, null, null);
        this.cloneAndValidate(field, null, null);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoDateField field = StoDateField.create("name");
        this.validate(field, "name", null, null);
        this.cloneAndValidate(field, "name", null);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoDateField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoDateField field = StoDateField.create(null);
        field.setValue(new Date(4294968296L));
        this.validate(field, null, null, new Date(4294968296L));
        this.cloneAndValidate(field, null, new Date(4294968296L));
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoDateField field = StoDateField.create("name");
        field.setValue(new Date(4294968296L));
        this.validate(field, "name", null, new Date(4294968296L));
        this.cloneAndValidate(field, "name", new Date(4294968296L));
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, null);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(new Date(4294968296L));
        this.validate(field, null, buffer, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(new Date(4294968296L));
        this.validate(field, "name", buffer, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue(new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue(new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoDateField field = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoDateField.get(buffer, field.shiftForHeader(45)), (Object)new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoDateField field = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue(new Date(4294968296L));
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((Object)StoDateField.get(buffer, field.shiftForHeader(52)), (Object)new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(new Date(4294968296L));
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoDateField field1 = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(new Date(4294968296L));
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(new Date(4294968296L));
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoDateField field1 = StoDateField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue(new Date(4294968296L));
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", new Date(4294968296L));
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(new Date(4294968296L));
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoDateField field3 = (StoDateField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, new Date(4294968296L));
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, new Date(4294968296L));
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoDateField field1 = StoDateField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue(new Date(42949656296L));
        field1.setBackingBuffer(buffer1, 35);
        this.validate(buffer1, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer1, 35);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoDateField field3 = (StoDateField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, new Date(42949656296L));
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", new Date(42949656296L));
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, null);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoDateField field2 = (StoDateField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDateField.create("name").contentsEquals(StoDateField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDateField.create(null).contentsEquals(StoDateField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoDateField.create("name1").contentsEquals(StoDateField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        StoDateField field2 = StoDateField.create(null);
        field1.setValue(new Date(100L));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        StoDateField field2 = StoDateField.create(null);
        field2.setValue(new Date(100L));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        StoDateField field2 = StoDateField.create(null);
        field1.setValue(new Date(67L));
        field2.setValue(new Date(178L));
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        StoDateField field2 = StoDateField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoDateField field1 = StoDateField.create("name");
        StoDateField field2 = StoDateField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoDateField field1 = StoDateField.create(null);
        StoDateField field2 = StoDateField.create(null);
        field1.setValue(new Date(42L));
        field2.setValue(new Date(42L));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoDateField field1 = StoDateField.create("name");
        StoDateField field2 = StoDateField.create("name");
        field1.setValue(new Date(66L));
        field2.setValue(new Date(66L));
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

