/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.StoByteField;
import com.neeve.sto.StoField;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public final class StoByteFieldTest
extends UnitTest {
    private final void validate(StoByteField field, String name, ByteBuffer buffer, byte val) {
        if (name == null) {
            Assert.assertNull((Object)field.getName());
        } else {
            Assert.assertEquals((Object)field.getName(), (Object)name);
        }
        if (buffer == null) {
            Assert.assertNull((Object)field.getBackingBuffer());
        } else {
            Assert.assertSame((Object)field.getBackingBuffer(), (Object)buffer);
        }
        Assert.assertEquals((Object)((Object)StoField.Type.BYTE), (Object)((Object)field.getType()));
        Assert.assertEquals((long)field.getValue(), (long)val);
    }

    private final void cloneAndValidate(StoByteField field, String name, byte val) {
        StoByteField clone = (StoByteField)field.clone();
        Assert.assertNotSame((Object)clone, (Object)field);
        this.validate(clone, name, null, val);
        Assert.assertTrue((boolean)field.contentsEquals(clone));
    }

    private final void validate(ByteBuffer buffer, int pos, int limit, int capacity) {
        Assert.assertEquals((long)buffer.position(), (long)pos);
        Assert.assertEquals((long)buffer.limit(), (long)limit);
        Assert.assertEquals((long)buffer.capacity(), (long)capacity);
    }

    @Test
    public void testStaticMethods() throws Exception {
        Assert.assertEquals((long)StoByteField.getSerializedLength(null, 0), (long)1L);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        StoByteField.put(buffer, 5, (byte)25);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoByteField.get(buffer, 5), (long)25L);
        this.validate(buffer, 0, 100, 100);
        StoByteField.put(buffer, 5, (byte)62);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoByteField.get(buffer, 5), (long)62L);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullName() throws Exception {
        StoByteField field = StoByteField.create(null);
        this.validate(field, null, null, (byte)0);
        this.cloneAndValidate(field, null, (byte)0);
    }

    @Test
    public void testCreateWithNonNullName() throws Exception {
        StoByteField field = StoByteField.create("name");
        this.validate(field, "name", null, (byte)0);
        this.cloneAndValidate(field, "name", (byte)0);
    }

    @Test
    public void testIsVariableLength() throws Exception {
        Assert.assertFalse((boolean)StoByteField.create(null).isVariableLength());
    }

    @Test
    public void testCreateWithNullNameSetValue() throws Exception {
        StoByteField field = StoByteField.create(null);
        field.setValue((byte)25);
        this.validate(field, null, null, (byte)25);
        this.cloneAndValidate(field, null, (byte)25);
    }

    @Test
    public void testCreateWithNonNullNameSetValue() throws Exception {
        StoByteField field = StoByteField.create("name");
        field.setValue((byte)25);
        this.validate(field, "name", null, (byte)25);
        this.cloneAndValidate(field, "name", (byte)25);
    }

    @Test
    public void testCreateWithNullNameBackByBuffer() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 5);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (byte)0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBuffer() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 9);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (byte)0);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByBuffer() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByBuffer() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.setBackingBuffer(buffer, 10);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueBackByThenClearBuffer() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.setBackingBuffer(buffer, 12);
        this.validate(buffer, 0, 100, 100);
        Assert.assertSame((Object)buffer, (Object)field.getBackingBuffer());
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValue() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        this.validate(buffer, 0, 100, 100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue((byte)25);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, buffer, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValue() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue((byte)25);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", buffer, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 22);
        this.validate(buffer, 0, 100, 100);
        field.setValue((byte)25);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameBackByBufferSetValueClearBuffer() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setBackingBuffer(buffer, 31);
        this.validate(buffer, 0, 100, 100);
        field.setValue((byte)25);
        this.validate(buffer, 0, 100, 100);
        field.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueSync() throws Exception {
        StoByteField field = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.sync(buffer, 45);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, null, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoByteField.get(buffer, field.shiftForHeader(45)), (long)25L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueSync() throws Exception {
        StoByteField field = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field.setValue((byte)25);
        field.sync(buffer, 52);
        this.validate(buffer, 0, 100, 100);
        this.validate(field, "name", null, (byte)25);
        this.validate(buffer, 0, 100, 100);
        Assert.assertEquals((long)StoByteField.get(buffer, field.shiftForHeader(52)), (long)25L);
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserialize() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer, 76);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserialize() throws Exception {
        StoByteField field1 = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        this.validate(field2, "name", buffer, (byte)25);
        Assert.assertSame((Object)buffer, (Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer, 76);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeClearBuffer() throws Exception {
        StoByteField field1 = StoByteField.create("name");
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer, 89);
        this.validate(buffer, 0, 100, 100);
        field2.clearBackingBuffer();
        this.validate(buffer, 0, 100, 100);
        Assert.assertNull((Object)field2.getBackingBuffer());
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, "name", (byte)25);
        this.validate(buffer, 0, 100, 100);
    }

    @Test
    public void testCreateWithNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer1, 76);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoByteField field3 = (StoByteField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, null, buffer2, (byte)25);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field3.contentsEquals(field2));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, null, (byte)25);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateWithNonNullNameSetValueDeserializeSetBuffer() throws Exception {
        StoByteField field1 = StoByteField.create("name");
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setValue((byte)25);
        field1.setBackingBuffer(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer1, 89);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.setBackingBuffer(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        StoByteField field3 = (StoByteField)StoField.create(buffer2, 65);
        this.validate(buffer2, 0, 100, 100);
        this.validate(field3, "name", buffer2, (byte)25);
        Assert.assertSame((Object)buffer2, (Object)field3.getBackingBuffer());
        Assert.assertTrue((boolean)field2.contentsEquals(field3));
        this.validate(buffer2, 0, 100, 100);
        this.cloneAndValidate(field3, "name", (byte)25);
        this.validate(buffer2, 0, 100, 100);
    }

    @Test
    public void testCreateDeserialize() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer, 80);
        this.validate(buffer, 0, 100, 100);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
        this.validate(buffer, 0, 100, 100);
        this.cloneAndValidate(field2, null, (byte)0);
        this.validate(buffer, 0, 100, 100);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateSetBackingBufferSync() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field1.sync(buffer2, 65);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateDeserializeSync() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        field1.setBackingBuffer(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        StoByteField field2 = (StoByteField)StoField.create(buffer1, 31);
        this.validate(buffer1, 0, 100, 100);
        ByteBuffer buffer2 = ByteBuffer.allocate(100);
        field2.sync(buffer2, 25);
    }

    @Test
    public void testContentsEqualsWithDifferentNamesFirstNonNull() throws Exception {
        Assert.assertFalse((boolean)StoByteField.create("name").contentsEquals(StoByteField.create(null)));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesSecondNonNull() throws Exception {
        Assert.assertFalse((boolean)StoByteField.create(null).contentsEquals(StoByteField.create("name")));
    }

    @Test
    public void testContentsEqualsWithDifferentNamesBothNonNull() throws Exception {
        Assert.assertFalse((boolean)StoByteField.create("name1").contentsEquals(StoByteField.create("name2")));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesFirstNonNull() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        StoByteField field2 = StoByteField.create(null);
        field1.setValue((byte)100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesSecondNonNull() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        StoByteField field2 = StoByteField.create(null);
        field2.setValue((byte)100);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithDifferentValuesBothNonNullDiffContent() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        StoByteField field2 = StoByteField.create(null);
        field1.setValue((byte)67);
        field2.setValue((byte)-78);
        Assert.assertFalse((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesDefault() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        StoByteField field2 = StoByteField.create(null);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesDefault() throws Exception {
        StoByteField field1 = StoByteField.create("name");
        StoByteField field2 = StoByteField.create("name");
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNullValuesNonDefault() throws Exception {
        StoByteField field1 = StoByteField.create(null);
        StoByteField field2 = StoByteField.create(null);
        field1.setValue((byte)42);
        field2.setValue((byte)42);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }

    @Test
    public void testContentsEqualsWithSameNameValuesNameNonNullValuesNonDefault() throws Exception {
        StoByteField field1 = StoByteField.create("name");
        StoByteField field2 = StoByteField.create("name");
        field1.setValue((byte)66);
        field2.setValue((byte)66);
        Assert.assertTrue((boolean)field1.contentsEquals(field2));
    }
}

