/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.sto.EStoException;
import com.neeve.sto.StoObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class StoTypeFactoryDescriptor
extends StoObject {
    private final String name;
    private final short id;
    private final String className;

    private StoTypeFactoryDescriptor(String name, short id, String className) {
        this.name = name;
        this.id = id;
        this.className = className;
    }

    public final String getName() {
        return this.name;
    }

    public final short getId() {
        return this.id;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void save(IConfigRepository repo) throws EStoException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sto/typefactories");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/sto/typefactories");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperty("Id", String.valueOf(this.getId()));
            entity.setProperty("Name", this.getName());
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new EStoException(e);
        }
    }

    public final void save() throws EStoException {
        this.save(ConfigRepositoryFactory.getInstance().getLocalRepository());
    }

    public final void delete(IConfigRepository repo) throws EStoException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sto/typefactories");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", " + this.id + ", '" + this.className + "')";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("type factory name cannot be null");
        }
        return repo.getSimpleEntity("/sto/typefactories/" + name) != null;
    }

    public static boolean exists(String name) {
        return StoTypeFactoryDescriptor.exists(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static StoTypeFactoryDescriptor create(String name, short id, String className) {
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("factory class name cannot be null");
        }
        return new StoTypeFactoryDescriptor(name, id, className);
    }

    public static StoTypeFactoryDescriptor load(IConfigRepository repo, String name) throws EStoException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/sto/typefactories/" + name);
        if (entity != null) {
            short id = (short)UtlProps.getValue((Properties)entity.getProperties(), (String)"Id", (int)0);
            if (id == 0) {
                throw new EStoException("Invalid type factory configuration [Missing or invalid value for 'Id']");
            }
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new EStoException("Invalid type factory configuration [Missing 'Class' property]");
            }
            return StoTypeFactoryDescriptor.create(name, id, className);
        }
        throw new EStoException("View factory '" + name + "' not found in repository");
    }

    public static StoTypeFactoryDescriptor load(String name) throws EStoException {
        return StoTypeFactoryDescriptor.load(ConfigRepositoryFactory.getInstance().getLocalRepository(), name);
    }

    public static Map<Short, StoTypeFactoryDescriptor> loadAll(IConfigRepository repo) throws EStoException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashMap<Short, StoTypeFactoryDescriptor> factories = new LinkedHashMap<Short, StoTypeFactoryDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sto/typefactories");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    StoTypeFactoryDescriptor descriptor = StoTypeFactoryDescriptor.load(repo, entity.getName());
                    StoTypeFactoryDescriptor existingDescriptor = factories.put(descriptor.getId(), descriptor);
                    if (existingDescriptor == null) continue;
                    descriptor.getTracer().log("STO type factory '" + descriptor.getName() + "' uses the same id as type factory '" + existingDescriptor.getName() + "' [id=" + descriptor.getId() + "]. Using type factory '" + descriptor.getName() + "'...", Tracer.Level.WARNING);
                }
                catch (EStoException e) {
                    throw new EStoException("Failure in loading descriptor for type factory '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return factories;
    }

    public static Map<Short, StoTypeFactoryDescriptor> loadAll() throws EStoException {
        return StoTypeFactoryDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getLocalRepository());
    }
}

