/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoIntField
extends StoField {
    private int val;

    private StoIntField(String name) {
        super(StoField.Type.INTEGER, name);
    }

    private StoIntField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoIntField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoIntField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (this.val == 0) {
            this.val = StoIntField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0;
    }

    @Override
    protected final int getSerializedLength() {
        return 4;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoIntField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoIntField)clonee).setValue(this.getValue());
    }

    public static StoIntField create(String name) {
        return new StoIntField(name);
    }

    public static StoIntField create(ByteBuffer buffer, int bufferOffset) {
        return new StoIntField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 4;
    }

    public static void put(ByteBuffer buffer, int offset, int val) {
        buffer.putInt(offset, val);
    }

    public static int get(ByteBuffer buffer, int offset) {
        return buffer.getInt(offset);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(0);
    }

    public final void setValue(int val) {
        this.val = val;
        if (this.buffer != null) {
            StoIntField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final int getValue() {
        if (this.val == 0 && this.buffer != null) {
            this.val = StoIntField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

