/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XFactory;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheader;
import com.neeve.pkt.PktSubheaderSMA;
import com.neeve.pkt.test.unit.PktTestHelper;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class PktSubheaderSMATest {
    @BeforeClass
    public static void setup() {
        PktTestHelper.loadPacketTypes();
    }

    private PktSerializable.SerializeContext serialize(PktSubheaderSMA subheader, PktSerializable.SerializeContext sc) {
        sc.setBufferCount(0);
        sc.addBuffer(IOBuffer.create((int)subheader.getSerializedLength(), (boolean)false));
        subheader.serialize(sc);
        Assert.assertEquals((long)5L, (long)PktSubheader.getType(sc.getByteBuffer(0), 0));
        return sc;
    }

    private PktSubheaderSMA deserialize(PktSerializable.SerializeContext sc) {
        PktSerializable.DeserializeContext dc = PktSerializable.DeserializeContext.create();
        dc.setBuffer(sc.flipBuffers().getByteBuffer(0));
        PktSubheaderSMA subHeader = (PktSubheaderSMA)PktSubheaderSMA.create();
        subHeader.deserialize(dc, subHeader.getSerializedLength(sc.getByteBuffer(0), 0), null);
        return subHeader;
    }

    @Test
    public void testIOBufferIsNullOnCreate() {
        Assert.assertNull((Object)PktSubheaderSMA.create().getBuffer().getIOBuffer());
    }

    @Test
    public void testFieldPopulation() {
        int expectedFixedLength = 23;
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktSubheaderSMA subheader = (PktSubheaderSMA)PktSubheaderSMA.create();
        Assert.assertEquals((long)23L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)1L, (long)subheader.getSubheaderVersion());
        Assert.assertNull((Object)subheader.getChannelName());
        Assert.assertNull((Object)subheader.getChannelNameAsRaw().getValue());
        Assert.assertEquals((long)0L, (long)subheader.getChannelId());
        Assert.assertEquals((long)0L, (long)subheader.getMessageEncodingType());
        Assert.assertEquals((long)0L, (long)subheader.getMessageViewFactoryId());
        Assert.assertEquals((long)0L, (long)subheader.getMessageViewType());
        Assert.assertEquals((long)0L, (long)subheader.getSender());
        Assert.assertEquals((long)0L, (long)subheader.getSno());
        PktSubheaderSMA deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)23L, (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)1L, (long)deserialized.getSubheaderVersion());
        Assert.assertNull((Object)deserialized.getChannelName());
        Assert.assertNull((Object)deserialized.getChannelNameAsRaw().getValue());
        Assert.assertEquals((long)0L, (long)deserialized.getChannelId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewType());
        Assert.assertEquals((long)0L, (long)deserialized.getSender());
        Assert.assertEquals((long)0L, (long)deserialized.getSno());
        Assert.assertEquals((long)23L, (long)subheader.getSerializedLength());
        Assert.assertEquals((long)1L, (long)subheader.getSubheaderVersion());
        subheader.setChannelId((short)2);
        subheader.setMessageEncodingType((byte)3);
        subheader.setMessageViewFactoryId((short)4);
        subheader.setMessageViewType((short)5);
        subheader.setSender(6);
        subheader.setSno(Long.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((long)23L, (long)subheader.getSerializedLength());
        subheader.setChannelName(XFactory.createXString((String)"TestChannel"));
        Assert.assertEquals((long)(23 + "TestChannel".length()), (long)subheader.getSerializedLength());
        Assert.assertEquals((long)1L, (long)subheader.getSubheaderVersion());
        Assert.assertEquals((long)2L, (long)subheader.getChannelId());
        Assert.assertEquals((long)3L, (long)subheader.getMessageEncodingType());
        Assert.assertEquals((long)4L, (long)subheader.getMessageViewFactoryId());
        Assert.assertEquals((long)5L, (long)subheader.getMessageViewType());
        Assert.assertEquals((long)6L, (long)subheader.getSender());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)subheader.getSno());
        Assert.assertEquals((Object)"TestChannel", (Object)subheader.getChannelNameAsRaw().getValue());
        Assert.assertEquals((Object)"TestChannel", (Object)subheader.getChannelName());
        deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)(23 + "TestChannel".length()), (long)deserialized.getSerializedLength());
        Assert.assertEquals((long)1L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((long)2L, (long)deserialized.getChannelId());
        Assert.assertEquals((long)3L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((long)4L, (long)deserialized.getMessageViewFactoryId());
        Assert.assertEquals((long)5L, (long)deserialized.getMessageViewType());
        Assert.assertEquals((long)6L, (long)deserialized.getSender());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)deserialized.getSno());
        Assert.assertEquals((Object)"TestChannel", (Object)deserialized.getChannelNameAsRaw().getValue());
        Assert.assertEquals((Object)"TestChannel", (Object)deserialized.getChannelName());
    }

    @Test
    public void testSubheaderPrepareNoChannelName() {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        PktSubheaderSMA.prepare(packet, (byte)0, (short)0, (short)0, 1, 2L, (short)0, null);
        PktSubheaderSMA subheader = packet.getHeader().getSMASubheader();
        PktSubheaderSMA deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)1L, (long)deserialized.getSubheaderVersion());
        Assert.assertNull((Object)deserialized.getChannelName());
        Assert.assertNull((Object)deserialized.getChannelNameAsRaw().getValue());
        Assert.assertEquals((long)0L, (long)deserialized.getChannelId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewType());
        Assert.assertEquals((long)1L, (long)deserialized.getSender());
        Assert.assertEquals((long)2L, (long)deserialized.getSno());
    }

    @Test
    public void testSubheaderPrepareWithChannelName() {
        PktSerializable.SerializeContext sc = PktSerializable.SerializeContext.create().setPolicy(0);
        PktPacket packet = PktFactory.getInstance().createPacket(912);
        PktSubheaderSMA.prepare(packet, (byte)0, (short)0, (short)0, 1, 2L, (short)0, XFactory.createXString((String)"TestChannel!"));
        PktSubheaderSMA subheader = packet.getHeader().getSMASubheader();
        PktSubheaderSMA deserialized = this.deserialize(this.serialize(subheader, sc));
        Assert.assertEquals((long)1L, (long)deserialized.getSubheaderVersion());
        Assert.assertEquals((Object)"TestChannel!", (Object)deserialized.getChannelNameAsRaw().getValue());
        Assert.assertEquals((Object)"TestChannel!", (Object)deserialized.getChannelName());
        Assert.assertEquals((long)0L, (long)deserialized.getChannelId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewFactoryId());
        Assert.assertEquals((long)0L, (long)deserialized.getMessageViewType());
        Assert.assertEquals((long)1L, (long)deserialized.getSender());
        Assert.assertEquals((long)2L, (long)deserialized.getSno());
    }
}

