/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktSerializeException;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktSerializable;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class PktBufferTest
extends UnitTest {
    private Random random;

    private byte[] randomByteArray(int len) {
        byte[] val = new byte[len];
        for (int i = 0; i < val.length; ++i) {
            val[i] = (byte)this.random.nextInt(128);
        }
        return val;
    }

    private ByteBuffer randomByteBuffer(int len, boolean direct) {
        ByteBuffer buffer = direct ? ByteBuffer.allocateDirect(len) : ByteBuffer.allocate(len);
        for (int i = 0; i < len; ++i) {
            buffer.put(i, (byte)this.random.nextInt(128));
        }
        return buffer;
    }

    private String randomString(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(String.valueOf(this.random.nextInt(10)));
        }
        return sb.toString();
    }

    private String getString(ByteBuffer buffer, int offset, int len) throws Exception {
        byte[] bytes = new byte[len];
        UtlBuffer.copy((ByteBuffer)buffer, (int)offset, (byte[])bytes, (int)0, (int)len);
        return new String(bytes, "UTF-8");
    }

    @Before
    public void before() {
        this.random = new Random(System.currentTimeMillis());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFreshCreateNullIOBufferFactory() {
        PktBuffer.create(null, 0, false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapWithNullIOBuffer() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(null, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapWithNegativeOffset() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(IOBuffer.create((int)10, (boolean)false), -1, 5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapWithNegativeLength() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(IOBuffer.create((int)10, (boolean)false), 0, -1);
    }

    @Test
    public void testWrapWithLengthLessThanIObufLength() {
        IOBuffer iobuf = IOBuffer.create((int)200, (int)0, (boolean)true);
        Assert.assertEquals((long)200L, (long)iobuf.getLength());
        Assert.assertEquals((long)200L, (long)iobuf.getBufferUnsafe().limit());
        Assert.assertEquals((long)256L, (long)iobuf.getCapacity());
        Assert.assertEquals((long)256L, (long)iobuf.getBufferUnsafe().capacity());
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(iobuf, 10, 189);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)200L, (long)buffer.getIOBuffer().getLength());
        Assert.assertEquals((long)200L, (long)buffer.getIOBuffer().getBufferUnsafe().limit());
        Assert.assertEquals((long)199L, (long)buffer.getIOBuffer().getHighwater());
    }

    @Test
    public void testWrapWithLengthEqualIObufLength() {
        IOBuffer iobuf = IOBuffer.create((int)200, (int)0, (boolean)true);
        Assert.assertEquals((long)200L, (long)iobuf.getLength());
        Assert.assertEquals((long)200L, (long)iobuf.getBufferUnsafe().limit());
        Assert.assertEquals((long)256L, (long)iobuf.getCapacity());
        Assert.assertEquals((long)256L, (long)iobuf.getBufferUnsafe().capacity());
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(iobuf, 10, 190);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)200L, (long)buffer.getIOBuffer().getLength());
        Assert.assertEquals((long)200L, (long)buffer.getIOBuffer().getBufferUnsafe().limit());
        Assert.assertEquals((long)200L, (long)buffer.getIOBuffer().getHighwater());
    }

    @Test
    public void testWrapWithLengthBetweenIObufLengthAndCapacity() {
        IOBuffer iobuf = IOBuffer.create((int)200, (int)0, (boolean)true);
        Assert.assertEquals((long)200L, (long)iobuf.getLength());
        Assert.assertEquals((long)200L, (long)iobuf.getBufferUnsafe().limit());
        Assert.assertEquals((long)256L, (long)iobuf.getCapacity());
        Assert.assertEquals((long)256L, (long)iobuf.getBufferUnsafe().capacity());
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(iobuf, 10, 191);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)201L, (long)buffer.getIOBuffer().getLength());
        Assert.assertEquals((long)201L, (long)buffer.getIOBuffer().getBufferUnsafe().limit());
        Assert.assertEquals((long)201L, (long)buffer.getIOBuffer().getHighwater());
    }

    @Test
    public void testWrapWithLengthEqualIObufCapacity() {
        IOBuffer iobuf = IOBuffer.create((int)200, (int)0, (boolean)true);
        Assert.assertEquals((long)200L, (long)iobuf.getLength());
        Assert.assertEquals((long)200L, (long)iobuf.getBufferUnsafe().limit());
        Assert.assertEquals((long)256L, (long)iobuf.getCapacity());
        Assert.assertEquals((long)256L, (long)iobuf.getBufferUnsafe().capacity());
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(iobuf, 10, 246);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getLength());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getBufferUnsafe().limit());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getHighwater());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrapWithLengthBeyondIObufCapacity() {
        IOBuffer iobuf = IOBuffer.create((int)256, (int)0, (boolean)true);
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(1), 0, false);
        buffer.wrapIOBuffer(iobuf, 10, 247);
    }

    private void testCreateWrap(boolean wrap, boolean nativeIOBuffer) {
        int size = this.random.nextInt(65536);
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(size), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        IOBuffer ioBuffer = null;
        if (wrap) {
            ioBuffer = IOBuffer.create((int)size, (boolean)nativeIOBuffer);
            buffer.wrapIOBuffer(ioBuffer, size / 2, size / 3);
        }
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertFalse((boolean)buffer.isFailOnWrite());
        Assert.assertFalse((boolean)buffer.isCopyOnWrite());
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertEquals((long)(wrap ? (long)(size / 2) : 0L), (long)buffer.getOffset());
        Assert.assertEquals((long)(wrap ? (long)(size / 3) : 0L), (long)buffer.getLength());
        Assert.assertEquals((Object)nativeIOBuffer, (Object)buffer.getIOBufferForWrite().isNative());
    }

    @Test
    public void testCreate_HeapIOBuffer() {
        this.testCreateWrap(false, false);
    }

    @Test
    public void testCreate_NativeIOBuffer() {
        this.testCreateWrap(false, true);
    }

    @Test
    public void testCreateWrap_HeapIOBuffer() {
        this.testCreateWrap(true, false);
    }

    @Test
    public void testCreateWrap_NativeIOBuffer() {
        this.testCreateWrap(true, true);
    }

    private void testCreateWrapPutByte(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        byte val = (byte)this.random.nextInt(128);
        buffer.put(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(pos));
        Assert.assertEquals((long)val, (long)buffer.inputStream(pos).read());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 99;
        val = (byte)this.random.nextInt(128);
        buffer.put(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(pos));
        Assert.assertEquals((long)val, (long)buffer.inputStream(pos).read());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos));
    }

    @Test
    public void testCreatePutByte_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByte(false, false);
    }

    @Test
    public void testCreatePutByte_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByte(false, true);
    }

    @Test
    public void testCreateWrapPutByte_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByte(true, false);
    }

    @Test
    public void testCreateWrapPutByte_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByte(true, true);
    }

    private void testCreateWrapPutChar(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        char val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readChar());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getChar((wrap ? 150 : 0) + pos));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 98;
        val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readChar());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getChar((wrap ? 150 : 0) + pos));
    }

    @Test
    public void testCreatePutChar_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutChar(false, false);
    }

    @Test
    public void testCreatePutChar_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutChar(false, true);
    }

    @Test
    public void testCreateWrapPutChar_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutChar(true, false);
    }

    @Test
    public void testCreateWrapPutChar_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutChar(true, true);
    }

    private void testCreateWrapPutShort(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        short val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readShort());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getShort((wrap ? 150 : 0) + pos));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 98;
        val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readShort());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getShort((wrap ? 150 : 0) + pos));
    }

    @Test
    public void testCreatePutShort_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutShort(false, false);
    }

    @Test
    public void testCreatePutShort_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutShort(false, true);
    }

    @Test
    public void testCreateWrapPutShort_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutShort(true, false);
    }

    @Test
    public void testCreateWrapPutShort_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutShort(true, true);
    }

    private void testCreateWrapPutInt(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        int val = this.random.nextInt();
        buffer.putInt(0, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readInt());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getInt((wrap ? 150 : 0) + pos));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        val = this.random.nextInt();
        pos = 96;
        buffer.putInt(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readInt());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getInt((wrap ? 150 : 0) + pos));
    }

    @Test
    public void testCreatePutInt_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutInt(false, false);
    }

    @Test
    public void testCreatePutInt_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutInt(false, true);
    }

    @Test
    public void testCreateWrapPutInt_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutInt(true, false);
    }

    @Test
    public void testCreateWrapPutInt_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutInt(true, true);
    }

    private void testCreateWrapPutFloat(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        float val = this.random.nextFloat();
        buffer.putFloat(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(pos), (double)0.0);
        Assert.assertEquals((double)val, (double)new DataInputStream(buffer.inputStream(pos)).readFloat(), (double)0.0);
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((double)val, (double)buffer.getIOBuffer().getBufferUnsafe().getFloat((wrap ? 150 : 0) + pos), (double)0.0);
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 96;
        val = this.random.nextFloat();
        buffer.putFloat(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(pos), (double)0.0);
        Assert.assertEquals((double)val, (double)new DataInputStream(buffer.inputStream(pos)).readFloat(), (double)0.0);
        Assert.assertEquals((double)val, (double)buffer.getIOBuffer().getBufferUnsafe().getFloat((wrap ? 150 : 0) + pos), (double)0.0);
    }

    @Test
    public void testCreatePutFloat_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutFloat(false, false);
    }

    @Test
    public void testCreatePutFloat_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutFloat(false, true);
    }

    @Test
    public void testCreateWrapPutFloat_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutFloat(true, false);
    }

    @Test
    public void testCreateWrapPutFloat_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutFloat(true, true);
    }

    private void testCreateWrapPutLong(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        long val = this.random.nextLong();
        buffer.putLong(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getLong(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readLong());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getLong((wrap ? 150 : 0) + pos));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 92;
        val = this.random.nextLong();
        buffer.putLong(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getLong(pos));
        Assert.assertEquals((long)val, (long)new DataInputStream(buffer.inputStream(pos)).readLong());
        Assert.assertEquals((long)val, (long)buffer.getIOBuffer().getBufferUnsafe().getLong((wrap ? 150 : 0) + pos));
    }

    @Test
    public void testCreatePutLong_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutLong(false, false);
    }

    @Test
    public void testCreatePutLong_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutLong(false, true);
    }

    @Test
    public void testCreateWrapPutLong_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutLong(true, false);
    }

    @Test
    public void testCreateWrapPutLong_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutLong(true, true);
    }

    private void testCreateWrapPutDouble(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        double val = this.random.nextDouble();
        buffer.putDouble(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(pos), (double)0.0);
        Assert.assertEquals((double)val, (double)new DataInputStream(buffer.inputStream(pos)).readDouble(), (double)0.0);
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((double)val, (double)buffer.getIOBuffer().getBufferUnsafe().getDouble((wrap ? 150 : 0) + pos), (double)0.0);
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 92;
        val = this.random.nextDouble();
        buffer.putDouble(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(pos), (double)0.0);
        Assert.assertEquals((double)val, (double)new DataInputStream(buffer.inputStream(pos)).readDouble(), (double)0.0);
        Assert.assertEquals((double)val, (double)buffer.getIOBuffer().getBufferUnsafe().getDouble((wrap ? 150 : 0) + pos), (double)0.0);
    }

    @Test
    public void testCreatePutDouble_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutDouble(false, false);
    }

    @Test
    public void testCreatePutDouble_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutDouble(false, true);
    }

    @Test
    public void testCreateWrapPutDouble_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutDouble(true, false);
    }

    @Test
    public void testCreateWrapPutDouble_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutDouble(true, true);
    }

    private void testCreateWrapPutString(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 0;
        String val = this.randomString(50);
        buffer.putString(pos, val);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(pos, val.length()));
        byte[] buf = new byte[val.length()];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        Assert.assertEquals((Object)val, (Object)new String(buf, "UTF-8"));
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)val, (Object)this.getString(buffer.getIOBuffer().getBufferUnsafe(), (wrap ? 150 : 0) + pos, val.length()));
        IOBuffer ioBuffer = buffer.getIOBuffer();
        val = this.randomString(50);
        pos = 100 - val.length();
        buffer.putString(pos, val);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(pos, val.length()));
        buf = new byte[val.length()];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        Assert.assertEquals((Object)val, (Object)new String(buf, "UTF-8"));
        Assert.assertEquals((Object)val, (Object)this.getString(buffer.getIOBuffer().getBufferUnsafe(), (wrap ? 150 : 0) + pos, val.length()));
    }

    @Test
    public void testCreatePutString_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutString(false, false);
    }

    @Test
    public void testCreatePutString_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutString(false, true);
    }

    @Test
    public void testCreateWrapPutString_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutString(true, false);
    }

    @Test
    public void testCreateWrapPutString_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutString(true, true);
    }

    private void testCreateWrapPutByteBuffer(boolean wrap, boolean nativeTestBuffer, boolean nativeIOBuffer) throws Exception {
        int i;
        int i2;
        int i3;
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        ByteBuffer val = this.randomByteBuffer(50, nativeTestBuffer);
        int pos = 5;
        buffer.putFrom(pos, val, 40);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        InputStream is = buffer.inputStream(pos);
        for (i3 = 0; i3 < 40; ++i3) {
            Assert.assertEquals((long)val.get(i3), (long)buffer.get(pos + i3));
            Assert.assertEquals((long)val.get(i3), (long)is.read());
        }
        for (i3 = 41; i3 < 50; ++i3) {
            Assert.assertEquals((long)0L, (long)buffer.get(pos + i3));
            Assert.assertEquals((long)0L, (long)is.read());
        }
        byte[] buf = new byte[50];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        for (i2 = 0; i2 < 40; ++i2) {
            Assert.assertEquals((long)val.get(i2), (long)buf[i2]);
        }
        for (i2 = 41; i2 < 50; ++i2) {
            Assert.assertEquals((long)0L, (long)buf[i2]);
        }
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        for (i2 = 0; i2 < 40; ++i2) {
            Assert.assertEquals((long)val.get(i2), (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i2));
        }
        for (i2 = 41; i2 < 50; ++i2) {
            Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i2));
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        val = this.randomByteBuffer(50, nativeTestBuffer);
        pos = 100 - val.remaining();
        buffer.putFrom(pos, val, 50);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        is = buffer.inputStream(pos);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val.get(i), (long)buffer.get(pos + i));
            Assert.assertEquals((long)val.get(i), (long)is.read());
        }
        buf = new byte[50];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val.get(i), (long)buf[i]);
        }
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val.get(i), (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i));
        }
    }

    @Test
    public void testCreatePutByteBuffer_HeapTestBuffer_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(false, false, false);
    }

    @Test
    public void testCreatePutByteBuffer_NativeTestBuffer_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(false, true, false);
    }

    @Test
    public void testCreatePutByteBuffer_HeapTestBuffer_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(false, false, true);
    }

    @Test
    public void testCreatePutByteBuffer_NativeTestBuffer_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(false, true, true);
    }

    @Test
    public void testCreateWrapPutByteBuffer_HeapTestBuffer_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(true, false, false);
    }

    @Test
    public void testCreateWrapPutByteBuffer_NativeTestBuffer_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(true, true, false);
    }

    @Test
    public void testCreateWrapPutByteBuffer_HeapTestBuffer_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(true, false, true);
    }

    @Test
    public void testCreateWrapPutByteBuffer_NativeTestBuffer_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteBuffer(true, true, true);
    }

    private void testCreateWrapPutByteArray(boolean wrap, boolean nativeIOBuffer) throws Exception {
        int i;
        int i2;
        int i3;
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        int pos = 5;
        byte[] val = this.randomByteArray(60);
        buffer.putFrom(pos, val, 10, 40);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertEquals((Object)(!wrap ? 1 : 0), (Object)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        InputStream is = buffer.inputStream(pos);
        for (i3 = 0; i3 < 40; ++i3) {
            Assert.assertEquals((long)val[10 + i3], (long)buffer.get(pos + i3));
            Assert.assertEquals((long)val[10 + i3], (long)is.read());
        }
        for (i3 = 41; i3 < 50; ++i3) {
            Assert.assertEquals((long)0L, (long)buffer.get(pos + i3));
            Assert.assertEquals((long)0L, (long)is.read());
        }
        byte[] buf = new byte[50];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        for (i2 = 0; i2 < 40; ++i2) {
            Assert.assertEquals((long)val[10 + i2], (long)buf[i2]);
        }
        for (i2 = 41; i2 < 50; ++i2) {
            Assert.assertEquals((long)0L, (long)buf[i2]);
        }
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        for (i2 = 0; i2 < 40; ++i2) {
            Assert.assertEquals((long)val[10 + i2], (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i2));
        }
        for (i2 = 41; i2 < 50; ++i2) {
            Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i2));
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        pos = 100 - val.length;
        val = this.randomByteArray(60);
        buffer.putFrom(pos, val, 5, 50);
        Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        is = buffer.inputStream(pos);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val[5 + i], (long)buffer.get(pos + i));
            Assert.assertEquals((long)val[5 + i], (long)is.read());
        }
        buf = new byte[50];
        buffer.inputStream(pos).read(buf, 0, buf.length);
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val[5 + i], (long)buf[i]);
        }
        Assert.assertEquals((long)0L, (long)buffer.getIOBuffer().getBufferUnsafe().position());
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val[5 + i], (long)buffer.getIOBuffer().getBufferUnsafe().get((wrap ? 150 : 0) + pos + i));
        }
    }

    @Test
    public void testCreatePutByteArray_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteArray(false, false);
    }

    @Test
    public void testCreatePutByteArray_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteArray(false, true);
    }

    @Test
    public void testCreateWrapPutByteArray_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutByteArray(true, false);
    }

    @Test
    public void testCreateWrapPutByteArray_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutByteArray(true, true);
    }

    private void testCreateGetWrap(boolean nativeIOBuffer) {
        int size = this.random.nextInt(65536);
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(10), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertEquals((long)0L, (long)buffer.getInt(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        IOBuffer ioBuffer = buffer.getIOBuffer();
        buffer.wrapIOBuffer(IOBuffer.create((int)size, (boolean)nativeIOBuffer), size / 2, size / 3);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertFalse((boolean)buffer.isFailOnWrite());
        Assert.assertFalse((boolean)buffer.isCopyOnWrite());
        Assert.assertEquals((long)(size / 2), (long)buffer.getOffset());
        Assert.assertEquals((long)(size / 3), (long)buffer.getLength());
        Assert.assertEquals((Object)nativeIOBuffer, (Object)buffer.getIOBuffer().isNative());
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
    }

    @Test
    public void testCreateGetWrap_HeapIOBuffer() {
        this.testCreateGetWrap(false);
    }

    @Test
    public void testCreateGetWrap_NativeIOBuffer() {
        this.testCreateGetWrap(true);
    }

    private void testCreatePutWrap(boolean nativeIOBuffer) {
        int size = this.random.nextInt(65536);
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(10), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.putInt(0, 100);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        IOBuffer ioBuffer = buffer.getIOBuffer();
        buffer.wrapIOBuffer(IOBuffer.create((int)size, (boolean)nativeIOBuffer), size / 2, size / 3);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertFalse((boolean)buffer.isFailOnWrite());
        Assert.assertFalse((boolean)buffer.isCopyOnWrite());
        Assert.assertEquals((long)(size / 2), (long)buffer.getOffset());
        Assert.assertEquals((long)(size / 3), (long)buffer.getLength());
        Assert.assertEquals((Object)nativeIOBuffer, (Object)buffer.getIOBuffer().isNative());
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
    }

    @Test
    public void testCreatePutWrap_HeapIOBuffer() {
        this.testCreatePutWrap(false);
    }

    @Test
    public void testCreatePutWrap_NativeIOBuffer() {
        this.testCreatePutWrap(true);
    }

    @Test
    public void testFailOnWriteOnBufferWithNoIOBuffer() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, false);
        Assert.assertNull((Object)buffer.getIOBuffer());
        buffer.setFailOnWrite();
        Assert.assertTrue((boolean)buffer.isFailOnWrite());
    }

    @Test
    public void testFailOnWriteOnBufferWithIOBuffer() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, false);
        buffer.get(0);
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        buffer.setFailOnWrite();
        Assert.assertTrue((boolean)buffer.isFailOnWrite());
    }

    private void testFailOnWritePutByte(boolean wrap, boolean failOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        if (wrap && failOnWriteBeforeWrap) {
            buffer.setFailOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
            if (!failOnWriteBeforeWrap) {
                buffer.setFailOnWrite();
            }
        } else {
            buffer.setFailOnWrite();
        }
        buffer.put(0, (byte)this.random.nextInt(128));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateFailOnWritePutByte_HeapIOBuffer() {
        this.testFailOnWritePutByte(false, false, false);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateFailOnWritePutByte_NativeIOBuffer() {
        this.testFailOnWritePutByte(false, false, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWrapFailOnWritePutByte_HeapIOBuffer() {
        this.testFailOnWritePutByte(true, false, false);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWrapFailOnWritePutByte_NativeIOBuffer() {
        this.testFailOnWritePutByte(true, false, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateFailOnWriteWrapPutByte_HeapIOBuffer() {
        this.testFailOnWritePutByte(true, true, false);
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateFailOnWriteWrapPutByte_NativeIOBuffer() {
        this.testFailOnWritePutByte(true, true, true);
    }

    @Test(expected=IllegalStateException.class)
    public void testCopyOnWriteOnFailOnWriteBuffer() {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, false);
        buffer.setFailOnWrite();
        buffer.setCopyOnWrite();
    }

    private void testCopyOnWritePutByte(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        byte val = (byte)this.random.nextInt(128);
        buffer.put(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(0));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (byte)this.random.nextInt(128);
        buffer.put(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(150));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (byte)this.random.nextInt(128);
        buffer.put(299, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(299));
    }

    @Test
    public void testCreateCopyOnWritePutByte_HeapIOBuffer() {
        this.testCopyOnWritePutByte(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutByte_NativeIOBuffer() {
        this.testCopyOnWritePutByte(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByte_HeapIOBuffer() {
        this.testCopyOnWritePutByte(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByte_NativeIOBuffer() {
        this.testCopyOnWritePutByte(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByte_HeapIOBuffer() {
        this.testCopyOnWritePutByte(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByte_NativeIOBuffer() {
        this.testCopyOnWritePutByte(true, true, true);
    }

    private void testCopyOnWritePutChar(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        char val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(0));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(150));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(298, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(298));
    }

    @Test
    public void testCreateCopyOnWritePutChar_HeapIOBuffer() {
        this.testCopyOnWritePutChar(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutChar_NativeIOBuffer() {
        this.testCopyOnWritePutChar(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutChar_HeapIOBuffer() {
        this.testCopyOnWritePutChar(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutChar_NativeIOBuffer() {
        this.testCopyOnWritePutChar(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutChar_HeapIOBuffer() {
        this.testCopyOnWritePutChar(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutChar_NativeIOBuffer() {
        this.testCopyOnWritePutChar(true, true, true);
    }

    private void testCopyOnWritePutShort(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        short val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(0));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(150));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(298, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(298));
    }

    @Test
    public void testCreateCopyOnWritePutShort_HeapIOBuffer() {
        this.testCopyOnWritePutShort(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutShort_NativeIOBuffer() {
        this.testCopyOnWritePutShort(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutShort_HeapIOBuffer() {
        this.testCopyOnWritePutShort(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutShort_NativeIOBuffer() {
        this.testCopyOnWritePutShort(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutShort_HeapIOBuffer() {
        this.testCopyOnWritePutShort(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutShort_NativeIOBuffer() {
        this.testCopyOnWritePutShort(true, true, true);
    }

    private void testCopyOnWritePutInt(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        int val = this.random.nextInt();
        buffer.putInt(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(0));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextInt();
        buffer.putInt(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(150));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextInt();
        buffer.putInt(296, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(296));
    }

    @Test
    public void testCreateCopyOnWritePutInt_HeapIOBuffer() {
        this.testCopyOnWritePutInt(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutInt_NativeIOBuffer() {
        this.testCopyOnWritePutInt(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutInt_HeapIOBuffer() {
        this.testCopyOnWritePutInt(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutInt_NativeIOBuffer() {
        this.testCopyOnWritePutInt(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutInt_HeapIOBuffer() {
        this.testCopyOnWritePutInt(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutInt_NativeIOBuffer() {
        this.testCopyOnWritePutInt(true, true, true);
    }

    private void testCopyOnWritePutFloat(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        float val = this.random.nextFloat();
        buffer.putFloat(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(0), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextFloat();
        buffer.putFloat(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(150), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextFloat();
        buffer.putFloat(296, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(296), (double)0.0);
    }

    @Test
    public void testCreateCopyOnWritePutFloat_HeapIOBuffer() {
        this.testCopyOnWritePutFloat(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutFloat_NativeIOBuffer() {
        this.testCopyOnWritePutFloat(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutFloat_HeapIOBuffer() {
        this.testCopyOnWritePutFloat(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutFloat_NativeIOBuffer() {
        this.testCopyOnWritePutFloat(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutFloat_HeapIOBuffer() {
        this.testCopyOnWritePutFloat(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutFloat_NativeIOBuffer() {
        this.testCopyOnWritePutFloat(true, true, true);
    }

    private void testCopyOnWritePutLong(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        long val = this.random.nextLong();
        buffer.putLong(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getLong(0), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextLong();
        buffer.putLong(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getLong(150), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextLong();
        buffer.putLong(292, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getLong(292), (double)0.0);
    }

    @Test
    public void testCreateCopyOnWritePutLong_HeapIOBuffer() {
        this.testCopyOnWritePutLong(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutLong_NativeIOBuffer() {
        this.testCopyOnWritePutLong(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutLong_HeapIOBuffer() {
        this.testCopyOnWritePutLong(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutLong_NativeIOBuffer() {
        this.testCopyOnWritePutLong(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutLong_HeapIOBuffer() {
        this.testCopyOnWritePutLong(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutLong_NativeIOBuffer() {
        this.testCopyOnWritePutLong(true, true, true);
    }

    private void testCopyOnWritePutDouble(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        double val = this.random.nextDouble();
        buffer.putDouble(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(0), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextDouble();
        buffer.putDouble(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(150), (double)0.0);
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.random.nextDouble();
        buffer.putDouble(292, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(292), (double)0.0);
    }

    @Test
    public void testCreateCopyOnWritePutDouble_HeapIOBuffer() {
        this.testCopyOnWritePutDouble(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutDouble_NativeIOBuffer() {
        this.testCopyOnWritePutDouble(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutDouble_HeapIOBuffer() {
        this.testCopyOnWritePutDouble(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutDouble_NativeIOBuffer() {
        this.testCopyOnWritePutDouble(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutDouble_HeapIOBuffer() {
        this.testCopyOnWritePutDouble(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutDouble_NativeIOBuffer() {
        this.testCopyOnWritePutDouble(true, true, true);
    }

    private void testCopyOnWritePutString(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        String val = this.randomString(50);
        buffer.putString(0, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(0, val.length()));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.randomString(50);
        buffer.putString(150, val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(150, val.length()));
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.randomString(50);
        buffer.putString(300 - val.length(), val);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(300 - val.length(), val.length()));
    }

    @Test
    public void testCreateCopyOnWritePutString_HeapIOBuffer() {
        this.testCopyOnWritePutString(false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutString_NativeIOBuffer() {
        this.testCopyOnWritePutString(false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutString_HeapIOBuffer() {
        this.testCopyOnWritePutString(true, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutString_NativeIOBuffer() {
        this.testCopyOnWritePutString(true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutString_HeapIOBuffer() {
        this.testCopyOnWritePutString(true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutString_NativeIOBuffer() {
        this.testCopyOnWritePutString(true, true, true);
    }

    private void testCopyOnWritePutByteBuffer(boolean wrap, boolean copyOnWriteBeforeWrap, boolean nativeTestBuffer, boolean nativeIOBuffer) {
        int i;
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        if (wrap && copyOnWriteBeforeWrap) {
            buffer.setCopyOnWrite();
        }
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            if (!copyOnWriteBeforeWrap) {
                buffer.setCopyOnWrite();
            }
        } else {
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            buffer.setCopyOnWrite();
        }
        IOBuffer ioBuffer = buffer.getIOBuffer();
        Assert.assertTrue((boolean)buffer.isCopyOnWrite());
        ByteBuffer val = this.randomByteBuffer(50, nativeTestBuffer);
        buffer.putFrom(0, val, val.remaining());
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val.get(i), (long)buffer.get(i));
        }
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.randomByteBuffer(50, nativeTestBuffer);
        buffer.putFrom(150, val, val.remaining());
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        for (i = 0; i < 50; ++i) {
            Assert.assertEquals((long)val.get(i), (long)buffer.get(150 + i));
        }
        ioBuffer = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        val = this.randomByteBuffer(50, nativeTestBuffer);
        int len = val.remaining();
        buffer.putFrom(300 - len, val, len);
        Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        for (int i2 = 0; i2 < 50; ++i2) {
            Assert.assertEquals((long)val.get(i2), (long)buffer.get(300 - len + i2));
        }
    }

    @Test
    public void testCreateCopyOnWritePutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(false, false, false, false);
    }

    @Test
    public void testCreateCopyOnWritePutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(false, false, true, false);
    }

    @Test
    public void testCreateCopyOnWritePutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(false, false, false, true);
    }

    @Test
    public void testCreateCopyOnWritePutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(false, false, true, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, false, false, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, false, true, false);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, false, false, true);
    }

    @Test
    public void testCreateWrapCopyOnWritePutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, false, true, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, true, false, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, true, true, false);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, true, false, true);
    }

    @Test
    public void testCreateCopyOnWriteWrapPutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testCopyOnWritePutByteBuffer(true, true, true, true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutByte(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 1;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            byte val = (byte)this.random.nextInt(128);
            buffer.put(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.get(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByte_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByte(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByte_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByte(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutChar(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            char val = (char)this.random.nextInt(128);
            buffer.putChar(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getChar(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutChar_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutChar(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutChar_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutChar(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutShort(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            short val = (short)this.random.nextInt(Short.MAX_VALUE);
            buffer.putShort(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getShort(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutShort_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutShort(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutShort_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutShort(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutInt(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            int val = this.random.nextInt();
            buffer.putInt(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getInt(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutInt_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutInt(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutInt_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutInt(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutFloat(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            float val = this.random.nextFloat();
            buffer.putFloat(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getFloat(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutFloat_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutFloat(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutFloat_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutFloat(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutLong(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            long val = this.random.nextLong();
            buffer.putLong(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getLong(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutLong_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutLong(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutLong_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutLong(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutDouble(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            double val = this.random.nextDouble();
            buffer.putDouble(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getDouble(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutDouble_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutDouble(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutDouble_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutDouble(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutString(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        String val = this.randomString(10);
        int objectSize = val.length();
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putString(pos, val);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((Object)val, (Object)buffer.getString(pos, objectSize));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutString_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutString(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutString_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutString(true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutByteBuffer(boolean nativeTestBuffer, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        ByteBuffer val = this.randomByteBuffer(10, nativeTestBuffer);
        int objectSize = val.remaining();
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putFrom(pos, val, objectSize);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < objectSize; ++j) {
                Assert.assertEquals((long)val.get(j), (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteBuffer(false, false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteBuffer(true, false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteBuffer(false, true);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteBuffer(true, true);
    }

    private void testAllocatedBufWithRoomToGrowAutoResizePutByteArray(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.get(0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        byte[] val = this.randomByteArray(10);
        int objectSize = val.length;
        for (int i = 1; i <= objectSize + 1; ++i) {
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putFrom(pos, val, 0, objectSize);
            Assert.assertSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < val.length; ++j) {
                Assert.assertEquals((long)val[j], (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteArray_HeapIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteArray(false);
    }

    @Test
    public void testCreateAllocatedBufWithRoomToGrowAutoResizePutByteArray_NativeIOBuffer() {
        this.testAllocatedBufWithRoomToGrowAutoResizePutByteArray(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutByte(boolean nativeIOBuffer) {
        int objectSize = 1;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            byte val = (byte)this.random.nextInt(128);
            buffer.put(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.get(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutByte_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByte(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutByte_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByte(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutChar(boolean nativeIOBuffer) {
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            char val = (char)this.random.nextInt(128);
            buffer.putChar(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getChar(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutChar_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutChar(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutChar_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutChar(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutShort(boolean nativeIOBuffer) {
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            short val = (short)this.random.nextInt(Short.MAX_VALUE);
            buffer.putShort(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getShort(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutShort_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutShort(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutShort_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutShort(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutInt(boolean nativeIOBuffer) {
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            int val = this.random.nextInt();
            buffer.putInt(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getInt(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutInt_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutInt(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutInt_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutInt(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutFloat(boolean nativeIOBuffer) {
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            float val = this.random.nextFloat();
            buffer.putFloat(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getFloat(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutFloat_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutFloat(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutFloat_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutFloat(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutLong(boolean nativeIOBuffer) {
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            long val = this.random.nextLong();
            buffer.putLong(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getLong(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutLong_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutLong(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutLong_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutLong(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutDouble(boolean nativeIOBuffer) {
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            double val = this.random.nextDouble();
            buffer.putDouble(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getDouble(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutDouble_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutDouble(false);
    }

    @Test
    public void testAllocatedBufWithNoRoomToGrowAutoResizePutDouble_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutDouble(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutString(boolean nativeIOBuffer) {
        String val = this.randomString(10);
        int objectSize = val.length();
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            buffer.putString(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((Object)val, (Object)buffer.getString(pos, objectSize));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutString_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutString(false);
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutString_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutString(true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer(boolean nativeTestBuffer, boolean nativeIOBuffer) {
        ByteBuffer val = this.randomByteBuffer(10, nativeTestBuffer);
        int objectSize = val.remaining();
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            buffer.putFrom(pos, val, objectSize);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < objectSize; ++j) {
                Assert.assertEquals((long)val.get(j), (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer(false, false);
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer(true, false);
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer(false, true);
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteBuffer(true, true);
    }

    private void testAllocatedBufWithNoRoomToGrowAutoResizePutByteArray(boolean nativeIOBuffer) {
        byte[] val = this.randomByteArray(10);
        int objectSize = val.length;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(256), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.get(0);
            Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 256 - objectSize + i;
            buffer.putFrom(pos, val, 0, objectSize);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < val.length; ++j) {
                Assert.assertEquals((long)val[j], (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteArray_HeapIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteArray(false);
    }

    @Test
    public void testCreateAllocatedBufWithNoRoomToGrowAutoResizePutByteArray_NativeIOBuffer() {
        this.testAllocatedBufWithNoRoomToGrowAutoResizePutByteArray(true);
    }

    private void testWrappedIOBufAutoResizeBufPutByte(boolean nativeIOBuffer) {
        int objectSize = 1;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            byte val = (byte)this.random.nextInt(128);
            buffer.put(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.get(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByte_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutByte(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutByte_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutByte(true);
    }

    private void testWrappedIOBufAutoResizeBufPutChar(boolean nativeIOBuffer) {
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            char val = (char)this.random.nextInt(128);
            buffer.putChar(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getChar(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutChar_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutChar(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutChar_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutChar(true);
    }

    private void testWrappedIOBufAutoResizeBufPutShort(boolean nativeIOBuffer) {
        int objectSize = 2;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            short val = (short)this.random.nextInt(Short.MAX_VALUE);
            buffer.putShort(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getShort(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutShort_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutShort(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutShort_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutShort(true);
    }

    private void testWrappedIOBufAutoResizeBufPutInt(boolean nativeIOBuffer) {
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            int val = this.random.nextInt();
            buffer.putInt(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getInt(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutInt_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutInt(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutInt_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutInt(true);
    }

    private void testWrappedIOBufAutoResizeBufPutFloat(boolean nativeIOBuffer) {
        int objectSize = 4;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            float val = this.random.nextFloat();
            buffer.putFloat(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getFloat(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutFloat_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutFloat(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutFloat_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutFloat(true);
    }

    private void testWrappedIOBufAutoResizeBufPutLong(boolean nativeIOBuffer) {
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            long val = this.random.nextLong();
            buffer.putLong(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((long)val, (long)buffer.getLong(pos));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutLong_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutLong(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutLong_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutLong(true);
    }

    private void testWrappedIOBufAutoResizeBufPutDouble(boolean nativeIOBuffer) {
        int objectSize = 8;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            double val = this.random.nextDouble();
            buffer.putDouble(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((double)val, (double)buffer.getDouble(pos), (double)0.0);
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutDouble_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutDouble(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizeBufPutDouble_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizeBufPutDouble(true);
    }

    private void testWrappedIOBufAutoResizePutString(boolean nativeIOBuffer) {
        String val = this.randomString(10);
        int objectSize = val.length();
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putString(pos, val);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            Assert.assertEquals((Object)val, (Object)buffer.getString(pos, objectSize));
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutString_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizePutString(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutString_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizePutString(true);
    }

    private void testWrappedIOBufAutoResizePutByteBuffer(boolean nativeTestBuffer, boolean nativeIOBuffer) {
        ByteBuffer val = this.randomByteBuffer(10, nativeTestBuffer);
        int objectSize = val.remaining();
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putFrom(pos, val, objectSize);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < objectSize; ++j) {
                Assert.assertEquals((long)val.get(j), (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteBuffer_HeapTestBuffer_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteBuffer(false, false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteBuffer_NativeTestBuffer_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteBuffer(true, false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteBuffer_HeapTestBuffer_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteBuffer(false, true);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteBuffer_NativeTestBuffer_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteBuffer(true, true);
    }

    private void testWrappedIOBufAutoResizePutByteArray(boolean nativeIOBuffer) {
        byte[] val = this.randomByteArray(10);
        int objectSize = val.length;
        for (int i = 1; i <= objectSize + 1; ++i) {
            PktBuffer buffer = PktBuffer.create(new SerializableEntity(300), 0, nativeIOBuffer);
            buffer.setInitializer(new BufferInitializer());
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 0, 300);
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            IOBuffer ioBuffer = buffer.getIOBuffer();
            int pos = 300 - objectSize + i;
            buffer.putFrom(pos, val, 0, objectSize);
            Assert.assertNotSame((Object)ioBuffer, (Object)buffer.getIOBuffer());
            Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
            for (int j = 0; j < val.length; ++j) {
                Assert.assertEquals((long)val[j], (long)buffer.get(pos + j));
            }
            Assert.assertEquals((long)(pos + objectSize), (long)buffer.getLength());
        }
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteArray_HeapIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteArray(false);
    }

    @Test
    public void testCreateWrappedIOBufAutoResizePutByteArray_NativeIOBuffer() {
        this.testWrappedIOBufAutoResizePutByteArray(true);
    }

    private void testAutoAllocatePutByte(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        byte val = (byte)this.random.nextInt(128);
        int objectSize = 1;
        buffer.put(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)val, (long)buffer.get(128));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutByte_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutByte(true, false);
    }

    @Test
    public void testAutoAllocatePutByte_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutByte(true, true);
    }

    @Test
    public void testAutoAllocatePutByte_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutByte(false, false);
    }

    @Test
    public void testAutoAllocatePutByte_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutByte(false, true);
    }

    private void testAutoAllocatePutChar(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        char val = (char)this.random.nextInt(Short.MAX_VALUE);
        int objectSize = 2;
        buffer.putChar(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)val, (long)buffer.getChar(128));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutChar_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutChar(true, false);
    }

    @Test
    public void testAutoAllocatePutChar_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutChar(true, true);
    }

    @Test
    public void testAutoAllocatePutChar_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutChar(false, false);
    }

    @Test
    public void testAutoAllocatePutChar_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutChar(false, true);
    }

    private void testAutoAllocatePutShort(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        short val = (short)this.random.nextInt(Short.MAX_VALUE);
        int objectSize = 2;
        buffer.putShort(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)val, (long)buffer.getShort(128));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutShort_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutShort(true, false);
    }

    @Test
    public void testAutoAllocatePutShort_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutShort(true, true);
    }

    @Test
    public void testAutoAllocatePutShort_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutShort(false, false);
    }

    @Test
    public void testAutoAllocatePutShort_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutShort(false, true);
    }

    private void testAutoAllocatePutInt(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        int val = this.random.nextInt();
        int objectSize = 4;
        buffer.putInt(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)val, (long)buffer.getInt(128));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutInt_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutInt(true, false);
    }

    @Test
    public void testAutoAllocatePutInt_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutInt(true, true);
    }

    @Test
    public void testAutoAllocatePutInt_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutInt(false, false);
    }

    @Test
    public void testAutoAllocatePutInt_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutInt(false, true);
    }

    private void testAutoAllocatePutFloat(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        float val = this.random.nextFloat();
        int objectSize = 4;
        buffer.putFloat(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((double)val, (double)buffer.getFloat(128), (double)0.0);
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutFloat_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutFloat(true, false);
    }

    @Test
    public void testAutoAllocatePutFloat_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutFloat(true, true);
    }

    @Test
    public void testAutoAllocatePutFloat_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutFloat(false, false);
    }

    @Test
    public void testAutoAllocatePutFloat_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutFloat(false, true);
    }

    private void testAutoAllocatePutLong(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        long val = this.random.nextLong();
        int objectSize = 8;
        buffer.putLong(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)val, (long)buffer.getLong(128));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutLong_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutLong(true, false);
    }

    @Test
    public void testAutoAllocatePutLong_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutLong(true, true);
    }

    @Test
    public void testAutoAllocatePutLong_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutLong(false, false);
    }

    @Test
    public void testAutoAllocatePutLong_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutLong(false, true);
    }

    private void testAutoAllocatePutDouble(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        double val = this.random.nextDouble();
        int objectSize = 8;
        buffer.putDouble(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((double)val, (double)buffer.getDouble(128), (double)0.0);
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? (long)(128 + objectSize) : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutDouble_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutDouble(true, false);
    }

    @Test
    public void testAutoAllocatePutDouble_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutDouble(true, true);
    }

    @Test
    public void testAutoAllocatePutDouble_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutDouble(false, false);
    }

    @Test
    public void testAutoAllocatePutDouble_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutDouble(false, true);
    }

    private void testAutoAllocatePutString(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        String val = this.randomString(10);
        buffer.putString(128, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((Object)val, (Object)buffer.getString(128, val.length()));
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? 138L : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutString_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutString(true, false);
    }

    @Test
    public void testAutoAllocatePutString_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutString(true, true);
    }

    @Test
    public void testAutoAllocatePutString_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutString(false, false);
    }

    @Test
    public void testAutoAllocatePutString_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutString(false, true);
    }

    private void testAutoAllocatePutByteBuffer(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeTestBuffer, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        ByteBuffer val = this.randomByteBuffer(10, nativeTestBuffer);
        int objectSize = val.remaining();
        buffer.putFrom(128, val, objectSize);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        for (int i = 0; i < objectSize; ++i) {
            Assert.assertEquals((double)val.get(i), (double)buffer.get(128 + i), (double)0.0);
        }
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? 138L : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthLessThanNewAllocSize_HeapTestBuffer_HeapIOBuffer() {
        this.testAutoAllocatePutByteBuffer(true, false, false);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthLessThanNewAllocSize_NativeTestBuffer_HeapIOBuffer() {
        this.testAutoAllocatePutByteBuffer(true, true, false);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthLessThanNewAllocSize_HeapTestBuffer_NativeIOBuffer() {
        this.testAutoAllocatePutByteBuffer(true, false, true);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthLessThanNewAllocSize_NativeTestBuffer_NativeIOBuffer() {
        this.testAutoAllocatePutByteBuffer(true, true, true);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferGreaterLessThanNewAllocSize_HeapTestBuffer_HeapIOBuffer() {
        this.testAutoAllocatePutByteBuffer(false, false, false);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferGreaterLessThanNewAllocSize_NativeTestBuffer_HeapIOBuffer() {
        this.testAutoAllocatePutByteBuffer(false, true, false);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthGreaterThanNewAllocSize_HeapTestBuffer_NativeIOBuffer() {
        this.testAutoAllocatePutByteBuffer(false, false, true);
    }

    @Test
    public void testAutoAllocatePutByteBuffer_InitialBufferLengthGreaterThanNewAllocSize_NativeTestBuffer_NativeIOBuffer() {
        this.testAutoAllocatePutByteBuffer(false, true, true);
    }

    private void testAutoAllocatePutByteArray(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        byte[] val = this.randomByteArray(10);
        buffer.putFrom(128, val, 0, 10);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        for (int i = 0; i < val.length; ++i) {
            Assert.assertEquals((double)val[i], (double)buffer.get(128 + i), (double)0.0);
        }
        Assert.assertEquals((long)(initialBufferLengthLessThanNewAllocSize ? 138L : 256L), (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocatePutByteArray_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutByteArray(true, false);
    }

    @Test
    public void testAutoAllocatePutByteArray_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutByteArray(true, true);
    }

    @Test
    public void testAutoAllocatePutByteArray_InitialBufferLengthGreaterThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocatePutByteArray(false, false);
    }

    @Test
    public void testAutoAllocatePutByteArray_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocatePutByteArray(false, true);
    }

    private void testAutoAllocateSetLength(boolean initialBufferLengthLessThanNewAllocSize, boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(initialBufferLengthLessThanNewAllocSize ? 100 : 256), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        buffer.setLength(138);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)256L, (long)buffer.getIOBuffer().getCapacity());
        Assert.assertEquals((long)138L, (long)buffer.getLength());
    }

    @Test
    public void testAutoAllocateSetLength_InitialBufferLengthLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocateSetLength(true, false);
    }

    @Test
    public void testAutoAllocateSetLength_InitialBufferLengthLessThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocateSetLength(true, true);
    }

    @Test
    public void testAutoAllocateSetLength_InitialBufferGreaterLessThanNewAllocSize_HeapIOBuffer() {
        this.testAutoAllocateSetLength(false, false);
    }

    @Test
    public void testAutoAllocateSetLength_InitialBufferLengthGreaterThanNewAllocSize_NativeIOBuffer() {
        this.testAutoAllocateSetLength(false, true);
    }

    private void testResetGetPutByte(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        byte val = (byte)this.random.nextInt(128);
        buffer.put(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = (byte)this.random.nextInt(128);
        buffer.put(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((long)0L, (long)buffer.get(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = (byte)this.random.nextInt(128);
        buffer.put(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.get(0));
    }

    @Test
    public void testResetGetPutByte_HeapIOBuffer() {
        this.testResetGetPutByte(false);
    }

    @Test
    public void testResetGetPutByte_NativeIOBuffer() {
        this.testResetGetPutByte(true);
    }

    private void testResetGetPutChar(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        char val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((long)0L, (long)buffer.getChar(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = (char)this.random.nextInt(Short.MAX_VALUE);
        buffer.putChar(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getChar(0));
    }

    @Test
    public void testResetGetPutChar_HeapIOBuffer() {
        this.testResetGetPutChar(false);
    }

    @Test
    public void testResetGetPutChar_NativeIOBuffer() {
        this.testResetGetPutChar(true);
    }

    private void testResetGetPutShort(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        short val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((long)0L, (long)buffer.getShort(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = (short)this.random.nextInt(Short.MAX_VALUE);
        buffer.putShort(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getShort(0));
    }

    @Test
    public void testResetGetPutShort_HeapIOBuffer() {
        this.testResetGetPutShort(false);
    }

    @Test
    public void testResetGetPutShort_NativeIOBuffer() {
        this.testResetGetPutShort(true);
    }

    private void testResetGetPutInt(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        int val = this.random.nextInt();
        buffer.putInt(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = this.random.nextInt();
        buffer.putInt(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((long)0L, (long)buffer.getInt(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = this.random.nextInt();
        buffer.putInt(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getInt(0));
    }

    @Test
    public void testResetGetPutInt_HeapIOBuffer() {
        this.testResetGetPutInt(false);
    }

    @Test
    public void testResetGetPutInt_NativeIOBuffer() {
        this.testResetGetPutInt(true);
    }

    private void testResetGetPutFloat(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        float val = this.random.nextFloat();
        buffer.putFloat(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = this.random.nextFloat();
        buffer.putFloat(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((double)0.0, (double)buffer.getFloat(0), (double)0.0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = this.random.nextFloat();
        buffer.putFloat(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getFloat(0), (double)0.0);
    }

    @Test
    public void testResetGetPutFloat_HeapIOBuffer() {
        this.testResetGetPutFloat(false);
    }

    @Test
    public void testResetGetPutFloat_NativeIOBuffer() {
        this.testResetGetPutFloat(true);
    }

    private void testResetGetPutLong(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        long val = this.random.nextLong();
        buffer.putLong(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = this.random.nextLong();
        buffer.putLong(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((long)0L, (long)buffer.getLong(0));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = this.random.nextLong();
        buffer.putLong(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((long)val, (long)buffer.getLong(0));
    }

    @Test
    public void testResetGetPutLong_HeapIOBuffer() {
        this.testResetGetPutLong(false);
    }

    @Test
    public void testResetGetPutLong_NativeIOBuffer() {
        this.testResetGetPutLong(true);
    }

    private void testResetGetPutDouble(boolean nativeIOBuffer) {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        double val = this.random.nextDouble();
        buffer.putDouble(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = this.random.nextDouble();
        buffer.putDouble(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((double)0.0, (double)buffer.getDouble(0), (double)0.0);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = this.random.nextDouble();
        buffer.putDouble(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((double)val, (double)buffer.getDouble(0), (double)0.0);
    }

    @Test
    public void testResetGetPutDouble_HeapIOBuffer() {
        this.testResetGetPutDouble(false);
    }

    @Test
    public void testResetGetPutDouble_NativeIOBuffer() {
        this.testResetGetPutDouble(true);
    }

    private void testResetGetPutString(boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        String val = this.randomString(50);
        buffer.putString(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        val = this.randomString(50);
        buffer.putString(0, val);
        Assert.assertFalse((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        Assert.assertEquals((Object)new String(new byte[]{0, 0, 0, 0, 0}, "UTF-8"), (Object)buffer.getString(0, 5));
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        buffer.reset();
        val = this.randomString(50);
        buffer.putString(0, val);
        Assert.assertTrue((boolean)((BufferInitializer)buffer.getInitializer()).initializerInvoked());
        Assert.assertEquals((Object)val, (Object)buffer.getString(0, val.length()));
    }

    @Test
    public void testResetGetPutString_HeapIOBuffer() throws Exception {
        this.testResetGetPutString(false);
    }

    @Test
    public void testResetGetPutString_NativeIOBuffer() throws Exception {
        this.testResetGetPutString(true);
    }

    private void testCreateInputStreamEof(boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        Assert.assertEquals((long)-1L, (long)buffer.inputStream(0).read());
        Assert.assertEquals((long)-1L, (long)buffer.inputStream(0).read(new byte[100], 0, 100));
    }

    @Test
    public void testCreateInputStreamEof_HeapIOBuffer() throws Exception {
        this.testCreateInputStreamEof(false);
    }

    @Test
    public void testCreateInputStreamEof_NativeIOBuffer() throws Exception {
        this.testCreateInputStreamEof(true);
    }

    private void testCreateWrapPutInputStreamEof(boolean wrap, boolean nativeIOBuffer) throws Exception {
        PktBuffer buffer = PktBuffer.create(new SerializableEntity(100), 0, nativeIOBuffer);
        buffer.setInitializer(new BufferInitializer());
        Assert.assertNull((Object)buffer.getIOBuffer());
        if (wrap) {
            buffer.wrapIOBuffer(IOBuffer.create((int)300, (boolean)nativeIOBuffer), 150, 100);
        }
        buffer.put(10, (byte)1);
        InputStream is = buffer.inputStream(99);
        Assert.assertEquals((long)0L, (long)is.read());
        Assert.assertEquals((long)-1L, (long)is.read());
        is = buffer.inputStream(99);
        Assert.assertEquals((long)1L, (long)is.read(new byte[100], 0, 100));
        Assert.assertEquals((long)-1L, (long)is.read());
        is = buffer.inputStream(99);
        Assert.assertEquals((long)1L, (long)is.read(new byte[100], 0, 100));
        Assert.assertEquals((long)-1L, (long)is.read(new byte[100], 0, 100));
        is = buffer.inputStream(100);
        Assert.assertEquals((long)-1L, (long)is.read());
        is = buffer.inputStream(100);
        Assert.assertEquals((long)-1L, (long)is.read(new byte[1], 0, 1));
    }

    @Test
    public void testCreatePutInputStreamEof_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutInputStreamEof(false, false);
    }

    @Test
    public void testCreatePutInputStreamEof_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutInputStreamEof(false, true);
    }

    @Test
    public void testCreateWrapPutInputStreamEof_HeapIOBuffer() throws Exception {
        this.testCreateWrapPutInputStreamEof(true, false);
    }

    @Test
    public void testCreateWrapPutInputStreamEof_NativeIOBuffer() throws Exception {
        this.testCreateWrapPutInputStreamEof(true, true);
    }

    private void testNativeCopy(PktBuffer pktBuffer) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(512);
        String testString = "TestString";
        byteBuffer.put(testString.getBytes());
        byteBuffer.flip();
        long address = UtlBuffer.getNativeBufferAddress((ByteBuffer)byteBuffer);
        pktBuffer.putFromNative(0, address, 0, byteBuffer.remaining());
        String strCopy = pktBuffer.getString(0, testString.length());
        Assert.assertEquals((String)"Natively copied string doesn't match", (Object)testString, (Object)strCopy);
    }

    @Test
    public void testNativeCopyToNativePktBuffer() throws Exception {
        this.testNativeCopy(PktBuffer.create(null, 1, true));
    }

    @Test
    public void testNativeCopyToHeapPktBuffer() throws Exception {
        this.testNativeCopy(PktBuffer.create(null, 1, false));
    }

    @Test
    public void testDirectBufferCopyWithOffset() {
        IOBuffer ioBuf = IOBuffer.create((int)256, (boolean)true);
        PktBuffer src = PktBuffer.create(null, 1, true);
        src.wrapIOBuffer(ioBuf, 10, 240);
        src.putString(0, "Test");
        PktBuffer target = PktBuffer.create(null, 1, true);
        target.putFrom(0, src, 0, 4);
        Assert.assertEquals((Object)"Test", (Object)target.getString(0, 4));
    }

    @Test
    public void testValidateResumptionLength() {
        IOBuffer iobuf = IOBuffer.create((int)256, (int)0, (boolean)true);
        PktBuffer buffer = PktBuffer.create(null, 1, true);
        Assert.assertEquals((long)0L, (long)buffer.getResumptionLength());
        buffer.wrapIOBuffer(iobuf, 10, 32);
        System.out.println(buffer.getIOBuffer().getHighwater());
        Assert.assertEquals((long)0L, (long)buffer.getResumptionLength());
        buffer.reset();
        Assert.assertEquals((long)32L, (long)buffer.getResumptionLength());
        buffer.ensureBackingBufferExists();
        Assert.assertEquals((long)0L, (long)buffer.getResumptionLength());
        Assert.assertNotNull((Object)buffer.getIOBuffer());
        Assert.assertFalse((iobuf == buffer.getIOBuffer() ? 1 : 0) != 0);
        Assert.assertEquals((long)32L, (long)buffer.getIOBuffer().getCapacity());
        buffer.setLength(64);
        Assert.assertEquals((long)0L, (long)buffer.getResumptionLength());
        buffer.reset();
        Assert.assertEquals((long)64L, (long)buffer.getResumptionLength());
    }

    private void testBufferStateAfterCopyOnWrite(boolean isNative) {
        PktBuffer buffer = PktBuffer.create(null, 256, isNative);
        buffer.setLength(100);
        IOBuffer iobuf = buffer.getIOBuffer();
        buffer.setCopyOnWrite();
        buffer.putInt(0, 0);
        Assert.assertNotSame((Object)iobuf, (Object)buffer.getIOBuffer());
        Assert.assertEquals((long)100L, (long)buffer.getLength());
        Assert.assertEquals((long)0L, (long)buffer.getOffset());
        Assert.assertFalse((boolean)buffer.isCopyOnWrite());
        Assert.assertFalse((boolean)buffer.isFailOnWrite());
        Assert.assertEquals((Object)isNative, (Object)buffer.getIOBuffer().isNative());
    }

    @Test
    public void testBufferStateAfterCopyOnWrite_HeapIOBuffer() {
        this.testBufferStateAfterCopyOnWrite(false);
    }

    @Test
    public void testBufferStateAfterCopyOnWrite_NativeIOBuffer() {
        this.testBufferStateAfterCopyOnWrite(true);
    }

    private final class BufferInitializer
    implements IOElasticBuffer.Initializer {
        boolean initializerInvoked;

        private BufferInitializer() {
        }

        final boolean initializerInvoked() {
            try {
                boolean bl = this.initializerInvoked;
                return bl;
            }
            finally {
                this.initializerInvoked = false;
            }
        }

        public final void initializeBuffer() {
            this.initializerInvoked = true;
        }
    }

    private final class SerializableEntity
    extends PktSerializable
    implements IOElasticBuffer.Sizer {
        int size;

        SerializableEntity(int size) {
            this.size = size;
        }

        public final int getInitialBufferLength() {
            return this.size;
        }

        @Override
        public final int getSerializedLength() {
            return this.size;
        }

        @Override
        public final void serialize(PktSerializable.SerializeContext context, Tracer tracer) throws EPktSerializeException {
        }

        @Override
        public final void deserialize(PktSerializable.DeserializeContext context, int headerSerializedLength, Tracer tracer) {
        }
    }
}

