/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializer;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.util.UtlObjectGraph;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class PktBodyDataTest {
    @Test
    public void testSerializeDeserialize() {
        System.setProperty("nv.optimizefor", "latency");
        Random random = new Random(1L);
        for (int i = 1; i <= 1000; ++i) {
            PktPacket packet = PktFactory.getInstance().createPacket(257);
            PktBodyData body = (PktBodyData)packet.getBody();
            byte[] data = (byte[])UtlObjectGraph.BuiltInHandler.getRandomValue(byte[].class, (Random)random);
            body.deserialize(data, 0, data.length);
            PktSerializer serializer = PktSerializer.create();
            IOBuffer iobuf = IOBuffer.create((int)(packet.getSerializedLength() * 2), (boolean)false);
            serializer.serialize(packet, iobuf, null);
            PktPacket deserialized = serializer.deserialize(iobuf.getBufferUnsafe(), null);
            PktBodyData deserializedBody = (PktBodyData)deserialized.getBody();
            Assert.assertEquals((String)("Deserialized body length not equals to data length (iteration=" + i + ")"), (long)data.length, (long)deserializedBody.getSerializedLength());
            Assert.assertEquals((String)("Deserialized body recorded length not equals to data length (iteration=" + i + ")"), (long)data.length, (long)deserializedBody.getBufferLength());
            Assert.assertEquals((String)("Deserialized body buffer length not equals to data length (iteration=" + i + ")"), (long)data.length, (long)deserializedBody.getBuffer().getLength());
            byte[] deserializedData = new byte[deserializedBody.getBufferLength()];
            deserializedBody.getBuffer().getTo(0, deserializedData, 0, deserializedData.length);
            String diff = UtlObjectGraph.diffObjects((Object)data, (Object)((Object)deserialized.getBody()));
            if (diff.length() > 0) {
                Assert.fail((String)("Deserialized data differs from original:\n" + diff));
            }
            iobuf.dispose();
            packet.dispose();
            deserialized.dispose();
        }
    }
}

